/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.ModInterface.ThaumCraft.TileEntityEssentiaRelay;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class EssentiaNetwork {
    private final MultiMap<WorldLocation, WorldLocation> tiles = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());
    private final MultiMap<WorldLocation, WorldLocation> nodes = new MultiMap((MultiMap.CollectionFactory)new MultiMap.ListFactory());
    private final HashMap<ImmutablePair<WorldLocation, WorldLocation>, ArrayList<WorldLocation>> pathList = new HashMap();
    private static final Comparator<NetworkEndpoint> pullComparator = new SuctionComparator(true);
    private static final Comparator<NetworkEndpoint> pushComparator = new SuctionComparator(false);

    public void addTile(TileEntityEssentiaRelay caller, TileEntity te) {
        if (te instanceof TileEntityEssentiaRelay) {
            this.nodes.addValue((Object)new WorldLocation((TileEntity)caller), (Object)new WorldLocation(te));
        } else {
            this.tiles.addValue((Object)new WorldLocation((TileEntity)caller), (Object)new WorldLocation(te));
        }
    }

    public void merge(EssentiaNetwork m) {
        this.tiles.putAll(m.tiles);
        this.nodes.putAll(m.nodes);
        for (WorldLocation loc : this.tiles.keySet()) {
            TileEntity te = loc.getTileEntity();
            if (!(te instanceof TileEntityEssentiaRelay)) continue;
            ((TileEntityEssentiaRelay)te).network = this;
        }
        m.tiles.clear();
        m.reset();
    }

    public void reset() {
        ArrayList set = new ArrayList(this.tiles.keySet());
        for (WorldLocation loc : set) {
            TileEntity te = loc.getTileEntity();
            if (!(te instanceof TileEntityEssentiaRelay)) continue;
            ((TileEntityEssentiaRelay)te).scan(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
        this.tiles.clear();
        this.nodes.clear();
        this.pathList.clear();
    }

    public EssentiaMovement addEssentia(TileEntityEssentiaRelay caller, ForgeDirection callDir, Aspect aspect, int amount) {
        return this.addEssentia(caller, aspect, amount, new WorldLocation((TileEntity)caller).move(callDir, 1));
    }

    public EssentiaMovement addEssentia(TileEntityEssentiaRelay caller, Aspect aspect, int amount, WorldLocation src) {
        ArrayList<EssentiaPath> li = new ArrayList<EssentiaPath>();
        ArrayList<NetworkEndpoint> list = this.collectAllTiles(src);
        Collections.sort(list, pushComparator);
        for (NetworkEndpoint p : list) {
            for (int i = 0; i < 6; ++i) {
                int added;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (!p.tile.canInputFrom(dir) || (added = p.tile.addEssentia(aspect, amount, dir)) <= 0) continue;
                amount -= added;
                ArrayList<WorldLocation> pt = this.getPath(new WorldLocation((TileEntity)caller), p.relayNode);
                if (pt.isEmpty()) {
                    // empty if block
                }
                pt.add(p.point);
                pt.add(0, src);
                li.add(new EssentiaPath(aspect, added, pt));
                if (amount <= 0) break;
            }
            if (amount > 0) continue;
            break;
        }
        return li.isEmpty() ? null : new EssentiaMovement(li);
    }

    private ArrayList<NetworkEndpoint> collectAllTiles(WorldLocation exclude) {
        ArrayList<NetworkEndpoint> li = new ArrayList<NetworkEndpoint>();
        for (WorldLocation node : this.tiles.keySet()) {
            Iterator it = this.tiles.get((Object)node).iterator();
            while (it.hasNext()) {
                WorldLocation loc = (WorldLocation)it.next();
                if (loc.equals((Object)exclude)) continue;
                TileEntity te = loc.getTileEntity();
                if (te instanceof IEssentiaTransport) {
                    li.add(new NetworkEndpoint(node, loc, (IEssentiaTransport)te));
                    continue;
                }
                it.remove();
            }
        }
        return li;
    }

    public EssentiaMovement removeEssentia(TileEntityEssentiaRelay caller, ForgeDirection callDir, Aspect aspect, int amount) {
        return this.removeEssentia(caller, callDir, aspect, amount, new WorldLocation((TileEntity)caller).move(callDir, 1));
    }

    public EssentiaMovement removeEssentia(TileEntityEssentiaRelay caller, ForgeDirection callDir, Aspect aspect, int amount, WorldLocation tgt) {
        TileEntity target = caller.getAdjacentTileEntity(callDir);
        ArrayList<EssentiaPath> li = new ArrayList<EssentiaPath>();
        ArrayList<NetworkEndpoint> list = this.collectAllTiles(tgt);
        Collections.sort(list, pullComparator);
        for (NetworkEndpoint p : list) {
            for (int i = 0; i < 6; ++i) {
                int rem;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (!p.tile.canOutputTo(dir) || (rem = p.tile.takeEssentia(aspect, amount, dir)) <= 0) continue;
                amount -= rem;
                ArrayList<WorldLocation> pt = this.getPath(p.relayNode, new WorldLocation((TileEntity)caller));
                if (pt.isEmpty()) {
                    // empty if block
                }
                pt.add(0, p.point);
                pt.add(tgt);
                li.add(new EssentiaPath(aspect, rem, pt));
                if (amount <= 0) break;
            }
            if (amount > 0) continue;
            break;
        }
        return li.isEmpty() ? null : new EssentiaMovement(li);
    }

    private ArrayList<WorldLocation> getPath(WorldLocation loc, WorldLocation loc2) {
        ArrayList<WorldLocation> path = new ArrayList<WorldLocation>();
        path.add(loc);
        HashSet<WorldLocation> set = new HashSet<WorldLocation>();
        set.add(loc);
        WorldLocation tg = this.getNearestLocationExcept(loc, set);
        if (tg == null) {
            return new ArrayList<WorldLocation>();
        }
        if (tg.equals((Object)loc2)) {
            path.add(loc2);
        } else {
            this.recursePathTo(tg, loc2, path, set);
        }
        return path;
    }

    private void recursePathTo(WorldLocation loc, WorldLocation loc2, ArrayList<WorldLocation> path, HashSet<WorldLocation> set) {
        path.add(loc);
        set.add(loc);
        WorldLocation tg = this.getNearestLocationExcept(loc, set);
        if (tg == null) {
            path.clear();
            return;
        }
        if (tg.equals((Object)loc2)) {
            path.add(loc2);
        } else {
            this.recursePathTo(tg, loc2, path, set);
        }
    }

    private WorldLocation getNearestLocationExcept(WorldLocation loc, HashSet<WorldLocation> set) {
        WorldLocation ret = null;
        double d = Double.POSITIVE_INFINITY;
        for (WorldLocation loc2 : this.tiles.keySet()) {
            double dist;
            if (set.contains(loc2) || !((dist = loc2.getDistanceTo(loc)) < d)) continue;
            d = dist;
            ret = loc2;
        }
        return ret;
    }

    public int countEssentia(Aspect aspect) {
        int sum = 0;
        for (WorldLocation node : this.tiles.keySet()) {
            Iterator it = this.tiles.get((Object)node).iterator();
            while (it.hasNext()) {
                WorldLocation loc = (WorldLocation)it.next();
                TileEntity te = loc.getTileEntity();
                if (te instanceof IEssentiaTransport) {
                    IEssentiaTransport p = (IEssentiaTransport)te;
                    for (int i = 0; i < 6; ++i) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                        if (!p.canOutputTo(dir)) continue;
                        if (p instanceof IAspectContainer) {
                            AspectList al = ((IAspectContainer)p).getAspects();
                            if (al == null) continue;
                            for (Aspect a : al.aspects.keySet()) {
                                if (a != aspect) continue;
                                sum += p.getEssentiaAmount(dir);
                            }
                            continue;
                        }
                        Aspect a = p.getEssentiaType(dir);
                        if (a != aspect) continue;
                        sum += p.getEssentiaAmount(dir);
                    }
                    continue;
                }
                it.remove();
            }
        }
        return sum;
    }

    public String toString() {
        return System.identityHashCode(this) + " " + this.tiles;
    }

    private static class SuctionComparator
    implements Comparator<NetworkEndpoint> {
        private final boolean suction;

        private SuctionComparator(boolean suck) {
            this.suction = suck;
        }

        @Override
        public int compare(NetworkEndpoint o1, NetworkEndpoint o2) {
            int ret = Integer.compare(o1.suction, o2.suction);
            if (!this.suction) {
                ret = -ret;
            }
            return ret;
        }
    }

    private static class NetworkEndpoint {
        public final WorldLocation relayNode;
        public final WorldLocation point;
        private final IEssentiaTransport tile;
        public final int suction;

        private NetworkEndpoint(WorldLocation node, WorldLocation loc, IEssentiaTransport te) {
            this.relayNode = node;
            this.point = loc;
            this.tile = te;
            int maxsuc = 0;
            for (int i = 0; i < 6; ++i) {
                maxsuc = Math.max(maxsuc, te.getSuctionAmount(ForgeDirection.VALID_DIRECTIONS[i]));
            }
            this.suction = maxsuc;
        }
    }

    public static class EssentiaPath {
        private final ArrayList<WorldLocation> path;
        public final WorldLocation target;
        public final WorldLocation source;
        public final Aspect aspect;
        public final int amount;

        private EssentiaPath(Aspect a, int amt, ArrayList<WorldLocation> li) {
            this.aspect = a;
            this.amount = amt;
            this.path = li;
            this.target = li.isEmpty() ? null : li.get(0);
            this.source = li.isEmpty() ? null : li.get(li.size() - 1);
        }

        public void update(World world, int x, int y, int z) {
            this.doParticles(world, x, y, z);
        }

        private void doParticles(World world, int x, int y, int z) {
            for (int i = 0; i < this.path.size() - 1; ++i) {
                WorldLocation loc1 = this.path.get(i);
                WorldLocation loc2 = this.path.get(i + 1);
                ReikaPacketHelper.sendStringIntPacket((String)"ChromaData", (int)ChromaPackets.ESSENTIAPARTICLE.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x, (double)y, (double)z, 32), (String)this.aspect.getTag(), (int[])new int[]{loc1.xCoord, loc2.xCoord, loc1.yCoord, loc2.yCoord, loc1.zCoord, loc2.zCoord, this.amount});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static void sendParticle(World world, int x1, int x2, int y1, int y2, int z1, int z2, String asp, int amt) {
            Aspect a = Aspect.getAspect((String)asp);
            int l = 100;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double dz = z2 - z1;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double v = 0.25;
            double vx = v * dx / dd;
            double vy = v * dy / dd;
            double vz = v * dz / dd;
            int i = 0;
            for (double d = 0.0; d <= dd; d += 0.125) {
                double px = (double)x1 + 0.5 + dx * d / dd;
                double py = (double)y1 + 0.5 + dy * d / dd;
                double pz = (double)z1 + 0.5 + dz * d / dd;
                double ds = Math.min(dd - d, d);
                float s = (float)(1.5 + (double)amt / 4.0 * ds / 1.0);
                EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setColor(a.getColor()).setLife(l).setScale(s).setRapidExpand();
                EntityBlurFX fx2 = new EntityBlurFX(world, px, py, pz).setColor(0xFFFFFF).setLife(l).setScale(s / 2.0f).setRapidExpand();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
                ++i;
            }
        }

        public String toString() {
            return this.amount + " of " + this.aspect.getName() + " along " + this.path;
        }
    }

    public static class EssentiaMovement {
        public final int totalAmount;
        private final ArrayList<EssentiaPath> paths;

        private EssentiaMovement(ArrayList<EssentiaPath> li) {
            this.paths = li;
            int sum = 0;
            for (EssentiaPath p : this.paths) {
                sum += p.amount;
            }
            this.totalAmount = sum;
        }

        public Collection<EssentiaPath> paths() {
            return Collections.unmodifiableList(this.paths);
        }
    }
}

