/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.IWandRodOnUpdate;
import thaumcraft.api.wands.WandRod;

public class CrystalWand
extends WandRod {
    private static final Random rand = new Random();
    private final IWandRodOnUpdate updater = new WandUpdater();

    public CrystalWand() {
        super("CRYSTALWAND", 6000, ChromaStacks.crystalWand, 18, null, null);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.registerTexture();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerTexture() {
        this.setTexture(DirectResourceManager.getResource((String)"Reika/ChromatiCraft/Textures/Wands/crystalwand.png"));
    }

    public IWandRodOnUpdate getOnUpdate() {
        return this.updater;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateWandClient(EntityPlayer player, int[] data) {
        ElementTagCompound tag = new ElementTagCompound();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            tag.addValueToColor(e, data[i]);
        }
        Vec3 vec = player.func_70040_Z();
        for (CrystalElement e : CrystalElement.elements) {
            double px = ReikaRandomHelper.getRandomPlusMinus((double)(player.field_70165_t + vec.field_72450_a), (double)1.0);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)(player.field_70163_u + vec.field_72448_b), (double)0.5);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)(player.field_70161_v + vec.field_72449_c), (double)1.0);
            EntityRuneFX fx = new EntityRuneFX(player.field_70170_p, px, py, pz, e).setLife(40).setScale(2.0f).setGravity(0.1f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.CAST, (Entity)player, (float)1.0f, (float)1.0f);
    }

    private static class WandUpdater
    implements IWandRodOnUpdate {
        private WandUpdater() {
        }

        public void onUpdate(ItemStack is, EntityPlayer player) {
            int n;
            if (ReikaPlayerAPI.isFake((EntityPlayer)player)) {
                return;
            }
            int n2 = n = ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)player.func_71045_bC()) ? 100 : 800;
            if (rand.nextInt(n) == 0) {
                AspectList al = ReikaThaumHelper.getVisInWand((ItemStack)is);
                ElementTagCompound tag = new ElementTagCompound();
                boolean flag = false;
                for (Aspect a : Aspect.getPrimalAspects()) {
                    int sp;
                    if (al.getAmount(a) <= 0 || (sp = ReikaThaumHelper.getWandSpaceFor((ItemStack)is, (Aspect)a)) <= 0) continue;
                    PlayerElementBuffer.instance.removeFromPlayer(player, ChromaAspectManager.instance.getElementCost(a, 1.0f));
                    ReikaThaumHelper.addVisToWand((ItemStack)is, (Aspect)a, (int)Math.min(sp, 10));
                    flag = true;
                }
                if (flag && player instanceof EntityPlayerMP) {
                    int[] data = new int[16];
                    for (int i = 0; i < CrystalElement.elements.length; ++i) {
                        CrystalElement e = CrystalElement.elements[i];
                        data[i] = tag.getValue(e);
                    }
                    ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.WANDCHARGE.ordinal(), (EntityPlayerMP)((EntityPlayerMP)player), (int[])data);
                }
            }
        }
    }
}

