/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.NEI;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.NEI.ChromaNEITabOccluder;
import Reika.ChromatiCraft.ModInterface.NEI.CrystalBrewerHandler;
import Reika.ChromatiCraft.ModInterface.NEI.CrystalFurnaceHandler;
import Reika.ChromatiCraft.ModInterface.NEI.EnchantDecompHandler;
import Reika.ChromatiCraft.ModInterface.NEI.FabricatorHandler;
import Reika.ChromatiCraft.ModInterface.NEI.GlowFireHandler;
import Reika.ChromatiCraft.ModInterface.NEI.PlantDustHandler;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.DragonAPI.DragonAPICore;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class NEIChromaConfig
implements IConfigureNEI {
    private static final CrystalBrewerHandler crystal = new CrystalBrewerHandler();
    private static final FabricatorHandler fabrication = new FabricatorHandler();
    private static final CrystalFurnaceHandler furnace = new CrystalFurnaceHandler();
    private static final GlowFireHandler glow = new GlowFireHandler();
    private static final PlantDustHandler plants = new PlantDustHandler();
    private static final EnchantDecompHandler enchant = new EnchantDecompHandler();
    private static final ChromaNEITabOccluder occlusion = new ChromaNEITabOccluder();

    public void loadConfig() {
        ChromaBlocks b;
        int i;
        ChromatiCraft.logger.log((Object)"Loading NEI Compatibility!");
        API.registerNEIGuiHandler((INEIGuiHandler)occlusion);
        API.registerRecipeHandler((ICraftingHandler)crystal);
        API.registerUsageHandler((IUsageHandler)crystal);
        API.registerRecipeHandler((ICraftingHandler)furnace);
        API.registerUsageHandler((IUsageHandler)furnace);
        API.registerRecipeHandler((ICraftingHandler)fabrication);
        API.registerRecipeHandler((ICraftingHandler)plants);
        API.registerRecipeHandler((ICraftingHandler)glow);
        API.registerUsageHandler((IUsageHandler)glow);
        API.registerRecipeHandler((ICraftingHandler)enchant);
        API.registerUsageHandler((IUsageHandler)enchant);
        ChromatiCraft.logger.log((Object)"Hiding technical blocks from NEI!");
        for (i = 0; i < ChromaBlocks.blockList.length; ++i) {
            b = ChromaBlocks.blockList[i];
            if (!b.isTechnical() && (DragonAPICore.isReikasComputer() || !b.isDimensionStructureBlock())) continue;
            this.hideBlock(b.getBlockInstance());
        }
        if (ChromatiCraft.instance.isLocked()) {
            for (i = 0; i < ChromaItems.itemList.length; ++i) {
                ChromaItems ir = ChromaItems.itemList[i];
                API.hideItem((ItemStack)new ItemStack(ir.getItemInstance(), 1, Short.MAX_VALUE));
            }
            for (i = 0; i < ChromaBlocks.blockList.length; ++i) {
                b = ChromaBlocks.blockList[i];
                this.hideBlock(b.getBlockInstance());
            }
        }
    }

    private void hideBlock(Block b) {
        API.hideItem((ItemStack)new ItemStack(b, 1, Short.MAX_VALUE));
    }

    public String getName() {
        return "ChromatiCraft NEI Handlers";
    }

    public String getVersion() {
        return "Gamma";
    }
}

