/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityRelayPowered;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModList;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IClimateControlled;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IAlvearyController;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogicAlveary;
import forestry.api.multiblock.MultiblockManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.visnet.VisNetHandler;

@APIStripper.Strippable(value={"forestry.api.multiblock.IAlvearyComponent", "forestry.api.multiblock.IAlvearyComponent$BeeModifier", "forestry.api.multiblock.IAlvearyComponent$BeeListener", "forestry.api.apiculture.IBeeModifier", "forestry.api.apiculture.IBeeListener"})
public class TileEntityLumenAlveary
extends TileEntityRelayPowered
implements IAlvearyComponent,
IAlvearyComponent.BeeModifier,
IAlvearyComponent.BeeListener,
IBeeModifier,
IBeeListener {
    private static final HashSet<AlvearyEffect> effectSet = new HashSet();
    private static final HashSet<AlvearyEffect> continualSet = new HashSet();
    private static final AutomationEffect automation;
    private static Method tickMethod;
    private static Field tempField;
    private static Field humidField;
    private Object logic;
    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    private AspectList aspects;
    private static final int VIS_LIMIT = 200;
    private Coordinate relativeLocation;
    private int lightningTicks;
    private String movePrincess;
    private boolean canWork;
    private EntityItem renderItem;
    private boolean multipleBoosters = false;

    public static String getEffectsAsString() {
        StringBuilder sb = new StringBuilder();
        for (AlvearyEffect ae : effectSet) {
            if (!(ae instanceof LumenAlvearyEffect)) continue;
            sb.append(ae.getDescription());
            sb.append(" - ");
            sb.append(((LumenAlvearyEffect)ae).color.displayName);
            sb.append(" (");
            sb.append(((LumenAlvearyEffect)ae).requiredEnergy);
            sb.append(" L/cycle)");
            sb.append("\n");
        }
        return sb.toString();
    }

    public TileEntityLumenAlveary() {
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.aspects = new AspectList();
        }
        if (ModList.FORESTRY.isLoaded()) {
            this.logic = MultiblockManager.logicFactory.createAlvearyLogic();
        }
    }

    @Override
    protected boolean makeRequests() {
        return this.isAlvearyComplete();
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return this.isAlvearyComplete() && this.isSideOpen(dir) && this.isAcceptingColor(e);
    }

    private boolean isSideOpen(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.relativeLocation.yCoord == 0;
            }
            case UP: {
                return this.relativeLocation.yCoord == 2;
            }
            case WEST: {
                return this.relativeLocation.xCoord == 0;
            }
            case EAST: {
                return this.relativeLocation.xCoord == 2;
            }
            case NORTH: {
                return this.relativeLocation.zCoord == 0;
            }
            case SOUTH: {
                return this.relativeLocation.zCoord == 2;
            }
        }
        return false;
    }

    public Coordinate getRelativeLocation() {
        return this.relativeLocation;
    }

    public boolean isAlvearyComplete() {
        return this.relativeLocation != null && !this.multipleBoosters;
    }

    public boolean hasMultipleBoosters() {
        return this.multipleBoosters;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (ModList.FORESTRY.isLoaded()) {
            if (this.multipleBoosters) {
                // empty if block
            }
            if (this.isAlvearyComplete()) {
                if (this.getTicksExisted() % 4 == 0) {
                    this.canWork = this.calcCanWork();
                }
                if (world.field_72995_K) {
                    this.doParticles(world, x, y, z);
                }
                if (this.hasQueen()) {
                    if (this.canQueenWork()) {
                        for (AlvearyEffect ae : effectSet) {
                            if (ae.isActive(this) && (ae.tickRate() == 1 || this.getTicksExisted() % ae.tickRate() == 0)) {
                                ae.tick(this);
                            }
                            if (!ModList.THAUMCRAFT.isLoaded()) continue;
                            AspectList cost = new AspectList();
                            if (ae instanceof VisAlvearyEffect) {
                                VisAlvearyEffect vae = (VisAlvearyEffect)ae;
                                cost.add(vae.aspect, 1);
                            }
                            for (Aspect a : cost.aspects.keySet()) {
                                if (this.aspects.getAmount(a) >= 200) continue;
                                this.aspects.add(a, VisNetHandler.drainVis((World)world, (int)x, (int)y, (int)z, (Aspect)a, (int)cost.getAmount(a)));
                            }
                        }
                    } else {
                        for (AlvearyEffect ae : continualSet) {
                            if (!ae.isActive(this) || ae.tickRate() != 1 && this.getTicksExisted() % ae.tickRate() != 0) continue;
                            ae.tick(this);
                        }
                    }
                } else if (this.movePrincess != null && !this.movePrincess.isEmpty() && this.energy.containsAtLeast(TileEntityLumenAlveary.automation.color, TileEntityLumenAlveary.automation.requiredEnergy)) {
                    this.cycleBees(this.movePrincess);
                    this.movePrincess = null;
                    this.drainEnergy(TileEntityLumenAlveary.automation.color, TileEntityLumenAlveary.automation.requiredEnergy);
                }
            } else {
                this.canWork = false;
            }
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.updateRenderItem();
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        int n = 2 + 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (rand.nextInt(n) == 0) {
            double o = 0.03125;
            int side = rand.nextInt(2);
            double dx = side == 0 ? rand.nextDouble() * 3.0 : (rand.nextBoolean() ? 0.0 - o : 3.0 + o);
            double dy = rand.nextDouble() * 3.5;
            double dz = side == 1 ? rand.nextDouble() * 3.0 : (rand.nextBoolean() ? 0.0 - o : 3.0 + o);
            double px = (double)(x - this.relativeLocation.xCoord) + dx;
            double py = (double)(y - this.relativeLocation.yCoord) + dy;
            double pz = (double)(z - this.relativeLocation.zCoord) + dz;
            int l = ReikaRandomHelper.getRandomBetween((int)5, (int)20);
            int c2 = 0xFFFFFF;
            int c1 = 10516288;
            float s = 1.5f * (float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.25);
            EntityBlurFX fx1 = new EntityBlurFX(world, px, py, pz).setLife(l).setColor(c1).setIcon(ChromaIcons.HEXFLARE2).setScale(s);
            EntityBlurFX fx2 = new EntityBlurFX(world, px, py, pz).setLife(l).setColor(c2).setIcon(ChromaIcons.HEXFLARE2).setScale(s / 2.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @Override
    protected ElementTagCompound getRequiredEnergy() {
        ElementTagCompound tag = new ElementTagCompound();
        if (!this.isAlvearyComplete()) {
            return tag;
        }
        for (AlvearyEffect ae : effectSet) {
            if (!(ae instanceof LumenAlvearyEffect)) continue;
            LumenAlvearyEffect lae = (LumenAlvearyEffect)ae;
            tag.addValueToColor(lae.color, lae.requiredEnergy * 10);
        }
        return tag;
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return this.getRequiredEnergy().contains(e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 15000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ALVEARY;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public ChunkCoordinates getCoordinates() {
        return new Coordinate((TileEntity)this).asChunkCoordinates();
    }

    public GameProfile getOwner() {
        return this.placerUUID != null ? new GameProfile(this.placerUUID, this.getPlacerName()) : null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public void onMachineAssembled(IMultiblockController controller, ChunkCoordinates minCoord, ChunkCoordinates maxCoord) {
        this.validateStructure(controller);
        this.triggerBlockUpdate();
        this.syncAllData(true);
        this.relativeLocation = new Coordinate((TileEntity)this).offset(new Coordinate(minCoord).negate());
        this.updateRenderItem();
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    private void validateStructure(IMultiblockController controller) {
        boolean flag = false;
        this.multipleBoosters = false;
        for (IMultiblockComponent com : controller.getComponents()) {
            if (!(com instanceof TileEntityLumenAlveary) || com == this) continue;
            this.multipleBoosters = true;
            break;
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public void onMachineBroken() {
        ReikaWorldHelper.causeAdjacentUpdates((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        this.triggerBlockUpdate();
        this.syncAllData(true);
        this.relativeLocation = null;
        this.updateRenderItem();
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public IBeeListener getBeeListener() {
        return this;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public IBeeModifier getBeeModifier() {
        return this;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public void wearOutEquipment(int amount) {
        for (AlvearyEffect ae : effectSet) {
            ae.consumeEnergy(this, amount);
            ae.onProductionTick(this);
        }
        this.updateRenderItem();
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public void onQueenDeath() {
        this.movePrincess = this.getSpecies().getUID();
    }

    private void cycleBees(String species) {
        IBeeHousing ibh = this.getBeeHousing();
        IBeeHousingInventory ibhi = ibh.getBeeInventory();
        ISidedInventory inv = (ISidedInventory)ibhi;
        ItemStack drone = ibhi.getDrone();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack in = inv.func_70301_a(i);
            if (in == null) continue;
            boolean flag = false;
            for (int s = 0; s < 6; ++s) {
                if (!inv.func_102008_b(i, in, s)) continue;
                flag = true;
            }
            if (!flag) continue;
            EnumBeeType type = ReikaBeeHelper.getBeeRoot().getType(in);
            IAlleleBeeSpecies sp = (IAlleleBeeSpecies)ReikaBeeHelper.getSpecies((ItemStack)in);
            if (type == EnumBeeType.PRINCESS && ibhi.getQueen() == null && sp.getUID().equals(species)) {
                ibhi.setQueen(in);
                inv.func_70299_a(i, null);
                continue;
            }
            if (type == EnumBeeType.DRONE && ReikaItemHelper.areStacksCombinable((ItemStack)drone, (ItemStack)in, (int)inv.func_70297_j_())) {
                int amt = Math.min(drone.func_77976_d() - drone.field_77994_a, in.field_77994_a);
                drone.field_77994_a += amt;
                ibhi.setDrone(drone);
                in.field_77994_a -= amt;
                if (in.field_77994_a != 0) continue;
                inv.func_70299_a(i, null);
                continue;
            }
            if (type != EnumBeeType.DRONE || drone != null || !sp.getUID().equals(species)) continue;
            ibhi.setDrone(in);
            inv.func_70299_a(i, null);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public boolean onPollenRetrieved(IIndividual pollen) {
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public float getTerritoryModifier(IBeeGenome genome, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this)) continue;
            f *= ae.territoryFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this)) continue;
            f *= ae.mutationFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this)) continue;
            f *= ae.lifespanFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public float getProductionModifier(IBeeGenome genome, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this)) continue;
            f *= ae.productionFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public float getFloweringModifier(IBeeGenome genome, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this)) continue;
            f *= ae.pollinationFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public float getGeneticDecay(IBeeGenome genome, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this)) continue;
            f *= ae.decayFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public boolean isSealed() {
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this) || !ae.isSealed(this)) continue;
            return true;
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public boolean isSelfLighted() {
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this) || !ae.isSelfLit(this)) continue;
            return true;
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public boolean isSunlightSimulated() {
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this) || !ae.isSkySimulated(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isHellish() {
        for (AlvearyEffect ae : effectSet) {
            if (!ae.isActive(this) || !ae.isHellish(this)) continue;
            return true;
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public IMultiblockLogicAlveary getMultiblockLogic() {
        return (IMultiblockLogicAlveary)this.logic;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    private void tickAlveary() {
        IAlvearyController iac = this.getMultiblockLogic().getController();
        try {
            tickMethod.invoke((Object)iac, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeError(e);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    private IBeeHousing getBeeHousing() {
        return this.getMultiblockLogic().getController();
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    private IBeeGenome getBeeGenome() {
        ItemStack is = this.getQueenItem();
        return is != null ? (IBeeGenome)ReikaBeeHelper.getGenome((ItemStack)is) : null;
    }

    public boolean hasQueen() {
        return ModList.FORESTRY.isLoaded() && this.getQueenItem() != null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public ItemStack getQueenItem() {
        IAlvearyController ibh = this.getMultiblockLogic().getController();
        if (ibh == null) {
            return null;
        }
        ItemStack is = ibh.getBeeInventory().getQueen();
        return is != null ? is.func_77946_l() : null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    public boolean canQueenWork() {
        return this.canWork;
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    private boolean calcCanWork() {
        return this.isAlvearyComplete() && this.getMultiblockLogic().getController().getBeekeepingLogic().canWork();
    }

    @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
    private IAlleleBeeSpecies getSpecies() {
        return this.hasQueen() ? this.getBeeGenome().getPrimary() : null;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (ModList.FORESTRY.isLoaded()) {
            this.getMultiblockLogic().readFromNBT(data);
        }
        this.movePrincess = data.func_74779_i("move");
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.aspects.readFromNBT(data);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (ModList.FORESTRY.isLoaded()) {
            this.getMultiblockLogic().writeToNBT(data);
        }
        if (this.movePrincess != null && !this.movePrincess.isEmpty()) {
            data.func_74778_a("move", this.movePrincess);
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.aspects.writeToNBT(data);
        }
    }

    public final void func_145829_t() {
        super.func_145829_t();
        if (ModList.FORESTRY.isLoaded()) {
            this.getMultiblockLogic().validate(this.field_145850_b, (IMultiblockComponent)this);
        }
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.FORESTRY.isLoaded()) {
            if (invalid) {
                this.getMultiblockLogic().invalidate(world, (IMultiblockComponent)this);
            } else {
                this.getMultiblockLogic().onChunkUnload(world, (IMultiblockComponent)this);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this);
        if (this.isAlvearyComplete()) {
            Coordinate c = new Coordinate((TileEntity)this).offset(this.relativeLocation.negate());
            Coordinate c2 = c.offset(3, 6, 3);
            return AxisAlignedBB.func_72330_a((double)c.xCoord, (double)c.yCoord, (double)c.zCoord, (double)c2.xCoord, (double)c2.yCoord, (double)c2.zCoord);
        }
        return box;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityItem getRenderItem() {
        return this.renderItem;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.updateRenderItem();
    }

    private void updateRenderItem() {
        this.renderItem = this.isAlvearyComplete() && this.hasQueen() ? new InertItem(this.field_145850_b, this.getQueenItem()) : null;
    }

    static {
        if (ModList.FORESTRY.isLoaded()) {
            try {
                Class<?> c = Class.forName("forestry.core.multiblock.MultiblockControllerBase");
                tickMethod = c.getDeclaredMethod("updateMultiblockEntity", new Class[0]);
                tickMethod.setAccessible(true);
                c = Class.forName("forestry.apiculture.multiblock.AlvearyController");
                tempField = c.getDeclaredField("tempChange");
                tempField.setAccessible(true);
                humidField = c.getDeclaredField("humidChange");
                humidField.setAccessible(true);
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)"Could not fetch Alveary tick() method");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.FORESTRY, e);
            }
        }
        new AccelerationEffectI();
        new AccelerationEffectII();
        new AccelerationEffectIII();
        new LightningProductionEffect();
        new HistoryRewriteEffect();
        new ExplorationEffect();
        new GeneticFluxEffect();
        new GeneticStabilityEffect();
        new GeneticImprovementEffect();
        new TemperatureMatchingEffect();
        new HumidityMatchingEffect();
        new GeneticRepairEffectI();
        new GeneticRepairEffectII();
        automation = new AutomationEffect();
        if (ModList.THAUMCRAFT.isLoaded()) {
            new ProductionBoostEffect();
        }
    }

    private static class GeneticRepairEffectII
    extends GeneticRepairEffect {
        private GeneticRepairEffectII() {
            super(2400);
        }

        @Override
        protected boolean doRepair(TileEntityLumenAlveary te) {
            return true;
        }
    }

    private static class GeneticRepairEffectI
    extends GeneticRepairEffect {
        private GeneticRepairEffectI() {
            super(100);
        }

        @Override
        protected boolean doRepair(TileEntityLumenAlveary te) {
            return rand.nextInt(40) == 0;
        }
    }

    private static abstract class GeneticRepairEffect
    extends LumenAlvearyEffect {
        private GeneticRepairEffect(int cost) {
            super(CrystalElement.MAGENTA, cost);
        }

        @Override
        public final String getDescription() {
            return "Genetic Repair";
        }

        @Override
        protected final void onProductionTick(TileEntityLumenAlveary te) {
            if (this.doRepair(te)) {
                ItemStack is = te.getQueenItem();
                ReikaBeeHelper.setPristine((ItemStack)is, (boolean)true);
                te.getBeeHousing().getBeeInventory().setQueen(is);
            }
        }

        protected abstract boolean doRepair(TileEntityLumenAlveary var1);
    }

    private static class HumidityMatchingEffect
    extends LumenAlvearyEffect {
        private HumidityMatchingEffect() {
            super(CrystalElement.CYAN, 80);
        }

        @Override
        protected int tickRate() {
            return 2;
        }

        @Override
        public String getDescription() {
            return "Dynamic Humidity";
        }

        @Override
        protected void tick(TileEntityLumenAlveary te) {
            IAlvearyController ac = te.getMultiblockLogic().getController();
            IClimateControlled cc = (IClimateControlled)ac;
            IAlleleBeeSpecies queen = te.getSpecies();
            if (queen == null) {
                return;
            }
            ChunkCoordinates loc = ac.getCoordinates();
            float cur = ac.getBiome().field_76751_G;
            float pref = ReikaBeeHelper.getHumidityRangeCenter((EnumHumidity)queen.getHumidity());
            if (pref != cur) {
                try {
                    humidField.set(ac, Float.valueOf(pref - cur));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected boolean worksWhenBeesDoNot() {
            return true;
        }
    }

    private static class TemperatureMatchingEffect
    extends LumenAlvearyEffect {
        private TemperatureMatchingEffect() {
            super(CrystalElement.ORANGE, 80);
        }

        @Override
        protected int tickRate() {
            return 2;
        }

        @Override
        public String getDescription() {
            return "Dynamic Temperature";
        }

        @Override
        protected void tick(TileEntityLumenAlveary te) {
            IAlvearyController ac = te.getMultiblockLogic().getController();
            IClimateControlled cc = (IClimateControlled)ac;
            IAlleleBeeSpecies queen = te.getSpecies();
            if (queen == null) {
                return;
            }
            ChunkCoordinates loc = ac.getCoordinates();
            float cur = ac.getBiome().func_150564_a(loc.field_71574_a, loc.field_71572_b, loc.field_71573_c);
            float pref = ReikaBeeHelper.getTemperatureRangeCenter((EnumTemperature)queen.getTemperature());
            if (pref != cur) {
                try {
                    tempField.set(ac, Float.valueOf(pref - cur));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected boolean isHellish(TileEntityLumenAlveary te) {
            return te.getSpecies() != null && te.getSpecies().getTemperature() == EnumTemperature.HELLISH;
        }

        @Override
        protected boolean worksWhenBeesDoNot() {
            return true;
        }
    }

    private static class GeneticImprovementEffect
    extends LumenAlvearyEffect {
        private static final double geneImprovementChance = 0.002;

        private GeneticImprovementEffect() {
            super(CrystalElement.BLACK, 120);
        }

        @Override
        protected void tick(TileEntityLumenAlveary te) {
            ItemStack queen;
            if (ReikaRandomHelper.doWithChance((double)0.002) && (queen = te.getBeeHousing().getBeeInventory().getQueen()) != null && AlleleManager.alleleRegistry.getIndividual(queen) instanceof IBee) {
                IBeeGenome ibg = te.getBeeGenome();
                if (ibg == null) {
                    return;
                }
                EnumBeeChromosome gene = EnumBeeChromosome.values()[rand.nextInt(EnumBeeChromosome.values().length)];
                if (this.canImprove(gene, ibg)) {
                    this.improveGene(gene, ibg, queen);
                }
            }
        }

        @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
        private void improveGene(EnumBeeChromosome gene, IBeeGenome ibg, ItemStack queen) {
            switch (gene) {
                case FERTILITY: 
                case FLOWERING: 
                case TERRITORY: 
                case SPEED: {
                    BeeAlleleRegistry.BeeGene g = ReikaBeeHelper.getGeneEnum((EnumBeeChromosome)gene, (IBeeGenome)ibg);
                    if (g == null || (g = g.oneBetter()) == null) break;
                    ReikaBeeHelper.setGene((ItemStack)queen, (IBeeGenome)ibg, (EnumBeeChromosome)gene, (IAllele)g.getAllele(), (boolean)true);
                    break;
                }
                case TEMPERATURE_TOLERANCE: {
                    EnumTolerance next;
                    if (ibg.getToleranceTemp() == EnumTolerance.NONE || (next = ReikaBeeHelper.getOneBetterTolerance((EnumTolerance)ibg.getToleranceTemp())) == null) break;
                    ReikaBeeHelper.setGene((ItemStack)queen, (IBeeGenome)ibg, (EnumBeeChromosome)gene, (IAllele)ReikaBeeHelper.getToleranceGene((EnumTolerance)next), (boolean)true);
                    break;
                }
                case HUMIDITY_TOLERANCE: {
                    EnumTolerance next;
                    if (ibg.getToleranceHumid() == EnumTolerance.NONE || (next = ReikaBeeHelper.getOneBetterTolerance((EnumTolerance)ibg.getToleranceHumid())) == null) break;
                    ReikaBeeHelper.setGene((ItemStack)queen, (IBeeGenome)ibg, (EnumBeeChromosome)gene, (IAllele)ReikaBeeHelper.getToleranceGene((EnumTolerance)next), (boolean)true);
                    break;
                }
            }
        }

        @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
        private boolean canImprove(EnumBeeChromosome gene, IBeeGenome ibg) {
            switch (gene) {
                case FERTILITY: {
                    return ibg.getFertility() < BeeAlleleRegistry.Fertility.MAXIMUM.getAllele().getValue();
                }
                case FLOWERING: {
                    return ibg.getFlowering() < BeeAlleleRegistry.Flowering.FASTEST.getAllele().getValue();
                }
                case HUMIDITY_TOLERANCE: {
                    return ReikaBeeHelper.getToleranceValue((EnumTolerance)ibg.getToleranceHumid()) > 0 && ReikaBeeHelper.getToleranceValue((EnumTolerance)ibg.getToleranceHumid()) < 2;
                }
                case SPEED: {
                    return ibg.getSpeed() < BeeAlleleRegistry.Speeds.FASTEST.getAllele().getValue();
                }
                case TEMPERATURE_TOLERANCE: {
                    return ReikaBeeHelper.getToleranceValue((EnumTolerance)ibg.getToleranceTemp()) > 0 && ReikaBeeHelper.getToleranceValue((EnumTolerance)ibg.getToleranceTemp()) < 2;
                }
                case TERRITORY: {
                    return ibg.getTerritory()[0] < BeeAlleleRegistry.Territory.LARGEST.getAllele().getValue()[0];
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Genetic Improvement";
        }
    }

    private static class ExplorationEffect
    extends LumenAlvearyEffect {
        private ExplorationEffect() {
            super(CrystalElement.LIME, 120);
        }

        @Override
        protected float territoryFactor(TileEntityLumenAlveary te) {
            return 1.5f;
        }

        @Override
        public String getDescription() {
            return "Exploration";
        }
    }

    private static class GeneticFluxEffect
    extends LumenAlvearyEffect {
        private GeneticFluxEffect() {
            super(CrystalElement.BLACK, 60);
        }

        @Override
        protected float mutationFactor(TileEntityLumenAlveary te) {
            return 4.0f;
        }

        @Override
        public String getDescription() {
            return "Genetic Flux";
        }
    }

    private static class GeneticStabilityEffect
    extends LumenAlvearyEffect {
        private GeneticStabilityEffect() {
            super(CrystalElement.WHITE, 20);
        }

        @Override
        protected float mutationFactor(TileEntityLumenAlveary te) {
            return 0.0f;
        }

        @Override
        protected float decayFactor(TileEntityLumenAlveary te) {
            return 0.75f;
        }

        @Override
        public String getDescription() {
            return "Genetic Stability";
        }
    }

    private static class GeneticBalancingEffect
    extends LumenAlvearyEffect {
        private static final double pristineConversionChance = 5.0E-4;
        private static final double geneBalancingChance = 0.005;

        private GeneticBalancingEffect() {
            super(CrystalElement.WHITE, 80);
        }

        @Override
        protected void tick(TileEntityLumenAlveary te) {
            EnumBeeChromosome gene;
            ItemStack queen;
            IBeeHousing ibh = te.getBeeHousing();
            IBeeGenome ibg = te.getBeeGenome();
            if (ibg == null) {
                return;
            }
            if (ReikaRandomHelper.doWithChance((double)5.0E-4) && (queen = ibh.getBeeInventory().getQueen()) != null && AlleleManager.alleleRegistry.getIndividual(queen) instanceof IBee) {
                ReikaBeeHelper.setPristine((ItemStack)queen, (boolean)true);
            }
            if (ReikaRandomHelper.doWithChance((double)0.005) && (queen = ibh.getBeeInventory().getQueen()) != null && AlleleManager.alleleRegistry.getIndividual(queen) instanceof IBee && this.canBalance(queen, ibg, gene = EnumBeeChromosome.values()[rand.nextInt(EnumBeeChromosome.values().length)])) {
                this.balanceGene(queen, ibg, gene);
            }
        }

        @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
        private void balanceGene(ItemStack queen, IBeeGenome ibg, EnumBeeChromosome gene) {
            ReikaBeeHelper.setGene((ItemStack)queen, (IBeeGenome)ibg, (EnumBeeChromosome)gene, (IAllele)ibg.getActiveAllele((IChromosomeType)gene), (boolean)true);
        }

        @DependentMethodStripper.ModDependent(value=ModList.FORESTRY)
        private boolean canBalance(ItemStack queen, IBeeGenome ibg, EnumBeeChromosome gene) {
            if (gene == EnumBeeChromosome.HUMIDITY) {
                return false;
            }
            IAllele primary = ibg.getActiveAllele((IChromosomeType)gene);
            IAllele secondary = ibg.getInactiveAllele((IChromosomeType)gene);
            return !primary.getUID().equals(secondary.getUID());
        }

        @Override
        public String getDescription() {
            return "Genetic Balancing";
        }
    }

    private static class HistoryRewriteEffect
    extends LumenAlvearyEffect {
        private static final double mateRewriteChance = 0.01;

        private HistoryRewriteEffect() {
            super(CrystalElement.LIGHTGRAY, 40);
        }

        @Override
        protected void tick(TileEntityLumenAlveary te) {
            IIndividual ii;
            ItemStack queen;
            if (ReikaRandomHelper.doWithChance((double)0.01) && (queen = te.getBeeHousing().getBeeInventory().getQueen()) != null && (ii = AlleleManager.alleleRegistry.getIndividual(queen)) instanceof IBee) {
                ReikaBeeHelper.setBeeMate((IBee)((IBee)ii), (IBee)((IBee)ii));
            }
        }

        @Override
        public String getDescription() {
            return "History Rewrite";
        }
    }

    private static class LightningProductionEffect
    extends LumenAlvearyEffect {
        private LightningProductionEffect() {
            super(CrystalElement.YELLOW, 100);
        }

        @Override
        protected void tick(TileEntityLumenAlveary te) {
            if (te.getBeeHousing().canBlockSeeTheSky() && te.getBeeHousing().getBiome().func_76738_d() && te.field_145850_b.func_72911_I() && te.field_145850_b.field_73007_j.size() > 0) {
                te.lightningTicks = 15;
            }
            if (te.lightningTicks > 0) {
                int n = 1 + te.lightningTicks / 4;
                for (int i = 0; i < n; ++i) {
                    ReikaBeeHelper.runProductionCycle((IBeeHousing)te.getBeeHousing());
                }
                te.lightningTicks--;
            }
        }

        @Override
        public String getDescription() {
            return "Lightning Production";
        }
    }

    private static class AccelerationEffectIII
    extends AccelerationEffect {
        private AccelerationEffectIII() {
            super(7, 1600);
        }
    }

    private static class AccelerationEffectII
    extends AccelerationEffect {
        private AccelerationEffectII() {
            super(3, 480);
        }
    }

    private static class AccelerationEffectI
    extends AccelerationEffect {
        private AccelerationEffectI() {
            super(1, 80);
        }
    }

    private static abstract class AccelerationEffect
    extends LumenAlvearyEffect {
        private final int tickRate;

        private AccelerationEffect(int ticks, int cost) {
            super(CrystalElement.LIGHTBLUE, cost);
            this.tickRate = ticks;
        }

        @Override
        protected void tick(TileEntityLumenAlveary te) {
            for (int i = 0; i < this.tickRate; ++i) {
                te.tickAlveary();
            }
        }

        @Override
        public final String getDescription() {
            return "Acceleration x" + (this.tickRate + 1);
        }
    }

    private static class AutomationEffect
    extends LumenAlvearyEffect {
        private AutomationEffect() {
            super(CrystalElement.GREEN, 100);
        }

        @Override
        protected boolean consumeOnTick() {
            return false;
        }

        @Override
        public String getDescription() {
            return "Genetic Recycling";
        }

        @Override
        protected int tickRate() {
            return 4;
        }
    }

    private static abstract class LumenAlvearyEffect
    extends AlvearyEffect {
        public final CrystalElement color;
        public final int requiredEnergy;

        protected LumenAlvearyEffect(CrystalElement e, int amt) {
            this.color = e;
            this.requiredEnergy = amt;
        }

        protected boolean consumeOnTick() {
            return true;
        }

        @Override
        protected final boolean isActive(TileEntityLumenAlveary te) {
            return te.energy.containsAtLeast(this.color, this.requiredEnergy);
        }

        @Override
        protected final void consumeEnergy(TileEntityLumenAlveary te, int amount) {
            int amt = amount * this.requiredEnergy;
            if (te.energy.containsAtLeast(this.color, amt)) {
                te.drainEnergy(this.color, amt);
            }
        }
    }

    private static class ProductionBoostEffect
    extends VisAlvearyEffect {
        private ProductionBoostEffect() {
            super(Aspect.ORDER, 20);
        }

        @Override
        protected float productionFactor(TileEntityLumenAlveary te) {
            return 2.0f;
        }

        @Override
        public String getDescription() {
            return "Production Boost";
        }
    }

    private static abstract class VisAlvearyEffect
    extends AlvearyEffect {
        public final Aspect aspect;
        public final int requiredVis;

        protected VisAlvearyEffect(Aspect a, int amt) {
            this.aspect = a;
            this.requiredVis = amt;
        }

        protected boolean consumeOnTick() {
            return true;
        }

        @Override
        protected final boolean isActive(TileEntityLumenAlveary te) {
            return te.aspects.getAmount(this.aspect) >= this.requiredVis;
        }

        @Override
        protected final void consumeEnergy(TileEntityLumenAlveary te, int amount) {
            int amt = amount * this.requiredVis;
            te.aspects.reduce(this.aspect, this.requiredVis);
        }
    }

    private static abstract class AlvearyEffect {
        protected AlvearyEffect() {
            effectSet.add(this);
            if (this.worksWhenBeesDoNot()) {
                continualSet.add(this);
            }
        }

        public abstract String getDescription();

        protected abstract void consumeEnergy(TileEntityLumenAlveary var1, int var2);

        protected abstract boolean isActive(TileEntityLumenAlveary var1);

        protected void tick(TileEntityLumenAlveary te) {
        }

        protected int tickRate() {
            return 1;
        }

        protected void onProductionTick(TileEntityLumenAlveary te) {
        }

        protected boolean worksWhenBeesDoNot() {
            return false;
        }

        protected float productionFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float pollinationFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float lifespanFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float mutationFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float territoryFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float decayFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected boolean isSealed(TileEntityLumenAlveary te) {
            return false;
        }

        protected boolean isSelfLit(TileEntityLumenAlveary te) {
            return false;
        }

        protected boolean isSkySimulated(TileEntityLumenAlveary te) {
            return false;
        }

        protected boolean isHellish(TileEntityLumenAlveary te) {
            return false;
        }
    }
}

