/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.ModInterface.Bees.ProductChecks;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.GUI.StatusLogger;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BasicFlowerProvider;
import Reika.DragonAPI.ModInteract.Bees.BasicGene;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SpecialAlleles {

    static class FlowerProviderCrystal
    extends BasicFlowerProvider
    implements ChromaBeeHelpers.ConditionalProductProvider {
        public final CrystalElement color;

        private FlowerProviderCrystal(CrystalElement color) {
            super(ChromaBlocks.CRYSTAL.getBlockInstance(), color.ordinal(), color.name().toLowerCase(Locale.ENGLISH));
            this.color = color;
        }

        public String getDescription() {
            return this.color.displayName;
        }

        public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
            IBeeGenome ibg = ((IBee)individual).getGenome();
            IAlleleBeeSpecies bee1 = ibg.getPrimary();
            IAlleleBeeSpecies bee2 = ibg.getSecondary();
            IBeeHousing ibh = (IBeeHousing)world.func_147438_o(x, y, z);
            ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])products);
            ItemHashMap<ProductChecks.ProductCondition> map = CrystalBees.productConditions.get((Object)this.color);
            ModularLogger.instance.log("CrystalBees", "Flower provider " + this.getDescription() + " affecting products " + li + " for " + bee1.getName() + "; map=" + map);
            if (map != null) {
                Iterator it = li.iterator();
                while (it.hasNext()) {
                    ItemStack is = (ItemStack)it.next();
                    ProductChecks.ProductCondition c = (ProductChecks.ProductCondition)map.get(is);
                    ModularLogger.instance.log("CrystalBees", "Check for " + is.func_82833_r() + ": " + c);
                    if (c == null) continue;
                    boolean flag = false;
                    if (bee1.getUID().equals(bee2.getUID()) && bee1.getUID().equals(CrystalBees.beeMap.get((Object)this.color).getUID())) {
                        if (this.areConditionalsAvailable(world, x, y, z, ibg, ibh)) {
                            ibh.getErrorLogic().setCondition(false, CrystalBees.conditionalsUnavailable);
                            if (c.check(world, x, y, z, ibg, ibh)) {
                                ModularLogger.instance.log("CrystalBees", "Check for " + is.func_82833_r() + " passed.");
                                flag = true;
                            }
                        } else {
                            ModularLogger.instance.log("CrystalBees", "Conditionals unavailable. Removing.");
                            ibh.getErrorLogic().setCondition(true, CrystalBees.conditionalsUnavailable);
                        }
                    }
                    if (flag) continue;
                    ModularLogger.instance.log("CrystalBees", "Check for " + is.func_82833_r() + " failed. Removing.");
                    it.remove();
                }
            }
            ItemStack[] ret = li.toArray(new ItemStack[li.size()]);
            return ret;
        }

        private boolean areConditionalsAvailable(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            if (!this.matchFlowerGene(ibg)) {
                return false;
            }
            if (CrystalBees.rand.nextFloat() > ibg.getSpeed()) {
                return false;
            }
            if (ibg.getFlowering() < BeeAlleleRegistry.Flowering.AVERAGE.getAllele().getValue()) {
                return false;
            }
            if (!ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)) && CrystalBees.rand.nextInt(2) > 0) {
                return false;
            }
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z))) {
                return false;
            }
            if (!ChromaBeeHelpers.isBestPossibleBee(ibg) && CrystalBees.rand.nextInt(2) > 0) {
                return false;
            }
            if (CrystalBees.rand.nextInt(3) > 0) {
                return true;
            }
            EntityPlayer ep = world.func_152378_a(ibh.getOwner().getId());
            if (ep != null) {
                return ProgressionManager.ProgressStage.SHARDCHARGE.isPlayerAtStage(ep);
            }
            return false;
        }

        private boolean matchFlowerGene(IBeeGenome ibg) {
            return ibg.getFlowerProvider() instanceof FlowerProviderCrystal && ((FlowerProviderCrystal)ibg.getFlowerProvider()).color == this.color;
        }

        @Override
        public ItemHashMap<ProductChecks.ProductCondition> getConditions() {
            return CrystalBees.productConditions.get((Object)this.color);
        }

        @Override
        public ArrayList<String> getGeneralRequirements() {
            ArrayList<String> li = new ArrayList<String>();
            li.add("Unmodified flower allele");
            li.add("'" + BeeAlleleRegistry.Flowering.AVERAGE.getAllele().getName() + "' flowering");
            li.add("Ambient temperature between 8C and 32C");
            li.add("50% boost from Rainbow Forest");
            li.add("50% boost from genetic superiority");
            li.add("33% boost from '" + ProgressionManager.ProgressStage.SHARDCHARGE.getTitle() + "' progression");
            li.add("Linear gains from faster production speeds");
            return li;
        }

        @Override
        public void sendStatusInfo(World world, int x, int y, int z, StatusLogger log, IBeeGenome ibg, IBeeHousing ibh) {
            log.addStatus("Flower Allele", this.matchFlowerGene(ibg));
            log.addStatus("Flowering Level", ibg.getFlowering() >= BeeAlleleRegistry.Flowering.AVERAGE.getAllele().getValue());
            log.addStatus("Temperature", ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z)));
            log.addStatus("Rainbow Forest", ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)));
            log.addStatus("Gene Superiority", ChromaBeeHelpers.isBestPossibleBee(ibg));
            EntityPlayer ep = world.func_152378_a(ibh.getOwner().getId());
            log.addStatus("Boosted Shard Progression", ep != null && ProgressionManager.ProgressStage.SHARDCHARGE.isPlayerAtStage(ep));
            for (ProductChecks.ProductCondition p : this.getConditions().values()) {
                log.addStatus(p.getDescription(), p.check(world, x, y, z, ibg, ibh));
            }
        }
    }

    static class FlowerProviderMulti
    extends BasicFlowerProvider
    implements ChromaBeeHelpers.ConditionalProductProvider {
        static final ItemHashMap<ProductChecks.ProductCondition> conditions = new ItemHashMap();

        private FlowerProviderMulti() {
            super(ChromaBlocks.RAINBOWLEAF.getBlockInstance(), 0, "Rainbow Leaves");
        }

        public String getDescription() {
            return "Shimmering, multicolored leaves";
        }

        public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
            IBeeGenome ibg = ((IBee)individual).getGenome();
            IAlleleBeeSpecies bee1 = ibg.getPrimary();
            IAlleleBeeSpecies bee2 = ibg.getSecondary();
            IBeeHousing ibh = (IBeeHousing)world.func_147438_o(x, y, z);
            ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])products);
            ModularLogger.instance.log("CrystalBees", "Flower provider " + this.getDescription() + " affecting products " + li + " for " + bee1.getName() + "; map=" + conditions);
            Iterator it = li.iterator();
            while (it.hasNext()) {
                ItemStack is = (ItemStack)it.next();
                ProductChecks.ProductCondition c = (ProductChecks.ProductCondition)conditions.get(is);
                ModularLogger.instance.log("CrystalBees", "Check for " + is.func_82833_r() + ": " + c);
                if (c == null) continue;
                boolean flag = false;
                if (bee1.getUID().equals(bee2.getUID()) && bee1.getUID().equals(CrystalBees.multi.getUID())) {
                    if (this.areConditionalsAvailable(world, x, y, z, ibg, ibh)) {
                        ibh.getErrorLogic().setCondition(false, CrystalBees.conditionalsUnavailable);
                        if (c.check(world, x, y, z, ibg, ibh)) {
                            ModularLogger.instance.log("CrystalBees", "Check for " + is.func_82833_r() + " passed.");
                            flag = true;
                        }
                    } else {
                        ModularLogger.instance.log("CrystalBees", "Conditionals unavailable. Removing.");
                        ibh.getErrorLogic().setCondition(true, CrystalBees.conditionalsUnavailable);
                    }
                }
                if (flag) continue;
                ModularLogger.instance.log("CrystalBees", "Check for " + is.func_82833_r() + " failed. Removing.");
                it.remove();
            }
            ItemStack[] ret = li.toArray(new ItemStack[li.size()]);
            return ret;
        }

        private boolean areConditionalsAvailable(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            if (!this.matchFlowerGene(ibg)) {
                return false;
            }
            if (CrystalBees.rand.nextFloat() > ibg.getSpeed() / 4.0f) {
                return false;
            }
            if (ibg.getFlowering() < CrystalBees.superFlowering.getAllele().getValue()) {
                return false;
            }
            if (!ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)) && CrystalBees.rand.nextInt(2) > 0) {
                return false;
            }
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z))) {
                return false;
            }
            if (!ChromaBeeHelpers.isBestPossibleBee(ibg) && CrystalBees.rand.nextInt(2) > 0) {
                return false;
            }
            if (CrystalBees.rand.nextInt(3) > 0) {
                return true;
            }
            EntityPlayer ep = world.func_152378_a(ibh.getOwner().getId());
            if (ep != null) {
                return ProgressionManager.ProgressStage.DIMENSION.isPlayerAtStage(ep);
            }
            return false;
        }

        private boolean matchFlowerGene(IBeeGenome ibg) {
            return ibg.getFlowerProvider() instanceof FlowerProviderMulti;
        }

        @Override
        public ItemHashMap<ProductChecks.ProductCondition> getConditions() {
            return conditions;
        }

        @Override
        public ArrayList<String> getGeneralRequirements() {
            ArrayList<String> li = new ArrayList<String>();
            li.add("Unmodified flower allele");
            li.add("'" + CrystalBees.superFlowering.getAllele().getName() + "' flowering");
            li.add("Ambient temperature between 8C and 32C");
            li.add("50% boost from Rainbow Forest");
            li.add("50% boost from genetic superiority");
            li.add("33% boost from '" + ProgressionManager.ProgressStage.DIMENSION.getTitle() + "' progression");
            li.add("Linear gains from faster production speeds");
            return li;
        }

        @Override
        public void sendStatusInfo(World world, int x, int y, int z, StatusLogger log, IBeeGenome ibg, IBeeHousing ibh) {
            log.addStatus("Flower Allele", this.matchFlowerGene(ibg));
            log.addStatus("Flowering Level", ibg.getFlowering() >= CrystalBees.superFlowering.getAllele().getValue());
            log.addStatus("Temperature", ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z)));
            log.addStatus("Rainbow Forest", ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)));
            log.addStatus("Gene Superiority", ChromaBeeHelpers.isBestPossibleBee(ibg));
            EntityPlayer ep = world.func_152378_a(ibh.getOwner().getId());
            log.addStatus("Dimension Progression", ep != null && ProgressionManager.ProgressStage.DIMENSION.isPlayerAtStage(ep));
            for (ProductChecks.ProductCondition p : this.getConditions().values()) {
                log.addStatus(p.getDescription(), p.check(world, x, y, z, ibg, ibh));
            }
        }
    }

    static final class CrystalEffect
    extends BasicGene
    implements IAlleleBeeEffect {
        public final CrystalElement color;
        private long lastWorldTick = -1L;
        private long lastWorldTickClient = -1L;

        public CrystalEffect(CrystalElement color) {
            super("effect.cavecrystal." + color.name().toLowerCase(Locale.ENGLISH), color.displayName + " Aura", EnumBeeChromosome.EFFECT);
            this.color = color;
        }

        public boolean isCombinable() {
            return true;
        }

        public IEffectData validateStorage(IEffectData ied) {
            return ied;
        }

        public IEffectData doEffect(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                ChunkCoordinates c = ibh.getCoordinates();
                if (this.canApplyEffect(world, c.field_71574_a, c.field_71572_b, c.field_71573_c)) {
                    int[] r = ibg.getTerritory();
                    AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)c.field_71574_a, (int)c.field_71572_b, (int)c.field_71573_c).func_72314_b((double)r[0], (double)r[1], (double)r[2]);
                    IEntitySelector s = null;
                    Class<EntityLivingBase> ce = EntityLivingBase.class;
                    switch (this.color) {
                        case MAGENTA: 
                        case CYAN: 
                        case LIGHTBLUE: 
                        case ORANGE: 
                        case PINK: 
                        case LIME: 
                        case RED: {
                            s = ReikaEntityHelper.nonMobSelector;
                            break;
                        }
                        case GREEN: {
                            ce = EntityPlayer.class;
                            break;
                        }
                        case BLACK: 
                        case GRAY: 
                        case LIGHTGRAY: {
                            s = ReikaEntityHelper.hostileOrPlayerSelector;
                            break;
                        }
                    }
                    List li = world.func_82733_a(ce, box, s);
                    for (EntityLivingBase e : li) {
                        CrystalPotionController.applyEffectFromColor(600, 0, e, this.color, CrystalBees.rand.nextInt(240) == 0 && e.func_70092_e((double)c.field_71574_a + 0.5, (double)c.field_71572_b + 0.5, (double)c.field_71573_c + 0.5) < 256.0);
                    }
                }
                if (this.lastWorldTick != world.func_82737_E() && CrystalBees.rand.nextInt(8000) == 0) {
                    ChromaAux.spawnInteractionBallLightning(world, c.field_71574_a, c.field_71572_b, c.field_71573_c, this.color);
                }
                this.lastWorldTick = world.func_82737_E();
            }
            return ied;
        }

        private boolean canApplyEffect(World world, int x, int y, int z) {
            if (this.color == CrystalElement.BLUE) {
                return world.func_72937_j(x, y + 1, z);
            }
            return true;
        }

        private boolean isValidBeeForEffect(IAlleleBeeSpecies bee) {
            return bee == CrystalBees.multi || bee instanceof CrystalBees.CrystalBee && ((CrystalBees.CrystalBee)bee).color == this.color;
        }

        @SideOnly(value=Side.CLIENT)
        public IEffectData doFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            World world;
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary()) && this.lastWorldTickClient != (world = ibh.getWorld()).func_82737_E()) {
                ChunkCoordinates c = ibh.getCoordinates();
                int delay = 12;
                ImmutablePair<CrystalElement, Integer> p = this.getActiveFXColor(world, delay);
                if (p.left == this.color) {
                    float vol;
                    int[] r = ibg.getTerritory();
                    AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)c.field_71574_a, (int)c.field_71572_b, (int)c.field_71573_c).func_72314_b((double)r[0], (double)r[1], (double)r[2]);
                    int n = (int)(Math.sqrt(ReikaAABBHelper.getVolume((AxisAlignedBB)box) / 480.0) / 2.0);
                    for (int i = 0; i < n; ++i) {
                        double px = ReikaRandomHelper.getRandomBetween((double)box.field_72340_a, (double)box.field_72336_d);
                        double py = ReikaRandomHelper.getRandomBetween((double)box.field_72338_b, (double)box.field_72337_e);
                        double pz = ReikaRandomHelper.getRandomBetween((double)box.field_72339_c, (double)box.field_72334_f);
                        float s = 1.0f + CrystalBees.rand.nextFloat();
                        EntityRuneFX fx = new EntityRuneFX(world, px, py, pz, this.color).setGravity(0.0f).setScale(s).setFading();
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    int n2 = (int)(Math.pow((double)n * 1.5, 1.5) / 4.0);
                    for (int i = 0; i < n2; ++i) {
                        double px = ReikaRandomHelper.getRandomBetween((double)box.field_72340_a, (double)box.field_72336_d);
                        double py = ReikaRandomHelper.getRandomBetween((double)box.field_72338_b, (double)box.field_72337_e);
                        double pz = ReikaRandomHelper.getRandomBetween((double)box.field_72339_c, (double)box.field_72334_f);
                        int s = CrystalBees.rand.nextInt(6);
                        switch (s) {
                            case 0: {
                                px = box.field_72340_a;
                                break;
                            }
                            case 1: {
                                px = box.field_72336_d;
                                break;
                            }
                            case 2: {
                                py = box.field_72338_b;
                                break;
                            }
                            case 3: {
                                py = box.field_72337_e;
                                break;
                            }
                            case 4: {
                                pz = box.field_72339_c;
                                break;
                            }
                            case 5: {
                                pz = box.field_72334_f;
                            }
                        }
                        EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setColor(this.color.getColor()).setScale(2.0f).setIcon(ChromaIcons.FADE_RAY);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                    String cl = gui != null ? gui.getClass().getName().toLowerCase(Locale.ENGLISH) : "";
                    boolean open = gui != null && (cl.contains("apiculture") || cl.contains("gendustry"));
                    float f = vol = open ? 1.5f : 0.45f;
                    if (world.func_82737_E() % (long)delay == 0L) {
                        int sound = (Integer)p.right;
                        if (sound == 0 || sound == 5) {
                            for (int i = 0; i <= 3; ++i) {
                                float f2 = CrystalMusicManager.instance.getScaledDing(this.color, i);
                                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (double)((double)c.field_71574_a + 0.5), (double)((double)c.field_71572_b + 0.5), (double)((double)c.field_71573_c + 0.5), (float)(vol / 3.0f), (float)f2);
                            }
                        } else {
                            float f3 = CrystalMusicManager.instance.getScaledDing(this.color, sound - 1);
                            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (double)((double)c.field_71574_a + 0.5), (double)((double)c.field_71572_b + 0.5), (double)((double)c.field_71573_c + 0.5), (float)vol, (float)f3);
                        }
                    }
                }
                this.lastWorldTickClient = world.func_82737_E();
            }
            return ied;
        }

        private ImmutablePair<CrystalElement, Integer> getActiveFXColor(World world, int delay) {
            long tick = world.func_82737_E() / (long)delay;
            int steps = 6;
            int active = (int)(tick / (long)steps % 16L);
            int sound = (int)(tick % (long)steps);
            return new ImmutablePair((Object)CrystalElement.elements[active], (Object)sound);
        }
    }

    static final class MultiAllele
    extends BasicGene
    implements IAlleleFlowers {
        private final FlowerProviderMulti provider = new FlowerProviderMulti();

        public MultiAllele() {
            super("flower.rainbowleaf", "Rainbow Leaves", EnumBeeChromosome.FLOWER_PROVIDER);
        }

        public IFlowerProvider getProvider() {
            return this.provider;
        }
    }

    static final class CrystalAllele
    extends BasicGene
    implements IAlleleFlowers {
        public final CrystalElement color;
        private final FlowerProviderCrystal provider;

        public CrystalAllele(CrystalElement color) {
            super("flower.cavecrystal." + color.name().toLowerCase(Locale.ENGLISH), color.displayName, EnumBeeChromosome.FLOWER_PROVIDER);
            this.color = color;
            this.provider = new FlowerProviderCrystal(color);
        }

        public IFlowerProvider getProvider() {
            return this.provider;
        }
    }
}

