/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Auxiliary.ProgressionCacher;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityAuraInfuser;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ProductChecks {

    static class RainbowTreeCheck
    extends ProductCondition {
        private final AreaBlockCheck check = new AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.RAINBOWLEAF.getBlockInstance(), 0), 3, 2);

        RainbowTreeCheck() {
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.check.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return "Rainbow Leaves";
        }
    }

    static class ChargedShardCheck
    extends ProductCondition {
        private final CrystalElement color;
        private final AreaBlockCheck crystal;
        private final AreaBlockCheck chroma;
        private final LeafCheck leaf;
        private final ProgressionCheck progress;

        ChargedShardCheck(CrystalElement e) {
            this.color = e;
            this.leaf = new LeafCheck(e);
            this.chroma = new AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.CHROMA.getBlockInstance(), 0), 1);
            FilledBlockArray.MultiKey crys = new FilledBlockArray.MultiKey();
            crys.add((BlockCheck)new BlockKey(ChromaBlocks.CRYSTAL.getBlockInstance(), 0));
            crys.add((BlockCheck)new BlockKey(ChromaBlocks.SUPER.getBlockInstance(), 0));
            this.crystal = new AreaBlockCheck((BlockCheck)crys, 1);
            this.progress = new ProgressionCheck(ProgressionManager.ProgressStage.SHARDCHARGE);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.progress.check(world, x, y, z, ibg, ibh) && this.crystal.check(world, x, y, z, ibg, ibh) && this.chroma.check(world, x, y, z, ibg, ibh) && this.leaf.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return "Liquid Chroma, " + this.color.displayName + " Tree and Crystal";
        }
    }

    static class LeafCheck
    extends ProductCondition {
        private final CrystalElement color;
        private final AreaBlockCheck check;

        LeafCheck(CrystalElement e) {
            this.color = e;
            FilledBlockArray.MultiKey mk = new FilledBlockArray.MultiKey();
            mk.add((BlockCheck)new BlockKey(ChromaBlocks.DECAY.getBlockInstance(), this.color.ordinal()));
            this.check = new AreaBlockCheck((BlockCheck)mk, 2, 2);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.check.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return this.color.displayName + " Dye Leaves";
        }
    }

    static class FlowerCheck
    extends ProductCondition {
        private final CrystalElement color;
        private final AreaBlockCheck check;

        FlowerCheck(CrystalElement e) {
            this.color = e;
            this.check = new AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.DYEFLOWER.getBlockInstance(), this.color.ordinal()), 1);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.check.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return this.color.displayName + " Dye Flowers";
        }
    }

    static class CrystalPlantCheck
    extends ProductCondition {
        private final CrystalElement color;
        private final AreaBlockCheck check;

        CrystalPlantCheck(CrystalElement e) {
            this.color = e;
            this.check = new AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.PLANT.getBlockInstance(), this.color.ordinal()), 1);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.check.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return this.color.displayName + " Crystal Bloom";
        }
    }

    static class ProgressionCheck
    extends ProductCondition {
        private final ProgressionManager.ProgressStage progress;

        ProgressionCheck(ProgressionManager.ProgressStage p) {
            this.progress = p;
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            EntityPlayer ep = world.func_152378_a(ibh.getOwner().getId());
            if (ep != null) {
                return this.progress.isPlayerAtStage(ep);
            }
            ProgressionCacher.ProgressCache c = ChromaBeeHelpers.getProgressCache(ibh);
            return c != null && c.containsProgress(this.progress);
        }

        @Override
        public String getDescription() {
            return "Progression '" + this.progress.getTitle() + "'";
        }
    }

    static class AreaBlockCheck
    extends ProductCondition {
        private final BlockCheck check;
        private final int stepSize;
        private final int stepSizeY;
        private static final HashMap<WorldLocation, Coordinate> successfulChecks = new HashMap();
        private static final WeightedRandom<Double> rangeRandom = new WeightedRandom();
        private static final int SEARCH_LOCS = 16;

        AreaBlockCheck(BlockCheck bk, int s) {
            this(bk, s, s);
        }

        AreaBlockCheck(BlockCheck bk, int s, int sy) {
            this.check = bk;
            this.stepSize = s;
            this.stepSizeY = sy;
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            Coordinate find;
            int[] r = ChromaBeeHelpers.getSearchRange(ibg, ibh);
            WorldLocation loc = ChromaBeeHelpers.getLocation(ibh);
            Coordinate c = successfulChecks.get(loc);
            if (c != null && !this.validate(world, loc, c, r[0], r[1])) {
                c = null;
            }
            if (c == null && (find = this.check(world, x, y, z, r[0], r[1])) != null) {
                successfulChecks.put(loc, find);
                c = find;
            }
            return c != null;
        }

        private boolean validate(World world, WorldLocation loc, Coordinate c, int r, int vr) {
            if (!c.isWithinSquare(new Coordinate(loc), r, vr, r)) {
                return false;
            }
            return this.check.matchInWorld(world, c.xCoord, c.yCoord, c.zCoord);
        }

        private Coordinate check(World world, int x, int y, int z, int r, int vr) {
            double f = (Double)rangeRandom.getRandomEntry();
            if (f == -1.0) {
                for (int i = -r; i <= r; i += this.stepSize) {
                    for (int k = -r; k <= r; k += this.stepSize) {
                        for (int h = -vr; h <= vr; h += this.stepSizeY) {
                            int dx = x + i;
                            int dy = y + h;
                            int dz = z + k;
                            if (!this.check.matchInWorld(world, dx, dy, dz)) continue;
                            return new Coordinate(dx, dy, dz);
                        }
                    }
                }
            } else {
                int dr = (int)(f * (double)r);
                int dvr = (int)(f * (double)vr);
                for (int i = 0; i < 16; ++i) {
                    int dz;
                    int dy;
                    int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
                    if (!this.check.matchInWorld(world, dx, dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)dvr), dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr))) continue;
                    return new Coordinate(dx, dy, dz);
                }
            }
            return null;
        }

        @Override
        public String getDescription() {
            return this.check.asItemStack().func_82833_r();
        }

        static {
            rangeRandom.addEntry((Object)-1.0, 1.0);
            rangeRandom.addEntry((Object)1.0, 4.0);
            rangeRandom.addEntry((Object)0.75, 6.0);
            rangeRandom.addEntry((Object)0.5, 8.0);
            rangeRandom.addEntry((Object)0.25, 16.0);
            rangeRandom.addEntry((Object)0.125, 32.0);
        }
    }

    static class AuraLocusCheck
    extends ProductCondition {
        AuraLocusCheck() {
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            EntityPlayer ep = ChromaBeeHelpers.getOwner(ibh);
            if (ep == null) {
                return false;
            }
            TileEntityAuraPoint te = TileEntityAuraPoint.getPoint(ep);
            if (te == null) {
                return false;
            }
            int[] r = ChromaBeeHelpers.getSearchRange(ibg, ibh);
            return Math.abs(te.field_145851_c - x) <= r[0] && Math.abs(te.field_145849_e - z) <= r[0] && Math.abs(te.field_145848_d - y) <= r[1];
        }

        @Override
        public String getDescription() {
            return "A nearby Aura Locus";
        }
    }

    static class IridescentShardCheck
    extends ProductCondition {
        IridescentShardCheck() {
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            int r;
            IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(ibh);
            int tr = (int)((float)ibg.getTerritory()[0] * 3.0f * beeModifier.getTerritoryModifier(ibg, 1.0f));
            int n = r = tr >= 64 ? 128 : MathHelper.func_76125_a((int)(16 * ReikaMathLibrary.intpow2((int)2, (int)((tr - 9) / 2))), (int)16, (int)96);
            int r2 = r >= 64 ? 24 : (r >= 32 ? 16 : (r >= 16 ? 12 : 8));
            EntityPlayer ep = world.func_152378_a(ibh.getOwner().getId());
            if (ep == null) {
                return false;
            }
            if (!ProgressionManager.ProgressStage.ALLOY.isPlayerAtStage(ep)) {
                return false;
            }
            TileEntityAuraInfuser te = this.check(world, x, y, z, r2, r2);
            return te != null && te.hasStructure() && te.isOwnedByPlayer(ep);
        }

        private TileEntityAuraInfuser check(World world, int x, int y, int z, int r, int vr) {
            boolean last = false;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    for (int h = -vr; h <= vr; ++h) {
                        int dx = x + i;
                        int dy = y + h;
                        int dz = z + k;
                        if (ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz) != ChromaTiles.INFUSER) continue;
                        return (TileEntityAuraInfuser)world.func_147438_o(dx, dy, dz);
                    }
                }
            }
            return null;
        }

        @Override
        public String getDescription() {
            return "An operational infusion ring";
        }
    }

    public static abstract class ProductCondition {
        public abstract boolean check(World var1, int var2, int var3, int var4, IBeeGenome var5, IBeeHousing var6);

        public abstract String getDescription();
    }
}

