/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBeeTypes;
import Reika.ChromatiCraft.ModInterface.Bees.HiveGenerator;
import Reika.ChromatiCraft.ModInterface.Bees.ProductChecks;
import Reika.ChromatiCraft.ModInterface.Bees.SpecialAlleles;
import Reika.ChromatiCraft.ModInterface.ItemColoredModInteract;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.GUI.StatusLogger;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.BeeSpecies;
import Reika.DragonAPI.ModInteract.Bees.BeeTraits;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.OreBerryBushHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class CrystalBees {
    static final String LOGGER_TAG = "CrystalBees";
    static final Random rand = new Random();
    static RawBee feedstock;
    static BasicBee protective;
    static BasicBee luminous;
    static BasicBee hostile;
    static BasicBee crystal;
    static BasicBee purity;
    static AdvancedBee chroma;
    static AdvancedBee lumen;
    static AdvancedBee aura;
    static AdvancedBee multi;
    static BeeAlleleRegistry.Fertility superFertility;
    static BeeAlleleRegistry.Territory superTerritory;
    static BeeAlleleRegistry.Speeds superSpeed;
    static BeeAlleleRegistry.Flowering superFlowering;
    static BeeAlleleRegistry.Life superLife;
    static BeeAlleleRegistry.Life blinkLife;
    static BeeSpecies.BeeBranch crystalBranch;
    static SpecialAlleles.MultiAllele multiFlower;
    private static ColorBlendList chromaColor;
    private static ColorBlendList auraColor;
    private static ColorBlendList lumenColor;
    private static ColorBlendList[] crystalColors;
    private static ColorBlendList multiColor;
    static final IErrorState conditionalsUnavailable;
    static final EnumMap<CrystalElement, CrystalBee> beeMap;
    static final EnumMap<CrystalElement, SpecialAlleles.CrystalEffect> effectMap;
    static final EnumMap<CrystalElement, SpecialAlleles.CrystalAllele> flowerMap;
    static final EnumMap<CrystalElement, ItemHashMap<ProductChecks.ProductCondition>> productConditions;
    static final Collection<ChromaBeeHelpers.ConditionalProductBee> conditionalBees;
    private static final ArrayList<BeeSpecies> basicBees;
    private static final ArrayList<BeeSpecies> advancedBees;

    @SideOnly(value=Side.CLIENT)
    private static void loadColorData() {
        chromaColor = new ColorBlendList(5.0f, ChromaFX.getChromaColorTiles());
        auraColor = new ColorBlendList(18.0f, new int[]{0xFFFF00, 0xFFFFFF, 0, 0x8000FF, 0xFF0000});
        lumenColor = new ColorBlendList(10.0f, new int[]{255, 0xFFFFFF, 0x22AAFF});
        crystalColors = new ColorBlendList[16];
        multiColor = new ColorBlendList(20.0f);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            int c = e.getColor();
            int c1 = ReikaColorAPI.mixColors((int)c, (int)0, (float)0.5f);
            int c2 = ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)0.5f);
            CrystalBees.crystalColors[i] = new ColorBlendList(40.0f, new int[]{c, c, c, c1, c, c, c, c2});
            multiColor.addColor(c);
        }
    }

    public static void register() {
        superFertility = BeeAlleleRegistry.Fertility.createNew((String)"multiply", (int)8, (boolean)false);
        superSpeed = BeeAlleleRegistry.Speeds.createNew((String)"accelerated", (float)4.0f, (boolean)false);
        superFlowering = BeeAlleleRegistry.Flowering.createNew((String)"naturalistic", (int)240, (boolean)false);
        superTerritory = BeeAlleleRegistry.Territory.createNew((String)"exploratory", (int)32, (int)16, (boolean)false);
        superLife = BeeAlleleRegistry.Life.createNew((String)"eon", (int)600, (boolean)false);
        blinkLife = BeeAlleleRegistry.Life.createNew((String)"blink", (int)2, (boolean)false);
        crystalBranch = new BeeSpecies.BeeBranch("branch.cccrystal", "Crystal", "Vitreus", "These bees can sense and sometimes field the crystal elements.");
        feedstock = new RawBee("Raw", "Imperitus Materia", 0x888888);
        feedstock.register();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement color = CrystalElement.elements[i];
            BeeTraits traits = CrystalBeeTypes.list[i].getTraits();
            CrystalBee bee = new CrystalBee(color, traits);
            SpecialAlleles.CrystalEffect eff = new SpecialAlleles.CrystalEffect(color);
            SpecialAlleles.CrystalAllele flw = new SpecialAlleles.CrystalAllele(color);
            effectMap.put(color, eff);
            flowerMap.put(color, flw);
            bee.register();
            beeMap.put(color, bee);
        }
        multiFlower = new SpecialAlleles.MultiAllele();
        ForestryAPI.errorStateRegistry.registerErrorState(conditionalsUnavailable);
        crystal = new BasicBee("Crystalline", "Vitreus Crystallum", BeeAlleleRegistry.Speeds.NORMAL, BeeAlleleRegistry.Life.SHORTEST, BeeAlleleRegistry.Flowering.SLOWEST, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.DEFAULT, 4630527);
        purity = new BasicBee("Pure", "Purus Mundi", BeeAlleleRegistry.Speeds.SLOWER, BeeAlleleRegistry.Life.NORMAL, BeeAlleleRegistry.Flowering.AVERAGE, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, 0xFFFFFF);
        protective = new BasicBee("Protective", "Vitreus Auxilium", BeeAlleleRegistry.Speeds.SLOWER, BeeAlleleRegistry.Life.ELONGATED, BeeAlleleRegistry.Flowering.SLOWER, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, 16734611);
        luminous = new BasicBee("Luminous", "Vitreus Lumens", BeeAlleleRegistry.Speeds.SLOW, BeeAlleleRegistry.Life.SHORTER, BeeAlleleRegistry.Flowering.SLOWER, BeeAlleleRegistry.Fertility.HIGH, BeeAlleleRegistry.Territory.DEFAULT, 12250111);
        hostile = new BasicBee("Hostile", "Vitreus Inimicus", BeeAlleleRegistry.Speeds.SLOWEST, BeeAlleleRegistry.Life.SHORT, BeeAlleleRegistry.Flowering.SLOW, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.DEFAULT, 16738816);
        crystal.register();
        purity.register();
        protective.register();
        luminous.register();
        hostile.register();
        chroma = new AdvancedBee("Iridescent", "Auram Stellans", BeeAlleleRegistry.Speeds.SLOWER, BeeAlleleRegistry.Life.NORMAL, BeeAlleleRegistry.Flowering.SLOWEST, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, chromaColor, EnumTemperature.COLD, ProgressionManager.ProgressStage.ALLOY);
        lumen = new AdvancedBee("Luminescent", "Auram Ardens", BeeAlleleRegistry.Speeds.NORMAL, BeeAlleleRegistry.Life.SHORTENED, BeeAlleleRegistry.Flowering.SLOWER, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, lumenColor, EnumTemperature.NORMAL, ProgressionManager.ProgressStage.DIMENSION);
        aura = new AdvancedBee("Radiant", "Auram Pharus", BeeAlleleRegistry.Speeds.SLOW, BeeAlleleRegistry.Life.LONG, BeeAlleleRegistry.Flowering.SLOW, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, auraColor, EnumTemperature.ICY, ProgressionManager.ProgressStage.CTM);
        multi = new AdvancedBee("Polychromatic", "Pigmentum Pluralis", BeeAlleleRegistry.Speeds.SLOWEST, BeeAlleleRegistry.Life.ELONGATED, BeeAlleleRegistry.Flowering.AVERAGE, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.DEFAULT, multiColor, EnumTemperature.WARM, ProgressionManager.ProgressStage.CTM);
        chroma.register();
        lumen.register();
        aura.register();
        multi.register();
        CrystalBees.addBreeding(CrystalElement.RED, CrystalElement.YELLOW, CrystalElement.ORANGE);
        CrystalBees.addBreeding(CrystalElement.WHITE, CrystalElement.GREEN, CrystalElement.LIME);
        CrystalBees.addBreeding(CrystalElement.RED, CrystalElement.WHITE, CrystalElement.PINK);
        CrystalBees.addBreeding(CrystalElement.RED, CrystalElement.BLUE, CrystalElement.PURPLE);
        CrystalBees.addBreeding(CrystalElement.WHITE, CrystalElement.BLACK, CrystalElement.GRAY);
        CrystalBees.addBreeding(CrystalElement.BLUE, CrystalElement.GREEN, CrystalElement.CYAN);
        CrystalBees.addBreeding(CrystalElement.BLUE, CrystalElement.WHITE, CrystalElement.LIGHTBLUE);
        CrystalBees.addBreeding(CrystalElement.WHITE, CrystalElement.GRAY, CrystalElement.LIGHTGRAY);
        CrystalBees.addBreeding(CrystalElement.PINK, CrystalElement.PURPLE, CrystalElement.MAGENTA);
        CrystalBees.addBreeding((BeeSpecies)purity, (BeeSpecies)crystal, CrystalElement.WHITE);
        CrystalBees.addBreeding((BeeSpecies)protective, (BeeSpecies)hostile, CrystalElement.BLACK);
        CrystalBees.addBreeding((BeeSpecies)protective, (BeeSpecies)crystal, CrystalElement.RED);
        CrystalBees.addBreeding((BeeSpecies)luminous, (BeeSpecies)crystal, CrystalElement.BLUE);
        CrystalBees.addBreeding("Rural", (BeeSpecies)crystal, CrystalElement.BROWN);
        CrystalBees.addBreeding("Industrious", (BeeSpecies)crystal, CrystalElement.YELLOW);
        CrystalBees.addBreeding("Tropical", (BeeSpecies)hostile, CrystalElement.GREEN);
        protective.addBreeding("Heroic", (BeeSpecies)crystal, 10);
        hostile.addBreeding("Demonic", (BeeSpecies)crystal, 10);
        luminous.addBreeding("Ended", (BeeSpecies)purity, 5);
        chroma.addBreeding(beeMap.get((Object)CrystalElement.PURPLE), beeMap.get((Object)CrystalElement.WHITE), 5);
        lumen.addBreeding(beeMap.get((Object)CrystalElement.BLUE), beeMap.get((Object)CrystalElement.BLACK), 5);
        aura.addBreeding((BeeSpecies)lumen, beeMap.get((Object)CrystalElement.YELLOW), 3);
        multi.addBreeding((BeeSpecies)aura, (BeeSpecies)chroma, 2);
        protective.addProduct(new ItemStack(Blocks.field_150343_Z), 2.0f);
        hostile.addProduct(new ItemStack(Items.field_151016_H), 4.0f);
        luminous.addProduct(new ItemStack(Items.field_151114_aO), 5.0f);
        protective.addProduct(ForestryHandler.Combs.HONEY.getItem(), 10.0f);
        hostile.addProduct(ForestryHandler.Combs.HONEY.getItem(), 10.0f);
        luminous.addProduct(ForestryHandler.Combs.HONEY.getItem(), 10.0f);
        crystal.addProduct(ChromaStacks.crystalPowder, 5.0f);
        purity.addProduct(new ItemStack(Items.field_151073_bk), 1.0f);
        chroma.addSpecialty(ChromaStacks.iridCrystal, 2.0f);
        chroma.otherChecks.add(new ProductChecks.IridescentShardCheck());
        lumen.addSpecialty(ChromaStacks.lumaDust, 2.0f);
        lumen.otherChecks.add(new ProductChecks.AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.POWERTREE.getBlockInstance()), 2, 1));
        lumen.addProduct(new ItemStack(Items.field_151114_aO), 15.0f);
        aura.addSpecialty(ChromaStacks.echoCrystal, 2.0f);
        aura.otherChecks.add(new ProductChecks.AuraLocusCheck());
        ProductChecks.RainbowTreeCheck tree = new ProductChecks.RainbowTreeCheck();
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            ItemStack shard = ChromaStacks.getChargedShard(e);
            multi.addSpecialty(shard, 4.0f);
            ItemStack is = ChromaItems.BERRY.getStackOfMetadata(i);
            multi.addSpecialty(is, 1.25f);
            SpecialAlleles.FlowerProviderMulti.conditions.put(is, (Object)tree);
            SpecialAlleles.FlowerProviderMulti.conditions.put(shard, (Object)new ProductChecks.ChargedShardCheck(e));
        }
        CrystalBees.chroma.initConditions();
        CrystalBees.lumen.initConditions();
        CrystalBees.aura.initConditions();
        CrystalBees.multi.initConditions();
        GameRegistry.registerWorldGenerator((IWorldGenerator)HiveGenerator.instance, (int)-5);
    }

    public static BeeSpecies getElementalBee(CrystalElement e) {
        return beeMap.get((Object)e);
    }

    public static BeeSpecies getCrystalBee() {
        return crystal;
    }

    public static BeeSpecies getPureBee() {
        return purity;
    }

    public static int beeCount() {
        return 16 + basicBees.size() + advancedBees.size();
    }

    public static BeeSpecies getBeeByIndex(int idx) {
        if (idx < basicBees.size()) {
            return basicBees.get(idx);
        }
        if ((idx -= basicBees.size()) < 16) {
            return beeMap.get((Object)CrystalElement.elements[idx]);
        }
        if ((idx -= 16) < advancedBees.size()) {
            return advancedBees.get(idx);
        }
        return null;
    }

    public static ArrayList<String> getBeeDescription(BeeSpecies b) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(b.getName());
        ret.add("");
        if (b instanceof CrystalBee) {
            CrystalBee cb = (CrystalBee)b;
            ret.add("This bee has one extremely powerful gene.");
        }
        if (b.getClass() == BasicBee.class) {
            ret.add("This bee is a breeding intermediate, not");
            ret.add("particularly valuable on its own.");
            ret.add("");
            ret.add("It may, however, be the first step towards");
            ret.add("something that is.");
        }
        if (b instanceof ChromaBeeHelpers.ConditionalProductBee) {
            ChromaBeeHelpers.ConditionalProductProvider p = ((ChromaBeeHelpers.ConditionalProductBee)b).getProductProvider();
            ret.add("Special Products:");
            ret.add("");
            ret.add("General Conditions:");
            ArrayList<String> li = p.getGeneralRequirements();
            for (String s : li) {
                ret.add(s);
            }
            ItemHashMap<ProductChecks.ProductCondition> map = p.getConditions();
            if (!map.isEmpty()) {
                ret.add("");
                ret.add("Specific Conditions:");
                for (ItemStack is : map.keySet()) {
                    ProductChecks.ProductCondition c = (ProductChecks.ProductCondition)map.get(is);
                    String d = c.getDescription();
                    ArrayList dl = ReikaStringParser.splitStringByNewlines((String)d);
                    if (dl.size() > 1) {
                        ret.add(is.func_82833_r() + ":");
                        for (String in : dl) {
                            ret.add(in);
                        }
                        ret.add("");
                        continue;
                    }
                    ret.add(is.func_82833_r() + ": " + d);
                }
            }
        }
        return ret;
    }

    public static Collection<BeeSpecies> getBasicBees() {
        return Collections.unmodifiableCollection(basicBees);
    }

    public static Collection<BeeSpecies> getAdvancedBees() {
        return Collections.unmodifiableCollection(advancedBees);
    }

    public static Collection<ChromaBeeHelpers.ConditionalProductBee> getConditionalBees() {
        return Collections.unmodifiableCollection(conditionalBees);
    }

    private static final void addBreeding(String in1, BeeSpecies in2, CrystalElement out) {
        CrystalBee cb = beeMap.get((Object)out);
        cb.addBreeding(in1, in2, 8);
    }

    private static final void addBreeding(BeeSpecies in1, BeeSpecies in2, CrystalElement out) {
        CrystalBee cb = beeMap.get((Object)out);
        cb.addBreeding(in1, in2, 8);
    }

    private static final void addBreeding(CrystalElement in1, CrystalElement in2, CrystalElement out) {
        CrystalBee p1 = beeMap.get((Object)in1);
        CrystalBee p2 = beeMap.get((Object)in2);
        CrystalBee cb = beeMap.get((Object)out);
        cb.addBreeding(p1, p2, 8);
    }

    public static void showConditionalStatuses(World world, int x, int y, int z, EntityPlayer ep, IBeeHousing ibh) {
        IBeeGenome ibg;
        IAlleleBeeSpecies sp;
        IIndividual ii;
        ItemStack is = ibh.getBeeInventory().getQueen();
        if (is != null && (ii = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee && (sp = (ibg = ((IBee)ii).getGenome()).getPrimary()) instanceof ChromaBeeHelpers.ConditionalProductBee) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Product Conditions for " + EnumChatFormatting.GOLD + sp.getName() + EnumChatFormatting.RESET + " Bee:"));
            ChromaBeeHelpers.ConditionalProductBee cb = (ChromaBeeHelpers.ConditionalProductBee)sp;
            ChromaBeeHelpers.ConditionalProductProvider cp = cb.getProductProvider();
            StatusLogger log = new StatusLogger();
            cp.sendStatusInfo(world, x, y, z, log, ibg, ibh);
            log.sendToPlayer(ep);
        }
    }

    static {
        conditionalsUnavailable = new IErrorState(){
            private IIcon icon;

            public short getID() {
                return 1600;
            }

            public String getUniqueName() {
                return "ChromatiCraft:noconditionals";
            }

            public String getDescription() {
                return "Conditionals Unavailable";
            }

            public String getHelp() {
                return "Specialized products are unavailable due to their conditions not being met.";
            }

            @SideOnly(value=Side.CLIENT)
            public void registerIcons(IIconRegister register) {
                this.icon = register.func_94245_a("chromaticraft:forestry-no-conditionals");
            }

            @SideOnly(value=Side.CLIENT)
            public IIcon getIcon() {
                return this.icon;
            }
        };
        beeMap = new EnumMap(CrystalElement.class);
        effectMap = new EnumMap(CrystalElement.class);
        flowerMap = new EnumMap(CrystalElement.class);
        productConditions = new EnumMap(CrystalElement.class);
        conditionalBees = new ArrayList<ChromaBeeHelpers.ConditionalProductBee>();
        basicBees = new ArrayList();
        advancedBees = new ArrayList();
        ModularLogger.instance.addLogger((DragonAPIMod)ChromatiCraft.instance, LOGGER_TAG);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            CrystalBees.loadColorData();
        }
    }

    static final class CrystalBee
    extends BeeSpecies
    implements ChromaBeeHelpers.ConditionalProductBee {
        public final CrystalElement color;
        public final BeeAlleleRegistry.Speeds speed;
        public final BeeAlleleRegistry.Fertility fertility;
        public final BeeAlleleRegistry.Flowering flowering;
        public final BeeAlleleRegistry.Life lifespan;
        public final BeeAlleleRegistry.Territory area;
        public final BeeAlleleRegistry.Tolerance tempDir;
        public final BeeAlleleRegistry.Tolerance humidDir;
        public final int tempTol;
        public final int humidTol;
        public final EnumTemperature temperature;
        public final EnumHumidity humidity;

        public CrystalBee(CrystalElement color, BeeTraits traits) {
            super(color.displayName + " Crystal", "bee.crystal." + color.name().toLowerCase(Locale.ENGLISH), "Vitreus " + color.displayName, "Reika", (IClassification)crystalBranch);
            this.color = color;
            this.speed = traits.speed;
            this.fertility = traits.fertility;
            this.flowering = traits.flowering;
            this.lifespan = traits.lifespan;
            this.area = traits.area;
            this.tempDir = traits.tempDir;
            this.humidDir = traits.humidDir;
            this.tempTol = traits.tempTol;
            this.humidTol = traits.humidTol;
            this.temperature = traits.temperature;
            this.humidity = traits.humidity;
            this.addConditionalProduct(ChromaItems.BERRY.getStackOf(color), 25, true, new ProductChecks.LeafCheck(color));
            this.addConditionalProduct(ItemColoredModInteract.ColoredModItems.COMB.getItem(color), 8, true, new ProductChecks.CrystalPlantCheck(color));
            this.addProduct(ForestryHandler.Combs.HONEY.getItem(), 15.0f);
            this.addConditionalProduct(ChromaOptions.isVanillaDyeMoreCommon() ? new ItemStack(Items.field_151100_aR, 1, color.ordinal()) : ChromaItems.DYE.getStackOf(color), 20, false, new ProductChecks.FlowerCheck(color));
            switch (color) {
                case BLACK: {
                    this.addConditionalProduct(ChromaStacks.auraDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredPlant.TieredPlants.FLOWER.level));
                    break;
                }
                case RED: {
                    this.addSpecialty(ChromaStacks.etherBerries, 5.0f);
                    break;
                }
                case GREEN: {
                    this.addSpecialty(ForestryHandler.Combs.SILKY.getItem(), 10.0f);
                    this.addSpecialty(ChromaStacks.livingEssence, 5.0f);
                    break;
                }
                case PURPLE: {
                    if (ModList.TINKERER.isLoaded()) {
                        this.addSpecialty(OreBerryBushHandler.BerryTypes.XP.getStack(), 3.0f);
                    }
                    this.addSpecialty(ChromaStacks.voidDust, 10.0f);
                    break;
                }
                case BROWN: {
                    ArrayList li = OreDictionary.getOres((String)"nuggetIron");
                    if (li.isEmpty()) break;
                    this.addSpecialty((ItemStack)li.get(0), 5.0f);
                    break;
                }
                case ORANGE: {
                    this.addSpecialty(new ItemStack(Items.field_151065_br), 10.0f);
                    this.addConditionalProduct(ChromaStacks.fireEssence, 5, true, new ProductChecks.ProgressionCheck(BlockTieredOre.TieredOres.FIRESTONE.level));
                    break;
                }
                case BLUE: {
                    this.addConditionalProduct(ChromaStacks.beaconDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredPlant.TieredPlants.DESERT.level));
                    break;
                }
                case YELLOW: {
                    this.addSpecialty(ChromaStacks.energyPowder, 5.0f);
                    break;
                }
                case WHITE: {
                    this.addConditionalProduct(ChromaStacks.purityDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredPlant.TieredPlants.CAVE.level));
                    break;
                }
                case CYAN: {
                    this.addConditionalProduct(ChromaStacks.waterDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredOre.TieredOres.WATERY.level));
                    break;
                }
                case LIME: {
                    this.addConditionalProduct(ChromaStacks.spaceDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredOre.TieredOres.SPACERIFT.level));
                    break;
                }
                case GRAY: {
                    this.addSpecialty(ChromaStacks.teleDust, 5.0f);
                    break;
                }
                case LIGHTGRAY: {
                    this.addSpecialty(ChromaStacks.icyDust, 5.0f);
                    break;
                }
                case MAGENTA: {
                    ItemStack is = ReikaBeeHelper.getBeeItem((String)feedstock.getUID(), (EnumBeeType)EnumBeeType.PRINCESS);
                    this.addSpecialty(is, 2.0f);
                }
            }
            conditionalBees.add(this);
        }

        private void addConditionalProduct(ItemStack is, int chance, boolean specialty, ProductChecks.ProductCondition c) {
            if (specialty) {
                this.addSpecialty(is, chance);
            } else {
                this.addProduct(is, chance);
            }
            ItemHashMap map = productConditions.get((Object)this.color);
            if (map == null) {
                map = new ItemHashMap();
                productConditions.put(this.color, (ItemHashMap<ProductChecks.ProductCondition>)map);
            }
            map.put(is, (Object)c);
        }

        public boolean isNocturnal() {
            return this.color == CrystalElement.BLUE;
        }

        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            World world = ibh.getWorld();
            int x = ibh.getCoordinates().field_71574_a;
            int y = ibh.getCoordinates().field_71572_b;
            int z = ibh.getCoordinates().field_71573_c;
            if (!(ibg.getFlowerProvider() instanceof SpecialAlleles.FlowerProviderCrystal)) {
                return false;
            }
            if (((SpecialAlleles.FlowerProviderCrystal)ibg.getFlowerProvider()).color != this.color) {
                return false;
            }
            if (this.rand.nextFloat() > ibg.getSpeed()) {
                return false;
            }
            if (ibg.getFlowering() < BeeAlleleRegistry.Flowering.AVERAGE.getAllele().getValue()) {
                return false;
            }
            if (!ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)) && this.rand.nextInt(2) > 0) {
                return false;
            }
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z))) {
                return false;
            }
            if (this.rand.nextInt(3) > 0) {
                return true;
            }
            EntityPlayer ep = world.func_152378_a(ibh.getOwner().getId());
            if (ep != null) {
                return ProgressionManager.ProgressStage.SHARDCHARGE.isPlayerAtStage(ep);
            }
            return false;
        }

        public String getDescription() {
            return "These bees seem to enjoy the magic aura of the cave crystals. So much so, in fact, that they will only thrive around their corresponding color.";
        }

        public EnumTemperature getTemperature() {
            return this.temperature;
        }

        public EnumHumidity getHumidity() {
            return this.humidity;
        }

        public boolean hasEffect() {
            return true;
        }

        public boolean isSecret() {
            return false;
        }

        public boolean isCounted() {
            return false;
        }

        public boolean isDominant() {
            return true;
        }

        public IAllele getFlowerAllele() {
            return (IAllele)flowerMap.get((Object)this.color);
        }

        public BeeAlleleRegistry.Speeds getProductionSpeed() {
            return this.speed;
        }

        public BeeAlleleRegistry.Fertility getFertility() {
            return this.fertility;
        }

        public BeeAlleleRegistry.Flowering getFloweringRate() {
            return this.flowering;
        }

        public BeeAlleleRegistry.Life getLifespan() {
            return this.lifespan;
        }

        public BeeAlleleRegistry.Territory getTerritorySize() {
            return this.area;
        }

        public boolean isCaveDwelling() {
            return true;
        }

        public int getTemperatureTolerance() {
            return this.tempTol;
        }

        public int getHumidityTolerance() {
            return this.humidTol;
        }

        public BeeAlleleRegistry.Tolerance getHumidityToleranceDir() {
            return this.humidDir;
        }

        public BeeAlleleRegistry.Tolerance getTemperatureToleranceDir() {
            return this.tempDir;
        }

        public boolean isTolerantFlyer() {
            return this.color == CrystalElement.CYAN;
        }

        public int getOutlineColor() {
            return crystalColors != null ? crystalColors[this.color.ordinal()].getColor((double)DragonAPICore.getSystemTimeAsInt() / 5.0 - (double)(this.color.ordinal() * 32)) : this.color.getColor();
        }

        public IAllele getEffectAllele() {
            return (IAllele)effectMap.get((Object)this.color);
        }

        @Override
        public ChromaBeeHelpers.ConditionalProductProvider getProductProvider() {
            return (SpecialAlleles.FlowerProviderCrystal)flowerMap.get((Object)this.color).getProvider();
        }
    }

    static class BasicBee
    extends BeeSpecies.TraitsBee {
        public final int outline;

        private BasicBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, int color) {
            this(name, latin, s, l, f, f2, a, color, EnumTemperature.NORMAL);
        }

        private BasicBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, int color, EnumTemperature t) {
            super(name, "bee." + name.toLowerCase(Locale.ENGLISH), latin, "Reika", (IClassification)crystalBranch, new BeeTraits());
            this.traits.speed = s;
            this.traits.lifespan = l;
            this.traits.flowering = f;
            this.traits.fertility = f2;
            this.traits.area = a;
            this.traits.tempDir = BeeAlleleRegistry.Tolerance.NONE;
            this.traits.humidDir = BeeAlleleRegistry.Tolerance.NONE;
            this.traits.tempTol = 0;
            this.traits.humidTol = 0;
            this.traits.temperature = t;
            this.traits.humidity = EnumHumidity.NORMAL;
            this.traits.temperature = t;
            this.outline = color;
            if (((Object)((Object)this)).getClass() == BasicBee.class) {
                basicBees.add(this);
            }
        }

        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            ChunkCoordinates cc = ibh.getCoordinates();
            return ReikaMathLibrary.isValueInsideBounds((int)8, (int)30, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)ibh.getWorld(), (int)cc.field_71574_a, (int)cc.field_71572_b, (int)cc.field_71573_c));
        }

        public String getDescription() {
            return "These bees do little on their own, but perhaps they could be purified into something stronger.";
        }

        public boolean hasEffect() {
            return false;
        }

        public boolean isSecret() {
            return false;
        }

        public boolean isCounted() {
            return false;
        }

        public boolean isDominant() {
            return true;
        }

        public IAllele getFlowerAllele() {
            return BeeAlleleRegistry.Flower.VANILLA.getAllele();
        }

        public IAllele getEffectAllele() {
            return BeeAlleleRegistry.Effect.NONE.getAllele();
        }

        public int getOutlineColor() {
            return this.outline;
        }
    }

    static class RawBee
    extends BasicBee {
        private RawBee(String name, String latin, int color) {
            super(name, latin, BeeAlleleRegistry.Speeds.SLOWEST, BeeAlleleRegistry.Life.NORMAL, BeeAlleleRegistry.Flowering.SLOWEST, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.DEFAULT, color);
        }

        @Override
        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            return false;
        }

        @Override
        public String getDescription() {
            return "With no traits or utility of their own, completely worthless as anything but raw feedstock.";
        }
    }

    static class AdvancedBee
    extends BasicBee
    implements ChromaBeeHelpers.ConditionalProductBee {
        private final ColorBlendList colorList;
        private final ProductChecks.ProgressionCheck progress;
        private final Collection<ProductChecks.ProductCondition> otherChecks = new ArrayList<ProductChecks.ProductCondition>();
        private final ChromaBeeHelpers.CompoundConditionalProductProvider manager = new ChromaBeeHelpers.CompoundConditionalProductProvider();

        private AdvancedBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, ColorBlendList c, EnumTemperature t, ProgressionManager.ProgressStage p) {
            super(name, latin, s, l, f, f2, a, 0xFFFFFF, t);
            this.colorList = c;
            this.progress = new ProductChecks.ProgressionCheck(p);
            conditionalBees.add(this);
            advancedBees.add(this);
        }

        private void initConditions() {
            if (this == multi) {
                this.manager.add((SpecialAlleles.FlowerProviderMulti)multiFlower.getProvider());
            }
            this.manager.addGeneral(this.progress);
            for (ProductChecks.ProductCondition p : this.otherChecks) {
                this.manager.addGeneral(p);
            }
        }

        @Override
        public String getDescription() {
            return "Hybridized from the crystal bees, these bees are mysterious and have unknown but surely significant beneficial effects.";
        }

        @Override
        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            World world = ibh.getWorld();
            int x = ibh.getCoordinates().field_71574_a;
            int y = ibh.getCoordinates().field_71572_b;
            int z = ibh.getCoordinates().field_71573_c;
            EntityPlayer ep = world.func_152378_a(ibh.getOwner().getId());
            for (ProductChecks.ProductCondition p : this.otherChecks) {
                if (p.check(world, x, y, z, ibg, ibh)) continue;
                return false;
            }
            if (ep != null) {
                return this.progress.check(world, x, y, z, ibg, ibh);
            }
            return false;
        }

        @Override
        public boolean hasEffect() {
            return true;
        }

        @Override
        public IAllele getEffectAllele() {
            return BeeAlleleRegistry.Effect.NONE.getAllele();
        }

        @Override
        public IAllele getFlowerAllele() {
            return this == multi ? multiFlower : super.getFlowerAllele();
        }

        @Override
        public int getOutlineColor() {
            return this.colorList != null ? this.colorList.getColor((double)DragonAPICore.getSystemTimeAsInt() / 30.0) : 0xFFFFFF;
        }

        @Override
        public ChromaBeeHelpers.ConditionalProductProvider getProductProvider() {
            return this.manager;
        }
    }
}

