/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Auxiliary.ProgressionCacher;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.ModInterface.Bees.ProductChecks;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.GUI.StatusLogger;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.EnumTolerance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ChromaBeeHelpers {
    public static boolean isBestPossibleBee(IBeeGenome ibg) {
        if (!(ibg.getNocturnal() && ibg.getCaveDwelling() && ibg.getTolerantFlyer())) {
            return false;
        }
        if (ibg.getToleranceHumid() != EnumTolerance.BOTH_5 || ibg.getToleranceTemp() != EnumTolerance.BOTH_5) {
            return false;
        }
        if (ibg.getFertility() < CrystalBees.superFertility.getAllele().getValue()) {
            return false;
        }
        if (ibg.getFlowering() < CrystalBees.superFlowering.getAllele().getValue()) {
            return false;
        }
        if (ibg.getLifespan() < CrystalBees.superLife.getAllele().getValue()) {
            return false;
        }
        if (ibg.getSpeed() < CrystalBees.superSpeed.getAllele().getValue()) {
            return false;
        }
        return Arrays.equals(ibg.getTerritory(), CrystalBees.superTerritory.getAllele().getValue());
    }

    static int[] getSearchRange(IBeeGenome ibg, IBeeHousing ibh) {
        int r;
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(ibh);
        int tr = (int)((float)ibg.getTerritory()[0] * 3.0f * beeModifier.getTerritoryModifier(ibg, 1.0f));
        int n = r = tr >= 64 ? 128 : MathHelper.func_76125_a((int)(16 * ReikaMathLibrary.intpow2((int)2, (int)((tr - 9) / 2))), (int)16, (int)96);
        int r2 = r >= 64 ? 24 : (r >= 32 ? 16 : (r >= 16 ? 12 : 8));
        return new int[]{r, r2};
    }

    public static WorldLocation getLocation(IBeeHousing ibh) {
        ChunkCoordinates c = ibh.getCoordinates();
        return new WorldLocation(ibh.getWorld(), c.field_71574_a, c.field_71572_b, c.field_71573_c);
    }

    public static EntityPlayer getOwner(IBeeHousing ibh) {
        GameProfile p = ibh.getOwner();
        return p != null && p.getId() != null ? ibh.getWorld().func_152378_a(p.getId()) : null;
    }

    public static ProgressionCacher.ProgressCache getProgressCache(IBeeHousing ibh) {
        UUID uid = ibh.getOwner().getId();
        return ProgressionCacher.instance.getProgressCache(ibh.getWorld(), uid);
    }

    static class CompoundConditionalProductProvider
    implements ConditionalProductProvider {
        private Collection<ConditionalProductProvider> list = new ArrayList<ConditionalProductProvider>();
        private Collection<ProductChecks.ProductCondition> extras = new ArrayList<ProductChecks.ProductCondition>();

        CompoundConditionalProductProvider() {
        }

        void add(ConditionalProductProvider p) {
            this.list.add(p);
        }

        void addGeneral(ProductChecks.ProductCondition c) {
            this.extras.add(c);
        }

        @Override
        public ItemHashMap<ProductChecks.ProductCondition> getConditions() {
            ItemHashMap map = new ItemHashMap();
            for (ConditionalProductProvider p : this.list) {
                map.putAll(p.getConditions());
            }
            return map;
        }

        @Override
        public ArrayList<String> getGeneralRequirements() {
            ArrayList<String> li = new ArrayList<String>();
            for (ConditionalProductProvider p : this.list) {
                li.addAll(p.getGeneralRequirements());
            }
            for (ProductChecks.ProductCondition c : this.extras) {
                li.add(c.getDescription());
            }
            return li;
        }

        @Override
        public void sendStatusInfo(World world, int x, int y, int z, StatusLogger log, IBeeGenome ibg, IBeeHousing ibh) {
            for (ConditionalProductProvider conditionalProductProvider : this.list) {
                conditionalProductProvider.sendStatusInfo(world, x, y, z, log, ibg, ibh);
            }
            for (ProductChecks.ProductCondition productCondition : this.extras) {
                log.addStatus(productCondition.getDescription(), productCondition.check(world, x, y, z, ibg, ibh));
            }
        }
    }

    public static interface ConditionalProductBee {
        public ConditionalProductProvider getProductProvider();
    }

    public static interface ConditionalProductProvider {
        public ItemHashMap<ProductChecks.ProductCondition> getConditions();

        public ArrayList<String> getGeneralRequirements();

        public void sendStatusInfo(World var1, int var2, int var3, int var4, StatusLogger var5, IBeeGenome var6, IBeeHousing var7);
    }
}

