/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityAccelerator;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModList;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ApiaryAcceleration
extends TileEntityAccelerator.Acceleration {
    public static final ApiaryAcceleration instance = new ApiaryAcceleration();
    private Field beeLogicModifiers;
    private Field beeLogicProgress;
    private Method beeLogicMate;
    private Field tileProgress;
    private static final int TICK_LENGTH = 550;

    public void register() {
        this.registerClass("forestry.apiculture.tiles.TileApiary");
        this.registerClass("forestry.apiculture.tiles.TileBeehouse");
        this.registerClass("net.bdew.gendustry.machines.apiary.TileApiary");
        this.registerClass("magicbees.tileentity.TileEntityMagicApiary");
        try {
            Class<?> c = Class.forName("forestry.apiculture.BeekeepingLogic");
            this.beeLogicMate = c.getDeclaredMethod("tickBreed", new Class[0]);
            this.beeLogicMate.setAccessible(true);
            this.beeLogicModifiers = c.getDeclaredField("beeModifier");
            this.beeLogicModifiers.setAccessible(true);
            this.beeLogicProgress = c.getDeclaredField("beeProgress");
            this.beeLogicProgress.setAccessible(true);
            c = Class.forName("forestry.apiculture.tiles.TileBeeHousingBase");
            this.tileProgress = c.getDeclaredField("breedingProgressPercent");
            this.tileProgress.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.FORESTRY, e);
            ChromatiCraft.logger.logError((Object)"Could not find BeeKeepingLogic internal members!");
        }
    }

    @Override
    protected void tick(TileEntity te, int factor) throws Exception {
        if (te.field_145850_b.field_72995_K) {
            return;
        }
        IBeeHousing ibh = (IBeeHousing)te;
        IBeeHousingInventory ibhi = ibh.getBeeInventory();
        ItemStack queen = ibhi.getQueen();
        if (queen != null) {
            IBeekeepingLogic lgc = ibh.getBeekeepingLogic();
            EnumBeeType type = ReikaBeeHelper.getBeeRoot().getType(queen);
            if (type == EnumBeeType.QUEEN) {
                if (lgc.canWork()) {
                    IBee bee = ReikaBeeHelper.getBee((ItemStack)queen);
                    if (bee.getHealth() <= 0) {
                        return;
                    }
                    float f = ((IBeeModifier)this.beeLogicModifiers.get(lgc)).getLifespanModifier(bee.getGenome(), bee.getMate(), 1.0f);
                    double c = (double)factor / 550.0;
                    float fac = 1.0f;
                    float step = 1.05f;
                    while (c * (double)fac * (double)step < 1.0) {
                        fac *= step;
                    }
                    if (ReikaRandomHelper.doWithChance((double)(c * (double)fac))) {
                        ReikaBeeHelper.ageBee((World)te.field_145850_b, (ItemStack)queen, (float)(f * fac));
                    }
                    this.beeLogicProgress.set(lgc, bee.getHealth());
                    this.tileProgress.set(te, (int)((double)bee.getHealth() * 2.25));
                }
            } else if (type == EnumBeeType.PRINCESS) {
                for (int i = 0; i < factor; ++i) {
                    this.beeLogicMate.invoke((Object)lgc, new Object[0]);
                }
            }
        }
    }
}

