/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.AE;

import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.ModList;
import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"appeng.api.networking.IGridHost", "appeng.api.networking.crafting.ICraftingProvider"})
public class TileEntityPatternCache
extends InventoriedChromaticBase
implements IGridHost,
ICraftingProvider {
    public static final int SIZE = 72;
    private Object aeGridBlock;
    private Object aeGridNode;
    private final StepTimer updateTimer = new StepTimer(50);

    public TileEntityPatternCache() {
        if (ModList.APPENG.isLoaded() && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.aeGridBlock = new BasicAEInterface((TileEntity)this, this.getTile().getCraftedProduct());
            this.aeGridNode = AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock);
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (ModList.APPENG.isLoaded() && !world.field_72995_K) {
            this.updateTimer.update();
            if (this.updateTimer.checkCap()) {
                this.aeGridNode = AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock);
                this.updateAE();
            }
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null && !world.field_72995_K) {
            this.updateAE();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    private void updateAE() {
        IGrid grid;
        if (this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).updateState();
        }
        if ((grid = ((IGridNode)this.aeGridNode).getGrid()) != null) {
            grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, (IGridNode)this.aeGridNode));
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    private ArrayList<ICraftingMedium> getValidPushables() {
        ArrayList<ICraftingMedium> li = new ArrayList<ICraftingMedium>();
        IMachineSet set = ((IGridNode)this.aeGridNode).getGrid().getMachines(IGridHost.class);
        for (IGridNode n : set) {
            IGridHost igh = n.getMachine();
            if (!(igh instanceof ICraftingMedium) || !this.isValidTarget(igh)) continue;
            li.add((ICraftingMedium)igh);
        }
        return li;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    private boolean isValidTarget(IGridHost igh) {
        block4: {
            block3: {
                if (!(igh instanceof IPart)) break block3;
                IPart ip = (IPart)igh;
                DimensionalCoord dc = ip.getGridNode().getGridBlock().getLocation();
                TileEntity te = dc.getWorld().func_147438_o(dc.x, dc.y, dc.z);
                if (!(te instanceof IPartHost)) break block4;
                IPartHost iph = (IPartHost)te;
                for (int i = 0; i < 6; ++i) {
                    TileEntity tile;
                    ForgeDirection dir = this.dirs[i];
                    IPart p = iph.getPart(dir);
                    if (p != ip || !this.isAssemblerTile(tile = te.field_145850_b.func_147438_o(te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ))) continue;
                    return true;
                }
                break block4;
            }
            if (igh instanceof TileEntity) {
                TileEntity te = (TileEntity)igh;
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection dir = this.dirs[i];
                    TileEntity tile = te.field_145850_b.func_147438_o(te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ);
                    if (!this.isAssemblerTile(tile)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAssemblerTile(TileEntity te) {
        return te.getClass().getSimpleName().equals("TileMolecularAssembler");
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public boolean pushPattern(ICraftingPatternDetails details, InventoryCrafting table) {
        ArrayList<ICraftingMedium> li = this.getValidPushables();
        for (ICraftingMedium icm : li) {
            if (icm.isBusy()) continue;
            icm.pushPattern(details, table);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public void provideCrafting(ICraftingProviderHelper tracker) {
        for (int i = 0; i < 72; ++i) {
            ItemStack is = this.inv[i];
            if (!this.isPattern(is)) continue;
            tracker.addCraftingOption((ICraftingMedium)this, ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.field_145850_b));
        }
    }

    private boolean isPattern(ItemStack is) {
        return is != null && ModList.APPENG.isLoaded() && is.func_77973_b() instanceof ICraftingPatternItem;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public boolean isBusy() {
        ArrayList<ICraftingMedium> li = this.getValidPushables();
        for (ICraftingMedium icm : li) {
            if (icm.isBusy()) continue;
            return false;
        }
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return side == 0;
    }

    public int func_70302_i_() {
        return 72;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return this.isPattern(is);
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getGridNode(ForgeDirection dir) {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.GLASS;
    }

    public void securityBreak() {
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PATTERNS;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    @Override
    protected void onSlotSet(int slot, ItemStack is) {
        if (ModList.APPENG.isLoaded() && !this.field_145850_b.field_72995_K) {
            this.updateAE();
        }
    }
}

