/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.AE;

import Reika.ChromatiCraft.ModInterface.AE.ItemRemoteTerminal;
import Reika.DragonAPI.Instantiable.BasicInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerRemoteTerminal
extends Container {
    private final ItemStack held;
    private final EntityPlayer player;
    private final IGridHost grid;
    private final List<IAEItemStack> items = new ArrayList<IAEItemStack>();
    private final ForgeDirection direction;
    private AEInventory inventory;

    public ContainerRemoteTerminal(EntityPlayer ep) {
        this.player = ep;
        this.held = this.player.func_71045_bC();
        ItemRemoteTerminal irt = (ItemRemoteTerminal)this.held.func_77973_b();
        this.grid = irt.getLink(this.held, this.player.field_70170_p);
        this.direction = ForgeDirection.VALID_DIRECTIONS[this.held.field_77990_d.func_74762_e("dir")];
        this.populate();
    }

    public void populate() {
        this.items.clear();
        IMEMonitor<IAEItemStack> ime = this.getAEInventory();
        if (ime != null) {
            for (IAEItemStack iae : ime.getStorageList()) {
                this.items.add(iae);
            }
        }
        this.sort(TerminalSort.ID);
        this.inventory = new AEInventory(this.items.size());
        for (int i = 0; i < this.items.size(); ++i) {
            IAEItemStack iae;
            iae = this.items.get(i);
            this.inventory.func_70299_a(i, iae.getItemStack());
            int x = 0;
            int y = 0;
            this.func_75146_a(new Slot((IInventory)this.inventory, i, x, y));
        }
    }

    private IMEMonitor<IAEItemStack> getAEInventory() {
        IStorageGrid isg;
        IGrid ig;
        IGridNode ign = this.grid.getGridNode(this.direction);
        if (ign != null && (ig = ign.getGrid()) != null && (isg = (IStorageGrid)ig.getCache(IStorageGrid.class)) != null) {
            IMEMonitor ime = isg.getItemInventory();
            return ime;
        }
        return null;
    }

    public void sort(TerminalSort sort) {
        Collections.sort(this.items, sort.comparator);
    }

    public ItemStack func_75144_a(int slot, int button, int c, EntityPlayer ep) {
        return super.func_75144_a(slot, button, c, ep);
    }

    public boolean func_75145_c(EntityPlayer ep) {
        return true;
    }

    private static class AEInventory
    extends BasicInventory {
        public AEInventory(int size) {
            super("Terminal", size);
        }

        public boolean func_94041_b(int i, ItemStack is) {
            return true;
        }
    }

    private static class SizeComparator
    implements Comparator<IAEItemStack> {
        private SizeComparator() {
        }

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            return o1.getStackSize() > o2.getStackSize() ? -1 : (o1.getStackSize() < o2.getStackSize() ? 1 : 0);
        }
    }

    private static class NameComparator
    implements Comparator<IAEItemStack> {
        private NameComparator() {
        }

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getItemStack().func_82833_r(), o2.getItemStack().func_82833_r());
        }
    }

    private static class IDComparator
    implements Comparator<IAEItemStack> {
        private IDComparator() {
        }

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            return Item.func_150891_b((Item)o1.getItem()) - Item.func_150891_b((Item)o2.getItem());
        }
    }

    public static enum TerminalSort {
        ID(new IDComparator()),
        NAME(new NameComparator()),
        COUNT(new SizeComparator());

        private final Comparator<IAEItemStack> comparator;

        private TerminalSort(Comparator<IAEItemStack> c) {
            this.comparator = c;
        }
    }
}

