/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Magic.Interfaces.ConnectivityAction;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class CrystalPath
implements Comparable<CrystalPath> {
    protected final ArrayList<WorldLocation> nodes;
    public final CrystalSource transmitter;
    public final WorldLocation origin;
    public final CrystalElement element;
    private final HashSet<CrystalNetworker.CrystalLink> links = new HashSet();
    protected final CrystalNetworker network;
    protected final boolean hasRealTarget;
    private int attenuation;
    private int theoreticalRange;
    private double totalDistance;

    protected CrystalPath(CrystalNetworker net, boolean real, CrystalElement e, List<WorldLocation> li) {
        this.nodes = new ArrayList<WorldLocation>(li);
        this.transmitter = PylonFinder.getSourceAt(this.nodes.get(this.nodes.size() - 1), true);
        this.origin = this.nodes.get(0);
        this.element = e;
        this.network = net;
        this.hasRealTarget = real;
        this.initialize();
    }

    protected void initialize() {
        int loss = 0;
        int range = 0;
        double dist = 0.0;
        for (int i = 1; i < this.nodes.size(); ++i) {
            WorldLocation loc = this.nodes.get(i);
            WorldLocation prev = this.nodes.get(i - 1);
            CrystalNetworkTile te = PylonFinder.getNetTileAt(loc, true);
            CrystalNetworkTile teprev = PylonFinder.getNetTileAt(prev, true);
            range += Math.min(((CrystalReceiver)teprev).getReceiveRange(), ((CrystalTransmitter)te).getSendRange());
            dist += Math.sqrt(te.getDistanceSqTo((double)teprev.getX() + 0.5, (double)teprev.getY() + 0.5, (double)teprev.getZ() + 0.5));
            if (i < this.nodes.size() - 1 && te instanceof CrystalRepeater) {
                loss += ((CrystalRepeater)te).getSignalDegradation();
                if (te instanceof ConnectivityAction) {
                    WorldLocation next = this.nodes.get(i + 1);
                    CrystalNetworkTile tenext = PylonFinder.getNetTileAt(next, true);
                    ConnectivityAction ca = (ConnectivityAction)te;
                    ca.notifyReceivingFrom(this, (CrystalTransmitter)tenext);
                    ca.notifySendingTo(this, (CrystalReceiver)teprev);
                }
            }
            this.links.add(this.network.getLink(prev, loc));
        }
        this.attenuation = loss;
        this.totalDistance = dist;
        this.theoreticalRange = range;
    }

    public void addBaseAttenuation(int amt) {
        if (amt > 0) {
            this.attenuation += amt;
        }
    }

    public final boolean containsLink(CrystalNetworker.CrystalLink l) {
        return this.links.contains(l);
    }

    public final int getSignalLoss() {
        return this.attenuation;
    }

    public boolean canTransmit() {
        return true;
    }

    public final String toString() {
        return (Object)((Object)this.element) + ": to " + this.origin + " from " + this.transmitter + ": " + this.nodes.size() + "x " + this.nodes.toString();
    }

    public boolean contains(CrystalNetworkTile te) {
        return this.nodes.contains(new WorldLocation(te.getWorld(), te.getX(), te.getY(), te.getZ()));
    }

    public final boolean checkLineOfSight() {
        return this.checkLineOfSight(null);
    }

    public final boolean checkLineOfSight(CrystalNetworker.CrystalLink l) {
        for (int i = 0; i < this.nodes.size() - 2; ++i) {
            WorldLocation src;
            WorldLocation tgt = this.nodes.get(i);
            if (l != null && !tgt.equals((Object)l.loc1) && !tgt.equals((Object)l.loc2) || PylonFinder.lineOfSight(src = this.nodes.get(i + 1), tgt)) continue;
            CrystalReceiver rec = PylonFinder.getReceiverAt(tgt, true);
            CrystalTransmitter sr = PylonFinder.getTransmitterAt(src, true);
            if (!sr.needsLineOfSightToReceiver(rec) && !rec.needsLineOfSightFromTransmitter(sr)) continue;
            return false;
        }
        return true;
    }

    public boolean stillValid() {
        int i;
        CrystalNetworkTile tile;
        if (!this.transmitter.canConduct() || !this.transmitter.isConductingElement(this.element)) {
            return false;
        }
        if (!(!this.hasRealTarget || (tile = PylonFinder.getNetTileAt(this.origin, false)) != null && tile.canConduct() && tile.isConductingElement(this.element))) {
            return false;
        }
        int n = i = this.hasRealTarget ? 0 : 1;
        while (i < this.nodes.size() - 2) {
            CrystalNetworker.CrystalLink l;
            WorldLocation tgt = this.nodes.get(i);
            WorldLocation src = this.nodes.get(i + 1);
            CrystalTransmitter sr = PylonFinder.getTransmitterAt(src, false);
            CrystalReceiver rec = PylonFinder.getReceiverAt(tgt, false);
            if (sr == null || !sr.canConduct() || !sr.isConductingElement(this.element)) {
                return false;
            }
            if ((sr.needsLineOfSightToReceiver(rec) || rec.needsLineOfSightFromTransmitter(sr)) && !(l = this.network.getLink(tgt, src)).hasLineOfSight()) {
                l.recalculateLOS();
                if (!l.hasLineOfSight()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void blink(int ticks, CrystalReceiver r) {
        ImmutableTriple<Double, Double, Double> offset;
        CrystalSource src = PylonFinder.getSourceAt(this.nodes.get(this.nodes.size() - 1), true);
        WorldLocation locs = this.nodes.get(this.nodes.size() - 2);
        if (r == null) {
            r = PylonFinder.getReceiverAt(locs, true);
        }
        double sx = (offset = r.getTargetRenderOffset(this.element)) != null ? (Double)offset.left : 0.0;
        double sy = offset != null ? (Double)offset.middle : 0.0;
        double sz = offset != null ? (Double)offset.right : 0.0;
        src.addSelfTickingTarget(locs, this.element, sx, sy, sz, r.getIncomingBeamRadius(), ticks);
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt(this.nodes.get(i), true);
            if (!(te instanceof CrystalTransmitter)) continue;
            WorldLocation tg = this.nodes.get(i - 1);
            r = PylonFinder.getReceiverAt(tg, true);
            offset = r.getTargetRenderOffset(this.element);
            double dx = offset != null ? (Double)offset.left : 0.0;
            double dy = offset != null ? (Double)offset.middle : 0.0;
            double dz = offset != null ? (Double)offset.right : 0.0;
            ((CrystalTransmitter)te).addSelfTickingTarget(tg, this.element, dx, dy, dz, r.getIncomingBeamRadius(), ticks);
        }
    }

    public void endBlink() {
        CrystalSource src = PylonFinder.getSourceAt(this.nodes.get(this.nodes.size() - 1), true);
        WorldLocation locs = this.nodes.get(this.nodes.size() - 2);
        src.removeTarget(locs, this.element);
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt(this.nodes.get(i), true);
            if (!(te instanceof CrystalTransmitter)) continue;
            WorldLocation tg = this.nodes.get(i - 1);
            ((CrystalTransmitter)te).removeTarget(tg, this.element);
        }
    }

    public float getOptimizationFactor() {
        return (float)((double)this.theoreticalRange / this.totalDistance);
    }

    @Override
    public int compareTo(CrystalPath o) {
        return o.transmitter.getSourcePriority() - this.transmitter.getSourcePriority();
    }

    public final boolean equals(Object o) {
        if (o instanceof CrystalPath) {
            CrystalPath p = (CrystalPath)o;
            return p.element == this.element && p.nodes.equals(this.nodes);
        }
        return false;
    }

    public final int hashCode() {
        return this.nodes.hashCode() ^ this.element.ordinal();
    }
}

