/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalFuse;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.NaturalCrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.NotifiedNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.PylonConnector;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworkException;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCompoundRepeater;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalBroadcaster;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalRepeater;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Auxiliary.Trackers.CrashNotifications;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldChunk;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.Data.Maps.TileEntityCache;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Event.SetBlockEvent;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class CrystalNetworker
implements TickRegistry.TickHandler {
    public static final CrystalNetworker instance = new CrystalNetworker();
    private static final String NBT_TAG = "crystalnet";
    private static final Random rand = new Random();
    private final TileEntityCache<CrystalNetworkTile> tiles = new TileEntityCache();
    private final EnumMap<CrystalElement, TileEntityCache<TileEntityCrystalPylon>> pylons = new EnumMap(CrystalElement.class);
    private final MultiMap<Integer, CrystalFlow> flows = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());
    private final HashMap<UUID, WorldLocation> verifier = new HashMap();
    private final MultiMap<WorldChunk, CrystalLink> losCache = new MultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory()).setNullEmpty();
    private final PluralMap<CrystalLink> links = new PluralMap(2);
    private final HashSet<CrystalFlow> toBreak = new HashSet();
    private final ArrayList<NotifiedNetworkTile> notifyCache = new ArrayList();

    private CrystalNetworker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModularLogger.instance.addLogger((DragonAPIMod)ChromatiCraft.instance, NBT_TAG);
        CrashNotifications.instance.addNotification(ConcurrentModificationException.class, (CrashNotifications.CrashNotification)new CMENote());
    }

    @SubscribeEvent
    public void markChunkCache(SetBlockEvent evt) {
        WorldChunk wc;
        Collection c;
        if (!evt.world.field_72995_K && (c = this.losCache.get((Object)(wc = new WorldChunk(evt.world, evt.chunkLocation)))) != null) {
            for (CrystalLink l : c) {
                double[] angs2;
                WorldLocation l1 = l.loc1;
                WorldLocation l2 = l.loc2;
                double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(l1.xCoord - l2.xCoord), (double)(l1.yCoord - l2.yCoord), (double)(l1.zCoord - l2.zCoord));
                if (!ReikaMathLibrary.approxrAbs((double)angs[1], (double)(angs2 = ReikaPhysicsHelper.cartesianToPolar((double)(l1.xCoord - evt.xCoord), (double)(l1.yCoord - evt.yCoord), (double)(l1.zCoord - evt.zCoord)))[1], (double)3.0) || !ReikaMathLibrary.approxrAbs((double)angs[2], (double)angs2[2], (double)3.0)) continue;
                l.hasLOS = false;
                for (CrystalFlow p : this.flows.get((Object)evt.world.field_73011_w.field_76574_g)) {
                    if (this.toBreak.contains(p) || !p.containsLink(l) || p.checkLineOfSight(l)) continue;
                    CrystalNetworkLogger.logFlowBreak(p, CrystalNetworkLogger.FlowFail.SIGHT);
                    this.schedulePathBreak(p);
                }
            }
        }
    }

    private void schedulePathBreak(CrystalFlow p) {
        this.toBreak.add(p);
    }

    void addLink(CrystalLink l, boolean connect) {
        l.hasLOS = connect;
        for (WorldChunk wc : l.chunks) {
            this.losCache.addValue((Object)wc, (Object)l);
        }
        this.links.put((Object)l, new Object[]{l.loc1, l.loc2});
    }

    void addLink(WorldLocation l1, WorldLocation l2, boolean connect) {
        this.addLink(new CrystalLink(l1, l2), connect);
    }

    CrystalLink getLink(WorldLocation l1, WorldLocation l2) {
        CrystalLink l = (CrystalLink)this.links.get(new Object[]{l1, l2});
        if (l == null) {
            l = new CrystalLink(l1, l2);
            this.addLink(l, false);
        }
        return l;
    }

    @SubscribeEvent
    public void clearOnUnload(WorldEvent.Unload evt) {
        PylonFinder.stopAllSearches();
        int dim = evt.world.field_73011_w.field_76574_g;
        ChromatiCraft.logger.debug((Object)("Unloading dimension " + dim + ", clearing crystal network."));
        try {
            this.clear(dim);
            for (WorldLocation worldLocation : this.tiles.keySet()) {
                CrystalNetworkTile te = (CrystalNetworkTile)this.tiles.get(worldLocation);
                PylonFinder.removePathsWithTile(te);
                if (!(te instanceof CrystalTransmitter)) continue;
                ((CrystalTransmitter)te).clearTargets(true);
            }
            this.tiles.removeWorld(evt.world);
            for (TileEntityCache tileEntityCache : this.pylons.values()) {
                tileEntityCache.removeWorld(evt.world);
            }
        }
        catch (ConcurrentModificationException e) {
            ChromatiCraft.logger.logError((Object)"Clearing the crystal network on world unload caused a CME. This is indicative of a deeper problem.");
            e.printStackTrace();
        }
    }

    private void save(NBTTagCompound NBT) {
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        this.tiles.writeToNBT(tag);
        NBT.func_74782_a(NBT_TAG, (NBTBase)tag);
    }

    private void load(NBTTagCompound NBT) {
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        this.tiles.readFromNBT(tag);
        for (CrystalNetworkTile te : this.tiles.values()) {
            if (!(te instanceof TileEntityCrystalPylon)) continue;
            TileEntityCrystalPylon tile = (TileEntityCrystalPylon)te;
            this.addPylon(tile);
        }
    }

    public boolean checkConnectivity(CrystalElement e, CrystalReceiver r) {
        EntityPlayer ep = r.getPlacerUUID() != null ? r.getWorld().func_152378_a(r.getPlacerUUID()) : null;
        try {
            CrystalPath p = new PylonFinder(e, r, ep).findPylon();
            return p != null && p.canTransmit();
        }
        catch (ConcurrentModificationException ex) {
            ex.printStackTrace();
            ChromatiCraft.logger.logError((Object)"CME during pathfinding!");
            return false;
        }
    }

    public CrystalPath getConnectivity(CrystalElement e, CrystalReceiver r) {
        EntityPlayer ep = r.getPlacerUUID() != null ? r.getWorld().func_152378_a(r.getPlacerUUID()) : null;
        try {
            CrystalPath p = new PylonFinder(e, r, ep).findPylon();
            return p != null && p.canTransmit() ? p : null;
        }
        catch (ConcurrentModificationException ex) {
            ex.printStackTrace();
            ChromatiCraft.logger.logError((Object)"CME during pathfinding!");
            return null;
        }
    }

    public boolean makeRequest(CrystalReceiver r, CrystalElement e, int amount, int range) {
        return this.makeRequest(r, e, amount, r.getWorld(), range, Integer.MAX_VALUE);
    }

    public boolean makeRequest(CrystalReceiver r, CrystalElement e, int amount, int range, int maxthru) {
        return this.makeRequest(r, e, amount, r.getWorld(), range, maxthru);
    }

    public boolean makeRequest(CrystalReceiver r, CrystalElement e, int amount, World world, int range, int maxthru) {
        if (amount <= 0) {
            return false;
        }
        if (this.hasFlowTo(r, e, world)) {
            return false;
        }
        EntityPlayer ep = r.getPlacerUUID() != null ? world.func_152378_a(r.getPlacerUUID()) : null;
        CrystalFlow p = new PylonFinder(e, r, ep).findPylon(amount, maxthru);
        CrystalNetworkLogger.logRequest(r, e, amount, p);
        if (p != null) {
            this.flows.addValue((Object)world.field_73011_w.field_76574_g, (Object)p);
            p.transmitter.onUsedBy(ep, e);
            return true;
        }
        return false;
    }

    public CrystalSource findSourceWithX(CrystalReceiver r, CrystalElement e, int amount, int range, boolean consume) {
        EntityPlayer ep = r.getPlacerUUID() != null ? r.getWorld().func_152378_a(r.getPlacerUUID()) : null;
        CrystalPath p = new PylonFinder(e, r, ep).findPylonWith(amount);
        if (p != null) {
            if (consume) {
                p.transmitter.drain(e, amount);
            }
            return p.transmitter;
        }
        return null;
    }

    public boolean hasFlowTo(CrystalReceiver r, CrystalElement e, World world) {
        Collection li = this.flows.get((Object)world.field_73011_w.field_76574_g);
        for (CrystalFlow f : li) {
            if (f.element != e || f.receiver != r) continue;
            return true;
        }
        return false;
    }

    public void tick(TickRegistry.TickType type, Object ... data) {
        Iterator i$ = this.flows.keySet().iterator();
        while (i$.hasNext()) {
            int dim = (Integer)i$.next();
            Collection c = this.flows.get((Object)dim);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                CrystalFlow p = (CrystalFlow)it.next();
                if (this.toBreak.contains(p)) {
                    p.receiver.onPathBroken(p, CrystalNetworkLogger.FlowFail.SIGHT);
                    p.resetTiles();
                    it.remove();
                    continue;
                }
                if (p.transmitter.canConduct() && p.canTransmit()) {
                    if (p.maxFlow == 0) {
                        p.tickRepeaters(0);
                        continue;
                    }
                    int amt = p.drain();
                    CrystalNetworkLogger.logFlowTick(p, amt);
                    if (amt <= 0) continue;
                    int add = p.receiver.receiveElement(p.element, amt);
                    p.transmitter.drain(p.element, amt);
                    if (add > 0) {
                        p.tickRepeaters(add);
                    }
                    if (p.isComplete()) {
                        p.resetTiles();
                        it.remove();
                        CrystalNetworkLogger.logFlowSatisfy(p);
                        p.receiver.onPathCompleted(p);
                        continue;
                    }
                    if (add > 0) continue;
                    CrystalNetworkLogger.logFlowBreak(p, CrystalNetworkLogger.FlowFail.FULL);
                    p.resetTiles();
                    it.remove();
                    continue;
                }
                CrystalNetworkLogger.logFlowBreak(p, CrystalNetworkLogger.FlowFail.ENERGY);
                p.receiver.onPathBroken(p, CrystalNetworkLogger.FlowFail.ENERGY);
                p.resetTiles();
                it.remove();
            }
        }
        this.toBreak.clear();
    }

    public void clear(int dim) {
        Collection li = this.flows.get((Object)dim);
        for (CrystalFlow f : li) {
            f.resetTiles();
        }
        this.flows.remove((Object)dim);
    }

    public void addTile(CrystalNetworkTile te) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            WorldLocation loc = PylonFinder.getLocation(te);
            CrystalNetworkTile old = (CrystalNetworkTile)this.tiles.get(loc);
            if (old != null) {
                this.removeTile(old);
            }
            this.tiles.put(loc, (Object)te);
            if (te instanceof TileEntityCrystalPylon) {
                this.addPylon((TileEntityCrystalPylon)te);
            }
            this.verifyTileAt(te, loc);
            for (NotifiedNetworkTile tile : this.notifyCache) {
                tile.onTileNetworkTopologyChange(te, false);
            }
            if (te instanceof NotifiedNetworkTile) {
                this.notifyCache.add((NotifiedNetworkTile)te);
            }
            WorldCrystalNetworkData.initNetworkData(te.getWorld()).func_76186_a(true);
            if (te instanceof TileEntityCrystalPylon) {
                PylonLocationData.initNetworkData(te.getWorld()).func_76186_a(true);
            }
            CrystalNetworkLogger.logTileAdd(te);
        }
    }

    private void verifyTileAt(CrystalNetworkTile te, WorldLocation loc) {
        UUID key = te.getUniqueID();
        WorldLocation prev = this.verifier.get(key);
        if (prev != null && !prev.equals((Object)loc)) {
            te.getWorld().func_147468_f(te.getX(), te.getY(), te.getZ());
            throw new CrystalNetworkException.InvalidLocationException(te, loc, prev);
        }
        this.verifier.put(key, loc);
    }

    public UUID getNewUniqueID() {
        UUID id = UUID.randomUUID();
        while (this.verifier.containsKey(id)) {
            id = UUID.randomUUID();
        }
        return id;
    }

    private void addPylon(TileEntityCrystalPylon te) {
        CrystalElement e = te.getColor();
        TileEntityCache c = this.pylons.get((Object)e);
        if (c == null) {
            c = new TileEntityCache();
            this.pylons.put(e, (TileEntityCache<TileEntityCrystalPylon>)c);
        }
        c.put((Object)te);
    }

    public Collection<TileEntityCrystalPylon> getNearbyPylons(World world, double x, double y, double z, CrystalElement e, int range, boolean LOS) {
        return this.getNearbyPylons(world, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), e, range, LOS);
    }

    public Collection<TileEntityCrystalPylon> getNearbyPylons(World world, int x, int y, int z, CrystalElement e, int range, boolean LOS) {
        TileEntityCache<TileEntityCrystalPylon> c = this.pylons.get((Object)e);
        ArrayList<TileEntityCrystalPylon> li = new ArrayList<TileEntityCrystalPylon>();
        if (c != null) {
            WorldLocation p = new WorldLocation(world, x, y, z);
            for (WorldLocation loc : c.getAllLocationsNear(p, (double)range)) {
                if (!(loc.getDistanceTo((double)x, (double)y, (double)z) <= (double)range) || LOS && !PylonFinder.lineOfSight(world, x, y, z, loc.xCoord, loc.yCoord, loc.zCoord)) continue;
                TileEntityCrystalPylon te = (TileEntityCrystalPylon)c.get(loc);
                if (te == null) {
                    ChromatiCraft.logger.logError((Object)("Null tile returned for location " + loc + "; " + loc.getBlockKey().getLocalized()));
                    te = (TileEntityCrystalPylon)loc.getTileEntity();
                    c.put(loc, (Object)te);
                }
                li.add(te);
            }
        }
        return li;
    }

    public Collection<TileEntityCrystalPylon> getAllNearbyPylons(CrystalNetworkTile te, double range) {
        return this.getAllNearbyPylons(te.getWorld(), te.getX(), te.getY(), te.getZ(), range);
    }

    public Collection<TileEntityCrystalPylon> getAllNearbyPylons(World world, int x, int y, int z, double range) {
        ArrayList<TileEntityCrystalPylon> li = new ArrayList<TileEntityCrystalPylon>();
        for (CrystalElement e : this.pylons.keySet()) {
            TileEntityCache<TileEntityCrystalPylon> c = this.pylons.get((Object)e);
            if (c == null) continue;
            WorldLocation p = new WorldLocation(world, x, y, z);
            for (WorldLocation loc : c.getAllLocationsNear(p, range)) {
                if (range != Double.POSITIVE_INFINITY && !(loc.getDistanceTo((double)x, (double)y, (double)z) <= range)) continue;
                TileEntityCrystalPylon te = (TileEntityCrystalPylon)c.get(loc);
                if (te == null) {
                    ChromatiCraft.logger.logError((Object)("Null tile returned for location " + loc + "; " + loc.getBlockKey().getLocalized()));
                    te = (TileEntityCrystalPylon)loc.getTileEntity();
                    c.put(loc, (Object)te);
                }
                li.add(te);
            }
        }
        return li;
    }

    public void removeTile(CrystalNetworkTile te) {
        TileEntityCrystalPylon tile;
        TileEntityCache<TileEntityCrystalPylon> c;
        this.tiles.remove(PylonFinder.getLocation(te));
        if (te instanceof NotifiedNetworkTile) {
            this.notifyCache.remove(te);
        }
        for (NotifiedNetworkTile tile2 : this.notifyCache) {
            tile2.onTileNetworkTopologyChange(te, true);
        }
        if (te instanceof TileEntityCrystalPylon && (c = this.pylons.get((Object)(tile = (TileEntityCrystalPylon)te).getColor())) != null) {
            c.remove((Object)tile);
        }
        Collection li = this.flows.get((Object)te.getWorld().field_73011_w.field_76574_g);
        Iterator it = li.iterator();
        while (it.hasNext()) {
            CrystalFlow p = (CrystalFlow)it.next();
            if (!p.contains(te)) continue;
            CrystalNetworkLogger.logFlowBreak(p, CrystalNetworkLogger.FlowFail.TILE);
            p.resetTiles();
            p.receiver.onPathBroken(p, CrystalNetworkLogger.FlowFail.TILE);
            it.remove();
        }
        PylonFinder.removePathsWithTile(te);
        WorldCrystalNetworkData.initNetworkData(te.getWorld()).func_76186_a(true);
        if (te instanceof TileEntityCrystalPylon) {
            PylonLocationData.initNetworkData(te.getWorld()).func_76186_a(true);
        }
        CrystalNetworkLogger.logTileRemove(te);
    }

    public void breakPaths(CrystalNetworkTile te) {
        Collection li = this.flows.get((Object)te.getWorld().field_73011_w.field_76574_g);
        Iterator it = li.iterator();
        while (it.hasNext()) {
            CrystalFlow p = (CrystalFlow)it.next();
            if (!p.contains(te)) continue;
            CrystalNetworkLogger.logFlowBreak(p, CrystalNetworkLogger.FlowFail.TILE);
            p.receiver.onPathBroken(p, CrystalNetworkLogger.FlowFail.TILE);
            p.resetTiles();
            it.remove();
        }
    }

    ArrayList<CrystalTransmitter> getTransmittersTo(CrystalReceiver r, CrystalElement e) {
        ArrayList<WorldLocation> locs;
        ArrayList<CrystalTransmitter> li = new ArrayList<CrystalTransmitter>();
        WorldLocation loc = PylonFinder.getLocation(r);
        if (r instanceof PylonConnector) {
            Collection<TileEntityCrystalPylon> c = this.getAllNearbyPylons(r, ((PylonConnector)r).getPylonRange());
            locs = new ArrayList<WorldLocation>();
            for (TileEntityCrystalPylon te : c) {
                if (!r.canReceiveFrom(te)) continue;
                locs.add(PylonFinder.getLocation(te));
            }
        } else {
            locs = this.tiles.getAllLocationsNear(loc, (double)r.getReceiveRange());
        }
        if (ModularLogger.instance.isEnabled(NBT_TAG)) {
            ModularLogger.instance.log(NBT_TAG, "Found " + locs.size() + " transmitters to " + r + ": " + locs);
        }
        for (WorldLocation c : locs) {
            CrystalTransmitter te;
            CrystalNetworkTile tile = (CrystalNetworkTile)this.tiles.get(c);
            if (!(tile instanceof CrystalTransmitter) || r == tile || !(te = (CrystalTransmitter)tile).canConduct() || !te.canTransmitTo(r) || e != null && !te.isConductingElement(e)) continue;
            boolean flag = r instanceof PylonConnector;
            double d = flag ? 0.0 : te.getDistanceSqTo(r.getX(), r.getY(), r.getZ());
            double send = te.getSendRange();
            double dist = r.getReceiveRange();
            if (!flag && !(d <= Math.min(dist * dist, send * send))) continue;
            li.add(te);
        }
        return li;
    }

    ArrayList<CrystalReceiver> getNearbyReceivers(CrystalTransmitter r, CrystalElement e) {
        ArrayList<CrystalReceiver> li = new ArrayList<CrystalReceiver>();
        try {
            WorldLocation loc = PylonFinder.getLocation(r);
            Collection locs = this.tiles.getAllLocationsNear(loc, (double)r.getSendRange());
            if (ModularLogger.instance.isEnabled(NBT_TAG)) {
                ModularLogger.instance.log(NBT_TAG, "Found " + locs.size() + " receivers from " + r + ": " + locs);
            }
            for (WorldLocation c : locs) {
                CrystalReceiver te;
                CrystalNetworkTile tile = (CrystalNetworkTile)this.tiles.get(c);
                if (!(tile instanceof CrystalReceiver) || r == tile || !(te = (CrystalReceiver)tile).canConduct() || !r.canTransmitTo(te) || e != null && !te.isConductingElement(e)) continue;
                double d = te.getDistanceSqTo(r.getX(), r.getY(), r.getZ());
                double send = r.getSendRange();
                double dist = te.getReceiveRange();
                if (!(d <= Math.min(dist * dist, send * send))) continue;
                li.add(te);
            }
        }
        catch (ConcurrentModificationException ex) {
            ex.printStackTrace();
            ChromatiCraft.logger.logError((Object)"CME when trying to pathfind on the crystal network. This indicates a deeper issue.");
        }
        return li;
    }

    ArrayList<CrystalSource> getAllSourcesFor(CrystalElement e, boolean activeOnly) {
        ArrayList<CrystalSource> li = new ArrayList<CrystalSource>();
        for (WorldLocation c : this.tiles.keySet()) {
            CrystalNetworkTile tile = (CrystalNetworkTile)this.tiles.get(c);
            if (!(tile instanceof CrystalSource)) continue;
            CrystalSource te = (CrystalSource)tile;
            if (activeOnly && !te.canConduct() || e != null && !te.isConductingElement(e)) continue;
            li.add(te);
        }
        return li;
    }

    public <T extends CrystalNetworkTile> T getNearestTileOfType(World world, int x, int y, int z, Class<T> type, double range) {
        return this.getNearestTileOfType(null, new WorldLocation(world, x, y, z), type, range);
    }

    public <T extends CrystalNetworkTile> T getNearestTileOfType(CrystalNetworkTile te, Class<T> type, double range) {
        WorldLocation loc = PylonFinder.getLocation(te);
        return this.getNearestTileOfType(te, loc, type, range);
    }

    private <T extends CrystalNetworkTile> T getNearestTileOfType(CrystalNetworkTile te, WorldLocation loc, Class<T> type, double range) {
        CrystalNetworkTile ret = null;
        double dist = Double.POSITIVE_INFINITY;
        HashSet<WorldLocation> rem = new HashSet<WorldLocation>();
        for (WorldLocation c : this.tiles.getAllLocationsNear(loc, range)) {
            double d;
            CrystalNetworkTile tile = (CrystalNetworkTile)this.tiles.get(c);
            if (tile == null) {
                ChromatiCraft.logger.logError((Object)("Null tile at " + c + " but still cached?!"));
                rem.add(c);
                continue;
            }
            if (te != null && tile == te || loc.dimensionID != c.dimensionID || !type.isAssignableFrom(tile.getClass()) || !((d = tile.getDistanceSqTo(loc.xCoord, loc.yCoord, loc.zCoord)) <= range * range) || !(d < dist)) continue;
            dist = d;
            ret = tile;
        }
        for (WorldLocation c : rem) {
            this.tiles.remove(c);
        }
        return (T)ret;
    }

    public <T extends CrystalNetworkTile> Collection<T> getNearTilesOfType(CrystalNetworkTile te, Class<T> type, int range) {
        return this.getNearTilesOfType(te.getWorld(), te.getX(), te.getY(), te.getZ(), type, range);
    }

    public <T extends CrystalNetworkTile> Collection<T> getNearTilesOfType(World world, int x, int y, int z, Class<T> type, int range) {
        ArrayList<CrystalNetworkTile> ret = new ArrayList<CrystalNetworkTile>();
        HashSet<WorldLocation> rem = new HashSet<WorldLocation>();
        WorldLocation loc = new WorldLocation(world, x, y, z);
        for (WorldLocation c : this.tiles.getAllLocationsNear(loc, (double)range)) {
            double d;
            CrystalNetworkTile tile = (CrystalNetworkTile)this.tiles.get(c);
            if (tile == null) {
                ChromatiCraft.logger.logError((Object)("Null tile at " + c + " but still cached?!"));
                rem.add(c);
                continue;
            }
            if (world.field_73011_w.field_76574_g != c.dimensionID || !type.isAssignableFrom(tile.getClass()) || !((d = tile.getDistanceSqTo(x, y, z)) <= (double)(range * range))) continue;
            ret.add(tile);
        }
        for (WorldLocation c : rem) {
            this.tiles.remove(c);
        }
        return ret;
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.SERVER);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.START;
    }

    public String getLabel() {
        return "Crystal Networker";
    }

    public void overloadColorConnectedTo(CrystalTransmitter te, CrystalElement color, int num, boolean recursive) {
        ArrayList<CrystalReceiver> li = this.getAllColorConnectedTo(te, color, recursive);
        if (li.isEmpty()) {
            return;
        }
        WeightedRandom w = new WeightedRandom();
        for (CrystalReceiver r : li) {
            if (r instanceof NaturalCrystalSource) continue;
            double wt = 1.0;
            if (r instanceof CrystalFuse) {
                wt = ((CrystalFuse)((Object)r)).getFailureWeight(color);
            }
            w.addEntry((Object)r, wt * 10.0);
        }
        for (int i = 0; i < num; ++i) {
            CrystalNetworkTile tile = (CrystalNetworkTile)w.getRandomEntry();
            if (tile instanceof CrystalFuse) {
                ((CrystalFuse)tile).overload(color);
                continue;
            }
            double x = (double)tile.getX() + 0.5;
            double y = (double)tile.getY() + 0.5;
            double z = (double)tile.getZ() + 0.5;
            tile.getWorld().func_147449_b(tile.getX(), tile.getY(), tile.getZ(), Blocks.field_150350_a);
            tile.getWorld().func_72876_a(null, x, y, z, 1.5f + rand.nextFloat() * 1.5f, true);
        }
    }

    public ArrayList<CrystalReceiver> getAllColorConnectedTo(CrystalTransmitter te, CrystalElement color, boolean recursive) {
        return this.getAllColorConnectedTo(te, color, recursive, new HashSet<WorldLocation>());
    }

    private ArrayList<CrystalReceiver> getAllColorConnectedTo(CrystalTransmitter te, CrystalElement color, boolean recursive, HashSet<WorldLocation> locs) {
        ArrayList<CrystalReceiver> li = this.getNearbyReceivers(te, color);
        if (recursive) {
            for (CrystalReceiver r : li) {
                WorldLocation loc = new WorldLocation(r.getWorld(), r.getX(), r.getY(), r.getZ());
                if (locs.contains(loc)) continue;
                locs.add(loc);
                if (!(r instanceof CrystalTransmitter)) continue;
                ArrayList<CrystalReceiver> li2 = this.getAllColorConnectedTo((CrystalTransmitter)((Object)r), color, recursive, locs);
                for (CrystalReceiver r2 : li2) {
                    WorldLocation loc2 = new WorldLocation(r.getWorld(), r.getX(), r.getY(), r.getZ());
                    if (locs.contains(loc2)) continue;
                    locs.add(loc2);
                    li.add(r2);
                }
            }
        }
        return li;
    }

    public void printCrystalNetwork(World world, int chunkX, int chunkZ) {
        MultiMap data = new MultiMap();
        for (WorldLocation loc : this.tiles.keySet()) {
            if (world != null && loc.dimensionID != world.field_73011_w.field_76574_g || chunkX != -1 && loc.xCoord / 16 != chunkX || chunkZ != -1 && loc.zCoord / 16 != chunkZ) continue;
            data.addValue((Object)loc.dimensionID, (Object)("(" + loc + " @ " + this.getString((CrystalNetworkTile)this.tiles.get(loc)) + ")"));
        }
        if (data.isEmpty()) {
            ReikaJavaLibrary.pConsole((Object)"[]");
        } else {
            Iterator i$ = data.keySet().iterator();
            while (i$.hasNext()) {
                int dim = (Integer)i$.next();
                ReikaJavaLibrary.pConsole((Object)("DIM" + dim + ":"));
                Collection li = data.get((Object)dim);
                ReikaJavaLibrary.pConsole((Object)(li.size() + "# " + li));
            }
        }
    }

    private String getString(CrystalNetworkTile net) {
        if (net instanceof TileEntityCrystalPylon) {
            TileEntityCrystalPylon te = (TileEntityCrystalPylon)net;
            return (Object)((Object)te.getColor()) + " Pylon [" + te.getEnergy(te.getColor()) + "/" + te.getMaxStorage(te.getColor()) + "], Struct=" + te.hasStructure() + ", Turbo=" + te.isEnhanced();
        }
        if (net instanceof TileEntityCrystalRepeater) {
            TileEntityCrystalRepeater te = (TileEntityCrystalRepeater)net;
            if (te instanceof TileEntityCompoundRepeater) {
                return "Compound Repeater, Struct=" + te.canConduct() + ", Turbo=" + te.isTurbocharged();
            }
            if (te instanceof TileEntityCrystalBroadcaster) {
                return "Broadcast Repeater, Struct=" + te.canConduct() + ", Turbo=" + te.isTurbocharged();
            }
            return (Object)((Object)te.getActiveColor()) + " Repeater, Struct=" + te.canConduct() + ", Turbo=" + te.isTurbocharged();
        }
        if (net instanceof TileEntityChromaticBase) {
            return ((TileEntityChromaticBase)((Object)net)).getName();
        }
        int[] conn = new int[16];
        for (int i = 0; i < 16; ++i) {
            conn[i] = net.isConductingElement(CrystalElement.elements[i]) ? 1 : 0;
        }
        return net.toString() + " : " + net.canConduct() + ", E=" + Arrays.toString(conn);
    }

    static class CrystalLink {
        public final WorldLocation loc1;
        public final WorldLocation loc2;
        private final HashSet<WorldChunk> chunks = new HashSet();
        private boolean hasLOS = false;

        CrystalLink(WorldLocation l1, WorldLocation l2) {
            this.loc1 = l1;
            this.loc2 = l2;
            double dd = l1.getDistanceTo(l2);
            World world = l1.getWorld();
            int i = 0;
            while ((double)i < dd) {
                int z;
                int x = MathHelper.func_76128_c((double)((double)l1.xCoord + (double)(i * (l2.xCoord - l1.xCoord)) / dd));
                WorldChunk ch = new WorldChunk(world, new ChunkCoordIntPair(x >> 4, (z = MathHelper.func_76128_c((double)((double)l1.zCoord + (double)(i * (l2.zCoord - l1.zCoord)) / dd))) >> 4));
                if (!this.chunks.contains(ch)) {
                    this.chunks.add(ch);
                }
                ++i;
            }
        }

        void recalculateLOS() {
            this.hasLOS = PylonFinder.lineOfSight(this.loc1, this.loc2);
        }

        public boolean isChunkInPath(WorldChunk wc) {
            return this.chunks.contains(wc);
        }

        public final int hashCode() {
            return this.loc1.hashCode() ^ this.loc2.hashCode();
        }

        public final boolean equals(Object o) {
            if (o instanceof CrystalLink) {
                CrystalLink l = (CrystalLink)o;
                return l.loc1.equals((Object)this.loc1) && l.loc2.equals((Object)this.loc2);
            }
            return false;
        }

        public String toString() {
            return "[" + this.loc1 + " > " + this.loc2 + "]";
        }

        final boolean hasLineOfSight() {
            return this.hasLOS;
        }
    }

    public static class WorldCrystalNetworkData
    extends WorldSavedData {
        private static final String IDENTIFIER = "crystalnet";

        public WorldCrystalNetworkData() {
            super("crystalnet");
        }

        public WorldCrystalNetworkData(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound NBT) {
            instance.load(NBT);
        }

        public void func_76187_b(NBTTagCompound NBT) {
            instance.save(NBT);
        }

        private static WorldCrystalNetworkData initNetworkData(World world) {
            WorldCrystalNetworkData data = (WorldCrystalNetworkData)world.func_72943_a(WorldCrystalNetworkData.class, "crystalnet");
            if (data == null) {
                data = new WorldCrystalNetworkData();
                world.func_72823_a("crystalnet", (WorldSavedData)data);
            }
            return data;
        }
    }

    public static class PylonLocationData
    extends WorldSavedData {
        private static final String IDENTIFIER = "pylonloc";

        public PylonLocationData() {
            super(IDENTIFIER);
        }

        public PylonLocationData(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound NBT) {
            PylonGenerator.instance.loadPylonLocations(NBT);
        }

        public void func_76187_b(NBTTagCompound NBT) {
            PylonGenerator.instance.savePylonLocations(NBT);
        }

        private static PylonLocationData initNetworkData(World world) {
            PylonLocationData data = (PylonLocationData)world.func_72943_a(PylonLocationData.class, IDENTIFIER);
            if (data == null) {
                data = new PylonLocationData();
                world.func_72823_a(IDENTIFIER, (WorldSavedData)data);
            }
            return data;
        }
    }

    private static class CMENote
    implements CrashNotifications.CrashNotification {
        private CMENote() {
        }

        public String getLabel() {
            return "Crystal Network CME";
        }

        public String addMessage(Throwable crash) {
            if (ReikaJavaLibrary.exceptionMentions((Throwable)crash, CrystalNetworker.class)) {
                return "This CME was thrown during crystal network pathfinding, and is likely the result of MC being multithreaded or otherwise optimized by mods like Optifine and FastCraft. Do not report this unless you can reproduce it with only ChromatiCraft.";
            }
            return null;
        }
    }
}

