/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.DynamicRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.WrapperTile;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class CrystalFlow
extends CrystalPath {
    private static final int MIN_THROUGHPUT = 10;
    public final int maxFlow;
    public final int totalCost;
    public final CrystalReceiver receiver;
    private int remainingAmount;

    CrystalFlow(CrystalNetworker net, CrystalPath p, CrystalReceiver r, int amt, int maxthru) {
        this(net, r, p.element, amt, p.nodes, maxthru);
    }

    protected CrystalFlow(CrystalNetworker net, CrystalReceiver r, CrystalElement e, int amt, List<WorldLocation> li, int maxthru) {
        super(net, !(r instanceof WrapperTile), e, li);
        this.remainingAmount = this.totalCost = amt + this.getSignalLoss();
        this.receiver = r;
        CrystalNetworkLogger.logPathCalculation("maxthru", maxthru);
        this.maxFlow = this.calcEffectiveThroughput(maxthru);
    }

    private int calcEffectiveThroughput(int maxthru) {
        int base = this.getMinMaxFlow();
        if (CrystalNetworkLogger.getLogLevel().isAtLeast(CrystalNetworkLogger.LoggingLevel.PATHCALC)) {
            CrystalNetworkLogger.logPathCalculation("base", base);
            CrystalNetworkLogger.logPathCalculation("bonus", this.getThoughputBonus());
            CrystalNetworkLogger.logPathCalculation("insured", this.getInsuredThroughput());
            CrystalNetworkLogger.logPathCalculation("max-base", Math.min(maxthru, base));
            CrystalNetworkLogger.logPathCalculation("totalthru", Math.min(Math.max(this.getInsuredThroughput(), base - this.getSignalLoss() + this.getThoughputBonus()), Math.min(maxthru, base)));
        }
        int result = Math.min(Math.max(this.getInsuredThroughput(), base - this.getThroughputPenalty(base) + this.getThoughputBonus()), Math.min(maxthru, base));
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt((WorldLocation)this.nodes.get(i), true);
            if (!(te instanceof DynamicRepeater)) continue;
            result = ((DynamicRepeater)te).getModifiedThoughput(result, this.transmitter, this.receiver);
        }
        return result;
    }

    private int getInsuredThroughput() {
        int val = 10;
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt((WorldLocation)this.nodes.get(i), true);
            if (!(te instanceof CrystalRepeater)) continue;
            val = Math.max(val, ((CrystalRepeater)te).getThoughputInsurance());
        }
        return val;
    }

    private int getThoughputBonus() {
        int val = 0;
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt((WorldLocation)this.nodes.get(i), true);
            if (!(te instanceof CrystalRepeater)) continue;
            val += ((CrystalRepeater)te).getThoughputBonus();
        }
        return val;
    }

    private int getMinMaxFlow() {
        int max = Math.min(this.transmitter.maxThroughput(), this.receiver.maxThroughput());
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt((WorldLocation)this.nodes.get(i), true);
            max = Math.min(max, te.maxThroughput());
        }
        return max;
    }

    private int getThroughputPenalty(int rawthru) {
        int att = this.getSignalLoss();
        if (att <= 1) {
            return 0;
        }
        int amt = (int)Math.pow(att / 80, 1.5 + 0.5 * (double)(1.0f - this.getOptimizationFactor()));
        double x = rawthru / att - 1;
        if (att > rawthru) {
            double y = -Math.sqrt(-x) * (double)(rawthru - amt - 10);
            amt = (int)((long)amt + Math.round(y));
        } else if (att < rawthru) {
            x = Math.min(x, 1.0);
            double y = Math.sqrt(x) * (double)amt;
            amt = (int)((long)amt - Math.round(y));
        }
        return Math.max(0, amt);
    }

    CrystalPath asPath() {
        return new CrystalPath(this.network, this.hasRealTarget, this.element, this.nodes);
    }

    @Override
    protected void initialize() {
        super.initialize();
        WorldLocation locs = (WorldLocation)this.nodes.get(this.nodes.size() - 2);
        CrystalReceiver r = PylonFinder.getReceiverAt(locs, true);
        ImmutableTriple<Double, Double, Double> offset = r.getTargetRenderOffset(this.element);
        double sx = offset != null ? (Double)offset.left : 0.0;
        double sy = offset != null ? (Double)offset.middle : 0.0;
        double sz = offset != null ? (Double)offset.right : 0.0;
        CrystalSource src = PylonFinder.getSourceAt((WorldLocation)this.nodes.get(this.nodes.size() - 1), true);
        src.addTarget(locs, this.element, sx, sy, sz, r.getIncomingBeamRadius());
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt((WorldLocation)this.nodes.get(i), true);
            if (!(te instanceof CrystalTransmitter)) continue;
            WorldLocation tg = (WorldLocation)this.nodes.get(i - 1);
            r = PylonFinder.getReceiverAt(tg, true);
            offset = r.getTargetRenderOffset(this.element);
            double dx = offset != null ? (Double)offset.left : 0.0;
            double dy = offset != null ? (Double)offset.middle : 0.0;
            double dz = offset != null ? (Double)offset.right : 0.0;
            ((CrystalTransmitter)te).addTarget(tg, this.element, dx, dy, dz, r.getIncomingBeamRadius());
        }
    }

    private String getTiles() {
        StringBuilder sb = new StringBuilder();
        sb.append("(0 is receiver, size-1 is source) N=");
        sb.append(this.nodes.size());
        sb.append("[");
        int i = 0;
        for (WorldLocation loc : this.nodes) {
            sb.append(i);
            sb.append("=");
            sb.append(loc.getTileEntity());
            sb.append(";");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public void resetTiles() {
        PylonFinder.getSourceAt((WorldLocation)this.nodes.get(this.nodes.size() - 1), true).removeTarget((WorldLocation)this.nodes.get(this.nodes.size() - 2), this.element);
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt((WorldLocation)this.nodes.get(i), true);
            if (!(te instanceof CrystalTransmitter)) continue;
            WorldLocation tg = (WorldLocation)this.nodes.get(i - 1);
            ((CrystalTransmitter)te).removeTarget(tg, this.element);
        }
    }

    public boolean isComplete() {
        return this.remainingAmount <= 0;
    }

    public int getRemainingLumens() {
        return this.remainingAmount;
    }

    int drain() {
        int ret = Math.min(this.transmitter.getEnergy(this.element), this.getDrainThisTick());
        if (ret <= 0) {
            return 0;
        }
        this.remainingAmount -= ret;
        return ret;
    }

    private int getDrainThisTick() {
        return Math.min(Math.min(this.maxFlow, this.transmitter.maxThroughput()), this.remainingAmount);
    }

    public void tickRepeaters(int amt) {
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = PylonFinder.getNetTileAt((WorldLocation)this.nodes.get(i), true);
            if (!(te instanceof CrystalRepeater)) continue;
            ((CrystalRepeater)te).onTransfer(this.transmitter, this.receiver, this.element, amt);
        }
    }
}

