/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Lore;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Math.HexGrid;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public enum Towers {
    ALPHA("\u03b1", 24, 0, 0, 0),
    BETA("\u03b2", 25, 0, 4, -4),
    GAMMA("\u03b3", 26, -2, 4, -2),
    DELTA("\u03b4", 27, -4, 4, 0),
    PSI("\u03c8", 47, -4, 2, 2),
    PHI("\u03c6", 45, -4, 0, 4),
    OMEGA("\u03c9", 48, -2, -2, 4),
    LAMBDA("\u03bb", 34, 0, -4, 4),
    THETA("\u03b8", 31, 2, -4, 2),
    CHI("\u03c7", 46, 4, -4, 0),
    MU("\u03bc", 35, 4, -2, -2),
    TAU("\u03c4", 43, 4, 0, -4),
    SIGMA("\u03c3", 42, 2, 2, -4);

    public final String character;
    public final int textureIndex;
    private final HexGrid.Hex hex;
    private ChunkCoordIntPair position;
    public static final Towers[] towerList;
    private static final HashMap<ChunkCoordIntPair, Towers> towerChunkCache;
    private static final EnumMap<Towers, Coordinate> towerCache;
    private static long lastWorldSeed;

    private Towers(String s, int idx, int x, int y, int z) {
        this.character = s;
        this.textureIndex = idx;
        this.hex = new HexGrid.Hex(1.0, x, y, z);
    }

    public ChunkCoordIntPair getRootPosition() {
        return this.position;
    }

    public static void loadPositions(World world, double radius) {
        towerChunkCache.clear();
        towerCache.clear();
        HexGrid grid = new HexGrid(9, radius, true, HexGrid.MapShape.HEXAGON).flower();
        Random rand = new Random(world.func_72905_C());
        double a = rand.nextDouble() * 360.0;
        double dx = -2500.0 + rand.nextDouble() * 5000.0;
        double dz = -2500.0 + rand.nextDouble() * 5000.0;
        for (int i = 0; i < towerList.length; ++i) {
            Towers t = towerList[i];
            grid.addHex(t.hex.q, t.hex.r, t.hex.s);
            HexGrid.Hex ref = grid.getHex(t.hex.q, t.hex.r, t.hex.s);
            HexGrid.Point p = grid.getHexLocation(ref).rotate(a, 0, 0).translate(dx, dz);
            int x = ReikaMathLibrary.roundToNearestX((int)16, (int)((int)Math.round(p.x)));
            int y = ReikaMathLibrary.roundToNearestX((int)16, (int)((int)Math.round(p.y)));
            t.position = new ChunkCoordIntPair(x, y);
            towerChunkCache.put(t.position, t);
        }
        lastWorldSeed = world.func_72905_C();
    }

    static Towers getTowerForChunk(int cx, int cz) {
        return towerChunkCache.get(new ChunkCoordIntPair(cx, cz));
    }

    public void generatedAt(int x, int y, int z) {
        towerCache.put(this, new Coordinate(x, y, z));
    }

    public Coordinate getGeneratedLocation() {
        return towerCache.get((Object)this);
    }

    public Towers getNeighbor1() {
        if (this == ALPHA) {
            return null;
        }
        if (this == SIGMA) {
            return BETA;
        }
        return towerList[this.ordinal() + 1];
    }

    public Towers getNeighbor2() {
        if (this == ALPHA) {
            return null;
        }
        if (this == BETA) {
            return SIGMA;
        }
        return towerList[this.ordinal() - 1];
    }

    public static boolean initialized(World world) {
        return !towerChunkCache.isEmpty() && lastWorldSeed == world.func_72905_C();
    }

    static {
        towerList = Towers.values();
        towerChunkCache = new HashMap();
        towerCache = new EnumMap(Towers.class);
    }
}

