/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Lore;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Lore.LoreScriptRenderer;
import Reika.ChromatiCraft.Magic.Lore.LoreScripts;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;

public class RosettaStone {
    private static final HashSet<Character> decodableCharacters = new HashSet();
    private final long seed;
    private final Random rand;
    private int alpha = 1;
    private final ArrayList<String> text = new ArrayList();

    public RosettaStone(EntityPlayer ep) {
        this.loadText();
        this.seed = ep.func_110124_au().hashCode();
        this.rand = new Random(this.seed);
    }

    public void loadText() {
        this.text.clear();
        for (String s : this.getData()) {
            if (s.isEmpty() || s.equals(System.lineSeparator())) continue;
            this.text.add(s);
        }
    }

    private ArrayList<String> getData() {
        if (LoreScripts.instance.hasReroutePath()) {
            return ReikaFileReader.getFileAsLines((File)LoreScripts.instance.getReroutedRosettaFile(), (boolean)true);
        }
        return ReikaFileReader.getFileAsLines((InputStream)ChromatiCraft.class.getResourceAsStream("Resources/rosetta.txt"), (boolean)true);
    }

    public void render(ScaledResolution res, double w2, double h2) {
        this.alpha = Math.min(this.alpha + 2, 255);
        double w = res.func_78327_c();
        int inset = 12;
        double x = w - (double)inset - 1.0;
        Minecraft.func_71410_x().field_71474_y.field_74330_P = false;
        this.rand.setSeed(this.seed + System.currentTimeMillis() / 100L);
        int color = 0xFFFFFF;
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/GUIs/all-back.png");
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78384_a(0xFFFFFF, Math.min(255, this.alpha * 2));
        Tessellator.field_78398_a.func_78374_a(0.0, h2 * 2.0, 0.0, 0.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(w2 * 2.0, h2 * 2.0, 0.0, 1.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(w2 * 2.0, 0.0, 0.0, 1.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        int dy = 0;
        LoreScriptRenderer.instance.startRendering(false, color | this.alpha << 24);
        for (String s : this.text) {
            int y = dy;
            LoreScriptRenderer.instance.renderLine(s, x, y, w - (double)inset / 2.0, false);
            dy += 9;
        }
        LoreScriptRenderer.instance.stopRendering();
        dy += 10;
        x = inset / 2 - 2;
        FontRenderer f = Minecraft.func_71410_x().field_71464_q;
        for (String s : this.text) {
            int y = dy;
            int dx = (int)x;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ') {
                    dx += 9;
                    continue;
                }
                if (decodableCharacters.contains(Character.valueOf(c)) && this.rand.nextInt(20) > 0) {
                    f.func_78276_b(String.valueOf(c), dx, y, color | Math.max(4, this.alpha) << 24);
                    dx += 8;
                    continue;
                }
                this.renderSmudge(c, dx, y);
                dx += 8;
            }
            dy += f.field_78288_b;
        }
    }

    private void renderSmudge(char c, int x, int y) {
        for (int i = 0; i < 4; ++i) {
            c = (char)(97 + this.rand.nextInt(26));
            int a = Math.max(4, (int)((double)this.alpha * (0.5 + 0.5 * this.rand.nextDouble())));
            Minecraft.func_71410_x().field_71464_q.func_78276_b(String.valueOf(c), x, y, 0xFFFFFF | a << 24);
        }
    }

    static {
        for (int i = 0; i < 26; ++i) {
            char c = (char)(97 + i);
            if (c == 'o' || c == 'f' || c == 'l' || c == 'r' || c == 'c' || c == 'p') continue;
            decodableCharacters.add(Character.valueOf(c));
        }
    }
}

