/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Lore;

import Reika.ChromatiCraft.Auxiliary.Render.ChromaOverlays;
import Reika.ChromatiCraft.Magic.Lore.KeyAssemblyPuzzle;
import Reika.ChromatiCraft.Magic.Lore.RosettaStone;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class LoreManager {
    public static final LoreManager instance = new LoreManager();
    private static final String NBT_TAG = "loretowers";
    private KeyAssemblyPuzzle puzzle;
    private RosettaStone rosetta;
    private final MultiMap<Towers, KeyAssemblyPuzzle.TileGroup> towerGroups = new MultiMap().setNullEmpty();

    private LoreManager() {
    }

    public void triggerLore(EntityPlayer ep, Towers t) {
        this.setPlayerScanned(ep, t, true);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.LORENOTE.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{t.ordinal()});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addLoreNote(EntityPlayer ep, Towers t) {
        this.setPlayerScanned(ep, t, true);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.LOREHEX, (Entity)ep, (float)1.0f, (float)1.0f, (boolean)false);
        ChromaOverlays.instance.addLoreNote(ep, t);
    }

    public Towers getTower(World world, int cx, int cz) {
        this.initTowers(world);
        return Towers.getTowerForChunk(cx, cz);
    }

    public void initTowers(World world) {
        if (!Towers.initialized(world)) {
            Towers.loadPositions(world, 2048.0);
        }
    }

    public ChunkCoordIntPair getNearestTowerChunk(World world, int cx, int cz) {
        this.initTowers(world);
        ChunkCoordIntPair ret = null;
        double mind = Double.POSITIVE_INFINITY;
        for (int i = 0; i < Towers.towerList.length; ++i) {
            Towers t = Towers.towerList[i];
            ChunkCoordIntPair p = t.getRootPosition();
            double d = ReikaMathLibrary.py3d((double)(cx - p.field_77276_a), (double)0.0, (double)(cz - p.field_77275_b));
            if (ret != null && !(d < mind)) continue;
            ret = p;
            mind = d;
        }
        return ret;
    }

    public KeyAssemblyPuzzle getPuzzle(EntityPlayer ep) {
        this.initTowers(ep.field_70170_p);
        if (this.puzzle == null || this.puzzle.getSeed() != KeyAssemblyPuzzle.calcSeed(ep)) {
            this.puzzle = KeyAssemblyPuzzle.generatePuzzle(ep);
        }
        return this.puzzle;
    }

    public void preparePuzzle(EntityPlayer ep) {
        this.initTowers(ep.field_70170_p);
        if (this.towerGroups.isEmpty()) {
            for (int i = 0; i < Towers.towerList.length; ++i) {
                Towers t = Towers.towerList[i];
                this.getGroupsForTower(ep, t);
            }
        }
    }

    public Collection<KeyAssemblyPuzzle.TileGroup> getGroupsForTower(EntityPlayer ep, Towers t) {
        Collection<KeyAssemblyPuzzle.TileGroup> c = this.towerGroups.get((Object)t);
        if (c == null) {
            KeyAssemblyPuzzle p = this.getPuzzle(ep);
            c = p.getRandomGroupsForTower(t);
            this.towerGroups.put((Object)t, c);
        }
        return Collections.unmodifiableCollection(c);
    }

    public void setPlayerScanned(EntityPlayer ep, Towers t, boolean set) {
        NBTTagCompound NBT = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        tag.func_74757_a(t.name(), set);
        NBT.func_74782_a(NBT_TAG, (NBTBase)tag);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public boolean hasPlayerScanned(EntityPlayer ep, Towers t) {
        NBTTagCompound NBT = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        return tag.func_74767_n(t.name());
    }

    public boolean hasScannedAllTowers(EntityPlayer ep) {
        for (int i = 0; i < Towers.towerList.length; ++i) {
            Towers t = Towers.towerList[i];
            if (this.hasPlayerScanned(ep, t)) continue;
            return false;
        }
        return true;
    }

    public boolean hasPlayerCompletedBoard(EntityPlayer ep) {
        NBTTagCompound NBT = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        return tag.func_74767_n("complete");
    }

    public void setBoardCompletion(EntityPlayer ep, boolean set) {
        NBTTagCompound NBT = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        tag.func_74757_a("complete", set);
        NBT.func_74782_a(NBT_TAG, (NBTBase)tag);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public void completeBoard(EntityPlayer ep) {
        this.setBoardCompletion(ep, true);
        if (ep.field_70170_p.field_72995_K) {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.LORECOMPLETE, (Entity)ep, (float)1.0f, (float)1.0f, (boolean)false);
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.LOREPUZZLECOMPLETE.ordinal(), (PacketTarget)PacketTarget.server, (int[])new int[0]);
        } else {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public RosettaStone getOrCreateRosetta(EntityPlayer ep) {
        if (this.rosetta == null) {
            this.rosetta = new RosettaStone(ep);
        }
        return this.rosetta;
    }
}

