/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Lore;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementMixer;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.ExtremaFinder;
import Reika.DragonAPI.Instantiable.Math.HexGrid;
import Reika.DragonAPI.Instantiable.ResettableRandom;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class KeyAssemblyPuzzle {
    private static final int SIZE = 15;
    public static final int CELL_SIZE = 15;
    private static final int BASE_SIZE = new HexGrid(15, 15.0, true, HexGrid.MapShape.HEXAGON).flower().cellCount();
    public static final int TOWER_COUNT = 13;
    public static final int GROUPS_PER_TOWER = 3;
    public static final int GROUP_SIZE = 4;
    private static final int REQUIRED_CELLS = 156;
    private static final int VOID_COUNT = BASE_SIZE - 156;
    private static final double SIN60 = Math.sin(Math.toRadians(60.0));
    private final HexGrid grid;
    private final HashMap<HexGrid.Hex, HexCell> cells = new HashMap();
    private final HashSet<HexGrid.Hex> emptyHexes = new HashSet();
    private final ArrayList<TileGroup> groups = new ArrayList();
    private final ArrayList<TileGroup> freeGroups = new ArrayList();
    private int activeCells;
    private static final String hexPNG = "Textures/colorhexes.png";
    private static final String voidPNG = "Textures/colorhexes-voids.png";
    private final ResettableRandom rand = new ResettableRandom();
    private long seed;

    private KeyAssemblyPuzzle() {
        this.grid = new HexGrid(15, 15.0, true, HexGrid.MapShape.HEXAGON).flower();
        for (HexGrid.Hex h : this.grid.getAllHexes()) {
            this.cells.put(h, new HexCell(h));
        }
    }

    public static KeyAssemblyPuzzle generatePuzzle(EntityPlayer ep) {
        return KeyAssemblyPuzzle.generatePuzzle(ep, KeyAssemblyPuzzle.calcSeed(ep));
    }

    private static KeyAssemblyPuzzle generatePuzzle(EntityPlayer ep, long seed) {
        KeyAssemblyPuzzle p = new KeyAssemblyPuzzle();
        p.generate(ep, seed);
        return p;
    }

    public static long calcSeed(EntityPlayer ep) {
        long seed1 = ep.field_70170_p.func_72905_C();
        UUID seed0 = ep.getPersistentID();
        long seed2 = ReikaMathLibrary.cantorCombine((long[])new long[]{seed1, seed0.getMostSignificantBits(), seed0.getLeastSignificantBits()});
        return seed2;
    }

    public long getSeed() {
        return this.seed;
    }

    private void generate(EntityPlayer ep, long seed) {
        this.seed = seed;
        this.rand.setSeed(seed);
        this.activeCells = 0;
        this.groups.clear();
        this.freeGroups.clear();
        this.fillGrid((Random)this.rand);
        this.generateVoids((Random)this.rand);
        LinkedList<Move> li = this.shuffle((Random)this.rand);
        this.subdivide((Random)this.rand);
        if (LoreManager.instance.hasPlayerCompletedBoard(ep)) {
            Iterator<Move> it = li.descendingIterator();
            while (it.hasNext()) {
                Move m = it.next().invert(this.grid);
                this.getCell(m.hex).occupant.move(this, m.direction, null);
            }
        }
    }

    public Collection<TileGroup> getRandomGroupsForTower(Towers t) {
        this.rand.setSeed(this.seed ^ (long)t.ordinal());
        ArrayList<TileGroup> ret = new ArrayList<TileGroup>();
        for (int i = 0; i < 3; ++i) {
            int idx = this.rand.nextInt(this.freeGroups.size());
            TileGroup g = this.freeGroups.get(idx);
            ret.add(g);
            this.freeGroups.remove(idx);
            for (HexGrid.Hex h : g.hexes) {
                HexCell c = this.getCell(h);
                c.tower = t;
            }
        }
        return ret;
    }

    private void fillGrid(Random rand) {
        for (HexCell c : this.cells.values()) {
            c.occupant = new HexTile(this.generateColor(c.location, rand));
            this.setCellContents(c.location, c.occupant, null);
            c.occupant.update(this, true, null);
        }
    }

    private void generateVoids(Random rand) {
        ArrayList<HexCell> li = new ArrayList<HexCell>(this.cells.values());
        for (int i = 0; i < VOID_COUNT; ++i) {
            HexCell c = li.get(rand.nextInt(li.size()));
            while (c.occupant == null) {
                c = li.get(rand.nextInt(li.size()));
            }
            c.occupant = null;
            this.setCellContents(c.location, null, null);
            this.emptyHexes.add(c.location);
        }
    }

    private LinkedList<Move> shuffle(Random rand) {
        LinkedList<Move> moves = new LinkedList<Move>();
        for (int i = 0; i < 500; ++i) {
            block5: {
                HexGrid.Hex h = (HexGrid.Hex)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, this.emptyHexes);
                ArrayList li = this.grid.getValidMovementDirections(h);
                int dir = (Integer)li.get(rand.nextInt(li.size()));
                HexGrid.Hex h2 = h.getNeighbor(dir);
                while (!li.isEmpty() && this.getCell(h2).occupant == null) {
                    li.remove((Object)dir);
                    if (li.isEmpty()) continue;
                    dir = (Integer)li.get(rand.nextInt(li.size()));
                    h2 = h.getNeighbor(dir);
                }
                if (!li.isEmpty()) {
                    try {
                        int dir2 = this.grid.getOppositeDirection(dir);
                        if (!this.getCell(h2).occupant.move(this, dir2, null)) break block5;
                        moves.add(new Move(h2, dir2));
                    }
                    catch (Exception e) {
                        ReikaJavaLibrary.pConsole((Object)("Errored on shuffle " + i + ": moving " + h2 + " into " + h + ", dir = " + this.grid.getOppositeDirection(dir) + ", from " + dir + "; c=" + this.getCell(h)));
                        ReikaJavaLibrary.pConsole((Object)e.toString());
                        break;
                    }
                }
            }
            if (i != 500 || !this.isComplete()) continue;
            i = 0;
        }
        return moves;
    }

    private void subdivide(Random rand) {
        LinkedList<HexGrid.Hex> li = this.findHamiltonianPath(rand);
        TileGroup g = new TileGroup();
        for (HexGrid.Hex h : li) {
            g.hexes.add(h);
            if (g.hexes.size() != 4) continue;
            this.groups.add(g);
            g = new TileGroup();
        }
        this.freeGroups.addAll(this.groups);
    }

    private LinkedList<HexGrid.Hex> findHamiltonianPath(Random rand) {
        LinkedList<HexGrid.Hex> path = null;
        boolean flag = true;
        while (flag) {
            HexGrid.Hex h = this.grid.getRandomEdgeCell(rand);
            while (this.getCell(h).occupant == null) {
                h = this.grid.getRandomEdgeCell(rand);
            }
            path = new LinkedList<HexGrid.Hex>();
            HashSet<HexGrid.Hex> pathCache = new HashSet<HexGrid.Hex>();
            flag = !this.pathSearch(rand, h, path, pathCache);
        }
        return path;
    }

    private boolean pathSearch(Random rand, HexGrid.Hex h, LinkedList<HexGrid.Hex> path, HashSet<HexGrid.Hex> pathCache) {
        path.add(h);
        pathCache.add(h);
        ExtremaFinder ef = new ExtremaFinder();
        for (HexGrid.Hex n : h.getNeighbors()) {
            if (!this.isValidPathCell(n, pathCache)) continue;
            double f = 0.0;
            ArrayList dirs = this.grid.getValidMovementDirections(n);
            Iterator it = dirs.iterator();
            while (it.hasNext()) {
                int dir = (Integer)it.next();
                HexGrid.Hex n2 = n.getNeighbor(dir);
                if (this.isValidPathCell(n2, pathCache) || pathCache.contains(n2)) continue;
                it.remove();
            }
            int val = 6 - dirs.size();
            f += 1.4 * (double)val;
            for (HexGrid.Hex n2 : n.getNeighbors()) {
                if (!this.grid.containsHex(n2) || !pathCache.contains(n2)) continue;
                f += 1.0;
            }
            ef.addValue((Object)n, f);
        }
        HexGrid.Hex step = (HexGrid.Hex)ef.getHighest();
        if (step != null) {
            return this.pathSearch(rand, step, path, pathCache);
        }
        return path.size() == 156;
    }

    private boolean isValidPathCell(HexGrid.Hex h, HashSet<HexGrid.Hex> pathCache) {
        return this.grid.containsHex(h) && !pathCache.contains(h) && this.getCell(h).occupant != null && !this.grid.dividesGrid(h, ReikaJavaLibrary.combineCollections((Collection[])new Collection[]{pathCache, this.emptyHexes}));
    }

    private CrystalElement generateColor(HexGrid.Hex h, Random rand) {
        if (rand.nextInt(32) == 0) {
            return CrystalElement.BROWN;
        }
        HashSet<CrystalElement> li = new HashSet<CrystalElement>();
        for (HexGrid.Hex h2 : h.getNeighbors()) {
            Collection<CrystalElement> ce;
            HexCell c;
            if (!this.grid.containsHex(h2) || (c = this.getCell(h2)).occupant == null || (ce = ElementMixer.instance.getRelatedColors(c.occupant.color)) == null) continue;
            li.addAll(ce);
        }
        return li.isEmpty() ? CrystalElement.elements[rand.nextInt(16)] : (CrystalElement)((Object)new ArrayList(li).get(rand.nextInt(li.size())));
    }

    private void drawTexturedHex(Tessellator v5, HexGrid.Hex h, double sizeX, double sizeY, float f) {
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/lorestruct.png");
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        HexCell c = this.cells.get(h);
        HexGrid.Point p = this.getHexLocation(h);
        double fx = (p.x - 7.5) / sizeX;
        double fy = (p.y - 7.5) / sizeY;
        GL11.glPushMatrix();
        GL11.glTranslated((double)p.x, (double)p.y, (double)0.0);
        v5.func_78371_b(6);
        double cu = 0.5 + fx;
        double cv = 0.5 + fy;
        double r = 7.5;
        double x = r + 0.1;
        double y = r - 1.0;
        double u = cu + x / sizeX;
        double v = cv + y / sizeY;
        v5.func_78374_a(x, y, 0.0, u, v);
        for (double a = 0.0; a <= 360.0; a += 60.0) {
            double ang = Math.toRadians(a);
            double dx = r + 0.1 + r * Math.cos(ang);
            double dy = r - 1.0 + r * Math.sin(ang);
            u = cu + dx / sizeX;
            v = cv + dy / sizeY;
            v5.func_78374_a(dx, dy, 0.0, u, v);
        }
        v5.func_78381_a();
        if (f < 3.0f) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            int clr = f >= 2.0f ? 0xFFFFFF : ReikaColorAPI.mixColors((int)0xFFFFFF, (int)0, (float)(f - 1.0f));
            int ap = f < 2.0f ? 255 : (int)(255.0f * (1.0f - (f - 2.0f)));
            v5.func_78371_b(6);
            v5.func_78384_a(clr, ap);
            r = 7.5;
            x = r + 0.1;
            y = r - 1.0;
            v5.func_78377_a(x, y, 0.0);
            for (double a = 0.0; a <= 360.0; a += 60.0) {
                double ang = Math.toRadians(a);
                double dx = r + 0.1 + r * Math.cos(ang);
                double dy = r - 1.0 + r * Math.sin(ang);
                v5.func_78377_a(dx, dy, 0.0);
            }
            v5.func_78381_a();
            GL11.glPopAttrib();
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public void render(Tessellator v5, EntityPlayer ep, ScaledResolution res) {
        boolean flag;
        GL11.glPushMatrix();
        double w2 = res.func_78327_c() / 2.0;
        double h2 = res.func_78324_d() / 2.0;
        GL11.glTranslated((double)w2, (double)h2, (double)0.0);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDisable((int)3008);
        boolean flag2 = flag = LoreManager.instance.hasPlayerCompletedBoard(ep);
        if (flag) {
            for (HexCell c : this.cells.values()) {
                if (!(c.getSolveFactor() < 1.0f)) continue;
                flag2 = false;
            }
            if (flag2) {
                GL11.glTranslated((double)(-w2), (double)(-h2), (double)0.0);
                LoreManager.instance.getOrCreateRosetta(ep).render(res, w2, h2);
            }
        }
        if (!flag2) {
            for (HexCell c : this.cells.values()) {
                float f;
                c.tickSolve();
                float f2 = f = flag ? c.getSolveFactor() : 0.0f;
                if (flag && f >= 1.0f) {
                    HexGrid.Hex h = c.location;
                    continue;
                }
                c.render(this, v5, true, 1.0f - Math.min(1.0f, f * 1.0625f));
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public HexGrid.Hex getOrigin() {
        return this.grid.getHex(0, 0, 0);
    }

    public boolean isComplete() {
        boolean flag;
        boolean bl = flag = this.activeCells == this.grid.cellCount();
        if (flag) {
            for (HexCell c : this.cells.values()) {
                c.solveTick = 1;
            }
        } else {
            for (HexCell c : this.cells.values()) {
                c.solveTick = 0;
            }
        }
        return flag;
    }

    private void setCellContents(HexGrid.Hex loc, HexTile h, EntityPlayer ep) {
        HexCell c = this.getCell(loc);
        c.occupant = h;
        if (h != null) {
            h.location = c;
            h.update(this, true, ep);
        } else {
            for (HexGrid.Hex n : loc.getNeighbors()) {
                HexCell c2 = this.getCell(n);
                if (c2 == null || c2.occupant == null) continue;
                c2.occupant.update(this, false, ep);
            }
        }
    }

    public HexCell getCell(HexGrid.Hex loc) {
        return this.cells.get(loc);
    }

    public HexGrid.Hex getHexAt(int x, int y) {
        return this.grid.getHexAtLocation(x, y);
    }

    public HexGrid.Point getHexLocation(HexGrid.Hex h) {
        return this.grid.getHexLocation(h);
    }

    public void flashUnknownHexes(EntityPlayer ep) {
        for (HexGrid.Hex h : this.cells.keySet()) {
            HexCell c = this.cells.get(h);
            if (c == null || c.playerKnows(ep)) continue;
            c.flash();
        }
    }

    private static class Move {
        private final HexGrid.Hex hex;
        private final int direction;

        private Move(HexGrid.Hex h, int dir) {
            this.hex = h;
            this.direction = dir;
        }

        private Move invert(HexGrid grid) {
            return new Move(this.hex.getNeighbor(this.direction), grid.getOppositeDirection(this.direction));
        }
    }

    public static class TileGroup {
        private final HashSet<HexGrid.Hex> hexes = new HashSet();

        private TileGroup() {
        }

        public String toString() {
            return this.hexes.toString();
        }

        public Collection<HexGrid.Hex> getHexes() {
            return Collections.unmodifiableCollection(this.hexes);
        }

        public HexGrid.Point getCenter(KeyAssemblyPuzzle pz) {
            HexGrid.Point p = new HexGrid.Point(0.0, 0.0);
            for (HexGrid.Hex h : this.hexes) {
                HexGrid.Point p2 = pz.getHexLocation(h);
                p = p.translate(p2.x, p2.y);
            }
            p = p.scale(1.0 / (double)this.hexes.size());
            return p;
        }

        public static TileGroup random(KeyAssemblyPuzzle p) {
            Random rand = new Random();
            TileGroup g = new TileGroup();
            HexGrid.Hex h = p.getOrigin();
            g.hexes.add(h);
            for (int i = 0; i < 3; ++i) {
                h = h.getNeighbor(rand.nextInt(6));
                g.hexes.add(h);
            }
            return g;
        }
    }

    private static class HexTile {
        private final CrystalElement color;
        private HexCell location;
        private boolean state;

        private HexTile(CrystalElement e) {
            this.color = e;
        }

        private boolean isValid(KeyAssemblyPuzzle p) {
            if (!ElementMixer.instance.hasMixes(this.color)) {
                return true;
            }
            for (HexGrid.Hex h : this.location.location.getNeighbors()) {
                HexCell c = p.getCell(h);
                if (c == null || c.occupant == null || !this.isRelatedTo(c.occupant)) continue;
                return true;
            }
            return false;
        }

        private boolean isRelatedTo(HexTile h) {
            return ElementMixer.instance.related(this.color, h.color);
        }

        @SideOnly(value=Side.CLIENT)
        public void render(KeyAssemblyPuzzle p, Tessellator v5, boolean inBoard, float f) {
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            HexGrid.Point loc = p.grid.getHexLocation(this.location.location);
            if (!inBoard || this.location.playerKnows((EntityPlayer)ep)) {
                ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)KeyAssemblyPuzzle.hexPNG);
                double u = (double)(2 + 64 * (this.color.ordinal() % 8)) / 512.0;
                double v = (double)(6 + this.color.ordinal() / 8 * 64 * 2 + (!inBoard || this.state ? 64 : 0)) / 256.0;
                double du = (u * 512.0 + 60.0) / 512.0;
                double dv = (v * 256.0 + 53.0) / 256.0;
                v5.func_78382_b();
                v5.func_78384_a(ReikaColorAPI.mixColors((int)0xFFFFFF, (int)0, (float)f), 255);
                v5.func_78374_a(0.0, 15.0 * SIN60, 0.0, u, dv);
                v5.func_78374_a(15.0, 15.0 * SIN60, 0.0, du, dv);
                v5.func_78374_a(15.0, 0.0, 0.0, du, v);
                v5.func_78374_a(0.0, 0.0, 0.0, u, v);
                v5.func_78381_a();
            } else {
                ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)KeyAssemblyPuzzle.voidPNG);
                double u = 0.015625;
                double v = 0.09375;
                double du = 0.484375;
                double dv = 0.921875;
                v5.func_78382_b();
                v5.func_78374_a(0.0, 15.0 * SIN60, 0.0, u, dv);
                v5.func_78374_a(15.0, 15.0 * SIN60, 0.0, du, dv);
                v5.func_78374_a(15.0, 0.0, 0.0, du, v);
                v5.func_78374_a(0.0, 0.0, 0.0, u, v);
                v5.func_78381_a();
            }
        }

        public boolean move(KeyAssemblyPuzzle p, int direction, EntityPlayer ep) {
            if (!p.grid.getValidMovementDirections(this.location.location).contains(direction)) {
                if (ep != null) {
                    this.location.flash();
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ERROR, (Entity)Minecraft.func_71410_x().field_71439_g, (float)1.0f, (float)2.0f);
                }
                return false;
            }
            HexCell target = this.location.getNeighbor(p, direction);
            if (target == null) {
                throw new RuntimeException(this.location.location.getNeighbor(direction).toString() + " has null cell yet was moved to?!");
            }
            if (target.occupant != null) {
                if (ep != null) {
                    target.flash();
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ERROR, (Entity)Minecraft.func_71410_x().field_71439_g, (float)1.0f, (float)2.0f);
                }
                return false;
            }
            p.setCellContents(this.location.location, null, ep);
            p.emptyHexes.add(this.location.location);
            this.location = this.location.getNeighbor(p, direction);
            p.emptyHexes.remove(this.location.location);
            p.setCellContents(this.location.location, this, ep);
            this.update(p, true, ep);
            return true;
        }

        private void update(KeyAssemblyPuzzle p, boolean adj, EntityPlayer ep) {
            boolean flag = this.isValid(p);
            if (flag != this.state) {
                if (flag) {
                    p.activeCells++;
                    if (ep != null) {
                        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.CAST, (Entity)Minecraft.func_71410_x().field_71439_g, (float)0.75f, (float)2.0f);
                        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.CAST, (Entity)Minecraft.func_71410_x().field_71439_g, (float)0.75f, (float)1.5f);
                    }
                } else {
                    p.activeCells--;
                    if (ep != null) {
                        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.RIFT, (Entity)Minecraft.func_71410_x().field_71439_g, (float)1.0f, (float)0.875f);
                        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.RIFT, (Entity)Minecraft.func_71410_x().field_71439_g, (float)1.0f, (float)0.5f);
                    }
                }
                this.state = flag;
            }
            if (adj) {
                for (HexGrid.Hex h : this.location.location.getNeighbors()) {
                    HexCell c = p.getCell(h);
                    if (c == null || c.occupant == null) continue;
                    c.occupant.update(p, false, ep);
                }
            }
        }

        public String toString() {
            return this.color.name();
        }
    }

    public static class HexCell {
        private final HexGrid.Hex location;
        private HexTile occupant = null;
        private Towers tower = null;
        public boolean isHovered;
        private int flashTick = 0;
        private int solveTick = 0;
        private final int solveOffset;

        private HexCell(HexGrid.Hex h) {
            this.location = h;
            this.solveOffset = -(h.q + h.s) * 2 - 20;
        }

        public void onClick(KeyAssemblyPuzzle p, double dx, double dy, EntityPlayer ep) {
            double r;
            if (this.occupant != null && (r = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)0.0)) >= 3.0) {
                double a = -Math.toDegrees(Math.atan2(dy, dx));
                int dir = p.grid.getNeighborDirection(a);
                this.occupant.move(p, dir, ep);
            }
        }

        public HexTile getOccupant() {
            return this.occupant;
        }

        public void render(KeyAssemblyPuzzle p, Tessellator v5, boolean inBoard, float f) {
            GL11.glPushMatrix();
            if (inBoard) {
                HexGrid.Point loc = p.grid.getHexLocation(this.location);
                GL11.glTranslated((double)loc.x, (double)loc.y, (double)0.0);
            }
            if (this.occupant != null) {
                this.occupant.render(p, v5, inBoard, f);
            } else {
                ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)KeyAssemblyPuzzle.voidPNG);
                double u = 0.515625;
                double v = 0.09375;
                double du = 0.984375;
                double dv = 0.921875;
                v5.func_78382_b();
                v5.func_78374_a(0.0, 15.0 * SIN60, 0.0, u, dv);
                v5.func_78374_a(15.0, 15.0 * SIN60, 0.0, du, dv);
                v5.func_78374_a(15.0, 0.0, 0.0, du, v);
                v5.func_78374_a(0.0, 0.0, 0.0, u, v);
                v5.func_78381_a();
            }
            if (inBoard && (this.isHovered || this.flashTick > 0)) {
                GL11.glDisable((int)2929);
                if (this.flashTick > 0) {
                    int a = (int)((double)(255 * this.flashTick) / 20.0);
                    int a2 = a / 2 - 32;
                    p.grid.drawHexEdges(v5, this.location, 0xFF0000 | a << 24);
                    if (a2 > 0) {
                        p.grid.drawFilledHex(v5, this.location, 0xFF0000 | a2 << 24);
                    }
                } else if (this.isHovered) {
                    p.grid.drawHexEdges(v5, this.location, -1);
                    GL11.glEnable((int)2929);
                    for (int i = 0; i < 6; ++i) {
                        if (!Keyboard.isKeyDown((int)(i == 0 ? 11 : 2 + i - 1)) || this.getNeighbor(p, i) == null) continue;
                        this.getNeighbor((KeyAssemblyPuzzle)p, (int)i).isHovered = true;
                    }
                }
            }
            this.isHovered = false;
            if (this.flashTick > 0) {
                --this.flashTick;
            }
            GL11.glPopMatrix();
        }

        public HexCell getNeighbor(KeyAssemblyPuzzle p, int direction) {
            return p.getCell(this.location.getNeighbor(direction));
        }

        public void flash() {
            this.flashTick = 20;
        }

        public float getSolveFactor() {
            if (this.solveTick == 0 || this.solveTick() <= 0) {
                return 0.0f;
            }
            int tick = this.solveTick();
            return (float)tick / 20.0f;
        }

        public void tickSolve() {
            if (this.solveTick > 0 && this.solveTick < 20 - this.solveOffset) {
                ++this.solveTick;
            }
        }

        private int solveTick() {
            return this.solveTick + this.solveOffset;
        }

        public String toString() {
            return this.location.toString() + " : " + this.occupant;
        }

        public boolean playerKnows(EntityPlayer ep) {
            if (this.occupant == null) {
                return true;
            }
            return this.tower == null || LoreManager.instance.hasPlayerScanned(ep, this.tower);
        }
    }
}

