/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.API.CrystalElementProxy;
import Reika.ChromatiCraft.API.ItemElementAPI;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PoolRecipes;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Block.Worldgen.BlockCliffStone;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ItemMagicRegistry;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;

public class ItemElementCalculator {
    public static final ItemElementCalculator instance = new ItemElementCalculator();
    private static final int MAX_DEPTH = 40;
    private final ItemHashMap<ElementTagCompound> cache = new ItemHashMap();
    private final Collection<ItemElementAPI.ItemInOutHandler> handlers = new ArrayList<ItemElementAPI.ItemInOutHandler>();
    private final ElementTagCompound empty = new ElementTagCompound();
    private List<KeyedItemStack> currentCalculation = new ArrayList<KeyedItemStack>();
    private static Field toolRecipeHeads;
    private static Field toolRecipeHandles;
    private static Field toolRecipeAccessories;
    private static Field toolRecipeExtras;
    private static Method getTransposerFilling;
    private static Method getTransposerDraining;
    private static Method getSmelter;
    private static Method getSawmill;
    private static Method getPulverizer;
    private static Field transposerIn;
    private static Field transposerOut;
    private static Field smelterIn1;
    private static Field smelterIn2;
    private static Field smelterOut1;
    private static Field smelterOut2;
    private static Field sawmillIn;
    private static Field sawmillOut1;
    private static Field sawmillOut2;
    private static Field pulverizerIn;
    private static Field pulverizerOut1;
    private static Field pulverizerOut2;

    private ItemElementCalculator() {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            ElementTagCompound tag1 = new ElementTagCompound();
            ElementTagCompound tag2 = new ElementTagCompound();
            ElementTagCompound tag4 = new ElementTagCompound();
            tag1.addValueToColor(e, 1);
            tag2.addValueToColor(e, 2);
            tag4.addValueToColor(e, 4);
            this.cache.put(ChromaItems.ELEMENTAL.getStackOf(e), (Object)tag4);
            this.cache.put(ChromaBlocks.RUNE.getStackOfMetadata(i), (Object)tag4);
            this.cache.put(ChromaBlocks.DYELEAF.getStackOfMetadata(i), (Object)tag1);
            this.cache.put(ChromaBlocks.DECAY.getStackOfMetadata(i), (Object)tag1);
            this.cache.put(ChromaBlocks.GLOW.getStackOfMetadata(i), (Object)tag2);
            this.cache.put(ChromaItems.DYE.getStackOfMetadata(i), (Object)tag1);
            this.cache.put(ChromaItems.SEED.getStackOfMetadata(i), (Object)tag1);
            this.cache.put(new ItemStack(Items.field_151100_aR, 1, i), (Object)tag1);
            this.cache.put(ChromaItems.DYE.getStackOfMetadata(i), (Object)tag1);
            ElementTagCompound tagc = tag1.copy();
            tagc.addValueToColor(CrystalElement.GREEN, 1);
            this.cache.put(new ItemStack(Blocks.field_150325_L, 1, 16 - i), (Object)tagc);
            Block rockwool = GameRegistry.findBlock((String)ModList.THERMALEXPANSION.modLabel, (String)"Rockwool");
            if (rockwool == null) continue;
            this.cache.put(new ItemStack(rockwool, 1, 16 - i), (Object)tagc);
        }
        this.cache.put(ChromaStacks.chromaDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.auraDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.beaconDust, (Object)new ElementTagCompound(1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.bindingCrystal, (Object)new ElementTagCompound(1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.focusDust, (Object)new ElementTagCompound(1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.enderDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.waterDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.resocrystal, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.resonanceDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.purityDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.firaxite, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0));
        this.cache.put(ChromaStacks.spaceDust, (Object)new ElementTagCompound(2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.elementDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.lumenGem, (Object)new ElementTagCompound(1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.lumaDust, (Object)new ElementTagCompound(1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.echoCrystal, (Object)new ElementTagCompound(2, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.glowbeans, (Object)new ElementTagCompound(1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.boostroot, (Object)new ElementTagCompound(2, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.avolite, (Object)new ElementTagCompound(0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.fireEssence, (Object)new ElementTagCompound(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0));
        this.cache.put(ChromaStacks.thermiticCrystal, (Object)new ElementTagCompound(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0));
        this.cache.put(ChromaStacks.voidDust, (Object)new ElementTagCompound(2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.energyPowder, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.icyDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.teleDust, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.livingEssence, (Object)new ElementTagCompound(1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.etherBerries, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.complexIngot, (Object)ElementTagCompound.getUniformTag(1));
        this.cache.put(ChromaStacks.iridCrystal, (Object)new ElementTagCompound(2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.miasma, (Object)new ElementTagCompound(1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.floatstone, (Object)new ElementTagCompound(1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.aqua, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.lifegel, (Object)new ElementTagCompound(1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0));
        this.cache.put(ChromaStacks.orthocrystal, (Object)new ElementTagCompound(1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.gem, (Object)new ElementTagCompound(1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.crysleaf, (Object)new ElementTagCompound(1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaStacks.oceanrock, (Object)new ElementTagCompound(1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.cliffshard, (Object)new ElementTagCompound(1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.STONE.ordinal()), (Object)new ElementTagCompound(2, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.COBBLE.ordinal()), (Object)new ElementTagCompound(2, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CRACK.ordinal()), (Object)new ElementTagCompound(2, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CRACKS.ordinal()), (Object)new ElementTagCompound(2, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.GLASS.ordinal()), (Object)new ElementTagCompound(2, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1));
        this.cache.put(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.LIGHT.ordinal()), (Object)new ElementTagCompound(2, 4, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.MOSS.ordinal()), (Object)new ElementTagCompound(2, 4, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CLOAK.ordinal()), (Object)new ElementTagCompound(2, 4, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(ChromaStacks.rawCrystal, (Object)new ElementTagCompound(10, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 20));
        this.cache.put(ChromaBlocks.RAINBOWSAPLING.getBlockInstance(), (Object)new ElementTagCompound(1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1));
        this.cache.put(ChromaBlocks.CLIFFSTONE.getStackOfMetadata(BlockCliffStone.Variants.STONE.getMeta(false, false)), (Object)new ElementTagCompound(1, 2, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
        this.cache.put(Items.field_151133_ar, (Object)ItemMagicRegistry.instance.getItemValue(new ItemStack(Items.field_151042_j)).scale(3.0f));
        this.cache.put((Item)Items.field_151097_aZ, (Object)ItemMagicRegistry.instance.getItemValue(new ItemStack(Items.field_151042_j)).scale(2.0f));
        ElementTagCompound rtag = ItemMagicRegistry.instance.getItemValue(new ItemStack(Items.field_151042_j)).scale(0.375f);
        rtag.addTag(CrystalElement.GREEN, 1);
        this.cache.put(Blocks.field_150448_aq, (Object)rtag);
        for (int i = 0; i < 16; ++i) {
            ItemStack is = new ItemStack(Blocks.field_150406_ce, 1, i);
            ElementTagCompound tag = new ElementTagCompound();
            tag.addValueToColor(CrystalElement.elements[i], 1);
            tag.addValueToColor(CrystalElement.BROWN, 2);
            tag.addValueToColor(CrystalElement.ORANGE, 1);
            this.cache.put(is, (Object)tag);
        }
    }

    public ElementTagCompound getValueForItem(ItemStack is) {
        return this.getValueForItem(is, 0);
    }

    private ElementTagCompound getValueForItem(ItemStack is, int step) {
        Fluid f;
        ElementTagCompound ftag;
        FluidStack fs;
        if (is == null) {
            return this.empty.copy();
        }
        if (!this.currentCalculation.isEmpty() && this.currentCalculation.contains(new KeyedItemStack(is).setIgnoreNBT(true).setSimpleHash(true))) {
            ChromatiCraft.logger.debug((Object)"Recipe contains its own output, possibly recursively.");
            return this.empty.copy();
        }
        ElementTagCompound tag = (ElementTagCompound)this.cache.get(is);
        if (tag == null) {
            if (step > 40) {
                return this.empty.copy();
            }
            tag = this.calculateTag(is, step);
            this.cache.put(is, (Object)tag);
        }
        tag = tag.copy();
        if (is.func_77948_v()) {
            tag.addValueToColor(CrystalElement.BLACK, 5);
            tag.addValueToColor(CrystalElement.PURPLE, 2);
        }
        if (is.func_77973_b() instanceof ItemSword) {
            float dmg = ((ItemSword)is.func_77973_b()).func_150931_i();
            tag.addValueToColor(CrystalElement.PINK, (int)(1.0f + dmg));
        }
        if (is.func_77973_b() instanceof ItemSpade || is.func_77973_b() instanceof ItemPickaxe) {
            tag.addValueToColor(CrystalElement.BROWN, 1 + ((ItemTool)is.func_77973_b()).func_150913_i().func_77996_d());
        }
        if (is.func_77973_b() instanceof ItemAxe || is.func_77973_b() instanceof ItemHoe || is.func_77973_b() instanceof ItemShears) {
            tag.addValueToColor(CrystalElement.GREEN, 2);
        }
        if (is.func_77973_b() instanceof ItemArmor) {
            tag.addValueToColor(CrystalElement.RED, Math.round((float)((ItemArmor)is.func_77973_b()).func_82812_d().func_78044_b(1) / 2.0f));
        }
        if (is.func_77973_b() instanceof ItemFood) {
            tag.addValueToColor(CrystalElement.MAGENTA, Math.round((float)((ItemFood)is.func_77973_b()).func_150905_g(is) / 2.0f));
        }
        if ((fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is)) != null && (ftag = ItemMagicRegistry.instance.getFluidValue(f = fs.getFluid())) != null) {
            tag.add(ftag);
        }
        return tag;
    }

    private ElementTagCompound getFromVanillaCrafting(ItemStack is, int step) {
        ArrayList li = ReikaRecipeHelper.getAllRecipesByOutput((List)CraftingManager.func_77594_a().func_77592_b(), (ItemStack)is);
        ElementTagCompound tag = new ElementTagCompound();
        for (IRecipe ir : li) {
            tag.addButMinimizeWith(this.getIRecipeTotal(ir, step + 1));
            if (!tag.containsAllColors() || tag.getMaximumValue() != 1) continue;
            return tag;
        }
        return tag;
    }

    private ElementTagCompound getFromVanillaSmelting(ItemStack is, int step) {
        ElementTagCompound tag = new ElementTagCompound();
        for (Object o : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
            ItemStack in = (ItemStack)o;
            ItemStack out = FurnaceRecipes.func_77602_a().func_151395_a(in);
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)out)) continue;
            ElementTagCompound tag2 = this.getValueForItem(in, step + 1);
            tag2.addValueToColor(CrystalElement.ORANGE, 1);
            tag.addButMinimizeWith(tag2);
            if (!tag.containsAllColors() || tag.getMaximumValue() != 1) continue;
            return tag;
        }
        return tag;
    }

    private ElementTagCompound getFromChromaCasting(ItemStack is, int step) {
        ElementTagCompound tag = new ElementTagCompound();
        ArrayList<CastingRecipe> li = RecipesCastingTable.instance.getAllRecipesMaking(is);
        for (CastingRecipe c : li) {
            ElementTagCompound tag2 = c.getInputElements();
            tag2.addValueToColor(CrystalElement.BLACK, 2);
            tag.addButMinimizeWith(tag2);
        }
        return tag;
    }

    private ElementTagCompound getFromChromaAlloying(ItemStack is, int step) {
        ElementTagCompound tag = new ElementTagCompound();
        PoolRecipes.PoolRecipe c = PoolRecipes.instance.getPoolRecipeByOutput(is);
        if (c == null) {
            return tag;
        }
        ElementTagCompound tag2 = c.getInputElements();
        tag2.addValueToColor(CrystalElement.BLACK, 2);
        tag.addButMinimizeWith(tag2);
        return tag;
    }

    @DependentMethodStripper.ModDependent(value=ModList.ROTARYCRAFT)
    private ElementTagCompound getFromRCWorktable(ItemStack is, int step) {
        ElementTagCompound tag = new ElementTagCompound();
        List li = WorktableRecipes.getInstance().getRecipeListCopy();
        for (WorktableRecipes.WorktableRecipe wr : li) {
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)wr.getOutput())) continue;
            tag.addButMinimizeWith(wr.getElements());
        }
        return tag;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THERMALEXPANSION)
    private ElementTagCompound getFromTE3(ItemStack is, int step) {
        ElementTagCompound tag = new ElementTagCompound();
        try {
            Object r;
            int i;
            Object[] pulv = (Object[])getPulverizer.invoke(null, new Object[0]);
            Object[] sawm = (Object[])getSawmill.invoke(null, new Object[0]);
            Object[] smelt = (Object[])getSmelter.invoke(null, new Object[0]);
            Object[] transp1 = (Object[])getTransposerFilling.invoke(null, new Object[0]);
            Object[] transp2 = (Object[])getTransposerDraining.invoke(null, new Object[0]);
            for (i = 0; i < pulv.length; ++i) {
                r = pulv[i];
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)pulverizerOut1.get(r))) && !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)pulverizerOut2.get(r)))) continue;
                tag.addButMinimizeWith(this.getValueForItem((ItemStack)pulverizerIn.get(r), step + 1));
            }
            for (i = 0; i < sawm.length; ++i) {
                r = sawm[i];
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)sawmillOut1.get(r))) && !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)sawmillOut2.get(r)))) continue;
                tag.addButMinimizeWith(this.getValueForItem((ItemStack)sawmillIn.get(r), step + 1));
            }
            for (i = 0; i < smelt.length; ++i) {
                r = smelt[i];
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)smelterOut1.get(r))) && !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)smelterOut2.get(r)))) continue;
                tag.addButMinimizeWith(this.getValueForItem((ItemStack)smelterIn1.get(r), step + 1));
                tag.addButMinimizeWith(this.getValueForItem((ItemStack)smelterIn2.get(r), step + 1));
            }
            for (i = 0; i < transp1.length; ++i) {
                r = transp1[i];
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)transposerOut.get(r)))) continue;
                tag.addButMinimizeWith(this.getValueForItem((ItemStack)transposerIn.get(r), step + 1));
            }
            for (i = 0; i < transp2.length; ++i) {
                r = transp2[i];
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)transposerOut.get(r)))) continue;
                tag.addButMinimizeWith(this.getValueForItem((ItemStack)transposerIn.get(r), step + 1));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return tag;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    private ElementTagCompound getFromThaumCraft(ItemStack is, int step) {
        ElementTagCompound tag = new ElementTagCompound();
        try {
            List li = ThaumcraftApi.getCraftingRecipes();
            for (Object o : li) {
                InfusionRecipe ir;
                ElementTagCompound asp;
                Object o2;
                Object in;
                ShapedArcaneRecipe sr;
                if (o instanceof ShapedArcaneRecipe) {
                    sr = (ShapedArcaneRecipe)o;
                    if (!ReikaItemHelper.matchStacks((ItemStack)sr.getRecipeOutput(), (ItemStack)is)) continue;
                    in = sr.getInput();
                    for (int i = 0; i < ((Object[])in).length; ++i) {
                        o2 = in[i];
                        tag.addButMinimizeWith(this.getTagForItemOrList(o2, step + 1));
                    }
                    tag.addValueToColor(CrystalElement.BLACK, 1);
                    for (Aspect a : sr.aspects.aspects.keySet()) {
                        asp = ChromaAspectManager.instance.getElementCost(a, 0.0f);
                        asp.setAllValuesTo(1);
                        tag.addTag(asp);
                    }
                    continue;
                }
                if (o instanceof ShapelessArcaneRecipe) {
                    sr = (ShapelessArcaneRecipe)o;
                    if (!ReikaItemHelper.matchStacks((ItemStack)sr.getRecipeOutput(), (ItemStack)is)) continue;
                    in = sr.getInput();
                    Iterator<Object> i$ = ((ArrayList)in).iterator();
                    while (i$.hasNext()) {
                        o2 = i$.next();
                        tag.addButMinimizeWith(this.getTagForItemOrList(o2, step + 1));
                    }
                    tag.addValueToColor(CrystalElement.BLACK, 1);
                    for (Aspect a : sr.aspects.aspects.keySet()) {
                        asp = ChromaAspectManager.instance.getElementCost(a, 0.0f);
                        asp.setAllValuesTo(1);
                        tag.addTag(asp);
                    }
                    continue;
                }
                if (o instanceof CrucibleRecipe) {
                    CrucibleRecipe cr = (CrucibleRecipe)o;
                    if (!ReikaItemHelper.matchStacks((ItemStack)cr.getRecipeOutput(), (ItemStack)is)) continue;
                    tag.addButMinimizeWith(this.getTagForItemOrList(cr.catalyst, step + 1));
                    tag.addValueToColor(CrystalElement.BLACK, 1);
                    for (Aspect a : cr.aspects.aspects.keySet()) {
                        ElementTagCompound asp2 = ChromaAspectManager.instance.getElementCost(a, 0.0f);
                        asp2.setAllValuesTo(1);
                        tag.addTag(asp2);
                    }
                    continue;
                }
                if (!(o instanceof InfusionRecipe) || !((ir = (InfusionRecipe)o).getRecipeOutput() instanceof ItemStack) || !ReikaItemHelper.matchStacks((ItemStack)((ItemStack)ir.getRecipeOutput()), (ItemStack)is)) continue;
                tag.addButMinimizeWith(this.getValueForItem(ir.getRecipeInput(), step + 1));
                ItemStack[] parts = ir.getComponents();
                for (int i = 0; i < parts.length; ++i) {
                    ItemStack in2 = parts[i];
                    tag.addButMinimizeWith(this.getValueForItem(in2, step + 1));
                }
                tag.addValueToColor(CrystalElement.BLACK, 2);
                for (Aspect a : ir.getAspects().aspects.keySet()) {
                    asp = ChromaAspectManager.instance.getElementCost(a, 0.0f);
                    asp.setAllValuesTo(1);
                    tag.addTag(asp);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return tag;
    }

    private ElementTagCompound calculateTag(ItemStack is, int step) {
        ElementTagCompound tag = ItemMagicRegistry.instance.getItemValue(is);
        if (tag != null) {
            return tag;
        }
        tag = new ElementTagCompound();
        this.currentCalculation.add(new KeyedItemStack(is).setIgnoreNBT(true).setSimpleHash(true));
        tag.addButMinimizeWith(this.getFromVanillaCrafting(is, step));
        tag.addButMinimizeWith(this.getFromVanillaSmelting(is, step));
        tag.addButMinimizeWith(this.getFromChromaCasting(is, step));
        tag.addButMinimizeWith(this.getFromChromaAlloying(is, step));
        if (ModList.ROTARYCRAFT.isLoaded()) {
            tag.addButMinimizeWith(this.getFromRCWorktable(is, step));
        }
        if (ModList.THERMALEXPANSION.isLoaded()) {
            tag.addButMinimizeWith(this.getFromTE3(is, step));
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            tag.addButMinimizeWith(this.getFromThaumCraft(is, step));
        }
        if (ModList.BCSILICON.isLoaded()) {
            // empty if block
        }
        if (ModList.TINKERER.isLoaded()) {
            // empty if block
        }
        if (ModList.APPENG.isLoaded()) {
            // empty if block
        }
        for (ItemElementAPI.ItemInOutHandler h : this.handlers) {
            Collection<ItemStack> c = h.getInputItemsFor(is);
            if (c == null || c.isEmpty()) continue;
            for (ItemStack in : c) {
                tag.addButMinimizeWith(this.getValueForItem(in, step));
            }
            Collection<CrystalElementProxy> c2 = h.getBonusElements();
            if (c2 == null || c2.isEmpty()) continue;
            for (CrystalElementProxy e : c2) {
                tag.addValueToColor(CrystalElement.getFromAPI(e), 1);
            }
        }
        ChromatiCraft.logger.debug((Object)("Calculated for " + is + " (" + is.func_82833_r() + "): " + tag));
        this.currentCalculation.remove(new KeyedItemStack(is).setIgnoreNBT(true).setSimpleHash(true));
        return tag;
    }

    public ElementTagCompound getIRecipeTotal(IRecipe ir) {
        return this.getIRecipeTotal(ir, 0);
    }

    private ElementTagCompound getIRecipeTotal(IRecipe ir, int step) {
        ElementTagCompound tag;
        block5: {
            block7: {
                block6: {
                    block4: {
                        tag = new ElementTagCompound();
                        if (!(ir instanceof ShapedRecipes)) break block4;
                        ShapedRecipes sr = (ShapedRecipes)ir;
                        for (int k = 0; k < sr.field_77574_d.length; ++k) {
                            ItemStack in = sr.field_77574_d[k];
                            ElementTagCompound value = this.getValueForItem(in, step + 1);
                            tag.addButMinimizeWith(value);
                        }
                        break block5;
                    }
                    if (!(ir instanceof ShapelessRecipes)) break block6;
                    ShapelessRecipes sr = (ShapelessRecipes)ir;
                    for (int k = 0; k < sr.field_77579_b.size(); ++k) {
                        ItemStack in = (ItemStack)sr.field_77579_b.get(k);
                        ElementTagCompound value = this.getValueForItem(in, step + 1);
                        tag.addButMinimizeWith(value);
                    }
                    break block5;
                }
                if (!(ir instanceof ShapedOreRecipe)) break block7;
                ShapedOreRecipe sr = (ShapedOreRecipe)ir;
                for (int k = 0; k < sr.getInput().length; ++k) {
                    Object in = sr.getInput()[k];
                    ElementTagCompound value = this.getTagForItemOrList(in, step);
                    tag.addButMinimizeWith(value);
                }
                break block5;
            }
            if (!(ir instanceof ShapelessOreRecipe)) break block5;
            ShapelessOreRecipe sr = (ShapelessOreRecipe)ir;
            for (int k = 0; k < sr.getInput().size(); ++k) {
                Object in = sr.getInput().get(k);
                ElementTagCompound value = this.getTagForItemOrList(in, step);
                tag.addButMinimizeWith(value);
            }
        }
        return tag;
    }

    private ElementTagCompound getTagForItemOrList(Object in, int step) {
        if (in instanceof ItemStack) {
            return this.getValueForItem((ItemStack)in, step + 1);
        }
        if (in instanceof Block) {
            return this.getValueForItem(new ItemStack((Block)in), step + 1);
        }
        if (in instanceof Item) {
            return this.getValueForItem(new ItemStack((Item)in), step + 1);
        }
        if (in instanceof ArrayList) {
            ArrayList li = (ArrayList)in;
            ElementTagCompound tag = new ElementTagCompound();
            for (int i = 0; i < li.size(); ++i) {
                ItemStack is = (ItemStack)li.get(i);
                ElementTagCompound value = this.getValueForItem(is, step + 1);
                tag.addButMinimizeWith(value);
            }
            return tag;
        }
        return null;
    }

    private static Field loadField(String c, String s) {
        try {
            return ItemElementCalculator.loadField(Class.forName(c), s);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Field loadField(Class c, String s) {
        try {
            Field f = c.getDeclaredField(s);
            f.setAccessible(true);
            return f;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Method loadMethod(String c, String s, Class ... args) {
        try {
            return ItemElementCalculator.loadMethod(Class.forName(c), s, args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Method loadMethod(Class c, String s, Class ... args) {
        try {
            Method f = c.getDeclaredMethod(s, args);
            f.setAccessible(true);
            return f;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        if (ModList.TINKERER.isLoaded()) {
            toolRecipeHeads = ItemElementCalculator.loadField("tconstruct.library.crafting.ToolRecipe", "headList");
            toolRecipeHandles = ItemElementCalculator.loadField("tconstruct.library.crafting.ToolRecipe", "handleList");
            toolRecipeAccessories = ItemElementCalculator.loadField("tconstruct.library.crafting.ToolRecipe", "accessoryList");
            toolRecipeExtras = ItemElementCalculator.loadField("tconstruct.library.crafting.ToolRecipe", "extraList");
        }
        if (ModList.THERMALEXPANSION.isLoaded()) {
            getTransposerFilling = ItemElementCalculator.loadMethod("cofh.thermalexpansion.util.crafting.TransposerManager", "getFillRecipeList", new Class[0]);
            getTransposerDraining = ItemElementCalculator.loadMethod("cofh.thermalexpansion.util.crafting.TransposerManager", "getExtractionRecipeList", new Class[0]);
            getSmelter = ItemElementCalculator.loadMethod("cofh.thermalexpansion.util.crafting.SmelterManager", "getRecipeList", new Class[0]);
            getSawmill = ItemElementCalculator.loadMethod("cofh.thermalexpansion.util.crafting.SawmillManager", "getRecipeList", new Class[0]);
            getPulverizer = ItemElementCalculator.loadMethod("cofh.thermalexpansion.util.crafting.PulverizerManager", "getRecipeList", new Class[0]);
            transposerIn = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.TransposerManager$RecipeTransposer", "input");
            transposerOut = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.TransposerManager$RecipeTransposer", "output");
            smelterIn1 = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.SmelterManager$RecipeSmelter", "primaryInput");
            smelterIn2 = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.SmelterManager$RecipeSmelter", "secondaryInput");
            smelterOut1 = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.SmelterManager$RecipeSmelter", "primaryOutput");
            smelterOut2 = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.SmelterManager$RecipeSmelter", "secondaryOutput");
            sawmillIn = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.SawmillManager$RecipeSawmill", "input");
            sawmillOut1 = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.SawmillManager$RecipeSawmill", "primaryOutput");
            sawmillOut2 = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.SawmillManager$RecipeSawmill", "secondaryOutput");
            pulverizerIn = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.PulverizerManager$RecipePulverizer", "input");
            pulverizerOut1 = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.PulverizerManager$RecipePulverizer", "primaryOutput");
            pulverizerOut2 = ItemElementCalculator.loadField("cofh.thermalexpansion.util.crafting.PulverizerManager$RecipePulverizer", "secondaryOutput");
        }
    }
}

