/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.Magic.ElementTag;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Proportionality;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class ElementTagCompound {
    private final EnumMap<CrystalElement, Integer> data = new EnumMap(CrystalElement.class);

    public ElementTagCompound() {
    }

    public ElementTagCompound(CrystalElement e, int value) {
        this();
        this.addTag(e, value);
    }

    public ElementTagCompound(int bk, int r, int g, int br, int b, int p, int c, int lg, int gy, int pk, int l, int y, int lb, int m, int o, int w) {
        this();
        this.addTag(CrystalElement.BLACK, bk);
        this.addTag(CrystalElement.RED, r);
        this.addTag(CrystalElement.GREEN, g);
        this.addTag(CrystalElement.BROWN, br);
        this.addTag(CrystalElement.BLUE, b);
        this.addTag(CrystalElement.PURPLE, p);
        this.addTag(CrystalElement.CYAN, c);
        this.addTag(CrystalElement.LIGHTGRAY, lg);
        this.addTag(CrystalElement.GRAY, gy);
        this.addTag(CrystalElement.PINK, pk);
        this.addTag(CrystalElement.LIME, l);
        this.addTag(CrystalElement.YELLOW, y);
        this.addTag(CrystalElement.LIGHTBLUE, lb);
        this.addTag(CrystalElement.MAGENTA, m);
        this.addTag(CrystalElement.ORANGE, o);
        this.addTag(CrystalElement.WHITE, w);
    }

    public boolean addTag(CrystalElement e, int value) {
        if (value <= 0) {
            return false;
        }
        if (this.data.containsKey((Object)e)) {
            return false;
        }
        this.data.put(e, value);
        return true;
    }

    public void setTag(CrystalElement e, int value) {
        if (value >= 0) {
            this.data.put(e, value);
        }
    }

    public int removeTag(CrystalElement e) {
        return this.data.remove((Object)e);
    }

    public int getValue(CrystalElement e) {
        return this.contains(e) ? this.data.get((Object)e) : 0;
    }

    public boolean contains(CrystalElement e) {
        return this.data.containsKey((Object)e);
    }

    public void addValueToColor(CrystalElement e, int value) {
        if (value <= 0) {
            return;
        }
        int has = this.getValue(e);
        int sum = has + value;
        this.setTag(e, sum);
    }

    public String toString() {
        return this.data.toString();
    }

    public Collection<CrystalElement> elementSet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public Proportionality<CrystalElement> getProportionality() {
        Proportionality p = new Proportionality();
        for (CrystalElement e : this.data.keySet()) {
            p.addValue((Object)e, (double)this.data.get((Object)e).intValue());
        }
        return p;
    }

    public void addTag(ElementTagCompound tag) {
        if (tag == null || tag.data.isEmpty()) {
            return;
        }
        for (CrystalElement e : tag.data.keySet()) {
            int amt = tag.getValue(e);
            int value = this.getValue(e);
            this.setTag(e, amt + value);
        }
    }

    public void maximizeWith(ElementTagCompound tag) {
        if (tag == null || tag.data.isEmpty()) {
            return;
        }
        for (CrystalElement e : tag.data.keySet()) {
            int amt = tag.getValue(e);
            int value = this.getValue(e);
            this.setTag(e, Math.max(amt, value));
        }
    }

    public void minimizeWith(ElementTagCompound tag) {
        if (tag == null || tag.data.isEmpty()) {
            return;
        }
        for (CrystalElement e : tag.data.keySet()) {
            int amt = tag.getValue(e);
            int value = this.getValue(e);
            this.setTag(e, Math.min(amt, value));
        }
        this.clearEmptyKeys();
    }

    public void addButMinimizeWith(ElementTagCompound tag) {
        if (tag == null || tag.data.isEmpty()) {
            return;
        }
        for (CrystalElement e : tag.data.keySet()) {
            int amt = tag.getValue(e);
            int value = this.getValue(e);
            int val = amt > 0 && value > 0 ? Math.min(amt, value) : (amt > 0 ? amt : value);
            this.setTag(e, val);
        }
        this.clearEmptyKeys();
    }

    public void maximizeWith(ElementTag tag) {
        this.setTag(tag.element, Math.max(this.getValue(tag.element), tag.value));
    }

    public void minimizeWith(ElementTag tag) {
        this.setTag(tag.element, Math.min(this.getValue(tag.element), tag.value));
        this.clearEmptyKeys();
    }

    public void clearEmptyKeys() {
        for (CrystalElement e : this.data.keySet()) {
            if (this.data.get((Object)e) > 0) continue;
            this.data.remove((Object)e);
        }
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public ElementTagCompound copy() {
        ElementTagCompound e = new ElementTagCompound();
        e.data.putAll(this.data);
        return e;
    }

    public ElementTagCompound scale(float s) {
        for (CrystalElement e : this.data.keySet()) {
            int amt = this.data.get((Object)e);
            if ((amt = (int)((float)amt * s)) <= 0) {
                amt = 1;
            }
            this.setTag(e, amt);
        }
        this.clearEmptyKeys();
        return this;
    }

    public ElementTagCompound square() {
        for (CrystalElement e : this.data.keySet()) {
            int amt = this.data.get((Object)e);
            amt *= amt;
            this.setTag(e, amt);
        }
        return this;
    }

    public ElementTagCompound power(double power) {
        for (CrystalElement e : this.data.keySet()) {
            int amt = this.data.get((Object)e);
            amt = Math.max(1, (int)Math.pow(amt, power));
            this.setTag(e, amt);
        }
        return this;
    }

    public ElementTagCompound clear() {
        this.data.clear();
        return this;
    }

    public void add(ElementTagCompound tag) {
        for (CrystalElement e : tag.data.keySet()) {
            this.addValueToColor(e, tag.getValue(e));
        }
    }

    public void subtract(CrystalElement e, int amt) {
        int has = this.getValue(e);
        this.setTag(e, Math.max(0, has - amt));
        this.clearEmptyKeys();
    }

    public void subtract(ElementTagCompound energy) {
        for (CrystalElement e : energy.data.keySet()) {
            int amt = energy.getValue(e);
            int has = this.getValue(e);
            this.setTag(e, Math.max(0, has - amt));
        }
        this.clearEmptyKeys();
    }

    public float divide(ElementTagCompound tag) {
        float f = Float.MAX_VALUE;
        for (CrystalElement e : tag.elementSet()) {
            f = Math.min(f, (float)this.getValue(e) / (float)tag.getValue(e));
        }
        return f;
    }

    public void readFromNBT(String name, NBTTagCompound NBT) {
        if (!NBT.func_74764_b(name)) {
            return;
        }
        NBTTagCompound tag = NBT.func_74775_l(name);
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            int amt = tag.func_74762_e(e.name());
            this.data.put(e, amt);
        }
        this.clearEmptyKeys();
    }

    public static ElementTagCompound createFromNBT(NBTTagCompound tag) {
        ElementTagCompound c = new ElementTagCompound();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            int amt = tag.func_74762_e(e.name());
            c.data.put(e, amt);
        }
        c.clearEmptyKeys();
        return c;
    }

    public void writeToNBT(String name, NBTTagCompound NBT) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            int amt = this.getValue(e);
            if (amt <= 0) continue;
            tag.func_74768_a(e.name(), amt);
        }
        NBT.func_74782_a(name, (NBTBase)tag);
    }

    public static ElementTagCompound getUniformTag(int level) {
        ElementTagCompound tag = new ElementTagCompound();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            tag.addTag(CrystalElement.elements[i], level);
        }
        return tag;
    }

    public boolean containsAtLeast(CrystalElement e, int amt) {
        return this.getValue(e) >= amt;
    }

    public boolean containsAtLeast(ElementTagCompound tag) {
        for (CrystalElement e : tag.data.keySet()) {
            int has;
            int val = tag.getValue(e);
            if (val <= (has = this.getValue(e))) continue;
            return false;
        }
        return true;
    }

    public int getTotalEnergy() {
        int amt = 0;
        for (CrystalElement e : this.data.keySet()) {
            int val = this.getValue(e);
            amt += val;
        }
        return amt;
    }

    public void intersectWith(ElementTagCompound tag) {
        ElementTagCompound temp = new ElementTagCompound();
        for (CrystalElement e : tag.data.keySet()) {
            if (!this.data.containsKey((Object)e)) continue;
            temp.addTag(e, this.getValue(e));
        }
        this.data.clear();
        for (CrystalElement e : temp.data.keySet()) {
            this.setTag(e, temp.getValue(e));
        }
    }

    public void intersectWithMinimum(ElementTagCompound tag) {
        ElementTagCompound temp = new ElementTagCompound();
        for (CrystalElement e : tag.data.keySet()) {
            if (!this.data.containsKey((Object)e) || tag.getValue(e) < this.data.get((Object)e)) continue;
            temp.addTag(e, this.getValue(e));
        }
        this.data.clear();
        for (CrystalElement e : temp.data.keySet()) {
            this.setTag(e, temp.getValue(e));
        }
    }

    public WeightedRandom<CrystalElement> asWeightedRandom() {
        WeightedRandom rand = new WeightedRandom();
        for (CrystalElement e : this.data.keySet()) {
            rand.addEntry((Object)e, (double)this.data.get((Object)e).intValue());
        }
        return rand;
    }

    public void clipToPrimaries() {
        ArrayList<CrystalElement> li = new ArrayList<CrystalElement>();
        for (CrystalElement e : this.data.keySet()) {
            if (e.isPrimary()) continue;
            li.add(e);
        }
        for (CrystalElement e : li) {
            this.data.remove((Object)e);
        }
    }

    public int tagCount() {
        return this.data.size();
    }

    public int getMaximumValue() {
        int max = 0;
        for (CrystalElement e : this.data.keySet()) {
            int amt = this.data.get((Object)e);
            if (amt <= max) continue;
            max = amt;
        }
        return max;
    }

    public int getMinimumValue() {
        int min = 0;
        for (CrystalElement e : this.data.keySet()) {
            int amt = this.data.get((Object)e);
            if (amt >= min) continue;
            min = amt;
        }
        return min;
    }

    public String toDisplay() {
        StringBuilder sb = new StringBuilder();
        for (CrystalElement e : this.data.keySet()) {
            int amt = this.data.get((Object)e);
            if (amt <= 0) continue;
            sb.append(e.displayName + ": " + amt + " Lumens");
            sb.append("\n");
        }
        return sb.toString();
    }

    public float getRatio(ElementTagCompound tag, CrystalElement e) {
        int val = tag.getValue(e);
        return val > 0 ? (float)(this.getValue(e) / val) : Float.POSITIVE_INFINITY;
    }

    public float getSmallestRatio(ElementTagCompound tag) {
        float min = Float.POSITIVE_INFINITY;
        for (CrystalElement e : this.data.keySet()) {
            min = Math.min(min, this.getRatio(tag, e));
        }
        return min;
    }

    public void setAllValuesTo(int amt) {
        for (CrystalElement e : this.data.keySet()) {
            this.data.put(e, amt);
        }
    }

    public int keySetAsBits() {
        int val = 0;
        for (CrystalElement e : this.elementSet()) {
            val |= 1 << e.ordinal();
        }
        return val;
    }

    public boolean isPrimaryOnly() {
        for (CrystalElement e : this.elementSet()) {
            if (e.isPrimary()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAllColors() {
        return this.data.size() == 16;
    }

    public void clamp(int max) {
        for (CrystalElement e : this.elementSet()) {
            this.setTag(e, Math.min(max, this.getValue(e)));
        }
    }
}

