/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Maps.MixMap;
import Reika.DragonAPI.Instantiable.Data.Maps.PairMap;
import java.util.ArrayList;
import java.util.Collection;

public class ElementMixer {
    public static final ElementMixer instance = new ElementMixer();
    private final MixMap<CrystalElement, CrystalElement> data = new MixMap();
    private final PairMap<CrystalElement> locks = new PairMap();

    private ElementMixer() {
        this.addMix(CrystalElement.BLACK, CrystalElement.WHITE, CrystalElement.GRAY);
        this.addMix(CrystalElement.RED, CrystalElement.WHITE, CrystalElement.PINK);
        this.addMix(CrystalElement.GREEN, CrystalElement.WHITE, CrystalElement.LIME);
        this.addMix(CrystalElement.BLUE, CrystalElement.WHITE, CrystalElement.LIGHTBLUE);
        this.addMix(CrystalElement.BLUE, CrystalElement.GREEN, CrystalElement.CYAN);
        this.addMix(CrystalElement.RED, CrystalElement.YELLOW, CrystalElement.ORANGE);
        this.addMix(CrystalElement.RED, CrystalElement.BLUE, CrystalElement.PURPLE);
        this.addMix(CrystalElement.GRAY, CrystalElement.WHITE, CrystalElement.LIGHTGRAY);
        this.addMix(CrystalElement.PURPLE, CrystalElement.PINK, CrystalElement.MAGENTA);
        this.addIncompatibility(CrystalElement.CYAN, CrystalElement.RED);
        this.addIncompatibility(CrystalElement.LIGHTGRAY, CrystalElement.BLUE);
        this.addIncompatibility(CrystalElement.PINK, CrystalElement.WHITE);
    }

    private void addMix(CrystalElement e1, CrystalElement e2, CrystalElement out) {
        this.data.addMix((Object)e1, (Object)e2, (Object)out);
    }

    public CrystalElement getMix(CrystalElement e1, CrystalElement e2) {
        return (CrystalElement)((Object)this.data.getMix((Object)e1, (Object)e2));
    }

    public boolean isMixable(CrystalElement e1, CrystalElement e2) {
        return this.getMix(e1, e2) != null;
    }

    public CrystalElement subtract(CrystalElement mix, CrystalElement e) {
        return (CrystalElement)((Object)this.data.getOtherEntry((Object)mix, (Object)e));
    }

    private void addIncompatibility(CrystalElement e1, CrystalElement e2) {
        this.locks.add((Object)e1, (Object)e2);
    }

    public boolean isCompatible(CrystalElement e1, CrystalElement e2) {
        return !this.locks.contains((Object)e1, (Object)e2);
    }

    public Collection<CrystalElement> getMixablesWith(CrystalElement color) {
        return this.data.getMixablesWith((Object)color);
    }

    public Collection<CrystalElement> getChildrenOf(CrystalElement color) {
        return this.data.getChildrenOf((Object)color);
    }

    public Collection<CrystalElement> getMixParents(CrystalElement color) {
        return this.data.getMixParents((Object)color);
    }

    public boolean related(CrystalElement e1, CrystalElement e2) {
        return this.getMixParents(e1).contains((Object)e2) || this.getMixParents(e2).contains((Object)e1);
    }

    public boolean hasMixes(CrystalElement color) {
        return !this.getRelatedColors(color).isEmpty();
    }

    public Collection<CrystalElement> getRelatedColors(CrystalElement color) {
        ArrayList<CrystalElement> c = new ArrayList<CrystalElement>(this.getMixParents(color));
        Collection<CrystalElement> c2 = this.getChildrenOf(color);
        if (c2 != null) {
            c.addAll(c2);
        }
        return c;
    }
}

