/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CrystalTarget {
    public final WorldLocation location;
    public final CrystalElement color;
    public final double endWidth;
    public final double offsetX;
    public final double offsetY;
    public final double offsetZ;

    public CrystalTarget(WorldLocation target, CrystalElement color, double w) {
        this(target, color, 0.0, 0.0, 0.0, w);
    }

    public CrystalTarget(WorldLocation target, CrystalElement color, double dx, double dy, double dz, double w) {
        if (target == null) {
            throw new IllegalArgumentException("Cannot supply null target!");
        }
        if (color == null) {
            throw new IllegalArgumentException("Cannot supply null color!");
        }
        this.color = color;
        this.location = target;
        this.offsetX = dx;
        this.offsetY = dy;
        this.offsetZ = dz;
        this.endWidth = w;
    }

    public void writeToNBT(String name, NBTTagCompound NBT) {
        if (this.location == null || this.color == null) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("color", this.color.ordinal());
        tag.func_74780_a("dx", this.offsetX);
        tag.func_74780_a("dy", this.offsetY);
        tag.func_74780_a("dz", this.offsetZ);
        tag.func_74780_a("width", this.endWidth);
        this.location.writeToNBT("loc", tag);
        NBT.func_74782_a(name, (NBTBase)tag);
    }

    public static CrystalTarget readFromNBT(String name, NBTTagCompound NBT) {
        if (!NBT.func_74764_b(name)) {
            return null;
        }
        NBTTagCompound tag = NBT.func_74775_l(name);
        if (tag == null) {
            return null;
        }
        WorldLocation loc = WorldLocation.readFromNBT((String)"loc", (NBTTagCompound)tag);
        CrystalElement e = CrystalElement.elements[tag.func_74762_e("color")];
        double dx = tag.func_74769_h("dx");
        double dy = tag.func_74769_h("dy");
        double dz = tag.func_74769_h("dz");
        double w = tag.func_74769_h("width");
        return loc != null && e != null ? new CrystalTarget(loc, e, dx, dy, dz, w) : null;
    }

    public boolean equals(Object o) {
        if (o instanceof CrystalTarget) {
            CrystalTarget t = (CrystalTarget)o;
            return t.location.equals((Object)this.location) && t.color == this.color;
        }
        return false;
    }

    public int hashCode() {
        return this.location.hashCode() + this.color.ordinal();
    }

    public String toString() {
        return this.color.name() + ": " + this.location.getTileEntity() + " {" + this.offsetX + "," + this.offsetY + "," + this.offsetZ + "}";
    }

    public static class TickingCrystalTarget
    extends CrystalTarget {
        private final int lifespan;
        private int tick;

        public TickingCrystalTarget(WorldLocation target, CrystalElement color, double w, int l) {
            super(target, color, w);
            this.lifespan = l;
        }

        public TickingCrystalTarget(WorldLocation target, CrystalElement color, double dx, double dy, double dz, double w, int l) {
            super(target, color, dx, dy, dz, w);
            this.lifespan = l;
        }

        public boolean tick() {
            ++this.tick;
            return this.tick >= this.lifespan;
        }
    }
}

