/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemPurifyCrystal;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import Reika.DragonAPI.ModList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class CrystalPotionController {
    private static final EnumMap<CrystalElement, Potion> map = new EnumMap(CrystalElement.class);
    private static final EnumMap<CrystalElement, Potion> nethermap = new EnumMap(CrystalElement.class);
    private static final HashSet<Integer> ignoredPotions = new HashSet();
    private static final Random rand = new Random();

    private static void addColorPotion(CrystalElement color, Potion pot) {
        map.put(color, pot);
    }

    private static void addNetherPotion(CrystalElement color, Potion pot) {
        nethermap.put(color, pot);
    }

    public static boolean shouldBeHostile(EntityLivingBase e, World world) {
        if (e instanceof EntityPlayer && ItemPurifyCrystal.isActive((EntityPlayer)e)) {
            return false;
        }
        return CrystalPotionController.isWorldHostile(world);
    }

    public static boolean isWorldHostile(World world) {
        if (ModList.EXTRAUTILS.isLoaded() && ExtraUtilsHandler.getInstance().initializedProperly() && world.field_73011_w.field_76574_g == ExtraUtilsHandler.getInstance().darkID) {
            return true;
        }
        if (ModList.THAUMCRAFT.isLoaded() && ThaumIDHandler.getInstance().initializedProperly() && world.field_73011_w.field_76574_g == ThaumIDHandler.getInstance().dimensionID) {
            return true;
        }
        if (ModList.MYSTCRAFT.isLoaded() && MystPages.Pages.HOSTILE.existsInWorld(world)) {
            return true;
        }
        return world.field_73011_w.field_76575_d;
    }

    public static boolean isPotionAllowed(PotionEffect eff, EntityLivingBase e) {
        if (eff == null) {
            return false;
        }
        Potion pot = Potion.field_76425_a[eff.func_76456_a()];
        PotionEffect has = e.func_70660_b(pot);
        if (has != null) {
            if (has.func_76458_c() > eff.func_76458_c()) {
                return false;
            }
            if (has.func_76459_b() > eff.func_76459_b()) {
                return false;
            }
        }
        if (e instanceof EntityPlayer && ItemPurifyCrystal.isActive((EntityPlayer)e)) {
            return !ReikaPotionHelper.isBadEffect((Potion)pot);
        }
        if (!(e instanceof EntityPlayer)) {
            boolean flag = false;
            if (e instanceof EntityCreature) {
                boolean bl = flag = ((EntityCreature)e).func_70668_bt() == EnumCreatureAttribute.UNDEAD;
            }
            return CrystalPotionController.shouldBeHostile(e, e.field_70170_p) ? ReikaPotionHelper.isBadEffect((Potion)pot) == flag : true;
        }
        if (CrystalPotionController.shouldBeHostile(e, e.field_70170_p)) {
            return eff.func_76456_a() == Potion.field_76439_r.field_76415_H || ReikaPotionHelper.isBadEffect((Potion)pot);
        }
        if (e.field_70170_p.field_73011_w.field_76574_g == 1) {
            return true;
        }
        return !ReikaPotionHelper.isBadEffect((Potion)pot);
    }

    public static boolean isBadPotion(CrystalElement e) {
        Potion pot = map.get((Object)e);
        return pot != null && ReikaPotionHelper.isBadEffect((Potion)pot);
    }

    public static PotionEffect getEffectFromColor(CrystalElement color, int dura, int level) {
        Potion pot = map.get((Object)color);
        if (pot == null) {
            return null;
        }
        return new PotionEffect(pot.field_76415_H, dura, level, true);
    }

    public static PotionEffect getNetherEffectFromColor(CrystalElement color, int dura, int level) {
        Potion pot = nethermap.get((Object)color);
        if (pot == null) {
            return null;
        }
        return new PotionEffect(pot.field_76415_H, dura, level, true);
    }

    public static String getPotionName(CrystalElement color) {
        if (color == CrystalElement.BLACK) {
            return "corrupting";
        }
        if (color == CrystalElement.PURPLE) {
            return "enhancing";
        }
        Potion pot = map.get((Object)color);
        if (pot == null && color == CrystalElement.BROWN) {
            return "lengthening";
        }
        if (pot == null) {
            return "[None]";
        }
        return StatCollector.func_74838_a((String)pot.func_76393_a());
    }

    public static boolean requiresCustomPotion(CrystalElement color) {
        if (color == CrystalElement.CYAN) {
            return true;
        }
        if (color == CrystalElement.YELLOW) {
            return true;
        }
        if (color == CrystalElement.LIME) {
            return true;
        }
        if (color == CrystalElement.RED) {
            return true;
        }
        return color == CrystalElement.BROWN;
    }

    public static boolean isCorruptedPotion(CrystalElement color) {
        if (color == CrystalElement.GRAY) {
            return true;
        }
        if (color == CrystalElement.LIGHTGRAY) {
            return true;
        }
        return color == CrystalElement.WHITE;
    }

    public static boolean isPotionModifier(CrystalElement color) {
        if (color == CrystalElement.BLACK) {
            return true;
        }
        return color == CrystalElement.PURPLE;
    }

    public static String getEffectName(CrystalElement color) {
        if (color == CrystalElement.BLACK) {
            return "Confuses Mobs";
        }
        if (color == CrystalElement.PURPLE) {
            return "Gives XP";
        }
        if (color == CrystalElement.WHITE) {
            return "Clears Effects";
        }
        return StatCollector.func_74838_a((String)map.get((Object)color).func_76393_a());
    }

    public static String getNetherEffectName(CrystalElement color) {
        if (color == CrystalElement.BROWN) {
            return "Nausea";
        }
        if (color == CrystalElement.PURPLE) {
            return "Takes XP";
        }
        if (color == CrystalElement.ORANGE) {
            return "Fire Damage";
        }
        if (color == CrystalElement.LIME) {
            return "Jump Disability";
        }
        if (color == CrystalElement.RED) {
            return "Direct Damage";
        }
        return StatCollector.func_74838_a((String)nethermap.get((Object)color).func_76393_a());
    }

    public static Set<Integer> ignoredBadPotionsForLevelZero() {
        return Collections.unmodifiableSet(ignoredPotions);
    }

    public static void addIgnoredPotion(Potion p) {
        ignoredPotions.add(p.field_76415_H);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void applyEffectFromColor(int dura, int level, EntityLivingBase e, CrystalElement color, boolean doFX) {
        if (CrystalPotionController.shouldBeHostile(e, e.field_70170_p)) {
            switch (color) {
                case ORANGE: {
                    e.func_70015_d(2);
                    return;
                }
                case RED: {
                    e.func_70097_a(DamageSource.field_76376_m, 1.0f);
                    return;
                }
                case PURPLE: {
                    if (e.field_70170_p.field_72995_K || rand.nextInt(5) != 0 || !(e instanceof EntityPlayer)) return;
                    EntityPlayer ep = (EntityPlayer)e;
                    if (ep.field_71068_ca > 0) {
                        ep.func_82242_a(-1);
                        return;
                    }
                    ep.field_71067_cb = 0;
                    ep.field_71106_cc = 0.0f;
                    return;
                }
                case BROWN: {
                    if (e.func_82165_m(Potion.field_76431_k.field_76415_H)) return;
                    e.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, Math.max(100, (int)((double)dura * 1.8)), level, true));
                    return;
                }
                case LIME: {
                    e.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, dura, -5, true));
                    return;
                }
                default: {
                    PotionEffect eff = CrystalPotionController.getNetherEffectFromColor(color, dura, level);
                    if (!CrystalPotionController.isPotionAllowed(eff, e)) return;
                    e.func_70690_d(eff);
                }
            }
            return;
        } else {
            switch (color) {
                case BLACK: {
                    if (!(e instanceof EntityMob)) return;
                    EntityMob m = (EntityMob)e;
                    m.func_70624_b(null);
                    m.func_70661_as().func_75499_g();
                    return;
                }
                case WHITE: {
                    ReikaPotionHelper.clearBadPotions((EntityLivingBase)e, level > 0 ? null : CrystalPotionController.ignoredBadPotionsForLevelZero());
                    return;
                }
                case PURPLE: {
                    if (!(e instanceof EntityPlayer) || e.field_70170_p.field_72995_K || level <= 0 && rand.nextInt(2) != 0) return;
                    EntityPlayer ep = (EntityPlayer)e;
                    if (doFX) {
                        ep.field_70170_p.func_72956_a((Entity)ep, "random.orb", 0.2f, rand.nextFloat() * 2.0f);
                    }
                    ep.func_71023_q(1);
                    return;
                }
                default: {
                    PotionEffect eff = CrystalPotionController.getEffectFromColor(color, dura, level);
                    if (eff == null || !CrystalPotionController.isPotionAllowed(eff, e)) return;
                    e.func_70690_d(eff);
                }
            }
        }
    }

    static {
        CrystalPotionController.addColorPotion(CrystalElement.BLUE, Potion.field_76439_r);
        CrystalPotionController.addColorPotion(CrystalElement.CYAN, Potion.field_76427_o);
        CrystalPotionController.addColorPotion(CrystalElement.GRAY, Potion.field_76421_d);
        CrystalPotionController.addColorPotion(CrystalElement.GREEN, Potion.field_76436_u);
        CrystalPotionController.addColorPotion(CrystalElement.LIGHTBLUE, Potion.field_76424_c);
        CrystalPotionController.addColorPotion(CrystalElement.LIGHTGRAY, Potion.field_76437_t);
        CrystalPotionController.addColorPotion(CrystalElement.LIME, Potion.field_76430_j);
        CrystalPotionController.addColorPotion(CrystalElement.MAGENTA, ChromatiCraft.betterRegen);
        CrystalPotionController.addColorPotion(CrystalElement.RED, Potion.field_76429_m);
        CrystalPotionController.addColorPotion(CrystalElement.ORANGE, Potion.field_76426_n);
        CrystalPotionController.addColorPotion(CrystalElement.PINK, Potion.field_76420_g);
        CrystalPotionController.addColorPotion(CrystalElement.YELLOW, Potion.field_76422_e);
        CrystalPotionController.addColorPotion(CrystalElement.WHITE, Potion.field_76441_p);
        CrystalPotionController.addColorPotion(CrystalElement.BROWN, ChromatiCraft.betterSat);
        CrystalPotionController.addNetherPotion(CrystalElement.BLACK, Potion.field_82731_v);
        CrystalPotionController.addNetherPotion(CrystalElement.CYAN, Potion.field_76438_s);
        CrystalPotionController.addNetherPotion(CrystalElement.GRAY, Potion.field_76440_q);
        CrystalPotionController.addNetherPotion(CrystalElement.GREEN, Potion.field_76436_u);
        CrystalPotionController.addNetherPotion(CrystalElement.LIGHTBLUE, Potion.field_76421_d);
        CrystalPotionController.addNetherPotion(CrystalElement.LIGHTGRAY, Potion.field_76437_t);
        CrystalPotionController.addNetherPotion(CrystalElement.YELLOW, Potion.field_76419_f);
        CrystalPotionController.addNetherPotion(CrystalElement.WHITE, Potion.field_76441_p);
        CrystalPotionController.addNetherPotion(CrystalElement.BROWN, Potion.field_76431_k);
        CrystalPotionController.addNetherPotion(CrystalElement.BLUE, Potion.field_76439_r);
        CrystalPotionController.addNetherPotion(CrystalElement.PINK, Potion.field_76420_g);
        CrystalPotionController.addNetherPotion(CrystalElement.MAGENTA, ChromatiCraft.betterRegen);
    }
}

