/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Aura;

import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseAura {
    private static final HashMap<BiomeGenBase, ElementTagCompound> biomeAura = new HashMap();
    private static final BlockMap<ElementTagCompound> blockAura = new BlockMap();

    private static void addBlockAura(Block b, CrystalElement e, int amt) {
        BaseAura.addBlockAura(b, -1, e, amt);
    }

    private static void addBlockAura(Block b, int meta, CrystalElement e, int amt) {
        ElementTagCompound tag = (ElementTagCompound)blockAura.get(b, meta);
        if (tag == null) {
            tag = new ElementTagCompound();
            blockAura.put(b, meta, (Object)tag);
        }
        tag.addValueToColor(e, amt);
    }

    private static void addBiomeAura(CrystalElement e, int amt, BiomeDictionary.Type type) {
        BaseAura.addBiomeAura(e, amt, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type));
    }

    private static void addBiomeAura(CrystalElement e, int amt, BiomeGenBase ... biomes) {
        for (int i = 0; i < biomes.length; ++i) {
            ElementTagCompound tag = biomeAura.get(biomes[i]);
            if (tag == null) {
                tag = new ElementTagCompound();
                biomeAura.put(biomes[i], tag);
            }
            tag.addValueToColor(e, amt);
        }
    }

    public static ElementTagCompound getBiomeBase(BiomeGenBase biome) {
        ElementTagCompound tag = new ElementTagCompound();
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (int i = 0; i < types.length; ++i) {
            ElementTagCompound tag2 = biomeAura.get(types[i]);
            if (tag2 == null) continue;
            tag.addTag(tag2);
        }
        return tag;
    }

    public static ElementTagCompound getBlockBase(Block b, int meta) {
        ElementTagCompound tag = (ElementTagCompound)blockAura.get(b, meta);
        return tag != null ? tag : new ElementTagCompound();
    }

    public static ElementTagCompound getBaseAura(World world, int x, int y, int z) {
        ElementTagCompound tag = new ElementTagCompound();
        BiomeGenBase biome = world.func_72807_a(x, z);
        tag.addTag(BaseAura.getBiomeBase(biome));
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (dy <= 0 || dy >= 256) continue;
            tag.addTag(BaseAura.getBlockBase(world.func_147439_a(dx, dy, dz), world.func_72805_g(dx, dy, dz)));
        }
        return tag;
    }

    static {
        BaseAura.addBiomeAura(CrystalElement.CYAN, 5, BiomeDictionary.Type.OCEAN);
        BaseAura.addBiomeAura(CrystalElement.ORANGE, 5, BiomeDictionary.Type.NETHER);
        BaseAura.addBlockAura(Blocks.field_150357_h, CrystalElement.RED, 10);
    }
}

