/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Aura;

import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.AuraSource;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.World;

public class AuraMap {
    public static final AuraMap instance = new AuraMap();
    private final ArrayList<AuraLocation> auraSources = new ArrayList();

    private AuraMap() {
    }

    public Collection<AuraLocation> getAuraSources() {
        return Collections.unmodifiableCollection(this.auraSources);
    }

    public ArrayList<AuraLocation> getAuraSourcesWithinDOfXYZ(World world, int x, int y, int z, double maxdist) {
        ArrayList<AuraLocation> li = new ArrayList<AuraLocation>();
        for (int i = 0; i < this.auraSources.size(); ++i) {
            AuraLocation loc = this.auraSources.get(i);
            double dist = loc.getDistanceFrom(x, y, z);
            if (!(dist <= maxdist)) continue;
            li.add(loc);
        }
        return li;
    }

    public void addAuraSource(AuraSource source, World world, int x, int y, int z) {
        AuraLocation loc = new AuraLocation(source, world, x, y, z);
        this.auraSources.add(loc);
    }

    public static class AuraLocation {
        public final AuraSource source;
        public final int xCoord;
        public final int yCoord;
        public final int zCoord;
        public final int dimensionID;

        private AuraLocation(AuraSource source, World world, int x, int y, int z) {
            this.source = source;
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.dimensionID = world.field_73011_w.field_76574_g;
        }

        public double getDistanceFrom(int x, int y, int z) {
            return ReikaMathLibrary.py3d((double)(this.xCoord - x), (double)(this.yCoord - y), (double)(this.zCoord - z));
        }

        public boolean isInWorld(World world) {
            return this.dimensionID == world.field_73011_w.field_76574_g;
        }

        public int getAuraStrengthAt(CrystalElement e, World world, int x, int y, int z) {
            if (!this.isInWorld(world)) {
                return 0;
            }
            int base = this.source.getAuras().getValue(e);
            if (base == 0) {
                return 0;
            }
            double d = this.getDistanceFrom(x, y, z);
            return this.calculateStrength(base, d);
        }

        public ElementTagCompound getAuraStrengthsAt(World world, int x, int y, int z) {
            if (!this.isInWorld(world)) {
                return null;
            }
            ElementTagCompound base = this.source.getAuras();
            if (base == null || base.isEmpty()) {
                return null;
            }
            double d = this.getDistanceFrom(x, y, z);
            ElementTagCompound e = new ElementTagCompound();
            for (int i = 0; i < CrystalElement.elements.length; ++i) {
                CrystalElement el = CrystalElement.elements[i];
                e.addTag(el, this.calculateStrength(base.getValue(el), d));
            }
            return e;
        }

        private int calculateStrength(int base, double dist) {
            return (int)((double)base * this.source.getCoefficient() / Math.pow(dist, this.source.getDistancePower()));
        }

        public boolean equals(Object o) {
            if (o instanceof AuraLocation) {
                AuraLocation a = (AuraLocation)o;
                return a.source == this.source && a.xCoord == this.xCoord && a.yCoord == this.yCoord && a.zCoord == this.zCoord && a.dimensionID == this.dimensionID;
            }
            return false;
        }
    }
}

