/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Artefact;

import Reika.ChromatiCraft.Items.ItemUnknownArtefact;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.World.IWG.UnknownArtefactGenerator;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;

public class ArtefactSpawner
implements TickRegistry.TickHandler {
    private static final int SPAWN_DISTANCE = 32;
    private static final int DESPAWN_DISTANCE = 64;
    private static final int SPAWN_LIMIT = 3;
    private static final Random rand = new Random();
    private final ArrayList<SpawnedArtefact> artefacts = new ArrayList();
    public static final ArtefactSpawner instance = new ArtefactSpawner();

    private ArtefactSpawner() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        EntityPlayer ep = (EntityPlayer)tickData[0];
        if (!ep.field_70170_p.field_72995_K) {
            return;
        }
        if (this.artefacts.size() < 3 && rand.nextInt(8000) == 0 && this.canSpawnArtefactNearPlayer(ep)) {
            int z;
            int y;
            double a = Math.toRadians(rand.nextDouble() * 360.0);
            double dx = ep.field_70165_t + 32.0 * Math.cos(a);
            double dz = ep.field_70161_v + 32.0 * Math.sin(a);
            int x = MathHelper.func_76128_c((double)dx);
            if (UnknownArtefactGenerator.canGenerateArtefactAt(ep.field_70170_p, x, y = ep.field_70170_p.func_72825_h(x, z = MathHelper.func_76128_c((double)dz)) - 1, z)) {
                double dy = (double)y - 0.5;
                this.artefacts.add(new SpawnedArtefact(dx, dy, dz));
            }
        }
        if (!this.artefacts.isEmpty()) {
            Iterator<SpawnedArtefact> it = this.artefacts.iterator();
            while (it.hasNext()) {
                SpawnedArtefact a = it.next();
                if (!a.tick(ep)) continue;
                it.remove();
            }
        }
    }

    private boolean canSpawnArtefactNearPlayer(EntityPlayer ep) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        int cx = ReikaMathLibrary.roundDownToX((int)16, (int)MathHelper.func_76128_c((double)ep.field_70165_t));
        int cz = ReikaMathLibrary.roundDownToX((int)16, (int)MathHelper.func_76128_c((double)ep.field_70161_v));
        return UnknownArtefactGenerator.instance.isUAChunk(ep.field_70170_p, cx, cz);
    }

    public boolean isOnTopOfArtefact(World world, int x, int y, int z) {
        if (!this.artefacts.isEmpty()) {
            Iterator<SpawnedArtefact> it = this.artefacts.iterator();
            while (it.hasNext()) {
                SpawnedArtefact a = it.next();
                Coordinate c = a.position.getCoordinate();
                if (!c.equals(x, y - 1, z)) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void checkPlayerBreak(BlockEvent.BreakEvent evt) {
        int cz;
        int cx;
        EntityPlayer ep = evt.getPlayer();
        if (ep instanceof EntityPlayerMP && !ReikaPlayerAPI.isFake((EntityPlayer)ep) && UnknownArtefactGenerator.instance.isUAChunk(evt.world, cx = ReikaMathLibrary.roundDownToX((int)16, (int)evt.x), cz = ReikaMathLibrary.roundDownToX((int)16, (int)evt.z))) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.DIGARTEFACT.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{evt.x, evt.y, evt.z});
        }
    }

    public void checkPlayerBreakClient(World world, int x, int y, int z) {
        if (this.isOnTopOfArtefact(world, x, y, z)) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.ARTEFACTCONFIRM.ordinal(), (PacketTarget)PacketTarget.server, (int[])new int[]{x, y, z});
        }
    }

    public void confirmUA(World world, int x, int y, int z) {
        world.func_147449_b(x, y, z, ChromaBlocks.ARTEFACT.getBlockInstance());
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.PLAYER);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.START;
    }

    public String getLabel() {
        return "UA Spawner";
    }

    public static class SpawnedArtefact {
        private final DecimalPosition position;

        private SpawnedArtefact(double x, double y, double z) {
            this.position = new DecimalPosition(x, y, z);
        }

        private boolean tick(EntityPlayer ep) {
            ItemUnknownArtefact.doUA_FX(ep.field_70170_p, this.position.xCoord, this.position.yCoord, this.position.zCoord);
            return ep.func_70092_e(this.position.xCoord, this.position.yCoord, this.position.zCoord) >= 4096.0;
        }
    }
}

