/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Wands;

import Reika.ChromatiCraft.Base.ItemWandBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.ProgressiveRecursiveBreaker;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class ItemTransitionWand
extends ItemWandBase
implements ProgressiveRecursiveBreaker.BreakerCallback {
    private static HashMap<Integer, BlockReplace> breakers = new HashMap();
    private static final int MAX_DEPTH = 18;
    private static final int MAX_DEPTH_BOOST = 24;

    public ItemTransitionWand(int index) {
        super(index);
        this.addEnergyCost(CrystalElement.GRAY, 2);
        this.addEnergyCost(CrystalElement.YELLOW, 1);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TRANSITION.ordinal(), world, 0, 0, 0);
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        if (!world.field_72995_K) {
            if (ep.func_70093_af()) {
                this.setStoredItem(is, ReikaBlockHelper.getWorldBlockAsItemStack((World)world, (int)x, (int)y, (int)z));
            } else {
                ItemStack store = this.getStoredItem(is);
                if (store == null) {
                    return false;
                }
                Block id = Block.func_149634_a((Item)store.func_77973_b());
                int meta = store.func_77960_j();
                if (id == null) {
                    return false;
                }
                TransitionMode mode = this.getMode(is);
                if (id == world.func_147439_a(x, y, z) && meta == world.func_72805_g(x, y, z) && mode != TransitionMode.VOLUMETRIC) {
                    return false;
                }
                if (mode == TransitionMode.VOLUMETRIC && !this.setOrGetBlockBox(is, x, y, z)) {
                    return false;
                }
                int depth = mode == TransitionMode.VOLUMETRIC ? Integer.MAX_VALUE : ItemTransitionWand.getDepth(ep);
                ProgressiveRecursiveBreaker.ProgressiveBreaker br = ProgressiveRecursiveBreaker.instance.addCoordinateWithReturn(world, x, y, z, depth);
                br.call = this;
                br.drops = false;
                br.extraSpread = false;
                br.player = ep;
                br.silkTouch = EnchantmentHelper.func_77502_d((EntityLivingBase)ep);
                BlockReplace brp = new BlockReplace(ep, id, meta, mode);
                brp.silkTouch = br.silkTouch;
                br.causeUpdates = false;
                if (mode == TransitionMode.VOLUMETRIC) {
                    br.bounds = this.getStoredBox(is);
                    br.isOmni = true;
                    br.pathTracking = true;
                }
                is.field_77990_d.func_82580_o("bbox");
                breakers.put(br.hashCode(), brp);
            }
        }
        return true;
    }

    public static int getDepth(EntityPlayer ep) {
        return ItemTransitionWand.canUseBoostedEffect(ep) ? 24 : 18;
    }

    private boolean setOrGetBlockBox(ItemStack is, int x, int y, int z) {
        BlockBox bb = this.getStoredBox(is);
        if (bb == null) {
            NBTTagCompound tag;
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            if ((tag = is.field_77990_d.func_74775_l("bbox")).func_82582_d()) {
                tag.func_74768_a("minx", x);
                tag.func_74768_a("miny", y);
                tag.func_74768_a("minz", z);
            } else {
                tag.func_74768_a("maxx", x);
                tag.func_74768_a("maxy", y);
                tag.func_74768_a("maxz", z);
            }
            is.field_77990_d.func_74782_a("bbox", (NBTBase)tag);
        }
        return (bb = this.getStoredBox(is)) != null;
    }

    private BlockBox getStoredBox(ItemStack is) {
        NBTTagCompound tag;
        if (is.field_77990_d != null && (tag = is.field_77990_d.func_74775_l("bbox")).func_150296_c().size() == 6) {
            return BlockBox.readFromNBT((NBTTagCompound)tag);
        }
        return null;
    }

    public ItemStack getStoredItem(ItemStack tool) {
        if (tool.field_77990_d != null) {
            NBTTagCompound tag = tool.field_77990_d.func_74775_l("stored");
            ItemStack ret = ItemStack.func_77949_a((NBTTagCompound)tag);
            return ret;
        }
        return null;
    }

    public void setStoredItem(ItemStack tool, ItemStack tostore) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tostore.func_77955_b(tag);
        tool.field_77990_d.func_74782_a("stored", (NBTBase)tag);
    }

    public void onPreBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        BlockReplace r = breakers.get(b.hashCode());
        if (r != null) {
            boolean exists;
            boolean bl = exists = world.func_72924_a(r.player.func_70005_c_()) != null;
            if (exists) {
                ItemStack is;
                ArrayList li = id.getDrops(world, x, y, z, meta, 0);
                if (r.silkTouch && (is = ReikaBlockHelper.getSilkTouch((World)world, (int)x, (int)y, (int)z, (Block)id, (int)meta, (EntityPlayer)r.player, (boolean)true)) != null) {
                    li.clear();
                    li.add(is);
                }
                for (ItemStack is2 : li) {
                    r.drops.add(is2);
                }
            } else {
                b.terminate();
            }
        }
    }

    public void onPostBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        BlockReplace r = breakers.get(b.hashCode());
        if (r != null) {
            boolean exists;
            boolean bl = exists = world.func_72924_a(r.player.func_70005_c_()) != null;
            if (exists) {
                world.func_147465_d(x, y, z, r.place, r.placeM, 3);
                ReikaSoundHelper.playPlaceSound((World)world, (int)x, (int)y, (int)z, (Block)r.place);
                this.drainPlayer(r.player);
                ReikaPlayerAPI.findAndDecrItem((EntityPlayer)r.player, (Block)r.place, (int)r.placeM);
            } else {
                b.terminate();
            }
        }
    }

    public boolean canBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        BlockReplace r = breakers.get(b.hashCode());
        if (!((BlockReplace)r).player.field_71075_bZ.field_75098_d) {
            if (ReikaBlockHelper.isUnbreakable((World)world, (int)x, (int)y, (int)z, (Block)id, (int)meta, (EntityPlayer)r.player)) {
                return false;
            }
            if (id instanceof SemiUnbreakable && ((SemiUnbreakable)id).isUnbreakable(world, x, y, z, meta)) {
                return false;
            }
        }
        if (world.func_147438_o(x, y, z) != null) {
            return false;
        }
        if (r != null) {
            boolean exists;
            boolean bl = exists = world.func_72924_a(r.player.func_70005_c_()) != null;
            if (exists && this.sufficientEnergy(r.player) && ReikaPlayerAPI.playerHasOrIsCreative((EntityPlayer)r.player, (Block)r.place, (int)r.placeM)) {
                boolean perm = world.field_72995_K || ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)x, (int)y, (int)z, (EntityPlayerMP)((EntityPlayerMP)r.player));
                switch (r.mode) {
                    case CONTIGUOUS: {
                        return perm;
                    }
                    case AIRONLY: {
                        return perm && ReikaWorldHelper.checkForAdjNonCube((World)world, (int)x, (int)y, (int)z) != null;
                    }
                    case VOLUMETRIC: {
                        return perm;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void onFinish(ProgressiveRecursiveBreaker.ProgressiveBreaker b) {
        BlockReplace r = breakers.get(b.hashCode());
        EntityPlayer ep = r.player;
        if (!ep.field_71075_bZ.field_75098_d) {
            for (ItemStack is : r.drops) {
                if (MinecraftForge.EVENT_BUS.post((Event)new EntityItemPickupEvent(ep, new EntityItem(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, is)))) continue;
                ReikaPlayerAPI.addOrDropItem((ItemStack)is, (EntityPlayer)ep);
            }
        }
        breakers.remove(b.hashCode());
    }

    public void setMode(ItemStack is, TransitionMode mode) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("mode", mode.ordinal());
    }

    public TransitionMode getMode(ItemStack is) {
        if (is.field_77990_d != null) {
            int idx = is.field_77990_d.func_74762_e("mode");
            return TransitionMode.list[idx];
        }
        return TransitionMode.CONTIGUOUS;
    }

    public static enum TransitionMode {
        CONTIGUOUS("Contiguous"),
        AIRONLY("Exposed Contiguous"),
        VOLUMETRIC("Volumetric");

        public final String desc;
        public static final TransitionMode[] list;

        private TransitionMode(String s) {
            this.desc = s;
        }

        static {
            list = TransitionMode.values();
        }
    }

    private static class BlockReplace {
        private final EntityPlayer player;
        private final Block place;
        private final int placeM;
        private final TransitionMode mode;
        private ArrayList<ItemStack> drops = new ArrayList();
        private boolean silkTouch;

        private BlockReplace(EntityPlayer ep, Block b, int meta, TransitionMode m) {
            this.place = b;
            this.placeM = meta;
            this.player = ep;
            this.mode = m;
        }
    }
}

