/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Wands;

import Reika.ChromatiCraft.Base.ItemWandBase;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemGrowthWand
extends ItemWandBase {
    private static final GrowthTicker ticker = new GrowthTicker();

    public ItemGrowthWand(int index) {
        super(index);
        this.addEnergyCost(CrystalElement.BLACK, 2);
        this.addEnergyCost(CrystalElement.PURPLE, 10);
        this.addEnergyCost(CrystalElement.GREEN, 40);
        TickRegistry.instance.registerTickHandler((TickRegistry.TickHandler)ticker);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float f1, float f2, float f3) {
        if (this.sufficientEnergy(ep)) {
            int r = this.getRange(ep);
            ItemGrowthWand.ticker.addLocation(ep, world, x, y, z, r, r / 2, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77345_t, (ItemStack)is) > 0);
            ChromaSounds.USE.playSoundAtBlock(world, x, y, z);
            return true;
        }
        return false;
    }

    private int getRange(EntityPlayer ep) {
        return ItemGrowthWand.canUseBoostedEffect(ep) ? 8 : 4;
    }

    private static class GrowthLocation {
        private final WorldLocation origin;
        private final EntityPlayer player;
        private static final Random rand = new Random();
        private final boolean enhanced;
        private TreeMap<Integer, ArrayList<Coordinate>> locations = new TreeMap();

        private GrowthLocation(EntityPlayer ep, World world, int x, int y, int z, int r1, int r2, boolean e) {
            this.origin = new WorldLocation(world, x, y, z);
            this.player = ep;
            for (int i = -r1; i <= r1; ++i) {
                for (int k = -r1; k <= r1; ++k) {
                    this.addLocation(x + i, y, z + k, i * i + k * k);
                }
            }
            this.enhanced = e;
        }

        public boolean isEmpty() {
            return this.locations.isEmpty();
        }

        private void addLocation(int x, int y, int z, int d) {
            ArrayList<Object> li = this.locations.get(d);
            if (li == null) {
                li = new ArrayList();
                this.locations.put(d, li);
            }
            li.add(new Coordinate(x, y, z));
        }

        private void removeLocation(Coordinate c, int idx, ArrayList<Coordinate> li, int d) {
            li.remove(idx);
            if (li.isEmpty()) {
                this.locations.remove(d);
            }
        }

        private void tick(World world) {
            int idx;
            int d = this.locations.firstKey();
            ArrayList<Coordinate> li = this.locations.get(d);
            Coordinate c = li.get(idx = rand.nextInt(li.size()));
            if (c != null) {
                int n = 1 + rand.nextInt(6);
                if (this.enhanced) {
                    n *= 1 + n;
                }
                for (int i = 0; i < n; ++i) {
                    c.updateTick(world);
                    PacketTarget.RadiusTarget pt = new PacketTarget.RadiusTarget(world, c, 16);
                    ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.GROWTH.ordinal(), (PacketTarget)pt, (int[])new int[]{c.xCoord, c.yCoord, c.zCoord});
                }
                this.removeLocation(c, idx, li, d);
                int f = this.enhanced ? 16 : 1;
                ((ItemGrowthWand)ChromaItems.GROWTH.getItemInstance()).drainPlayer(this.player, f);
            }
        }
    }

    public static class GrowthTicker
    implements TickRegistry.TickHandler {
        private final Collection<GrowthLocation> locations = new ArrayList<GrowthLocation>();
        private boolean isIterating;
        private Collection<GrowthLocation> holdingCache = new ArrayList<GrowthLocation>();

        public void tick(TickRegistry.TickType type, Object ... tickData) {
            World world = (World)tickData[0];
            this.isIterating = true;
            Iterator<GrowthLocation> it = this.locations.iterator();
            while (it.hasNext()) {
                GrowthLocation g = it.next();
                if (((GrowthLocation)g).origin.dimensionID != world.field_73011_w.field_76574_g) continue;
                g.tick(world);
                if (!g.isEmpty()) continue;
                it.remove();
            }
            this.locations.addAll(this.holdingCache);
            this.holdingCache.clear();
            this.isIterating = false;
        }

        private void addLocation(EntityPlayer ep, World world, int x, int y, int z, int w, int h, boolean e) {
            GrowthLocation g = new GrowthLocation(ep, world, x, y, z, w, h, e);
            if (this.isIterating) {
                this.holdingCache.add(g);
            } else {
                this.locations.add(g);
            }
        }

        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.WORLD);
        }

        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.START;
        }

        public String getLabel() {
            return "Growth Wand";
        }
    }
}

