/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Wands;

import Reika.ChromatiCraft.Base.ItemWandBase;
import Reika.ChromatiCraft.Block.BlockHoverBlock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemFlightWand
extends ItemWandBase {
    public ItemFlightWand(int index) {
        super(index);
        this.addEnergyCost(CrystalElement.BLACK, 5);
        this.addEnergyCost(CrystalElement.LIME, 20);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        boolean flag = false;
        if (this.canUse(ep)) {
            flag = this.trigger(world, is, ep, ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)8.0, (boolean)true));
        }
        if (!flag) {
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.HOVER.ordinal(), world, 0, 0, 0);
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        return this.canUse(ep) && this.trigger(world, is, ep, new MovingObjectPosition(x, y, z, s, Vec3.func_72443_a((double)a, (double)b, (double)c)));
    }

    private boolean canUse(EntityPlayer ep) {
        return this.sufficientEnergy(ep);
    }

    private boolean trigger(World world, ItemStack is, EntityPlayer ep, MovingObjectPosition mov) {
        int z;
        int y;
        int x;
        if (mov != null && mov.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_147439_a(x = mov.field_72311_b, (y = mov.field_72312_c) + 1, z = mov.field_72309_d).isAir((IBlockAccess)world, x, y + 1, z)) {
            ChromaSounds.CAST.playSound((Entity)ep);
            for (double d = 0.0; d <= 1.0; d += 0.125) {
                double dx = ep.field_70165_t + d * ((double)x - ep.field_70165_t);
                double dy = ep.field_70163_u + d * ((double)y - ep.field_70163_u);
                double dz = ep.field_70161_v + d * ((double)z - ep.field_70161_v);
                double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
                double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
                double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
                ReikaParticleHelper.ENCHANTMENT.spawnAt(world, dx, dy, dz, vx, vy, vz);
            }
            for (int i = 1; i <= 8; ++i) {
                if (!world.func_147439_a(x, y + i, z).isAir((IBlockAccess)world, x, y + i, z)) continue;
                BlockHoverBlock.HoverType mode = ItemFlightWand.getMode(is);
                world.func_147465_d(x, y + i, z, ChromaBlocks.HOVER.getBlockInstance(), mode.getDecayMeta(), 3);
                this.drainPlayer(ep, this.getEnergyCostFactor(mode));
            }
            return true;
        }
        return false;
    }

    public static BlockHoverBlock.HoverType getMode(ItemStack is) {
        return is.field_77990_d != null ? BlockHoverBlock.HoverType.list[is.field_77990_d.func_74762_e("mode")] : BlockHoverBlock.HoverType.ELEVATE;
    }

    public static void setMode(ItemStack is, BlockHoverBlock.HoverType type) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("mode", type.ordinal());
    }

    private float getEnergyCostFactor(BlockHoverBlock.HoverType type) {
        switch (type) {
            case ELEVATE: {
                return 1.5f;
            }
            case FASTELEVATE: {
                return 2.0f;
            }
        }
        return 1.0f;
    }
}

