/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Wands;

import Reika.ChromatiCraft.Base.ItemWandBase;
import Reika.ChromatiCraft.Block.Decoration.BlockEtherealLight;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.DragonAPI.Auxiliary.ProgressiveRecursiveBreaker;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.PlayerReference;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModList;
import Reika.GeoStrata.Registry.GeoBlocks;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemExcavationWand
extends ItemWandBase
implements ProgressiveRecursiveBreaker.BreakerCallback {
    private static final int MAX_DEPTH = 12;
    private static final int MAX_DEPTH_BOOST = 18;
    private static final HashMap<Integer, PlayerReference> breakers = new HashMap();

    public ItemExcavationWand(int index) {
        super(index);
        this.addEnergyCost(CrystalElement.BROWN, 1);
        this.addEnergyCost(CrystalElement.YELLOW, 2);
    }

    public float getDigSpeed(ItemStack is, Block b, int meta) {
        return 5.0f;
    }

    public boolean canHarvestBlock(Block b, ItemStack is) {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return Integer.MAX_VALUE;
    }

    public static boolean spreadOn(World world, int x, int y, int z, Block b, int meta) {
        if (world.field_73011_w.func_76569_d() && b == Blocks.field_150348_b) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && b == Blocks.field_150424_aL) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == 1 && b == Blocks.field_150377_bs) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        return !(te instanceof CrystalNetworkTile) && !(te instanceof TileEntityStructControl);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer ep) {
        World world = ep.field_70170_p;
        if (!world.field_72995_K) {
            ProgressiveRecursiveBreaker.ProgressiveBreaker b = ProgressiveRecursiveBreaker.instance.addCoordinateWithReturn(world, x, y, z, ItemExcavationWand.getDepth(ep));
            b.call = this;
            b.silkTouch = ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77348_q, (ItemStack)itemstack) > 0;
            b.drops = !ep.field_71075_bZ.field_75098_d;
            b.fortune = ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77346_s, (ItemStack)itemstack);
            if (ep.func_70093_af()) {
                b.extraSpread = true;
            }
            if (ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_151369_A, (ItemStack)itemstack) > 0) {
                b.dropInventory = ep.field_71071_by;
            }
            b.taxiCabDistance = true;
            b.player = ep;
            b.hungerFactor = 0.125f;
            HashSet<BlockKey> set = ItemExcavationWand.getSpreadBlocks(world, x, y, z);
            for (BlockKey bk : set) {
                b.addBlock(bk);
            }
            breakers.put(b.hashCode(), new PlayerReference(ep));
        }
        return true;
    }

    public static HashSet<BlockKey> getSpreadBlocks(World world, int x, int y, int z) {
        HashSet<BlockKey> set;
        block6: {
            Block bk;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    set = new HashSet<BlockKey>();
                                    bk = world.func_147439_a(x, y, z);
                                    if (bk != Blocks.field_150439_ay) break block5;
                                    set.add(new BlockKey(Blocks.field_150450_ax));
                                    break block6;
                                }
                                if (bk != Blocks.field_150450_ax) break block7;
                                set.add(new BlockKey(Blocks.field_150439_ay));
                                break block6;
                            }
                            if (!(bk instanceof BlockStairs)) break block8;
                            for (int i = 0; i < 16; ++i) {
                                set.add(new BlockKey(bk, i));
                            }
                            break block6;
                        }
                        if (bk != ChromaBlocks.GLOWLEAF.getBlockInstance()) break block9;
                        for (int i = 0; i < 16; ++i) {
                            set.add(new BlockKey(bk, i));
                        }
                        break block6;
                    }
                    if (!ModList.GEOSTRATA.isLoaded() || bk != GeoBlocks.LAVAROCK.getBlockInstance()) break block10;
                    for (int i = 0; i < 16; ++i) {
                        set.add(new BlockKey(bk, i));
                    }
                    break block6;
                }
                if (bk != TwilightForestHandler.BlockEntry.NAGASTONE.getBlock()) break block11;
                for (int i = 0; i < 16; ++i) {
                    set.add(new BlockKey(bk, i));
                }
                break block6;
            }
            if (bk != TwilightForestHandler.BlockEntry.AURORA.getBlock()) break block6;
            for (int i = 0; i < 16; ++i) {
                set.add(new BlockKey(bk, i));
            }
        }
        return set;
    }

    public static int getDepth(EntityPlayer ep) {
        return ItemExcavationWand.canUseBoostedEffect(ep) ? 18 : 12;
    }

    public void onPreBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
    }

    public void onPostBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        PlayerReference p = breakers.get(b.hashCode());
        if (p != null) {
            EntityPlayer ep = p.getPlayer(world);
            if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77343_v, (ItemStack)p.getHeldItem())) {
                this.placeSomeLight(world, x, y, z);
            }
            if (ep != null) {
                this.drainPlayer(ep);
            } else {
                b.terminate();
            }
        }
    }

    private void placeSomeLight(World world, int x, int y, int z) {
        if (world.func_72957_l(x, y, z) < 8) {
            world.func_147465_d(x, y, z, ChromaBlocks.LIGHT.getBlockInstance(), BlockEtherealLight.Flags.PARTICLES.getFlag(), 3);
        }
    }

    public boolean canBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        EntityPlayer ep;
        PlayerReference p = breakers.get(b.hashCode());
        if (p != null && (ep = p.getPlayer(world)) != null) {
            return this.sufficientEnergy(ep) && this.canBreakBlock(world, x, y, z, id, meta, ep);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canBreakBlock(World world, int x, int y, int z, Block id, int meta, EntityPlayer ep) {
        if (!world.field_72995_K) {
            if (!ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)x, (int)y, (int)z, (EntityPlayerMP)((EntityPlayerMP)ep))) return false;
        }
        if (!ItemExcavationWand.spreadOn(world, x, y, z, id, meta)) return false;
        return true;
    }

    public void onFinish(ProgressiveRecursiveBreaker.ProgressiveBreaker b) {
        breakers.remove(b.hashCode());
    }
}

