/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Wands;

import Reika.ChromatiCraft.API.Interfaces.UnCopyableBlock;
import Reika.ChromatiCraft.Base.ItemWandBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ItemDuplicationWand
extends ItemWandBase {
    public static final int MAX_SIZE = Math.min(1000, ChromaOptions.COPYSIZE.getValue());
    private static HashMap<String, StructuredBlockArray> structures = new HashMap();
    private HashMap<String, Boolean> region = new HashMap();
    private HashMap<String, Coordinate> centers = new HashMap();
    private HashMap<String, Coordinate> lastClick = new HashMap();
    private static Collection<String> lock = new ArrayList<String>();
    private static final BlockMap<ItemStack> specialReqs = new BlockMap();
    private static final PlacementTicker ticker = new PlacementTicker();

    public ItemDuplicationWand(int index) {
        super(index);
        this.addEnergyCost(CrystalElement.BLACK, 4);
        this.addEnergyCost(CrystalElement.PURPLE, 2);
        this.addEnergyCost(CrystalElement.LIGHTBLUE, 4);
        TickRegistry.instance.registerTickHandler((TickRegistry.TickHandler)ticker);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        String sg = ep.func_70005_c_();
        if (world.field_72995_K) {
            return true;
        }
        if (lock.contains(sg)) {
            return false;
        }
        if (this.sufficientEnergy(ep)) {
            if (ep.func_70093_af()) {
                ChromaSounds.CAST.playSound((Entity)ep, 0.75f, 0.5f);
                this.addToStructureCache(world, x, y, z, sg);
            } else {
                StructuredBlockArray struct = structures.get(sg);
                if (struct != null && !struct.isEmpty() && this.hasItems(struct, ep) && this.sufficientEnergy(ep, 1.0f + (float)struct.getSize() / 16.0f)) {
                    this.copyStructure(world, x, y, z, s, sg);
                    if (!ep.field_71075_bZ.field_75098_d) {
                        this.drainPlayer(ep, 1.0f + (float)struct.getSize() / 16.0f);
                        this.removeFromInventory(ep, struct);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean hasItems(StructuredBlockArray blocks, EntityPlayer ep) {
        if (ep.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemHashMap items = blocks.getItems();
        this.performMappings((ItemHashMap<Integer>)items);
        return ReikaInventoryHelper.inventoryContains((ItemHashMap)items, (IInventory)ep.field_71071_by);
    }

    private void removeFromInventory(EntityPlayer ep, StructuredBlockArray blocks) {
        ItemHashMap items = blocks.getItems();
        this.performMappings((ItemHashMap<Integer>)items);
        ReikaInventoryHelper.removeFromInventory((ItemHashMap)items, (IInventory)ep.field_71071_by);
    }

    private void performMappings(ItemHashMap<Integer> items) {
        HashMap<BlockKey, Fluid> fluids = new HashMap<BlockKey, Fluid>();
        for (BlockKey bk : specialReqs.keySet()) {
            ItemStack is = bk.asItemStack();
            Integer get = (Integer)items.get(is);
            if (get == null) continue;
            items.remove(is);
            ItemStack is2 = (ItemStack)specialReqs.get(bk);
            items.put(is2, (Object)get);
        }
        for (ItemStack is : items.keySet()) {
            Fluid f;
            Block b = Block.func_149634_a((Item)is.func_77973_b());
            if (!(b instanceof BlockFluidBase) && !(b instanceof BlockLiquid) || (f = FluidRegistry.lookupFluidForBlock((Block)b)) == null) continue;
            fluids.put(new BlockKey(b, 0), f);
        }
        for (BlockKey bk : fluids.keySet()) {
            ArrayList fill;
            Fluid f = (Fluid)fluids.get(bk);
            ItemStack is = bk.asItemStack();
            Integer get = (Integer)items.get(is);
            items.remove(is);
            if (ReikaFluidHelper.isInfinite((Fluid)f) || (fill = ReikaFluidHelper.getAllContainersFor((Fluid)f)).isEmpty()) continue;
            items.put((ItemStack)fill.get(0), (Object)get);
        }
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        ItemDuplicationWand.finishPlacement(ep.func_70005_c_());
        this.clearStructureCache(ep.func_70005_c_());
        ChromaSounds.ERROR.playSound((Entity)ep, 1.0f, 0.5f);
        return is;
    }

    private void clearStructureCache(String s) {
        this.region.remove(s);
        this.centers.remove(s);
    }

    private void addToStructureCache(World world, int x, int y, int z, String s) {
        boolean second;
        StructuredBlockArray all = structures.get(s);
        Coordinate cx = new Coordinate(x, y, z);
        boolean bl = second = this.region.containsKey(s) && this.region.get(s) != false;
        if (all == null) {
            all = new StructuredBlockArray(world);
            if (!second) {
                this.centers.put(s, cx);
            }
        }
        if (second) {
            Coordinate last = this.lastClick.get(s);
            StructuredBlockArray add = new StructuredBlockArray(world);
            int x1 = Math.min(last.xCoord, x);
            int x2 = Math.max(last.xCoord, x);
            int y1 = Math.min(last.yCoord, y);
            int y2 = Math.max(last.yCoord, y);
            int z1 = Math.min(last.zCoord, z);
            int z2 = Math.max(last.zCoord, z);
            int ct = 0;
            for (int dx = x1; dx <= x2; ++dx) {
                for (int dy = y1; dy <= y2; ++dy) {
                    for (int dz = z1; dz <= z2; ++dz) {
                        if (dy < 0) continue;
                        Block b = world.func_147439_a(dx, dy, dz);
                        int meta = world.func_72805_g(dx, dy, dz);
                        if (b instanceof UnCopyableBlock && ((UnCopyableBlock)b).disallowCopy(meta) || !ChromaOptions.COPYTILE.getState() && world.func_147438_o(dx, dy, dz) instanceof TileEntityBase || (b instanceof BlockFluidBase || b instanceof BlockLiquid) && !ReikaFluidHelper.isInfinite((Fluid)FluidRegistry.lookupFluidForBlock((Block)b))) continue;
                        add.addBlockCoordinate(dx, dy, dz);
                        ++ct;
                    }
                }
            }
            if (add.getSize() < MAX_SIZE || DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
                Coordinate c = this.centers.get(s);
                add.offset(-c.xCoord, -c.yCoord, -c.zCoord);
                add.copyTo((BlockArray)all);
                structures.put(s, all);
                ChromatiCraft.logger.debug((Object)("Added " + ct + " blocks to region, from " + cx + " to " + last + ", for " + s + ". Now has " + all.getSize() + " blocks."));
                this.region.put(s, false);
                this.lastClick.remove(s);
            }
        } else {
            ChromatiCraft.logger.debug((Object)("Started drawing subregion for " + s));
            this.lastClick.put(s, cx);
            this.region.put(s, true);
        }
    }

    private void copyStructure(World world, int x, int y, int z, int s, String sg) {
        lock.add(sg);
        ItemDuplicationWand.triggerPlacement(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[s], sg);
    }

    private static void triggerPlacement(World world, int x, int y, int z, ForgeDirection dir, String s) {
        StructuredBlockArray struct = structures.get(s);
        ArrayList<PositionedBlock> ls = new ArrayList<PositionedBlock>();
        for (int i = 0; i < struct.getSize(); ++i) {
            Coordinate c = struct.getNthBlock(i);
            int dx = c.xCoord + x + dir.offsetX;
            int dy = c.yCoord + y + dir.offsetY;
            int dz = c.zCoord + z + dir.offsetZ;
            if (struct.getBlockAt(c.xCoord, c.yCoord, c.zCoord).isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord)) continue;
            ls.add(new PositionedBlock(dx, dy, dz, struct.getBlockAt(c.xCoord, c.yCoord, c.zCoord), struct.getMetaAt(c.xCoord, c.yCoord, c.zCoord)));
        }
        ticker.placing.put(s, new OperationList(world, ls));
    }

    private static void finishPlacement(String s) {
        lock.remove(s);
        structures.remove(s);
        ticker.placing.remove(s);
    }

    public static StructuredBlockArray getStructureFor(EntityPlayer ep) {
        String s = ep.func_70005_c_();
        StructuredBlockArray a = structures.get(s);
        return !lock.contains(s) && a != null ? (StructuredBlockArray)a.copy() : null;
    }

    public static void loadMappings() {
        int i;
        ItemDuplicationWand.addMapping(Blocks.field_150458_ak, Blocks.field_150346_d);
        for (i = 0; i < ReikaCropHelper.cropList.length; ++i) {
            ReikaCropHelper crop = ReikaCropHelper.cropList[i];
            ItemDuplicationWand.addMapping(crop.blockID, crop.getSeedItem());
        }
        for (i = 0; i < 16; ++i) {
            ItemDuplicationWand.addMapping(ChromaBlocks.PLANT.getBlockInstance(), i, ChromaItems.SEED.getStackOfMetadata(i));
        }
        if (ModList.ROTARYCRAFT.isLoaded()) {
            ItemDuplicationWand.addMapping(BlockRegistry.CANOLA.getBlockInstance(), ItemRegistry.CANOLA.getItemInstance());
        }
        ItemDuplicationWand.addMapping(Blocks.field_150436_aH, Items.field_151120_aE);
        ItemDuplicationWand.addMapping(Blocks.field_150393_bb, Items.field_151080_bb);
        ItemDuplicationWand.addMapping(Blocks.field_150394_bc, Items.field_151081_bc);
        ItemDuplicationWand.addMapping(Blocks.field_150418_aU, 0, Blocks.field_150348_b);
        ItemDuplicationWand.addMapping(Blocks.field_150418_aU, 1, Blocks.field_150347_e);
        ItemDuplicationWand.addMapping(Blocks.field_150418_aU, 2, Blocks.field_150417_aV);
        ItemDuplicationWand.addMapping(Blocks.field_150418_aU, 3, ReikaItemHelper.mossyBricks);
        ItemDuplicationWand.addMapping(Blocks.field_150418_aU, 4, ReikaItemHelper.crackBricks);
        ItemDuplicationWand.addMapping(Blocks.field_150418_aU, 5, ReikaItemHelper.circleBricks);
        ItemDuplicationWand.addMapping(Blocks.field_150439_ay, Blocks.field_150450_ax);
        ItemDuplicationWand.addMapping(Blocks.field_150437_az, Blocks.field_150429_aA);
        ItemDuplicationWand.addMapping((Block)Blocks.field_150413_aR, Items.field_151107_aW);
        ItemDuplicationWand.addMapping((Block)Blocks.field_150416_aS, Items.field_151107_aW);
        ItemDuplicationWand.addMapping((Block)Blocks.field_150441_bU, Items.field_151132_bS);
        ItemDuplicationWand.addMapping((Block)Blocks.field_150455_bV, Items.field_151132_bS);
        ItemDuplicationWand.addMapping(Blocks.field_150382_bo, Items.field_151067_bt);
        ItemDuplicationWand.addMapping((Block)Blocks.field_150383_bp, Items.field_151066_bu);
        ItemDuplicationWand.addMapping(Blocks.field_150444_as, Items.field_151155_ap);
        ItemDuplicationWand.addMapping(Blocks.field_150472_an, Items.field_151155_ap);
        ItemDuplicationWand.addMapping(Blocks.field_150466_ao, Items.field_151135_aq);
        ItemDuplicationWand.addMapping(Blocks.field_150454_av, Items.field_151139_aw);
        ItemDuplicationWand.addMapping(Blocks.field_150470_am, Blocks.field_150460_al);
        ItemDuplicationWand.addMapping(Blocks.field_150457_bL, Items.field_151162_bE);
        ItemDuplicationWand.addMapping(Blocks.field_150473_bD, Items.field_151007_F);
        for (i = 0; i < 3; ++i) {
            ItemDuplicationWand.addMapping(Blocks.field_150465_bP, i, new ItemStack(Items.field_151144_bL, 1, i));
        }
    }

    private static void addMapping(Block b, int m, Block i) {
        ItemDuplicationWand.addMapping(b, m, new ItemStack(i));
    }

    private static void addMapping(Block b, Block i) {
        ItemDuplicationWand.addMapping(b, 0, new ItemStack(i));
    }

    private static void addMapping(Block b, int m, Item i) {
        ItemDuplicationWand.addMapping(b, m, new ItemStack(i));
    }

    private static void addMapping(Block b, Item i) {
        ItemDuplicationWand.addMapping(b, 0, new ItemStack(i));
    }

    private static void addMapping(Block b, ItemStack is) {
        ItemDuplicationWand.addMapping(b, 0, is);
    }

    private static void addMapping(Block b, int m, ItemStack is) {
        specialReqs.put(b, m, (Object)is);
    }

    private static class PrimacySorter
    implements Comparator<PositionedBlock> {
        private PrimacySorter() {
        }

        @Override
        public int compare(PositionedBlock o1, PositionedBlock o2) {
            return PrimacySorter.getIndex(o1.block) - PrimacySorter.getIndex(o2.block);
        }

        private static int getIndex(Block b) {
            if (b.func_149662_c()) {
                return 0;
            }
            if (b instanceof BlockFarmland || b instanceof BlockSlab || b instanceof BlockGlass) {
                return 1;
            }
            if (b instanceof BlockLeavesBase || b instanceof BlockStairs) {
                return 1;
            }
            if (b instanceof BlockBush || b.func_149688_o() == Material.field_151570_A || b.func_149688_o() == Material.field_151585_k) {
                return 2;
            }
            if (b.func_149688_o() == Material.field_151594_q || b.func_149688_o() == Material.field_151593_r || b.func_149688_o() == Material.field_151567_E) {
                return 2;
            }
            if (b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151569_G || b.func_149688_o() == Material.field_151597_y) {
                return 2;
            }
            if (b == Blocks.field_150478_aa || b == Blocks.field_150429_aA || b == Blocks.field_150437_az || b instanceof BlockDoor) {
                return 2;
            }
            if (b instanceof BlockLiquid || b instanceof BlockFluidBase || b.func_149688_o() == Material.field_151586_h || b.func_149688_o() == Material.field_151587_i) {
                return 3;
            }
            if (b == Blocks.field_150350_a || b.func_149688_o() == Material.field_151579_a || b instanceof BlockAir) {
                return 4;
            }
            return 0;
        }
    }

    private static class OperationList {
        private static final PrimacySorter sorter = new PrimacySorter();
        private final ArrayList<PositionedBlock> list;
        private int index = 0;
        private final int dimension;

        private OperationList(World world, ArrayList<PositionedBlock> li) {
            this.list = new ArrayList<PositionedBlock>(li);
            this.dimension = world.field_73011_w.field_76574_g;
            Collections.shuffle(this.list);
            Collections.sort(this.list, sorter);
        }

        public boolean isDone() {
            return this.index >= this.list.size();
        }
    }

    private static class PositionedBlock {
        private final Coordinate coord;
        private final Block block;
        private final int meta;

        private PositionedBlock(int x, int y, int z, Block b, int m) {
            this(new Coordinate(x, y, z), b, m);
        }

        private PositionedBlock(Coordinate c, Block b, int m) {
            this.coord = c;
            this.block = b;
            this.meta = m;
        }

        private void place(World world) {
            if (this.block == Blocks.field_150350_a || this.block instanceof BlockAir) {
                Block b2 = this.coord.getBlock(world);
                if (b2 == Blocks.field_150350_a) {
                    ChromaSounds.ERROR.playSoundAtBlock(world, this.coord.xCoord, this.coord.yCoord, this.coord.zCoord, 0.25f, 2.0f);
                } else {
                    ReikaSoundHelper.playBreakSound((World)world, (int)this.coord.xCoord, (int)this.coord.yCoord, (int)this.coord.zCoord, (Block)b2);
                }
            } else {
                ReikaSoundHelper.playPlaceSound((World)world, (int)this.coord.xCoord, (int)this.coord.yCoord, (int)this.coord.zCoord, (Block)this.block);
            }
            if (!world.field_72995_K) {
                this.coord.setBlock(world, this.block, this.meta);
            }
        }

        public String toString() {
            return Block.func_149682_b((Block)this.block) + ":" + this.meta + " @ " + this.coord.toString();
        }
    }

    public static class PlacementTicker
    implements TickRegistry.TickHandler {
        private HashMap<String, OperationList> placing = new HashMap();

        private PlacementTicker() {
        }

        public void tick(TickRegistry.TickType type, Object ... tickData) {
            World world = (World)tickData[0];
            ArrayList<String> end = new ArrayList<String>();
            for (String s : this.placing.keySet()) {
                OperationList o = this.placing.get(s);
                if (o.dimension != world.field_73011_w.field_76574_g) continue;
                ArrayList li = o.list;
                PositionedBlock b = (PositionedBlock)li.get(o.index);
                b.place(world);
                o.index++;
                if (!o.isDone()) continue;
                end.add(s);
                ItemDuplicationWand.finishPlacement(s);
            }
            for (String s : end) {
                this.placing.remove(s);
            }
        }

        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.WORLD);
        }

        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.START;
        }

        public String getLabel() {
            return "Duplicator";
        }
    }
}

