/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools.Wands;

import Reika.ChromatiCraft.Base.ItemWandBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Interfaces.Item.EntityCapturingItem;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemCaptureWand
extends ItemWandBase
implements EntityCapturingItem {
    private final ElementTagCompound perTick;
    private static final String NBT_TAG = "mob";

    public ItemCaptureWand(int index) {
        super(index);
        this.addEnergyCost(CrystalElement.PINK, 10);
        this.addEnergyCost(CrystalElement.LIME, 20);
        this.addEnergyCost(CrystalElement.LIGHTGRAY, 50);
        this.perTick = this.getEnergy(0.1f);
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int slot, boolean held) {
        if (held && ItemCaptureWand.hasMob(is)) {
            EntityPlayer ep = (EntityPlayer)e;
            if (!ep.field_71075_bZ.field_75098_d) {
                if (PlayerElementBuffer.instance.playerHas(ep, this.perTick)) {
                    PlayerElementBuffer.instance.removeFromPlayer(ep, this.perTick);
                } else {
                    this.releaseMob(is, ep, world, MathHelper.func_76128_c((double)ep.field_70165_t), MathHelper.func_76128_c((double)ep.field_70163_u), MathHelper.func_76128_c((double)ep.field_70161_v));
                    ChromaSounds.ERROR.playSound((Entity)ep);
                }
            }
        }
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (ItemCaptureWand.hasMob(is)) {
            double x = ep.field_70165_t;
            double y = ep.field_70163_u;
            double z = ep.field_70161_v;
            Vec3 vec = ep.func_70040_Z();
            vec.field_72450_a *= 2.0;
            vec.field_72448_b *= 5.0;
            vec.field_72449_c *= 2.0;
            int dx = MathHelper.func_76128_c((double)(x + vec.field_72450_a));
            int dy = MathHelper.func_76128_c((double)(y + vec.field_72448_b));
            int dz = MathHelper.func_76128_c((double)(z + vec.field_72449_c));
            this.releaseMob(is, ep, world, dx, dy, dz);
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        if (ItemCaptureWand.hasMob(is)) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (this.releaseMob(is, ep, world, dx, dy, dz)) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack is) {
        return ItemCaptureWand.hasMob(is);
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        if (ItemCaptureWand.hasMob(is)) {
            EntityLiving e = ItemCaptureWand.getMob(is, ep.field_70170_p);
            li.add(String.format("Contains a %s.", EntityList.func_75621_b((Entity)e)));
            li.add(String.format("Health: %.0f hearts", Float.valueOf(e.func_110143_aJ() / 2.0f)));
        } else {
            li.add("Contains no mob.");
        }
    }

    public boolean func_111207_a(ItemStack is, EntityPlayer ep, EntityLivingBase elb) {
        if (!ItemCaptureWand.hasMob(is) && elb instanceof EntityLiving && ItemCaptureWand.isEntityCapturable((EntityLiving)elb) && this.sufficientEnergy(ep)) {
            this.captureMob(is, ep, (EntityLiving)elb);
            ep.func_70062_b(0, is);
            return true;
        }
        return false;
    }

    private void captureMob(ItemStack is, EntityPlayer ep, EntityLiving el) {
        ItemCaptureWand.setMob(is, el);
        this.drainPlayer(ep);
        el.func_70106_y();
    }

    private boolean releaseMob(ItemStack is, EntityPlayer ep, World world, int x, int y, int z) {
        EntityLiving e = ItemCaptureWand.getMob(is, world);
        if (e != null) {
            this.drainPlayer(ep);
            e.func_70107_b((double)x + 0.5, (double)y, (double)z + 0.5);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)e);
            }
            is.field_77990_d.func_82580_o(NBT_TAG);
            return true;
        }
        return false;
    }

    private static boolean isEntityCapturable(EntityLiving e) {
        return !ReikaEntityHelper.isBossMob((EntityLiving)e);
    }

    private static void setMob(ItemStack is, EntityLiving e) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", EntityList.func_75621_b((Entity)e));
        NBTTagCompound dat = new NBTTagCompound();
        e.func_70109_d(dat);
        nbt.func_74782_a("data", (NBTBase)dat);
        is.field_77990_d.func_74782_a(NBT_TAG, (NBTBase)nbt);
    }

    public static EntityLiving getMob(ItemStack is, World world) {
        String n = ItemCaptureWand.getEntityName(is);
        EntityLiving e = (EntityLiving)EntityList.func_75620_a((String)n, (World)world);
        if (e == null) {
            return null;
        }
        NBTTagCompound mob = is.field_77990_d.func_74775_l(NBT_TAG);
        NBTTagCompound dat = mob.func_74775_l("data");
        e.func_70020_e(dat);
        return e;
    }

    private static String getEntityName(ItemStack is) {
        if (is.field_77990_d == null || !is.field_77990_d.func_74764_b(NBT_TAG)) {
            return null;
        }
        NBTTagCompound mob = is.field_77990_d.func_74775_l(NBT_TAG);
        return mob.func_74779_i("name");
    }

    private static boolean hasMob(ItemStack is) {
        return is.field_77990_d != null && is.field_77990_d.func_74764_b(NBT_TAG);
    }

    public boolean hasEntity(ItemStack is) {
        return ItemCaptureWand.hasMob(is);
    }

    public String currentEntityName(ItemStack is) {
        return ItemCaptureWand.getEntityName(is);
    }
}

