/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.World.IWG.DungeonGenerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Instantiable.Formula.PeriodicExpression;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.ParticleController.FlashColorController;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemStructureFinder
extends ItemChromaTool {
    private static final double RANGE = 512.0;
    private static final double FUZZ = 96.0;
    private static ChromaStructures.Structures[] TYPES;
    private static final int[] COLORS;
    private static final Random rand;

    public ItemStructureFinder(int index) {
        super(index);
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int slot, boolean held) {
        if (held && e instanceof EntityPlayer && !world.field_72995_K) {
            int type;
            WorldLocation loc;
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            if ((loc = DungeonGenerator.instance.getNearestStructure(TYPES[type = this.getStructureType(is)], world, e.field_70165_t, e.field_70163_u, e.field_70161_v, 512.0)) != null) {
                double dist = loc.getDistanceTo(e);
                if (dist <= 96.0) {
                    double px = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70165_t, (double)96.0);
                    double py = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70163_u, (double)96.0);
                    double pz = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70161_v, (double)96.0);
                    this.sendParticle((EntityPlayer)e, px, py, pz, TYPES[type], true);
                } else {
                    double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)loc.xCoord + 0.5), (double)96.0);
                    double py = ReikaRandomHelper.getRandomPlusMinus((double)((double)loc.yCoord + 0.5), (double)96.0);
                    double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)loc.zCoord + 0.5), (double)96.0);
                    this.sendParticle((EntityPlayer)e, px, py, pz, TYPES[type], false);
                }
            }
        }
    }

    private void sendParticle(EntityPlayer ep, double sx, double sy, double sz, ChromaStructures.Structures s, boolean close) {
        if (ep instanceof EntityPlayerMP) {
            PacketTarget.PlayerTarget pt = new PacketTarget.PlayerTarget((EntityPlayerMP)ep);
            ReikaPacketHelper.sendPositionPacket((String)"ChromaData", (int)ChromaPackets.STRUCTFIND.ordinal(), (World)ep.field_70170_p, (double)sx, (double)sy, (double)sz, (PacketTarget)pt, (int[])new int[]{s.ordinal(), close ? 1 : 0});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doHeldFX(EntityPlayer ep, double sx, double sy, double sz, ChromaStructures.Structures s, boolean close) {
        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)0.0625, (double)(-ep.field_70125_A), (double)(ep.field_70759_as + 90.0f + 60.0f));
        double px = ep.field_70165_t + xyz[0];
        double py = ep.field_70163_u + xyz[1];
        double pz = ep.field_70161_v + xyz[2];
        double dx = sx - px;
        double dy = sy - py;
        double dz = sz - pz;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double v = 0.015625;
        double vx = dx / dd * v;
        double vy = dy / dd * v;
        double vz = dz / dd * v;
        float sc = 0.125f + rand.nextFloat() * 0.25f;
        int l = 10;
        int c = COLORS[s.ordinal()];
        EntityBlurFX fx = new EntityBlurFX(ep.field_70170_p, px, py, pz, vx, vy, vz);
        if (close) {
            l *= 2;
            sc = (float)((double)sc * 0.5);
            fx.setIcon(ChromaIcons.FADE_RAY);
            double d = rand.nextDouble() * 360.0;
            PeriodicExpression e = new PeriodicExpression().addWave(0.5, 16.0, d).normalize();
            fx.setColorController((ColorController)new FlashColorController((MathExpression)e, c, 0xFFFFFF));
            fx.field_70159_w *= 0.375;
            fx.field_70181_x *= 0.375;
            fx.field_70179_y *= 0.375;
        }
        fx.setLife(10).setScale(sc).setColor(c);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private int getStructureType(ItemStack is) {
        if (TYPES == null) {
            TYPES = DungeonGenerator.instance.getStructureTypes().toArray(new ChromaStructures.Structures[DungeonGenerator.instance.getStructureTypes().size()]);
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        int type = is.field_77990_d != null ? is.field_77990_d.func_74762_e("type") : 0;
        return type;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            int type = this.getStructureType(is);
            li.add(String.format("Type: " + (Object)((Object)TYPES[type]), new Object[0]));
        }
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        int type = this.getStructureType(is);
        type = (type + 1) % TYPES.length;
        is.field_77990_d.func_74768_a("type", type);
        return is;
    }

    static {
        COLORS = new int[ChromaStructures.Structures.structureList.length];
        ItemStructureFinder.COLORS[ChromaStructures.Structures.BURROW.ordinal()] = 7976835;
        ItemStructureFinder.COLORS[ChromaStructures.Structures.CAVERN.ordinal()] = 9413557;
        ItemStructureFinder.COLORS[ChromaStructures.Structures.OCEAN.ordinal()] = 6341828;
        ItemStructureFinder.COLORS[ChromaStructures.Structures.DESERT.ordinal()] = 12543325;
        rand = new Random();
    }
}

