/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Auxiliary.TemporaryCrystalReceiver;
import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Orbit;
import Reika.DragonAPI.Instantiable.ParticleController.OrbitMotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemPurifyCrystal
extends ItemChromaTool {
    private static final String TAG = "last_purify";
    public static final int CHARGE_STATES = 4;
    public static final int MAX_CHARGE = 2592000;

    public ItemPurifyCrystal(int index) {
        super(index);
    }

    public void func_150895_a(Item i, CreativeTabs c, List li) {
        li.add(this.getChargedItem(0));
        li.add(this.getChargedItem(2592000));
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        Object[] objectArray = new Object[2];
        objectArray[0] = Float.valueOf(100.0f * (float)ItemPurifyCrystal.getCharge(is) / 2592000.0f);
        objectArray[1] = "%";
        li.add(String.format("Energy: %.2f%s", objectArray));
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int slot, boolean held) {
        if (e instanceof EntityPlayer) {
            if (ItemPurifyCrystal.getCharge(is) > 0) {
                e.getEntityData().func_74772_a(TAG, world.func_82737_E());
                ItemPurifyCrystal.removeCharge(is, CrystalPotionController.isWorldHostile(world) ? 12 : 1);
                if (world.field_72995_K) {
                    this.doHeldFX(is, e);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doHeldFX(ItemStack is, Entity e) {
        if (field_77697_d.nextInt(8) == 0) {
            double r = 2.5;
            double ec = 0.0;
            double i = e.field_70173_aa * 4;
            double raan = 0.0;
            Orbit o = new Orbit(r, ec, i, raan, 0.0, 0.0);
            OrbitMotionController p = new OrbitMotionController(o, e.field_70165_t, e.field_70163_u, e.field_70161_v).trackEntity(e);
            p.thetaSpeed = ReikaRandomHelper.getRandomBetween((double)1.5, (double)5.0);
            int l = 60 + field_77697_d.nextInt(120);
            float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.25);
            EntityBlurFX fx = new EntityBlurFX(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v).setPositionController((PositionController)p).setLife(l).setIcon(ChromaIcons.CENTER).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public int getEntityLifespan(ItemStack is, World world) {
        return Integer.MAX_VALUE;
    }

    public boolean onEntityItemUpdate(EntityItem ei) {
        int charge = ItemPurifyCrystal.getCharge(ei.func_92059_d());
        if (!ei.field_70170_p.field_72995_K) {
            if (charge < 2592000) {
                int range = 32;
                WorldLocation loc = new WorldLocation((Entity)ei);
                TemporaryCrystalReceiver r = new TemporaryCrystalReceiver(loc, 0, range, 0.0625, ChromaResearchManager.ResearchLevel.ENDGAME);
                ItemStack is = ei.func_92059_d();
                int amt = ItemPurifyCrystal.getChargeRate(is);
                CrystalElement e = CrystalElement.WHITE;
                CrystalSource s = CrystalNetworker.instance.getNearestTileOfType(r, CrystalSource.class, range);
                if (s != null) {
                    s.drain(e, amt * 4);
                    if (s instanceof TileEntityCrystalPylon) {
                        amt = (int)((double)amt * 1.25);
                        if (((TileEntityCrystalPylon)s).isEnhanced()) {
                            amt = (int)((double)amt * 1.5);
                        }
                    }
                    if (loc.getBlock() == ChromaBlocks.CHROMA.getBlockInstance() && loc.getBlockMetadata() == 0) {
                        amt = (int)((double)amt * 1.25);
                    }
                    ItemPurifyCrystal.addCharge(is, amt);
                    ReikaPacketHelper.sendEntitySyncPacket((String)"DragonAPIData", (Entity)ei, (double)32.0);
                }
            }
        } else if (charge > 0) {
            this.doChargeFX(ei, charge);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void doChargeFX(EntityItem ei, int charge) {
        if (charge == 2592000) {
            double ang = 360.0 * Math.sin((double)ei.field_70292_b / 50.0);
            for (int i = 0; i < 360; i += 60) {
                double v = 0.125 + 0.0625 * Math.sin((double)ei.field_70292_b / 250.0);
                double vx = v * Math.cos(Math.toRadians(ang + (double)i));
                double vz = v * Math.sin(Math.toRadians(ang + (double)i));
                EntityBlurFX fx = new EntityBlurFX(ei.field_70170_p, ei.field_70165_t, (double)((int)ei.field_70163_u) + 0.25, ei.field_70161_v, vx, 0.0, vz).setLife(40).setRapidExpand().setScale(1.5f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        } else {
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
            double[] vel = ReikaPhysicsHelper.polarToCartesian((double)v, (double)(field_77697_d.nextDouble() * 360.0), (double)(field_77697_d.nextDouble() * 360.0));
            float s = 1.0f + field_77697_d.nextFloat();
            EntityBlurFX fx = new EntityBlurFX(ei.field_70170_p, ei.field_70165_t, (double)((int)ei.field_70163_u) + 0.25, ei.field_70161_v, vel[0], vel[1], vel[2]).setLife(40).setScale(s).setColliding();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public static boolean isActive(EntityPlayer ep) {
        return ep.field_70170_p.func_82737_E() - ep.getEntityData().func_74763_f(TAG) < 20L;
    }

    private static int getChargeRate(ItemStack is) {
        int get = ItemPurifyCrystal.getCharge(is);
        return (int)(5.0 * Math.min(20.0, 1.0 + 100.0 * ReikaMathLibrary.cosInterpolation((double)0.0, (double)2592000.0, (double)get)));
    }

    public ItemStack getChargedItem(int charge) {
        ItemStack is = new ItemStack((Item)this);
        ItemPurifyCrystal.addCharge(is, charge);
        return is;
    }

    public static int addCharge(ItemStack is, int amt) {
        int get = ItemPurifyCrystal.getCharge(is);
        amt = Math.min(amt, 2592000 - get);
        ItemPurifyCrystal.setCharge(is, get + amt);
        return amt;
    }

    public static int removeCharge(ItemStack is, int amt) {
        int get = ItemPurifyCrystal.getCharge(is);
        amt = Math.min(get, amt);
        ItemPurifyCrystal.setCharge(is, get - amt);
        return amt;
    }

    private static void setCharge(ItemStack is, int amt) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("charge", MathHelper.func_76125_a((int)amt, (int)0, (int)2592000));
        is.func_77964_b(Math.round((float)(3 * ItemPurifyCrystal.getCharge(is)) / 2592000.0f));
    }

    public static int getCharge(ItemStack is) {
        return is.field_77990_d != null ? is.field_77990_d.func_74762_e("charge") : 0;
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        return super.getItemSpriteIndex(item) + item.func_77960_j();
    }
}

