/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.DragonAPI.Instantiable.ParticleController.CollectingPositionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemKillAuraGun
extends ItemChromaTool {
    public static final int CHARGE_TIME = 100;
    public static final int BASE_DAMAGE = 12;
    public static final int MAX_DAMAGE = 18;
    public static final int RANGE = 12;
    public static final float RANGE_FALLOFF = 0.5f;
    public static final float ANGLE_FALLOFF = 0.058333334f;
    public static final float CHARGE_FALLOFF = 0.12f;
    private static int useTick;
    private static int useTickUnbounded;

    public ItemKillAuraGun(int index) {
        super(index);
    }

    private static boolean fire(ItemStack is, EntityPlayer ep, int power) {
        ++power;
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)ep, (double)12.0);
        List li = ep.field_70170_p.func_72872_a(EntityLivingBase.class, box);
        for (Entity e : li) {
            float dmg;
            if (e == ep || !((dmg = ItemKillAuraGun.getWallAttackDamage(is, ep, e, power)) > 0.0f)) continue;
            e.func_70097_a((DamageSource)new ReikaEntityHelper.WrappedDamageSource(DamageSource.field_76376_m, ep), dmg);
        }
        ChromaSounds.KILLAURA.playSound((Entity)ep, 1.0f, 0.4f + 0.6f * (float)power / 100.0f);
        if (ep.field_70170_p.field_72995_K) {
            ItemKillAuraGun.doFireParticles(ep, power);
        }
        return false;
    }

    private static float getFalloffFactor(ItemStack is) {
        return 1.0f - (float)ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)ChromaEnchants.WEAPONAOE.getEnchantment(), (ItemStack)is) / 10.0f;
    }

    private static float getRawDamage(ItemStack is) {
        float f = 0.6f;
        return 12.0f + (float)ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77345_t, (ItemStack)is) * f;
    }

    @SideOnly(value=Side.CLIENT)
    private static void doFireParticles(EntityPlayer ep, int power) {
        int n = (128 + field_77697_d.nextInt(128)) * power / 100;
        Vec3 vec = ep.func_70040_Z();
        double r = 0.5;
        double lx = ep.field_70165_t + vec.field_72450_a * r;
        double ly = ep.field_70163_u + vec.field_72448_b * r;
        double lz = ep.field_70161_v + vec.field_72449_c * r;
        for (int i = 0; i < n; ++i) {
            double phi = field_77697_d.nextDouble() * 360.0;
            double theta = field_77697_d.nextDouble() * 360.0;
            boolean flag = false;
            int d = field_77697_d.nextInt(4);
            if (d > 0) {
                double b = d % 2 == 0 ? 10.0 : 5.0;
                phi = ReikaRandomHelper.getRandomPlusMinus((double)(90.0f + ep.field_70759_as), (double)b);
                theta = ReikaRandomHelper.getRandomPlusMinus((double)(-ep.field_70125_A), (double)b);
                flag = true;
            }
            float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)2.0, (double)1.0);
            if (!flag) {
                s *= 2.0f;
            }
            ChromaIcons ico = ChromaIcons.FLARE;
            switch (field_77697_d.nextInt(3)) {
                case 0: {
                    ico = ChromaIcons.CENTER;
                    break;
                }
                case 1: {
                    ico = ChromaIcons.NODE2;
                }
            }
            EntityFloatingSeedsFX fx = (EntityFloatingSeedsFX)new EntityFloatingSeedsFX(ep.field_70170_p, lx, ly, lz, phi, theta).setColor(0xFFFFFF).setNoSlowdown().setScale(s).setIcon(ico);
            fx.particleVelocity *= 2.0 * ReikaRandomHelper.getRandomPlusMinus((double)4.0, (double)1.5);
            fx.freedom *= ReikaRandomHelper.getRandomPlusMinus((double)1.5, (double)0.5);
            fx.angleVelocity *= ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.75);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private static float getWallAttackDamage(ItemStack is, EntityPlayer ep, Entity e, int power) {
        double d = e.func_70032_d((Entity)ep);
        if (d <= 12.0) {
            double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(e.field_70165_t - ep.field_70165_t), (double)(e.field_70163_u - ep.field_70163_u), (double)(e.field_70161_v - ep.field_70161_v));
            angs[1] = angs[1] - 90.0 - (double)ep.field_70125_A;
            angs[2] = 180.0 - angs[2] - (double)ep.field_70759_as;
            angs[1] = Math.abs(MathHelper.func_76138_g((double)angs[1]));
            angs[2] = Math.abs(MathHelper.func_76138_g((double)angs[2]));
            double da = ReikaMathLibrary.py3d((double)angs[2], (double)0.0, (double)angs[1]);
            float f = ItemKillAuraGun.getFalloffFactor(is);
            double dmg = (double)ItemKillAuraGun.getRawDamage(is) - (double)(0.5f * f) * Math.max(0.0, d - 2.0) - (double)(0.058333334f * f) * da - (double)((float)(100 - power) * 0.12f);
            return (float)Math.max(1.0, dmg);
        }
        return 0.0f;
    }

    public void func_77615_a(ItemStack is, World world, EntityPlayer ep, int count) {
        count = MathHelper.func_76125_a((int)(this.func_77626_a(is) - count), (int)0, (int)100);
        if (count > 10) {
            ItemKillAuraGun.fire(is, ep, count);
        }
        useTick = 0;
        useTickUnbounded = 0;
        ep.func_71008_a(null, 0);
    }

    public ItemStack func_77654_b(ItemStack is, World world, EntityPlayer ep) {
        return is;
    }

    public int func_77626_a(ItemStack is) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack is) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        ep.func_71008_a(is, this.func_77626_a(is));
        return is;
    }

    public void onUsingTick(ItemStack is, EntityPlayer ep, int count) {
        useTickUnbounded = count = this.func_77626_a(is) - count;
        count = MathHelper.func_76125_a((int)count, (int)0, (int)100);
        if (ep.field_70170_p.field_72995_K) {
            this.doChargingParticles(ep, count);
            useTick = count;
        }
        if (!ep.field_70170_p.field_72995_K) {
            ChromaSounds.KILLAURA_CHARGE.playSound((Entity)ep, 0.25f + 2.0f * (float)count / 100.0f, MathHelper.func_76131_a((float)0.5f, (float)(2.0f * (float)count / 100.0f), (float)2.0f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getUseTick() {
        return useTick;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getUnboundedUseTick() {
        return useTickUnbounded;
    }

    @SideOnly(value=Side.CLIENT)
    private void doChargingParticles(EntityPlayer ep, int power) {
        int n;
        double f = Math.pow(0.125f + 2.0f * (float)power / 100.0f, 2.0);
        if (ReikaRandomHelper.doWithChance((double)(f - (double)(n = (int)f)))) {
            ++n;
        }
        Vec3 vec = ep.func_70040_Z();
        double r = 0.5;
        double lx = ep.field_70165_t + vec.field_72450_a * r;
        double ly = ep.field_70163_u + vec.field_72448_b * r;
        double lz = ep.field_70161_v + vec.field_72449_c * r;
        for (int i = 0; i < n; ++i) {
            double dx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.25);
            double dy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.25);
            double dz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.25);
            double px = lx + dx;
            double py = ly + dy;
            double pz = lz + dz;
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125);
            double vx = -v * dx;
            double vy = -v * dx;
            double vz = -v * dx;
            int t = 6 + field_77697_d.nextInt(5);
            CollectingPositionController p = new CollectingPositionController(px, py, pz, lx, ly, lz, t);
            EntityBlurFX fx = new EntityBlurFX(ep.field_70170_p, px, py, pz).setLife(t).setScale(0.5f).setPositionController((PositionController)p).setIcon(ChromaIcons.FLARE);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public int getItemEnchantability(ItemStack is) {
        return Items.field_151050_s.getItemEnchantability(is);
    }
}

