/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items.Tools;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.AuraPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemInventoryLinker
extends ItemChromaTool
implements AuraPowered {
    public ItemInventoryLinker(int index) {
        super(index);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer ep, World world, int x, int y, int z, int s, float a, float b, float c) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            ItemInventoryLinker.link(is, te);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (ep.func_70093_af()) {
            is.func_77964_b(0);
            ItemInventoryLinker.setMode(is, ItemInventoryLinker.getMode(is).next());
        } else {
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.LINK.ordinal(), world, 0, 0, 0);
        }
        return is;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        if (is.field_77990_d != null) {
            if (is.field_77990_d.func_74764_b("link")) {
                WorldLocation loc = WorldLocation.readFromNBT((String)"link", (NBTTagCompound)is.field_77990_d);
                if (loc != null) {
                    if (loc.getWorld() != null) {
                        Block id = loc.getBlock();
                        if (id != Blocks.field_150350_a && loc.getTileEntity() instanceof IInventory) {
                            li.add("Linked to " + id.func_149732_F() + " at " + loc);
                        } else if (id != Blocks.field_150350_a) {
                            li.add("Linked block " + id.func_149732_F());
                            li.add("at " + loc + " is invalid.");
                        } else {
                            li.add("Linked block at " + loc);
                            li.add("is missing.");
                        }
                    } else {
                        li.add("Linked to " + loc);
                    }
                } else {
                    li.add("Invalid link");
                }
            } else {
                li.add("No link");
            }
            Mode m = ItemInventoryLinker.getMode(is);
            switch (m) {
                case EVERYTHING: {
                    li.add("Sending all items");
                    break;
                }
                case NOTHING: {
                    li.add("Sending no items");
                    break;
                }
                case BLACKLIST: {
                    li.add("Sending everything except:");
                    break;
                }
                case WHITELIST: {
                    li.add("Sending:");
                }
            }
            if (m.usesInventory() && is.field_77990_d.func_74764_b("items")) {
                if (Keyboard.isKeyDown((int)42)) {
                    for (KeyedItemStack in : ItemInventoryLinker.getItemList(is)) {
                        li.add(">>" + in.getCriteriaAsChatFormatting() + in.getItemStack().func_82833_r());
                    }
                } else {
                    li.add(EnumChatFormatting.GREEN + "Hold shift for item data");
                }
            }
        }
    }

    @Override
    public ElementTagCompound getRequirements(ItemStack is) {
        return new ElementTagCompound();
    }

    private static boolean canLinkItems(EntityPlayer ep, ItemStack tool) {
        return true;
    }

    public static boolean linksItem(EntityPlayer ep, ItemStack tool, ItemStack is) {
        return ItemInventoryLinker.canLinkItems(ep, tool) && ItemInventoryLinker.getMode(tool).linksItem(tool, is);
    }

    public static Mode getMode(ItemStack tool) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        return Mode.list[tool.field_77990_d.func_74762_e("mode")];
    }

    private static void setMode(ItemStack tool, Mode mode) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        tool.field_77990_d.func_74768_a("mode", mode.ordinal());
    }

    public static ArrayList<Filter> getFilters(ItemStack is) {
        ArrayList<Filter> li = new ArrayList<Filter>();
        if (is.field_77990_d != null && is.field_77990_d.func_74764_b("filter")) {
            NBTTagList items = is.field_77990_d.func_150295_c("filter", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            for (NBTTagCompound nbt : items.field_74747_a) {
                String s = nbt.func_74779_i("filterType");
                Filter f = ItemInventoryLinker.constructFilter(s);
                if (f == null) {
                    ChromatiCraft.logger.logError((Object)("Error reading item filter for " + is.func_82833_r() + "; unrecognized type " + s));
                    continue;
                }
                f.readFromNBT(nbt);
                li.add(f);
            }
        }
        return li;
    }

    public static final HashSet<KeyedItemStack> getItemList(ItemStack tool) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        if (tool.field_77990_d.func_74764_b("items")) {
            return ItemInventoryLinker.loadItemList(tool.field_77990_d.func_150295_c("items", ReikaNBTHelper.NBTTypes.COMPOUND.ID));
        }
        ArrayList<Filter> li = ItemInventoryLinker.getFilters(tool);
        HashSet<KeyedItemStack> set = new HashSet<KeyedItemStack>();
        for (Filter f : li) {
            KeyedItemStack ks = f.getKey();
            if (set.contains(ks)) continue;
            set.add(ks);
        }
        return set;
    }

    private static HashSet<KeyedItemStack> loadItemList(NBTTagList tag) {
        HashSet<KeyedItemStack> set = new HashSet<KeyedItemStack>();
        for (NBTTagCompound nbt : tag.field_74747_a) {
            KeyedItemStack item = KeyedItemStack.readFromNBT((NBTTagCompound)nbt);
            if (set.contains(item)) continue;
            set.add(item);
        }
        return set;
    }

    private static void saveItemList(NBTTagCompound tag, HashSet<KeyedItemStack> set) {
        NBTTagList li = new NBTTagList();
        for (KeyedItemStack is : set) {
            NBTTagCompound nbt = new NBTTagCompound();
            is.writeToNBT(nbt);
            li.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a("items", (NBTBase)li);
    }

    private static Filter constructFilter(String s) {
        try {
            Class<?> c = Class.forName(s);
            Constructor<?> con = c.getDeclaredConstructor(new Class[0]);
            con.setAccessible(true);
            return (Filter)con.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setFilters(ItemStack is, ArrayList<Filter> li) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_82580_o("items");
        NBTTagList items = new NBTTagList();
        for (Filter f : li) {
            NBTTagCompound nbt = new NBTTagCompound();
            f.writeToNBT(nbt);
            nbt.func_74778_a("filterType", f.getClass().getName());
            items.func_74742_a((NBTBase)nbt);
        }
        is.field_77990_d.func_74782_a("filter", (NBTBase)items);
    }

    public static void setItems(ItemStack is, ArrayList<ItemStack> li) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        ArrayList<Filter> li2 = new ArrayList<Filter>();
        for (ItemStack in : li) {
            Filter f = ItemInventoryLinker.constructFilter(in);
            if (f == null) continue;
            li2.add(f);
        }
        ItemInventoryLinker.setFilters(is, li2);
        ItemInventoryLinker.saveItemList(is.field_77990_d, ItemInventoryLinker.getItemList(is));
    }

    private static Filter constructFilter(ItemStack in) {
        if (in == null) {
            return null;
        }
        return new ItemFilter(in);
    }

    public static boolean processItem(World world, ItemStack tool, ItemStack is) {
        IInventory ii = ItemInventoryLinker.getInventory(world, tool);
        if (ii != null) {
            return ReikaInventoryHelper.addToIInv((ItemStack)is.func_77946_l(), (IInventory)ii);
        }
        return false;
    }

    private static IInventory getInventory(World world, ItemStack is) {
        if (is.field_77990_d == null) {
            return null;
        }
        if (!is.field_77990_d.func_74764_b("link")) {
            return null;
        }
        WorldLocation loc = WorldLocation.readFromNBT((String)"link", (NBTTagCompound)is.field_77990_d);
        if (loc != null) {
            TileEntity te = loc.getTileEntity();
            return te instanceof IInventory ? (IInventory)te : null;
        }
        return null;
    }

    private static void link(ItemStack is, TileEntity te) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        WorldLocation loc = new WorldLocation(te);
        loc.writeToNBT("link", is.field_77990_d);
    }

    public static final class ItemFilter
    extends Filter {
        private ItemStack item;

        private ItemFilter() {
        }

        public ItemFilter(ItemStack is) {
            this.item = is.func_77946_l();
        }

        @Override
        protected void writeToNBT(NBTTagCompound tag) {
            this.item.func_77955_b(tag);
        }

        @Override
        protected void readFromNBT(NBTTagCompound tag) {
            this.item = ItemStack.func_77949_a((NBTTagCompound)tag);
        }

        @Override
        protected KeyedItemStack getKey() {
            return new KeyedItemStack(this.item).setIgnoreMetadata(false).setSized(false).setIgnoreNBT(false).setSimpleHash(true);
        }
    }

    public static abstract class Filter {
        protected Filter() {
        }

        protected abstract void writeToNBT(NBTTagCompound var1);

        protected abstract void readFromNBT(NBTTagCompound var1);

        protected abstract KeyedItemStack getKey();
    }

    public static enum Mode {
        WHITELIST,
        BLACKLIST,
        EVERYTHING,
        NOTHING;

        private static final Mode[] list;

        private boolean linksItem(ItemStack tool, ItemStack is) {
            switch (this) {
                case BLACKLIST: {
                    return !WHITELIST.linksItem(tool, is);
                }
                case WHITELIST: {
                    return ItemInventoryLinker.getItemList(tool).contains(new KeyedItemStack(is).setSimpleHash(true));
                }
                case EVERYTHING: {
                    return true;
                }
                case NOTHING: {
                    return false;
                }
            }
            return false;
        }

        public boolean usesInventory() {
            return this != EVERYTHING && this != NOTHING;
        }

        private Mode next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        static {
            list = Mode.values();
        }
    }
}

