/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items;

import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.ItemChromaMulti;
import Reika.ChromatiCraft.Magic.Artefact.UABombingEffects;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Interfaces.Item.AnimatedSpritesheet;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemUnknownArtefact
extends ItemChromaMulti
implements AnimatedSpritesheet {
    private static final int RENDER_TEXT_MIN_WORD_LENGTH = 2;
    private static final int RENDER_TEXT_MAX_WORD_LENGTH = 8;
    private static final int RENDER_TEXT_LENGTH = 24;
    private static final int STEP_SPEED = 200;
    private static final Random rand = new Random();
    private static String renderText;
    private static String renderTextNext;
    private static int panLocation;
    private static long stepTime;
    private static final Interpolation chanceTable;

    public ItemUnknownArtefact(int tex) {
        super(tex);
        this.func_77625_d(1);
    }

    public boolean onEntityItemUpdate(EntityItem ei) {
        ei.lifespan = Integer.MAX_VALUE;
        ItemStack is = ei.func_92059_d();
        if (ei.field_70170_p.field_72995_K) {
            if (ArtefactTypes.list[is.func_77960_j()].doesFX()) {
                this.doItemFX(ei.field_70170_p, (Entity)ei, is);
            }
        } else {
            int x = MathHelper.func_76128_c((double)ei.field_70165_t);
            int y = MathHelper.func_76128_c((double)ei.field_70163_u);
            int z = MathHelper.func_76128_c((double)ei.field_70161_v);
            if (ArtefactTypes.list[is.func_77960_j()].triggersUABombing()) {
                // empty if block
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean verbose) {
        if (System.currentTimeMillis() - stepTime >= 200L) {
            this.cycleRenderText();
            stepTime = System.currentTimeMillis();
        }
        li.add(this.getRenderText());
    }

    public void func_77663_a(ItemStack is, World world, Entity e, int slot, boolean held) {
        if (ArtefactTypes.list[is.func_77960_j()].damagesEntities() && rand.nextInt(1000) == 0) {
            if (rand.nextBoolean()) {
                e.func_70097_a(DamageSource.field_76380_i, 1.0f);
            } else if (e instanceof EntityLivingBase) {
                ReikaEntityHelper.damageArmor((EntityLivingBase)((EntityLivingBase)e), (int)5);
                e.func_70097_a(DamageSource.field_76380_i, 0.01f);
            }
        }
        if (ArtefactTypes.list[is.func_77960_j()].triggersUABombing() && rand.nextInt(200) == 0) {
            ItemUnknownArtefact.UABombing(e);
        }
        if (world.field_72995_K && ArtefactTypes.list[is.func_77960_j()].doesFX()) {
            this.doHeldFX(world, e, is);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doHeldFX(World world, Entity e, ItemStack is) {
    }

    @SideOnly(value=Side.CLIENT)
    private void doItemFX(World world, Entity e, ItemStack is) {
        ItemUnknownArtefact.doUA_FX(world, e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    @SideOnly(value=Side.CLIENT)
    public static void doUA_FX(World world, double posX, double posY, double posZ) {
        if (rand.nextBoolean()) {
            double px = ReikaRandomHelper.getRandomPlusMinus((double)posX, (double)1.0);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)(posY + 0.25), (double)1.0);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)posZ, (double)1.0);
            int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40);
            double s = 6.0 + rand.nextDouble() * 9.0;
            int c = ReikaColorAPI.mixColors((int)12304, (int)48, (float)rand.nextFloat());
            EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setColor(c).setLife(l).setScale((float)s).setAlphaFading().setIcon(ChromaIcons.FADE_CLOUD);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        int n = 1 + rand.nextInt(2);
        for (int i = 0; i < n; ++i) {
            double px = ReikaRandomHelper.getRandomPlusMinus((double)posX, (double)2.0);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)posY, (double)2.0);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)posZ, (double)2.0);
            int l = ReikaRandomHelper.getRandomBetween((int)3, (int)8);
            double maxv = 0.125 / (double)l;
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)maxv);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)maxv);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)maxv);
            EntityBlurFX fx = new EntityBlurFX(world, px, py, pz, vx, vy, vz).setColor(0xFFFFFF).setLife(l).setRapidExpand().setIcon(ChromaIcons.FADE_STAR);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public static void onAddedToInventory(IInventory inv, ItemStack is) {
        int amt;
        double ch;
        if (ArtefactTypes.list[is.func_77960_j()].triggersUABombing() && (ch = chanceTable.getValue((double)(amt = ReikaInventoryHelper.countItem((Item)ChromaItems.ARTEFACT.getItemInstance(), (int)ArtefactTypes.ARTIFACT.ordinal(), (IInventory)inv)))) > 0.0 && ReikaRandomHelper.doWithChance((double)ch)) {
            ItemUnknownArtefact.UABombing(inv);
        }
    }

    private static void UABombing(IInventory inv) {
        TileEntity te = (TileEntity)inv;
        UABombingEffects.instance.trigger(te, inv);
    }

    private static void UABombing(Entity e) {
        UABombingEffects.instance.trigger(e);
    }

    private static String getRenderText() {
        return ChromaFontRenderer.FontType.OBFUSCATED.id + renderTextNext.substring(0, panLocation) + renderText.substring(panLocation);
    }

    private static void cycleRenderText() {
        if (renderText == null) {
            renderText = ItemUnknownArtefact.generateNewRenderText();
        }
        if (renderTextNext == null) {
            renderTextNext = ItemUnknownArtefact.generateNewRenderText();
        }
        if (++panLocation >= 24) {
            panLocation = 0;
            renderText = renderTextNext;
            renderTextNext = ItemUnknownArtefact.generateNewRenderText();
        }
    }

    private static String generateNewRenderText() {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < 24) {
            int len = Math.min(24 - sb.length(), ReikaRandomHelper.getRandomBetween((int)2, (int)8));
            while (len > 0 && sb.length() < 24) {
                char c = (char)ReikaRandomHelper.getRandomBetween((int)47, (int)126);
                sb.append(String.valueOf(c));
            }
            sb.append(" ");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean useAnimatedRender(ItemStack is) {
        return true;
    }

    public int getFrameCount() {
        return 16;
    }

    public int getBaseRow(ItemStack is) {
        return 6 + is.func_77960_j();
    }

    public int getColumn(ItemStack is) {
        return 0;
    }

    public int getFrameOffset(ItemStack is) {
        return System.identityHashCode(is) % this.getFrameCount();
    }

    public int getFrameSpeed() {
        return 4;
    }

    @Override
    public String getTexture(ItemStack is) {
        return "/Reika/ChromatiCraft/Textures/Items/miscanim.png";
    }

    public boolean verticalFrames() {
        return false;
    }

    static {
        chanceTable = new Interpolation(false);
        chanceTable.addPoint(2.0, 0.0);
        chanceTable.addPoint(3.0, 0.01);
        chanceTable.addPoint(4.0, 0.25);
        chanceTable.addPoint(12.0, 0.5);
        chanceTable.addPoint(16.0, 0.75);
        chanceTable.addPoint(24.0, 0.975);
        chanceTable.addPoint(32.0, 0.995);
        chanceTable.addPoint(64.0, 1.0);
    }

    public static enum ArtefactTypes {
        ARTIFACT,
        FRAGMENT;

        public static final ArtefactTypes[] list;

        public boolean emitsLight() {
            return this == ARTIFACT;
        }

        public boolean damagesEntities() {
            return this == ARTIFACT;
        }

        public boolean triggersUABombing() {
            return this == ARTIFACT;
        }

        public boolean doesFX() {
            return this == ARTIFACT;
        }

        static {
            list = ArtefactTypes.values();
        }
    }
}

