/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Items;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.Interfaces.TieredItem;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.ItemCrystalBasic;
import Reika.ChromatiCraft.Block.BlockActiveChroma;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Item.AnimatedSpritesheet;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import vazkii.botania.api.recipe.IFlowerComponent;

@APIStripper.Strippable(value={"vazkii.botania.api.recipe.IFlowerComponent"})
public class ItemCrystalShard
extends ItemCrystalBasic
implements AnimatedSpritesheet,
TieredItem,
IFlowerComponent {
    private static final int[] offsets = ReikaArrayHelper.getLinearArray((int)16);

    public ItemCrystalShard(int tex) {
        super(tex);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onEntityItemUpdate(EntityItem ei) {
        int x = MathHelper.func_76128_c((double)ei.field_70165_t);
        int y = MathHelper.func_76128_c((double)ei.field_70163_u);
        int z = MathHelper.func_76128_c((double)ei.field_70161_v);
        int dmg = ei.func_92059_d().func_77960_j();
        Block b = ei.field_70170_p.func_147439_a(x, y, z);
        if (b != ChromaBlocks.CHROMA.getBlockInstance()) return false;
        if (ei.field_70170_p.func_72805_g(x, y, z) != 0) return false;
        if (dmg < 16) {
            if (ItemCrystalShard.canCharge(ei)) {
                TileEntity te = ei.field_70170_p.func_147438_o(x, y, z);
                if (!(te instanceof BlockActiveChroma.TileEntityChroma)) return false;
                BlockActiveChroma.TileEntityChroma tc = (BlockActiveChroma.TileEntityChroma)te;
                if (!tc.isFullyActive()) return false;
                if (tc.getElement().ordinal() != dmg) return false;
                boolean done = ItemCrystalShard.tickShardCharging(ei, CrystalElement.elements[dmg], tc.getEtherCount(), x, y, z);
                if (!done) return false;
                tc.clear();
                return false;
            }
        }
        ei.lifespan = Integer.MAX_VALUE;
        return false;
    }

    public static boolean canCharge(EntityItem ei) {
        EntityPlayer ep = ReikaItemHelper.getDropper((EntityItem)ei);
        return ep != null && ProgressionManager.ProgressStage.SHARDCHARGE.playerHasPrerequisites(ep);
    }

    public static boolean tickShardCharging(EntityItem ei, CrystalElement e, int ether, int x, int y, int z) {
        ei.lifespan = Integer.MAX_VALUE;
        NBTTagCompound tag = ei.getEntityData().func_74775_l("chroma");
        int tick = tag.func_74762_e("tick");
        int age = tag.func_74762_e("age");
        if (ei.field_70170_p.field_72995_K && tick % 16 == 0) {
            ChromaFX.doShardBoostingFX(ei);
        }
        int n = BlockActiveChroma.getSpeedMultiplier(ether);
        if (age > ei.field_70292_b) {
            tick = 0;
            tag.func_74768_a("tick", tick + n);
            tag.func_74768_a("age", ei.field_70292_b);
            ei.getEntityData().func_74782_a("chroma", (NBTBase)tag);
        } else {
            if (tick >= 6000 && !ei.field_70170_p.field_72995_K) {
                ItemStack is = ChromaItems.SHARD.getCraftedMetadataProduct(ei.func_92059_d().field_77994_a, 16 + e.ordinal());
                EntityItem ei2 = new EntityItem(ei.field_70170_p, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, is);
                ei2.lifespan = Integer.MAX_VALUE;
                if (!ei.field_70170_p.field_72995_K) {
                    ei.field_70170_p.func_72838_d((Entity)ei2);
                    ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.SHARDBOOST.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget((Entity)ei, 64), (int[])new int[]{ei.func_145782_y()});
                    ChromaSounds.INFUSE.playSoundAtBlock(ei.field_70170_p, x, y, z);
                    ProgressionManager.ProgressStage.SHARDCHARGE.stepPlayerTo(ReikaItemHelper.getDropper((EntityItem)ei));
                }
                ei.func_70106_y();
                return true;
            }
            tag.func_74768_a("tick", tick + n);
            tag.func_74768_a("age", ei.field_70292_b);
            ei.getEntityData().func_74782_a("chroma", (NBTBase)tag);
        }
        return false;
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        return super.getItemSpriteIndex(item) - item.func_77960_j() + item.func_77960_j() % 16;
    }

    public boolean func_150892_m(ItemStack is) {
        return false;
    }

    @Override
    public int getNumberTypes() {
        return CrystalElement.elements.length * 2;
    }

    public String func_150896_i(ItemStack is) {
        String ret = "";
        CrystalElement dye = CrystalElement.elements[is.func_77960_j()];
        switch (dye) {
            case BLACK: {
                ret = ret + PotionHelper.field_77932_i;
                break;
            }
            case BLUE: {
                ret = ret + PotionHelper.field_82818_l;
                break;
            }
            case BROWN: {
                ret = ret + PotionHelper.field_77932_i;
                break;
            }
            case CYAN: {
                ret = ret + "";
                break;
            }
            case GRAY: {
                ret = ret + PotionHelper.field_77922_b;
                break;
            }
            case GREEN: {
                ret = ret + PotionHelper.field_77920_d;
                break;
            }
            case LIGHTBLUE: {
                ret = ret + PotionHelper.field_77922_b;
                break;
            }
            case LIGHTGRAY: {
                ret = ret + PotionHelper.field_77919_g;
                break;
            }
            case LIME: {
                ret = ret + "";
                break;
            }
            case MAGENTA: {
                ret = ret + "+0-1-2-3&4-4+13";
                break;
            }
            case ORANGE: {
                ret = ret + PotionHelper.field_77931_h;
                break;
            }
            case PINK: {
                ret = ret + PotionHelper.field_77919_g;
                break;
            }
            case PURPLE: {
                ret = ret + PotionHelper.field_77929_j;
                break;
            }
            case RED: {
                ret = ret + "";
            }
            case WHITE: {
                ret = ret + PotionHelper.field_82818_l;
                break;
            }
            case YELLOW: {
                ret = ret + "";
                break;
            }
            default: {
                ret = ret + "";
            }
        }
        if (is.func_77960_j() >= 16) {
            ret = ret + "+5+6-7";
        }
        return ret;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append("Good for ");
        CrystalElement color = CrystalElement.elements[is.func_77960_j() % 16];
        sb.append(CrystalPotionController.getPotionName(color));
        sb.append(" Potions");
        li.add(sb.toString());
        if (is.func_77960_j() >= 16) {
            li.add(EnumChatFormatting.LIGHT_PURPLE.toString() + "Gives level II enhanced potions");
        } else {
            li.add(EnumChatFormatting.GOLD.toString() + "Gives ordinary potions");
        }
        if (!ProgressionManager.instance.hasPlayerDiscoveredColor(ep, color)) {
            ArrayList<String> li2 = new ArrayList<String>();
            for (Object o : li) {
                if (!(o instanceof String)) continue;
                String s = (String)o;
                if (!((String)o).contains(ChromaFontRenderer.FontType.OBFUSCATED.id)) {
                    s = ChromaFontRenderer.FontType.OBFUSCATED.id + o;
                }
                li2.add(s);
            }
            li.clear();
            li.addAll(li2);
        }
    }

    public boolean useAnimatedRender(ItemStack is) {
        return is.func_77960_j() >= 16;
    }

    public int getFrameSpeed() {
        return 3;
    }

    public int getColumn(ItemStack is) {
        return is.func_77960_j() % 16;
    }

    public int getFrameCount() {
        return 16;
    }

    public int getBaseRow(ItemStack is) {
        return 0;
    }

    @Override
    public String getTexture(ItemStack is) {
        return is.func_77960_j() >= 16 ? "/Reika/ChromatiCraft/Textures/Items/shardglow.png" : super.getTexture(is);
    }

    public int getFrameOffset(ItemStack is) {
        return offsets[is.func_77960_j() % 16];
    }

    @Override
    public ProgressionManager.ProgressStage getDiscoveryTier(ItemStack is) {
        return ProgressionManager.ProgressStage.RUNEUSE;
    }

    @Override
    public boolean isTiered(ItemStack is) {
        return is.func_77960_j() >= 16;
    }

    public boolean verticalFrames() {
        return true;
    }

    public boolean canFit(ItemStack stack, IInventory apothecary) {
        return true;
    }

    public int getParticleColor(ItemStack is) {
        return CrystalElement.elements[is.func_77960_j() % 16].getColor();
    }

    static {
        ReikaArrayHelper.shuffleArray((int[])offsets);
    }
}

