/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile;

import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityTeleportGate;
import Reika.DragonAPI.Base.CoreContainer;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.RegionMap;
import Reika.DragonAPI.Instantiable.Data.ObjectWeb;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import java.awt.Point;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiTeleportGate
extends GuiChromaBase {
    private final TileEntityTeleportGate gate;
    private final WorldLocation gateLoc;
    private final ConnectionWeb web = new ConnectionWeb();
    private final RegionMap<LinkNode> pointLocs = new RegionMap();
    private static final int SIZE = 16;
    private double offsetX = 0.0;
    private double offsetZ = 0.0;
    private double scaleFactor = 1.0;

    public GuiTeleportGate(EntityPlayer ep, TileEntityTeleportGate te) {
        super((Container)new CoreContainer(ep, (TileEntity)te), ep, te);
        this.gate = te;
        this.gateLoc = new WorldLocation((TileEntity)te);
        this.field_146999_f = 240;
        this.field_147000_g = 200;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        this.web.clear();
        for (TileEntityTeleportGate.GateData dat : TileEntityTeleportGate.getCache()) {
            LinkNode l = new LinkNode(dat);
            l.statusFlags |= dat.statusFlags;
            this.web.addNode(l);
        }
        this.web.scaleTo(this.field_146999_f, this.field_147000_g, 16);
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        this.func_73866_w_();
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        LinkNode l = (LinkNode)this.pointLocs.getRegion(-j + x, -k + y);
        if (l != null) {
            if (!l.location.equals(this.gate.field_145850_b, this.gate.field_145851_c, this.gate.field_145848_d, this.gate.field_145849_e)) {
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.TRIGGERTELEPORT.ordinal(), (PacketTarget)PacketTarget.server, (int[])new int[]{this.gate.field_145850_b.field_73011_w.field_76574_g, this.gate.field_145851_c, this.gate.field_145848_d, this.gate.field_145849_e, ((LinkNode)l).location.dimensionID, ((LinkNode)l).location.xCoord, ((LinkNode)l).location.yCoord, ((LinkNode)l).location.zCoord});
            } else {
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ERROR, (Entity)this.player, (float)1.0f, (float)1.0f);
            }
        } else if (x >= j && y >= k && x <= j + this.field_146289_q.func_78256_a("Reload Preview") + 3 && y <= k + this.field_146289_q.field_78288_b + 3) {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)1.0f, (float)1.0f);
            this.player.func_71053_j();
            this.gate.takeSnapshot();
        }
    }

    public void handleTriggerConfirm(boolean success) {
        ReikaSoundHelper.playClientSound((SoundEnum)(success ? ChromaSounds.USE : ChromaSounds.ERROR), (Entity)this.player, (float)1.0f, (float)1.0f);
        if (success) {
            this.player.func_71053_j();
            this.player.field_70125_A = 0.0f;
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        this.pointLocs.clear();
        this.web.render(j, k, 16);
        String s = "Reload Preview";
        int c = ReikaColorAPI.mixColors((int)-1, (int)-2139062144, (float)Math.min(1.0f, 0.625f + 0.5f * (float)Math.sin((double)System.currentTimeMillis() / 400.0)));
        api.drawRectFrame(0, 0, this.field_146289_q.func_78256_a(s) + 3, this.field_146289_q.field_78288_b + 3, c);
        this.field_146289_q.func_78276_b(s, 2, 2, 0xFFFFFF);
    }

    @Override
    protected void func_146976_a(float p, int a, int b) {
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        api.drawRectFrame(j, k, this.field_146999_f, this.field_147000_g, -1);
    }

    @Override
    public void func_73863_a(int mx, int my, float ptick) {
        super.func_73863_a(mx, my, ptick);
        double d = Math.max(-40.0, -6.0 * this.scaleFactor);
        if (Keyboard.isKeyDown((int)201)) {
            this.scaleFactor *= 0.95;
        } else if (Keyboard.isKeyDown((int)209)) {
            this.scaleFactor *= 1.05;
        } else if (Keyboard.isKeyDown((int)17)) {
            this.offsetZ -= d;
        } else if (Keyboard.isKeyDown((int)30)) {
            this.offsetX -= d;
        } else if (Keyboard.isKeyDown((int)31)) {
            this.offsetZ += d;
        } else if (Keyboard.isKeyDown((int)32)) {
            this.offsetX += d;
        } else if (Keyboard.isKeyDown((int)199)) {
            this.scaleFactor = 1.0;
            this.offsetX = 0.0;
            this.offsetZ = 0.0;
        }
    }

    @Override
    protected boolean drawTitle() {
        return false;
    }

    @Override
    public String getGuiTexture() {
        return "teleport";
    }

    private class LinkNode
    implements Comparable<LinkNode> {
        private int statusFlags;
        private final WorldLocation location;
        private double renderX;
        private double renderZ;

        private LinkNode(TileEntityTeleportGate.GateData dat) {
            this.location = dat.location;
            if (this.location.dimensionID != Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g) {
                this.setFlag(TileEntityTeleportGate.Statuses.DIMENSION);
            }
            if (dat.isOwnedBy(GuiTeleportGate.this.player)) {
                this.setFlag(TileEntityTeleportGate.Statuses.OWNED);
            }
        }

        private String getTextureID() {
            return TileEntityTeleportGate.getTextureID(this.location);
        }

        private LinkNode setFlag(TileEntityTeleportGate.Statuses s) {
            this.statusFlags |= s.flag;
            return this;
        }

        public int getRenderColor() {
            for (int i = 0; i < TileEntityTeleportGate.Statuses.list.length; ++i) {
                TileEntityTeleportGate.Statuses s = TileEntityTeleportGate.Statuses.list[i];
                if (s.check(this.statusFlags)) continue;
                return s.color;
            }
            return 0xFFFFFF;
        }

        public String toString() {
            return this.location.toString() + " [" + this.renderX + "/" + this.renderZ + "/" + Integer.toBinaryString(this.statusFlags) + "]";
        }

        @Override
        public int compareTo(LinkNode o) {
            return Integer.compare(this.location.hashCode(), o.location.hashCode());
        }
    }

    private class ConnectionWeb {
        private final ObjectWeb<LinkNode> web = new ObjectWeb();
        private double minX = 2.147483647E9;
        private double minZ = 2.147483647E9;
        private double maxX = -2.147483648E9;
        private double maxZ = -2.147483648E9;

        private ConnectionWeb() {
        }

        private void addNode(LinkNode l) {
            this.web.addNode((Object)l);
            if (TileEntityTeleportGate.Statuses.OWNED.check(l.statusFlags) && TileEntityTeleportGate.Statuses.STRUCTURE.check(l.statusFlags)) {
                for (LinkNode l2 : this.web.objects()) {
                    if (!TileEntityTeleportGate.Statuses.POWERED.check(l.statusFlags) && !TileEntityTeleportGate.Statuses.POWERED.check(l2.statusFlags) || !TileEntityTeleportGate.Statuses.OWNED.check(l2.statusFlags) || !TileEntityTeleportGate.Statuses.STRUCTURE.check(l2.statusFlags)) continue;
                    this.web.addBilateralConnection((Object)l, (Object)l2);
                }
            }
            l.renderX = ((LinkNode)l).location.xCoord;
            l.renderZ = ((LinkNode)l).location.zCoord;
            this.minX = Math.min(this.minX, (double)((LinkNode)l).location.xCoord);
            this.minZ = Math.min(this.minZ, (double)((LinkNode)l).location.zCoord);
            this.maxX = Math.max(this.maxX, (double)((LinkNode)l).location.xCoord);
            this.maxZ = Math.max(this.maxZ, (double)((LinkNode)l).location.zCoord);
        }

        private void clear() {
            this.web.clear();
            this.minX = 2.147483647E9;
            this.minZ = 2.147483647E9;
            this.maxX = -2.147483648E9;
            this.maxZ = -2.147483648E9;
        }

        public String toString() {
            return this.web.toString();
        }

        private void scaleTo(int sizeX, int sizeY, int elementSize) {
            sizeX -= elementSize;
            sizeY -= elementSize;
            for (LinkNode l : this.web.objects()) {
                l.renderX -= this.minX;
                l.renderZ -= this.minZ;
            }
            this.maxX -= this.minX;
            this.maxZ -= this.minZ;
            double sx = (double)sizeX / this.maxX;
            double sz = (double)sizeY / this.maxZ;
            double sm = Math.min(sx, sz);
            for (LinkNode l : this.web.objects()) {
                l.renderX *= sm;
                l.renderZ *= sm;
            }
            this.maxX *= sm;
            this.maxZ *= sm;
        }

        private void render(int j, int k, int s) {
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            int dx = (int)(-this.maxX / 2.0 * GuiTeleportGate.this.scaleFactor) + GuiTeleportGate.this.field_146999_f / 2 + (int)GuiTeleportGate.this.offsetX;
            int dz = (int)(-this.maxZ / 2.0 * GuiTeleportGate.this.scaleFactor) + GuiTeleportGate.this.field_147000_g / 2 + (int)GuiTeleportGate.this.offsetZ;
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            for (LinkNode l : this.web.objects()) {
                int lx = (int)Math.round(l.renderX * GuiTeleportGate.this.scaleFactor) + dx;
                int lz = (int)Math.round(l.renderZ * GuiTeleportGate.this.scaleFactor) + dz;
                boolean mbox = api.isMouseInBox(j + lx + 3, j + lx + s - 4, k + lz + 3, k + lz + s - 4);
                for (LinkNode l2 : this.web.getChildren((Object)l)) {
                    int lz2;
                    int lx2 = (int)Math.round(l2.renderX * GuiTeleportGate.this.scaleFactor) + dx;
                    ImmutablePair ps = ReikaVectorHelper.clipLine((int)(lx + s / 2), (int)(lx2 + s / 2), (int)(lz + s / 2), (int)((lz2 = (int)Math.round(l2.renderZ * GuiTeleportGate.this.scaleFactor) + dz) + s / 2), (int)0, (int)0, (int)GuiTeleportGate.this.field_146999_f, (int)GuiTeleportGate.this.field_147000_g);
                    if (ps == null) continue;
                    int lc = mbox ? -1 : 0x4040404;
                    api.drawLine(((Point)ps.left).x, ((Point)ps.left).y, ((Point)ps.right).x, ((Point)ps.right).y, lc);
                }
            }
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ReikaTextureHelper.bindTerrainTexture();
            for (LinkNode l : this.web.objects()) {
                int c = l.getRenderColor();
                int lx = (int)Math.round(l.renderX * GuiTeleportGate.this.scaleFactor) + dx;
                int lz = (int)Math.round(l.renderZ * GuiTeleportGate.this.scaleFactor) + dz;
                if (lx < 0 || lx > GuiTeleportGate.this.field_146999_f - s || lz < 0 || lz >= GuiTeleportGate.this.field_147000_g - s) continue;
                boolean mbox = api.isMouseInBox(j + lx + 3, j + lx + s - 4, k + lz + 3, k + lz + s - 4);
                GL11.glColor3f((float)((float)ReikaColorAPI.getRed((int)c) / 255.0f), (float)((float)ReikaColorAPI.getGreen((int)c) / 255.0f), (float)((float)ReikaColorAPI.getBlue((int)c) / 255.0f));
                api.func_94065_a(lx, lz, ChromaIcons.DIAMOND.getIcon(), s, s);
                if (l.location.equals((Object)GuiTeleportGate.this.gateLoc)) {
                    int clr = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)0xA0A0A0, (float)((float)(0.5 + 0.5 * Math.sin((double)System.currentTimeMillis() / 200.0))));
                    api.drawRectFrame(lx + 1, lz + 1, 14, 14, clr);
                }
                GuiTeleportGate.this.pointLocs.addRegionByWH(lx, lz, s, s, (Object)l);
                if (!mbox) continue;
                GuiTeleportGate.this.gate;
                BufferedImage img = TileEntityTeleportGate.getPreview(l.location);
                if (img == null) {
                    ReikaTextureHelper.bindFinalTexture(ChromatiCraft.class, (String)"Textures/GateNotFound.png");
                } else {
                    ReikaTextureHelper.bindRawTexture((BufferedImage)img, (String)l.getTextureID());
                }
                double w = img == null ? 106.75 : (double)img.getWidth() / 8.0;
                double h = img == null ? 60.0 : (double)img.getHeight() / 8.0;
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                double x = (double)api.getMouseRealX() - w / 1.25;
                double y = (double)api.getMouseRealY() - h / 4.0;
                x = Math.min(x, (double)GuiTeleportGate.this.field_146999_f - w);
                y = Math.min(y, (double)GuiTeleportGate.this.field_147000_g - h);
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
                Tessellator.field_78398_a.func_78374_a(x, y + h, 0.0, 0.0, 1.0);
                Tessellator.field_78398_a.func_78374_a(x + w, y + h, 0.0, 1.0, 1.0);
                Tessellator.field_78398_a.func_78374_a(x + w, y, 0.0, 1.0, 0.0);
                Tessellator.field_78398_a.func_78374_a(x, y, 0.0, 0.0, 0.0);
                Tessellator.field_78398_a.func_78381_a();
                ReikaTextureHelper.bindTerrainTexture();
                String sg = l.location.toString();
                api.drawTooltipAt(GuiTeleportGate.this.field_146289_q, sg, (int)x + GuiTeleportGate.this.field_146289_q.func_78256_a(sg) + 19, (int)y - (((GuiTeleportGate)GuiTeleportGate.this).field_146289_q.field_78288_b - 8));
            }
            GL11.glPopAttrib();
        }
    }
}

