/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile;

import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Decoration.TileEntityParticleSpawner;
import Reika.DragonAPI.Base.CoreContainer;
import Reika.DragonAPI.Instantiable.BoundedValue;
import Reika.DragonAPI.Instantiable.GUI.ImagedGuiButton;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class GuiParticleSpawner
extends GuiChromaBase {
    private final TileEntityParticleSpawner tile;
    private GuiPage page = GuiPage.POSITION;
    private boolean RGBMode = true;
    private int red;
    private int green;
    private int blue;
    private int hue;
    private float saturation;
    private float luminosity;
    private int color;
    private static ArrayList<ChromaIcons> permittedIcons = new ArrayList();

    public GuiParticleSpawner(EntityPlayer ep, TileEntityParticleSpawner te) {
        super((Container)new CoreContainer(ep, (TileEntity)te), ep, te);
        this.tile = te;
        this.color = this.tile.particles.particleColor;
        this.red = ReikaColorAPI.getRed((int)this.color);
        this.green = ReikaColorAPI.getGreen((int)this.color);
        this.blue = ReikaColorAPI.getBlue((int)this.color);
        float[] hsv = Color.RGBtoHSB(this.red, this.green, this.blue, null);
        this.hue = (int)(hsv[0] * 360.0f);
        this.saturation = hsv[1];
        this.luminosity = hsv[2];
    }

    private static boolean isIconAllowed(ChromaIcons ico) {
        switch (ico) {
            case TRANSPARENT: 
            case GUARDIANOUTER: 
            case SPARKLE_ROUNDED: 
            case REPEATER: 
            case MULTIREPEATER: 
            case BROADCAST: 
            case LASER: 
            case LASEREND: 
            case RIFT: 
            case RIFTHALO: 
            case NOENTER: 
            case CHECK: 
            case QUESTION: 
            case BLUEFIRE: 
            case BATTERY: 
            case BLANK: 
            case ALLCOLORS: 
            case BASICFADE: 
            case BASICFADE_FAST: 
            case FRAME: 
            case REGIONS: 
            case WEAKREPEATER: 
            case LATTICE: 
            case GLOWFRAME_TRANS: 
            case GLOWFRAMEDOT_TRANS: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void func_73866_w_() {
        int v;
        int u;
        int y;
        int x;
        int i;
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        for (int i2 = 0; i2 < GuiPage.list.length; ++i2) {
            GuiPage.list[i2].initOptions(this.tile, this.RGBMode);
        }
        String file = this.getFullTexturePath();
        int n = 4;
        for (i = 0; i < GuiPage.list.length; ++i) {
            x = j + n;
            y = k + n + 20 * i;
            u = i == this.page.ordinal() ? 198 : 178;
            v = i * 20;
            this.field_146292_n.add(new ImagedGuiButton(i, x, y, 20, 20, u, v, file, ChromatiCraft.class));
        }
        switch (this.page) {
            case POSITION: 
            case VELOCITY: {
                for (i = 0; i < 12; ++i) {
                    x = j + 29 + i % 2 * 122;
                    y = k + 19 + i / 2 * 24;
                    u = i % 2 == 1 ? 126 : 106;
                    v = 173;
                    ImagedGuiButton b = new ImagedGuiButton(i + 100, x, y, 20, 20, u, v, file, ChromatiCraft.class);
                    this.field_146292_n.add(b);
                }
                break;
            }
            case COLOR: {
                ImagedGuiButton b;
                for (i = 0; i < 16; ++i) {
                    x = j + 27 + i % 8 * 18;
                    y = k + 18 + i / 8 * 18;
                    u = 106;
                    v = 213;
                    b = new ImagedGuiButton(i + 100, x, y, 20, 20, u, v, file, ChromatiCraft.class);
                    b.icon = CrystalElement.elements[i].getGlowRune();
                    b.iconWidth = 16;
                    b.iconHeight = 16;
                    this.field_146292_n.add(b);
                }
                for (i = 0; i < 8; ++i) {
                    x = j + 29 + i % 2 * 122;
                    y = k + 58 + i / 2 * 20;
                    u = i % 2 == 1 ? 126 : 106;
                    v = i >= 6 ? 193 : 173;
                    b = new ImagedGuiButton(i + 200, x, y, 20, 20, u, v, file, ChromatiCraft.class);
                    this.field_146292_n.add(b);
                }
                int in = 45;
                this.field_146292_n.add(new GuiButton(300, j + 29 + in, k + 142, 143 - in * 2, 20, !this.RGBMode ? "HSV" : "RGB"));
                break;
            }
            case ICON: {
                int i3 = 0;
                for (ChromaIcons ico : permittedIcons) {
                    int r = 7;
                    int x2 = j + 29 + i3 % r * 21 - 2;
                    int y2 = k + 18 + i3 / r * 21;
                    int u2 = 106;
                    int v2 = 213;
                    ImagedGuiButton b = new ImagedGuiButton(i3 + 100, x2, y2, 20, 20, u2, v2, file, ChromatiCraft.class);
                    b.icon = ico.getIcon();
                    b.iconWidth = 16;
                    b.iconHeight = 16;
                    this.field_146292_n.add(b);
                    ++i3;
                }
                break;
            }
            case TIMING: {
                int u3;
                int y3;
                int x3;
                int i3;
                for (i3 = 0; i3 < 8; ++i3) {
                    x3 = j + 29 + i3 % 2 * 122;
                    y3 = k + 19 + i3 / 2 * 24;
                    u3 = i3 % 2 == 1 ? 126 : 106;
                    int v3 = 173;
                    if (i3 >= 6) {
                        v3 += 20;
                    }
                    ImagedGuiButton b = new ImagedGuiButton(i3 + 100, x3, y3, 20, 20, u3, v3, file, ChromatiCraft.class);
                    this.field_146292_n.add(b);
                }
                break;
            }
            case MODIFIER: {
                int u3;
                int y3;
                int x3;
                int i3;
                for (i3 = 0; i3 < 14; ++i3) {
                    x3 = j + 29 + i3 % 2 * 122;
                    y3 = k + 19 + i3 / 2 * 20;
                    u3 = i3 % 2 == 1 ? 126 : 106;
                    int v4 = 173;
                    if (i3 >= 8) {
                        v4 += 20;
                    }
                    ImagedGuiButton b = new ImagedGuiButton(i3 + 100, x3, y3, 20, 20, u3, v4, file, ChromatiCraft.class);
                    this.field_146292_n.add(b);
                }
                break;
            }
        }
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k < GuiPage.list.length) {
            this.page = GuiPage.list[b.field_146127_k];
        } else {
            int n = 1;
            if (GuiScreen.func_146272_n()) {
                n = 4;
                if (this.page == GuiPage.COLOR || this.page == GuiPage.TIMING && !ReikaMathLibrary.isValueInsideBoundsIncl((int)2, (int)3, (int)(b.field_146127_k - 100))) {
                    n = 5;
                } else if (this.page == GuiPage.ICON || this.page == GuiPage.MODIFIER && ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)9, (int)(b.field_146127_k - 100))) {
                    n = 1;
                }
            }
            block8: for (int i = 0; i < n; ++i) {
                switch (this.page) {
                    case POSITION: {
                        this.handlePositionButton(b.field_146127_k - 100);
                        continue block8;
                    }
                    case VELOCITY: {
                        this.handleVelocityButton(b.field_146127_k - 100);
                        continue block8;
                    }
                    case COLOR: {
                        this.handleColorButton(b.field_146127_k);
                        continue block8;
                    }
                    case ICON: {
                        if (b.field_146127_k < 100) continue block8;
                        this.tile.particles.particleIcon = permittedIcons.get(b.field_146127_k - 100);
                        continue block8;
                    }
                    case TIMING: {
                        this.handleTimingButton(b.field_146127_k - 100);
                        continue block8;
                    }
                    case MODIFIER: {
                        this.handleModifierButton(b.field_146127_k - 100);
                    }
                }
            }
        }
        this.tile.particles.sendData();
        this.func_73866_w_();
    }

    private void handleModifierButton(int i) {
        switch (i) {
            case 0: {
                this.tile.particles.particleGravity.decrease();
                break;
            }
            case 1: {
                this.tile.particles.particleGravity.increase();
                break;
            }
            case 2: {
                this.tile.particles.particleGravity.decreaseVariation();
                break;
            }
            case 3: {
                this.tile.particles.particleGravity.increaseVariation();
                break;
            }
            case 4: {
                this.tile.particles.particleSize.decrease();
                break;
            }
            case 5: {
                this.tile.particles.particleSize.increase();
                break;
            }
            case 6: {
                this.tile.particles.particleSize.decreaseVariation();
                break;
            }
            case 7: {
                this.tile.particles.particleSize.increaseVariation();
                break;
            }
            case 8: {
                this.tile.particles.particleCollision = false;
                break;
            }
            case 9: {
                this.tile.particles.particleCollision = true;
                break;
            }
            case 10: {
                this.tile.particles.rapidExpand = false;
                break;
            }
            case 11: {
                this.tile.particles.rapidExpand = true;
                break;
            }
            case 12: {
                this.tile.particles.noSlowdown = false;
                break;
            }
            case 13: {
                this.tile.particles.noSlowdown = true;
            }
        }
    }

    private void handleTimingButton(int i) {
        switch (i) {
            case 0: {
                this.tile.particles.particleLife.decrease();
                break;
            }
            case 1: {
                this.tile.particles.particleLife.increase();
                break;
            }
            case 2: {
                this.tile.particles.particleLife.decreaseVariation();
                break;
            }
            case 3: {
                this.tile.particles.particleLife.increaseVariation();
                break;
            }
            case 4: {
                this.tile.particles.particleRate.decrease();
                break;
            }
            case 5: {
                this.tile.particles.particleRate.increase();
                break;
            }
            case 6: {
                this.tile.particles.alphaFade = false;
                break;
            }
            case 7: {
                this.tile.particles.alphaFade = true;
            }
        }
    }

    private void handlePositionButton(int i) {
        switch (i) {
            case 0: {
                this.tile.particles.particlePositionX.decrease();
                break;
            }
            case 1: {
                this.tile.particles.particlePositionX.increase();
                break;
            }
            case 2: {
                this.tile.particles.particlePositionX.decreaseVariation();
                break;
            }
            case 3: {
                this.tile.particles.particlePositionX.increaseVariation();
                break;
            }
            case 4: {
                this.tile.particles.particlePositionY.decrease();
                break;
            }
            case 5: {
                this.tile.particles.particlePositionY.increase();
                break;
            }
            case 6: {
                this.tile.particles.particlePositionY.decreaseVariation();
                break;
            }
            case 7: {
                this.tile.particles.particlePositionY.increaseVariation();
                break;
            }
            case 8: {
                this.tile.particles.particlePositionZ.decrease();
                break;
            }
            case 9: {
                this.tile.particles.particlePositionZ.increase();
                break;
            }
            case 10: {
                this.tile.particles.particlePositionZ.decreaseVariation();
                break;
            }
            case 11: {
                this.tile.particles.particlePositionZ.increaseVariation();
            }
        }
    }

    private void handleVelocityButton(int i) {
        switch (i) {
            case 0: {
                this.tile.particles.particleVelocityX.decrease();
                break;
            }
            case 1: {
                this.tile.particles.particleVelocityX.increase();
                break;
            }
            case 2: {
                this.tile.particles.particleVelocityX.decreaseVariation();
                break;
            }
            case 3: {
                this.tile.particles.particleVelocityX.increaseVariation();
                break;
            }
            case 4: {
                this.tile.particles.particleVelocityY.decrease();
                break;
            }
            case 5: {
                this.tile.particles.particleVelocityY.increase();
                break;
            }
            case 6: {
                this.tile.particles.particleVelocityY.decreaseVariation();
                break;
            }
            case 7: {
                this.tile.particles.particleVelocityY.increaseVariation();
                break;
            }
            case 8: {
                this.tile.particles.particleVelocityZ.decrease();
                break;
            }
            case 9: {
                this.tile.particles.particleVelocityZ.increase();
                break;
            }
            case 10: {
                this.tile.particles.particleVelocityZ.decreaseVariation();
                break;
            }
            case 11: {
                this.tile.particles.particleVelocityZ.increaseVariation();
            }
        }
    }

    private void handleColorButton(int id) {
        if (id == 300) {
            this.RGBMode = !this.RGBMode;
            this.roundColors();
        } else if (id >= 200) {
            if (this.RGBMode) {
                switch (id - 200) {
                    case 0: {
                        this.red = Math.max(this.red - 1, 0);
                        break;
                    }
                    case 1: {
                        this.red = Math.min(this.red + 1, 255);
                        break;
                    }
                    case 2: {
                        this.green = Math.max(this.green - 1, 0);
                        break;
                    }
                    case 3: {
                        this.green = Math.min(this.green + 1, 255);
                        break;
                    }
                    case 4: {
                        this.blue = Math.max(this.blue - 1, 0);
                        break;
                    }
                    case 5: {
                        this.blue = Math.min(this.blue + 1, 255);
                    }
                }
                this.calcColors(1);
            } else {
                switch (id - 200) {
                    case 0: {
                        this.hue = Math.max(this.hue - 1, 0);
                        break;
                    }
                    case 1: {
                        this.hue = Math.min(this.hue + 1, 360);
                        break;
                    }
                    case 2: {
                        this.saturation = Math.max(this.saturation - 0.05f, 0.0f);
                        break;
                    }
                    case 3: {
                        this.saturation = Math.min(this.saturation + 0.05f, 1.0f);
                        break;
                    }
                    case 4: {
                        this.luminosity = Math.max(this.luminosity - 0.05f, 0.0f);
                        break;
                    }
                    case 5: {
                        this.luminosity = Math.min(this.luminosity + 0.05f, 1.0f);
                    }
                }
                this.calcColors(0);
            }
            if (id - 200 == 6) {
                this.tile.particles.cyclingColor = false;
            }
            if (id - 200 == 7) {
                this.tile.particles.cyclingColor = true;
            }
        } else if (id >= 100) {
            this.color = CrystalElement.elements[id - 100].getColor();
            this.calcColors(2);
        }
    }

    private void roundColors() {
        if (!this.RGBMode) {
            this.saturation = ReikaMathLibrary.roundToDecimalPlaces((float)this.saturation, (int)1);
            this.luminosity = ReikaMathLibrary.roundToDecimalPlaces((float)this.luminosity, (int)1);
        }
        this.calcColors(0);
    }

    private void calcColors(int mode) {
        switch (mode) {
            case 0: {
                this.color = Color.HSBtoRGB((float)this.hue / 360.0f, this.saturation, this.luminosity);
                this.red = ReikaColorAPI.getRed((int)this.color);
                this.green = ReikaColorAPI.getGreen((int)this.color);
                this.blue = ReikaColorAPI.getBlue((int)this.color);
                break;
            }
            case 1: {
                this.color = ReikaColorAPI.RGBtoHex((int)this.red, (int)this.green, (int)this.blue);
                float[] hsv = Color.RGBtoHSB(this.red, this.green, this.blue, null);
                this.hue = (int)(hsv[0] * 360.0f);
                this.saturation = hsv[1];
                this.luminosity = hsv[2];
                break;
            }
            case 2: {
                this.red = ReikaColorAPI.getRed((int)this.color);
                this.green = ReikaColorAPI.getGreen((int)this.color);
                this.blue = ReikaColorAPI.getBlue((int)this.color);
                float[] hsv = Color.RGBtoHSB(this.red, this.green, this.blue, null);
                this.hue = (int)(hsv[0] * 360.0f);
                this.saturation = hsv[1];
                this.luminosity = hsv[2];
                break;
            }
        }
        this.tile.particles.particleColor = this.color;
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        int i = 0;
        int sy = this.page == GuiPage.MODIFIER || this.page == GuiPage.COLOR ? 20 : 24;
        for (Option o : this.page.options) {
            int dx = j + 49;
            int dy = k + 19 + sy * i;
            if (this.page == GuiPage.COLOR) {
                dy += 39;
            }
            ++i;
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)this.getFullTexturePath());
            api.func_73729_b(dx, dy, 0, 173, 102, 20);
            String s = o.display + ": " + String.valueOf(o.getValue());
            GL11.glTranslated((double)0.0, (double)0.0, (double)350.0);
            api.drawCenteredStringNoShadow(this.field_146289_q, s, dx + 51, dy + 6, 0xFFFFFF);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-350.0);
            if (!(o instanceof VariableOption)) continue;
            VariableOption v = (VariableOption)o;
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)this.getFullTexturePath());
            api.func_73729_b(dx, dy += sy, 0, 173, 102, 20);
            s = "Variance: " + String.valueOf(v.getVariance());
            GL11.glTranslated((double)0.0, (double)0.0, (double)350.0);
            api.drawCenteredStringNoShadow(this.field_146289_q, s, dx + 51, dy + 6, 0xFFFFFF);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-350.0);
            ++i;
        }
    }

    @Override
    public String getGuiTexture() {
        return "particle";
    }

    static {
        for (int i = 0; i < ChromaIcons.iconList.length; ++i) {
            ChromaIcons ico = ChromaIcons.iconList[i];
            if (!GuiParticleSpawner.isIconAllowed(ico)) continue;
            permittedIcons.add(ico);
        }
    }

    private static class VariableOption<N extends Number>
    extends Option {
        private final TileEntityParticleSpawner.VariableValue<N> value;

        private VariableOption(String s, TileEntityParticleSpawner.VariableValue<N> v) {
            super(s);
            this.value = v;
        }

        public Number getValue() {
            return this.value.getValue();
        }

        public Number getVariance() {
            return this.value.getVariation();
        }
    }

    private static class SliderOption<N extends Number>
    extends Option {
        private final BoundedValue<N> value;

        private SliderOption(String s, BoundedValue<N> v) {
            super(s);
            this.value = v;
        }

        public Number getValue() {
            return this.value.getValue();
        }
    }

    private static class ToggleOption<N extends Number>
    extends Option {
        private boolean isEnabled;

        private ToggleOption(String s) {
            this(s, false);
        }

        private ToggleOption(String s, boolean b) {
            super(s);
            this.isEnabled = b;
        }

        public Number getValue() {
            return this.isEnabled ? 1 : 0;
        }
    }

    private static abstract class Option<N extends Number> {
        public final String display;

        private Option(String s) {
            this.display = s;
        }

        public abstract N getValue();
    }

    private static enum GuiPage {
        POSITION,
        VELOCITY,
        COLOR,
        ICON,
        TIMING,
        MODIFIER;

        private static final GuiPage[] list;
        private final ArrayList<Option> options = new ArrayList();

        private void initOptions(TileEntityParticleSpawner p, boolean RGB) {
            this.options.clear();
            switch (this) {
                case POSITION: {
                    this.options.add(new VariableOption("X Position", p.particles.particlePositionX));
                    this.options.add(new VariableOption("Y Position", p.particles.particlePositionY));
                    this.options.add(new VariableOption("Z Position", p.particles.particlePositionZ));
                    break;
                }
                case VELOCITY: {
                    this.options.add(new VariableOption("X Velocity", p.particles.particleVelocityX));
                    this.options.add(new VariableOption("Y Velocity", p.particles.particleVelocityY));
                    this.options.add(new VariableOption("Z Velocity", p.particles.particleVelocityZ));
                    break;
                }
                case COLOR: {
                    int color = p.particles.particleColor;
                    int r = ReikaColorAPI.getRed((int)color);
                    int g = ReikaColorAPI.getGreen((int)color);
                    int b = ReikaColorAPI.getBlue((int)color);
                    if (RGB) {
                        this.options.add(new SliderOption("Red", new BoundedValue((Number)0, (Number)255, (Number)r)));
                        this.options.add(new SliderOption("Green", new BoundedValue((Number)0, (Number)255, (Number)g)));
                        this.options.add(new SliderOption("Blue", new BoundedValue((Number)0, (Number)255, (Number)b)));
                    } else {
                        float[] hsv = Color.RGBtoHSB(r, g, b, null);
                        int hue = (int)(hsv[0] * 360.0f);
                        float sat = hsv[1];
                        float lum = hsv[2];
                        this.options.add(new SliderOption("Hue", new BoundedValue((Number)0, (Number)360, (Number)hue)));
                        this.options.add(new SliderOption("Saturation", new BoundedValue((Number)Float.valueOf(0.0f), (Number)1, (Number)Float.valueOf(sat)).setStep((Number)Float.valueOf(0.03125f))));
                        this.options.add(new SliderOption("Luminosity", new BoundedValue((Number)Float.valueOf(0.0f), (Number)1, (Number)Float.valueOf(lum)).setStep((Number)Float.valueOf(0.03125f))));
                    }
                    this.options.add(new ToggleOption("Cycling Color", p.particles.cyclingColor));
                    break;
                }
                case ICON: {
                    break;
                }
                case TIMING: {
                    this.options.add(new VariableOption("Lifetime", p.particles.particleLife));
                    this.options.add(new SliderOption("Rate", p.particles.particleRate));
                    this.options.add(new ToggleOption("Alpha Fade", p.particles.alphaFade));
                    break;
                }
                case MODIFIER: {
                    this.options.add(new VariableOption("Gravity", p.particles.particleGravity));
                    this.options.add(new VariableOption("Size", p.particles.particleSize));
                    this.options.add(new ToggleOption("Collision", p.particles.particleCollision));
                    this.options.add(new ToggleOption("Fast Expand", p.particles.rapidExpand));
                    this.options.add(new ToggleOption("No Slowdown", p.particles.noSlowdown));
                }
            }
        }

        static {
            list = GuiPage.values();
        }
    }
}

