/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Decoration.TileEntityCrystalMusic;
import Reika.DragonAPI.Base.CoreContainer;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Instantiable.GUI.PianoWheel;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import java.util.HashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class GuiCrystalMusic
extends GuiChromaBase
implements PianoWheel.PianoGui {
    private final TileEntityCrystalMusic music;
    private PianoWheel wheel;
    private int channel = 0;
    private boolean rest = false;
    private int activeNote;
    private int length;
    private Pages page = Pages.KEYS;
    private GuiTextField input;
    private static final HashMap<ReikaMusicHelper.Note, Integer> colors = new HashMap();

    public GuiCrystalMusic(EntityPlayer ep, TileEntityCrystalMusic te) {
        super((Container)new CoreContainer(ep, (TileEntity)te), ep, te);
        this.music = te;
        this.field_146999_f = 240;
        this.field_147000_g = 190;
        this.activeNote = 3;
        this.length = this.getNoteLength(this.activeNote);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        int r = 72;
        this.wheel = new PianoWheel((PianoWheel.PianoGui)this, ReikaMusicHelper.MusicKey.C3, 4, r, j + this.field_146999_f / 2, k + this.field_147000_g / 2 + 4, false);
        String file = "Textures/GUIs/musicoverlay.png";
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(4, j + 4, k + 4, 19, 20, this.page == Pages.MIDI ? 209 : 228, 116, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        if (this.page == Pages.KEYS) {
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(0, j + 4, k + 4 + 20, 19, 20, 228, 136, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(1, j + 4, k + 4 + 40, 19, 20, 228, 156, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(2, j + 4, k + 4 + 80, 28, 20, 228, 196, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(3, j + 4, k + 4 + 60, 21, 20, 228, 176, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        } else {
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(5, j + 4, k + 4 + 20, 19, 20, 209, 136, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        }
        if (this.page == Pages.KEYS) {
            for (int i = 0; i < 6; ++i) {
                int col = i % 3;
                int row = i / 3;
                int u = 60 + col * 20;
                int v = 216 + row * 20;
                if (this.rest) {
                    u += 120;
                }
                if (i == this.activeNote) {
                    u -= 60;
                }
                this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(50 + i, j + 48 + 4 + r * 2 + 8, k + this.field_147000_g / 2 + (i - 3) * 20, 20, 20, u, v, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
            }
        }
        if (this.page == Pages.KEYS) {
            int dx = (this.field_146999_f - 192) / 2;
            for (int i = 0; i < 16; ++i) {
                int u = 0 + i * 12;
                int v = i == this.channel ? 204 : 192;
                this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(16 + i, j + dx + i * 12, k + this.field_147000_g - 12 - 4, 12, 12, u, v, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
            }
        }
        if (this.page == Pages.MIDI) {
            this.input = new GuiTextField(this.field_146289_q, j + 8, k + 100, this.field_146999_f - 16, 16);
            this.input.func_146203_f(128);
            this.input.func_146195_b(false);
            this.input.func_146180_a("");
        }
    }

    protected void func_146284_a(GuiButton b) {
        if (b.field_146127_k == 0) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MUSICCLEAR.ordinal(), (TileEntity)this.music, (int[])new int[0]);
        } else if (b.field_146127_k == 1) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MUSICCLEARCHANNEL.ordinal(), (TileEntity)this.music, (int)this.channel);
        } else if (b.field_146127_k == 2) {
            this.rest = !this.rest;
        } else if (b.field_146127_k == 3) {
            this.music.dispatchDemo();
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MUSICDEMO.ordinal(), (TileEntity)this.music, (int[])new int[0]);
        } else if (b.field_146127_k == 4) {
            this.page = this.page.otherPage();
        } else {
            if (b.field_146127_k == 5) {
                this.music.loadLocalMIDI(this.input.func_146179_b());
                return;
            }
            if (b.field_146127_k >= 16 && b.field_146127_k < 32) {
                this.channel = b.field_146127_k - 16;
            } else if (b.field_146127_k >= 50 && b.field_146127_k < 56) {
                this.activeNote = b.field_146127_k - 50;
                this.length = this.getNoteLength(this.activeNote);
            }
        }
        this.func_73866_w_();
    }

    private int getNoteLength(int idx) {
        switch (idx) {
            case 0: {
                return 48;
            }
            case 1: {
                return 36;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        if (this.page == Pages.KEYS) {
            this.wheel.mouseClicked(b, x, y);
        } else if (this.page == Pages.MIDI) {
            this.input.func_146192_a(x, y, b);
        }
    }

    protected void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (this.page == Pages.MIDI) {
            this.input.func_146201_a(c, i);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
    }

    @Override
    protected void func_146976_a(float p, int a, int b) {
        super.func_146976_a(p, a, b);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.page == Pages.KEYS) {
            this.wheel.draw(false, false, false);
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            GL11.glDisable((int)3008);
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/GUIs/musicoverlay.png");
            this.func_73729_b(this.wheel.originX - this.wheel.radius - 16, this.wheel.originY - this.wheel.radius - 16, 0, 0, 176, 176);
            GL11.glPopAttrib();
        } else if (this.page == Pages.MIDI) {
            this.input.func_146194_f();
            if (!this.input.func_146206_l()) {
                int d = this.input.func_146198_h();
            }
            ReikaGuiAPI.instance.drawCenteredStringNoShadow(this.field_146289_q, "Select a MIDI file. Be sure to include", j + this.field_146999_f / 2 + 1, k + 64, 0xFFFFFF);
            ReikaGuiAPI.instance.drawCenteredStringNoShadow(this.field_146289_q, "C:/ and file extension and use \"/\", not \"\\\".", j + this.field_146999_f / 2 + 1, k + 74, 0xFFFFFF);
        }
    }

    @Override
    public String getGuiTexture() {
        return "music";
    }

    public void onKeyPressed(ReikaMusicHelper.MusicKey key) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (Entity)this.player, (float)1.0f, (float)((float)CrystalMusicManager.instance.getPitchFactor(key)));
        for (CrystalElement e : CrystalMusicManager.instance.getColorsWithKey(key)) {
            this.music.playCrystal(this.music.field_145850_b, this.music.field_145851_c, this.music.field_145848_d, this.music.field_145849_e, e, this.length);
        }
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MUSICNOTE.ordinal(), (TileEntity)this.music, (int)this.channel, (int)key.ordinal(), (int)this.length, (int)(this.rest ? 1 : 0));
    }

    public int getColor(ReikaMusicHelper.MusicKey key) {
        return colors.get(key.getNote());
    }

    static {
        colors.put(ReikaMusicHelper.Note.C, CrystalElement.BLACK.getColor());
        colors.put(ReikaMusicHelper.Note.CSHARP, CrystalElement.RED.getColor());
        colors.put(ReikaMusicHelper.Note.D, CrystalElement.ORANGE.getColor());
        colors.put(ReikaMusicHelper.Note.EFLAT, CrystalElement.CYAN.getColor());
        colors.put(ReikaMusicHelper.Note.E, CrystalElement.YELLOW.getColor());
        colors.put(ReikaMusicHelper.Note.F, CrystalElement.LIME.getColor());
        colors.put(ReikaMusicHelper.Note.FSHARP, CrystalElement.GREEN.getColor());
        colors.put(ReikaMusicHelper.Note.G, CrystalElement.BLUE.getColor());
        colors.put(ReikaMusicHelper.Note.GSHARP, CrystalElement.MAGENTA.getColor());
        colors.put(ReikaMusicHelper.Note.A, CrystalElement.PURPLE.getColor());
        colors.put(ReikaMusicHelper.Note.BFLAT, CrystalElement.LIGHTBLUE.getColor());
        colors.put(ReikaMusicHelper.Note.B, CrystalElement.PINK.getColor());
    }

    private static enum Pages {
        KEYS,
        MIDI;


        private Pages otherPage() {
            return this == KEYS ? MIDI : KEYS;
        }
    }
}

