/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Tile;

import Reika.ChromatiCraft.Auxiliary.ChromaBookData;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Base.GuiChromaBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Container.ContainerCastingAuto;
import Reika.ChromatiCraft.Items.ItemChromaPlacer;
import Reika.ChromatiCraft.Items.Tools.ItemPendant;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiCastingAuto
extends GuiChromaBase {
    private static final List<ChromaResearch> list = new ArrayList<ChromaResearch>();
    private int index = 0;
    private int number = 1;
    private final List<CastingRecipe> usableRecipes = new ArrayList<CastingRecipe>();
    private final List<CastingRecipe> visible = new ArrayList<CastingRecipe>();
    private final TileEntityCastingAuto tile;

    public GuiCastingAuto(TileEntityCastingAuto te, EntityPlayer ep) {
        super((Container)new ContainerCastingAuto(te, ep), ep, te);
        this.field_146999_f = 224;
        this.field_147000_g = 227;
        this.tile = te;
        Collection<CastingRecipe> recipes = te.getAvailableRecipes();
        for (ChromaResearch r : list) {
            if (!ChromaResearchManager.instance.playerHasFragment(ep, r)) continue;
            ArrayList<CastingRecipe> c = r.getCraftingRecipes();
            for (CastingRecipe cr : c) {
                if (!recipes.contains(cr)) continue;
                this.usableRecipes.add(cr);
            }
        }
        this.filterRecipes();
        this.index = this.visible.contains(te.getCurrentRecipeOutput()) ? this.visible.indexOf(te.getCurrentRecipeOutput()) : 0;
    }

    private CastingRecipe getRecipe() {
        return this.index >= 0 && !this.visible.isEmpty() ? this.visible.get(this.index) : null;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        String tex = "Textures/GUIs/buttons.png";
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(0, j + 144, k + 32, 74, 10, 100, 36, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(1, j + 144, k + 42, 74, 10, 100, 46, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(3, j + 40, k + 32, 10, 10, 90, 16, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(2, j + 40, k + 42, 10, 10, 90, 26, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(4, j + 28, k + 32, 10, 10, 90, 66, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(5, j + 28, k + 42, 10, 10, 90, 56, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (Minecraft.func_71410_x().field_71441_e.func_82737_E() % 5L == 0L) {
            this.filterRecipes();
        }
    }

    private void filterRecipes() {
        this.visible.clear();
        Container c = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (c instanceof ContainerCastingAuto) {
            ContainerCastingAuto cc = (ContainerCastingAuto)c;
            for (CastingRecipe cr : this.usableRecipes) {
                if (!cc.isRecipeValid(cr)) continue;
                this.visible.add(cr);
            }
        }
        Collections.sort(this.visible, new CastingRecipe.RecipeComparator());
        this.index = Math.min(this.index, this.visible.size() - 1);
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        switch (b.field_146127_k) {
            case 0: {
                this.prevRecipe(GuiScreen.func_146271_m(), Keyboard.isKeyDown((int)42));
                break;
            }
            case 1: {
                this.nextRecipe(GuiScreen.func_146271_m(), Keyboard.isKeyDown((int)42));
                break;
            }
            case 2: {
                if (this.number > 1) {
                    this.number -= this.getIncrement();
                }
                if (this.number >= 1) break;
                this.number = 1;
                break;
            }
            case 3: {
                this.number += this.getIncrement();
                break;
            }
            case 4: {
                if (this.getRecipe() == null) break;
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.AUTORECIPE.ordinal(), (TileEntity)this.tile, (int)RecipesCastingTable.instance.getIDForRecipe(this.getRecipe()), (int)this.number);
                break;
            }
            case 5: {
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.AUTOCANCEL.ordinal(), (TileEntity)this.tile, (int[])new int[0]);
            }
        }
    }

    protected void func_73869_a(char c, int key) {
        super.func_73869_a(c, key);
        if (key == 207) {
            this.index = this.visible.size() - 1;
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)0.5f, (float)1.0f);
        } else if (key == 199) {
            this.index = 0;
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)0.5f, (float)1.0f);
        }
    }

    private void prevRecipe(boolean newItem, boolean newType) {
        CastingRecipe cr = this.getRecipe();
        ItemStack cur = null;
        if (cr != null) {
            cur = cr.getOutput();
        }
        if (this.index > 0) {
            do {
                --this.index;
                this.number = 1;
                cr = this.getRecipe();
            } while (this.index > 0 && (newItem || newType) && this.getRecipe() != null && this.matchRecipe(cur, cr, newType));
        }
    }

    private void nextRecipe(boolean newItem, boolean newType) {
        CastingRecipe cr = this.getRecipe();
        ItemStack cur = null;
        if (cr != null) {
            cur = cr.getOutput();
        }
        if (this.index < this.visible.size() - 1) {
            do {
                ++this.index;
                this.number = 1;
                cr = this.getRecipe();
            } while (this.index < this.visible.size() - 1 && (newItem || newType) && this.getRecipe() != null && this.matchRecipe(cur, cr, newType));
        }
    }

    private boolean matchRecipe(ItemStack cur, CastingRecipe r, boolean newType) {
        if (newType) {
            if (cur.func_77973_b() instanceof ItemPendant) {
                return r.getOutput().func_77973_b() instanceof ItemPendant;
            }
            if (cur.func_77973_b() instanceof ItemChromaPlacer) {
                return r.getOutput().func_77960_j() == cur.func_77960_j();
            }
        }
        return newType ? cur.func_77973_b() == this.getRecipe().getOutput().func_77973_b() : ReikaItemHelper.matchStacks((ItemStack)cur, (ItemStack)this.getRecipe().getOutput());
    }

    private int getIncrement() {
        return Keyboard.isKeyDown((int)42) ? 64 : (GuiScreen.func_146271_m() ? 16 : 1);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        CastingRecipe cr = this.getRecipe();
        if (cr != null) {
            ChromaBookData.drawCompressedCastingRecipe(this.field_146289_q, field_146296_j, cr, j, k);
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        CastingRecipe cr = this.getRecipe();
        if (cr != null) {
            GL11.glPushAttrib((int)1048575);
            ItemStack out = cr.getOutput();
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            String s = out.func_82833_r();
            if (ChromaItems.ADJACENCY.matchWith(out)) {
                s = s + " (Tier " + out.field_77990_d.func_74762_e("tier") + ")";
            }
            this.field_146289_q.func_78276_b(s, 10, 18, 0xFFFFFF);
            this.field_146289_q.func_78276_b(String.format("x%d = %d", this.number, this.number * out.field_77994_a), 74, 38, 0xFFFFFF);
            api.drawItemStack(field_146296_j, out, 52, 34);
            GL11.glPopAttrib();
        }
    }

    @Override
    public String getGuiTexture() {
        return "automator3";
    }

    static {
        for (ChromaResearch r : ChromaResearch.getAllNonParents()) {
            if (!r.isCrafting() || r.getRecipeCount() <= 0) continue;
            list.add(r);
        }
    }
}

