/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class GuiChromability
extends GuiScreen
implements CustomSoundGuiButton.CustomSoundGui {
    protected final EntityPlayer player;
    protected int xSize;
    protected int ySize;
    protected final ArrayList<AbilityAPI.Ability> abilities = new ArrayList();
    private int index = 0;
    private int dx = 0;

    public GuiChromability(EntityPlayer ep) {
        this.player = ep;
        this.xSize = 232;
        this.ySize = 188;
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            ChromaDescriptions.reload();
        }
        this.abilities.addAll(Chromabilities.getAbilitiesAvailableToPlayer(ep));
    }

    public final void playButtonSound(GuiButton b) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)0.5f, (float)1.0f);
    }

    public final void playHoverSound(GuiButton b) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUISEL, (Entity)this.player, (float)0.8f, (float)1.0f);
    }

    protected final AbilityAPI.Ability getActiveAbility() {
        return this.abilities.get(this.index);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int midx = this.field_146294_l / 2;
        int midy = this.field_146295_m / 2;
        int w = 12;
        int h = this.ySize - 14;
        int out = this.xSize / 2;
        String tex = this.getButtonTexture();
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(0, midx - w - out, midy - h / 2, w, h, 244, 0, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(1, midx + out, midy - h / 2, w, h, 232, 0, tex, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
    }

    protected String getButtonTexture() {
        return "Textures/GUIs/ability.png";
    }

    protected void func_146284_a(GuiButton b) {
        switch (b.field_146127_k) {
            case 0: {
                this.scrollRight(1);
                break;
            }
            case 1: {
                this.scrollLeft(1);
            }
        }
    }

    protected final void scrollLeft(int n) {
        if (this.dx == 0 && this.index < this.abilities.size() - 1) {
            for (int i = 0; i < n - 1 && this.index < this.abilities.size() - 2; ++i) {
                ++this.index;
            }
            --this.dx;
            this.markButtons(false);
        }
    }

    protected final void scrollRight(int n) {
        if (this.dx == 0 && this.index > 0) {
            for (int i = 0; i < n - 1 && this.index > 1; ++i) {
                --this.index;
            }
            ++this.dx;
            this.markButtons(false);
        }
    }

    private void markButtons(boolean on) {
        this.func_73866_w_();
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton b2 = (GuiButton)this.field_146292_n.get(i);
            b2.field_146125_m = on;
        }
    }

    public final void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbilityAPI.Ability c = this.abilities.get(this.index);
        boolean has = Chromabilities.playerHasAbility(this.player, c);
        double px = 2.0 * (double)Math.abs(this.dx) / (double)this.field_146294_l;
        int sp = Math.max(1, (int)(360.0 / (double)Math.max(1, ReikaRenderHelper.getFPS()) * Math.max(1.0, 6.0 * Math.abs(-(px * px) + 2.0 * px))));
        if (this.dx > 0) {
            this.dx += sp;
        }
        if (this.dx < 0) {
            this.dx -= sp;
        }
        if (this.dx >= this.field_146294_l) {
            this.dx = 0;
            --this.index;
            this.markButtons(true);
        }
        if (this.dx <= -this.field_146294_l) {
            this.dx = 0;
            ++this.index;
            this.markButtons(true);
        }
        int m = this.dx != 0 ? 1 : 0;
        int min = this.index > 0 ? -m : 0;
        int max = this.index < this.abilities.size() - 1 ? m : 0;
        for (int i = min; i <= max; ++i) {
            int a = j + i * this.field_146294_l + this.dx;
            AbilityAPI.Ability ca = this.abilities.get(this.index + i);
            String s = this.getBackTexture(ca);
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)s);
            this.func_73729_b(a, k, 0, 0, this.xSize, this.ySize);
        }
        this.drawPreview(c, j, k);
        this.field_146289_q.func_78276_b(c.getDisplayName(), j + 63 + this.dx, k + 9, 0);
        if (this.dx != 0) {
            if (this.index > 0) {
                c = this.abilities.get(this.index - 1);
                this.field_146289_q.func_78276_b(c.getDisplayName(), j + 63 + this.dx - this.field_146294_l, k + 9, 0);
            }
            if (this.index < this.abilities.size() - 1) {
                c = this.abilities.get(this.index + 1);
                this.field_146289_q.func_78276_b(c.getDisplayName(), j + 63 + this.dx + this.field_146294_l, k + 9, 0);
            }
        }
        int fx = 9;
        int fy = 64;
        if (!has) {
            // empty if block
        }
        String desc = c.getDescription();
        this.field_146289_q.func_78279_b(desc, j + this.dx + fx, k + fy, this.xSize - fx * 2, 0xFFFFFF);
        if (this.dx != 0) {
            if (this.index > 0) {
                c = this.abilities.get(this.index - 1);
                desc = c.getDescription();
                this.field_146289_q.func_78279_b(desc, j + this.dx + fx - this.field_146294_l, k + fy, this.xSize - fx * 2, 0xFFFFFF);
            }
            if (this.index < this.abilities.size() - 1) {
                c = this.abilities.get(this.index + 1);
                desc = c.getDescription();
                this.field_146289_q.func_78279_b(desc, j + this.dx + fx + this.field_146294_l, k + fy, this.xSize - fx * 2, 0xFFFFFF);
            }
        }
    }

    protected String getBackTexture(AbilityAPI.Ability a) {
        return Chromabilities.playerHasAbility(this.player, a) ? "Textures/GUIs/ability.png" : "Textures/GUIs/ability2.png";
    }

    private void drawPreview(AbilityAPI.Ability c, int j, int k) {
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)this.getTextureName(c));
        GL11.glPushMatrix();
        double d = 0.1953125;
        GL11.glScaled((double)d, (double)d, (double)d);
        int x = j + 8 + this.dx;
        int y = k + 8;
        this.func_73729_b((int)((double)x / d), (int)((double)y / d), 0, 0, 256, 256);
        if (this.dx != 0) {
            if (this.index > 0) {
                c = this.abilities.get(this.index - 1);
                ReikaTextureHelper.bindTexture((Class)c.getTextureReferenceClass(), (String)this.getTextureName(c));
                x = j + 8 + this.dx - this.field_146294_l;
                this.func_73729_b((int)((double)x / d), (int)((double)y / d), 0, 0, 256, 256);
            }
            if (this.index < this.abilities.size() - 1) {
                c = this.abilities.get(this.index + 1);
                ReikaTextureHelper.bindTexture((Class)c.getTextureReferenceClass(), (String)this.getTextureName(c));
                x = j + 8 + this.dx + this.field_146294_l;
                this.func_73729_b((int)((double)x / d), (int)((double)y / d), 0, 0, 256, 256);
            }
        }
        GL11.glPopMatrix();
    }

    private String getTextureName(AbilityAPI.Ability c) {
        return c.getTexturePath(!Chromabilities.playerHasAbility(this.player, c));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
    }
}

