/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Base.BlockModelledChromaTile;
import Reika.ChromatiCraft.Base.GuiBookSection;
import Reika.ChromatiCraft.Entity.EntityChromaEnderCrystal;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiStructure
extends GuiBookSection {
    private int mode = 0;
    private int tick = 0;
    private final FilledBlockArray array = this.page.getStructure().getStructureForDisplay();
    private final StructureRenderer render;

    public GuiStructure(EntityPlayer ep, ChromaResearch r) {
        super(ChromaGuis.STRUCTURE, ep, r, 256, 220, false);
        int dy;
        int dz;
        int dx;
        int i;
        if (this.page.name().toLowerCase(Locale.ENGLISH).contains("casting")) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ(), ChromaTiles.TABLE.getBlock(), ChromaTiles.TABLE.getBlockMetadata());
            if (this.page == ChromaResearch.CASTING2 || this.page == ChromaResearch.CASTING3) {
                for (i = -4; i <= 4; i += 2) {
                    for (int k = -4; k <= 4; k += 2) {
                        if (i == 0 && k == 0) continue;
                        dx = this.array.getMidX() + i;
                        dz = this.array.getMidZ() + k;
                        dy = this.array.getMinY() + 1 + (Math.abs(i) != 4 && Math.abs(k) != 4 ? 0 : 1);
                        this.array.setBlock(dx, dy, dz, ChromaTiles.STAND.getBlock(), ChromaTiles.STAND.getBlockMetadata());
                    }
                }
            }
        }
        if (this.page == ChromaResearch.TREE || this.page == ChromaResearch.BOOSTTREE) {
            this.array.setBlock(this.array.getMidX() - 1, this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.POWERTREE.getBlock(), ChromaTiles.POWERTREE.getBlockMetadata());
        }
        if (this.page == ChromaResearch.INFUSION) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 2, this.array.getMidZ(), ChromaTiles.INFUSER.getBlock(), ChromaTiles.INFUSER.getBlockMetadata());
        }
        if (this.page == ChromaResearch.MINIPYLON) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 6, this.array.getMidZ(), ChromaTiles.PERSONAL.getBlock(), ChromaTiles.PERSONAL.getBlockMetadata());
        }
        if (this.page == ChromaResearch.PYLON || this.page == ChromaResearch.PYLONTURBO) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 9, this.array.getMidZ(), ChromaTiles.PYLON.getBlock(), ChromaTiles.PYLON.getBlockMetadata());
        }
        if (this.page == ChromaResearch.PYLONBROADCAST) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 10, this.array.getMidZ(), ChromaTiles.PYLON.getBlock(), ChromaTiles.PYLON.getBlockMetadata());
        }
        if (this.page == ChromaResearch.CLOAKTOWER) {
            this.array.setBlock(this.array.getMidX(), this.array.getMinY() + 5, this.array.getMidZ(), ChromaTiles.CLOAKING.getBlock(), ChromaTiles.CLOAKING.getBlockMetadata());
        }
        this.render = new StructureRenderer(this.array);
        if (this.page == ChromaResearch.PYLON || this.page == ChromaResearch.PYLONTURBO) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 9, this.array.getMidZ(), ChromaTiles.PYLON.getCraftedProduct());
        } else if (this.page == ChromaResearch.PYLONBROADCAST) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 10, this.array.getMidZ(), ChromaTiles.PYLON.getCraftedProduct());
        } else if (this.page == ChromaResearch.MINIPYLON) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 6, this.array.getMidZ(), ChromaTiles.PERSONAL.getCraftedProduct());
        } else if (this.page == ChromaResearch.CLOAKTOWER) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 5, this.array.getMidZ(), ChromaTiles.CLOAKING.getCraftedProduct());
        } else if (this.page == ChromaResearch.TREE || this.page == ChromaResearch.BOOSTTREE) {
            this.render.addOverride(this.array.getMidX() - 1, this.array.getMaxY(), this.array.getMidZ(), ChromaTiles.POWERTREE.getCraftedProduct());
        } else if (this.page == ChromaResearch.BEACONSTRUCT) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ(), ChromaTiles.BEACON.getCraftedProduct());
        } else if (this.page.name().contains("METEOR")) {
            ItemStack is = ChromaTiles.METEOR.getCraftedProduct();
            if (this.page == ChromaResearch.METEOR2) {
                is.field_77990_d = null;
            }
            if (this.page == ChromaResearch.METEOR2) {
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74768_a("tier", 1);
            }
            if (this.page == ChromaResearch.METEOR3) {
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74768_a("tier", 2);
            }
            this.render.addOverride(this.array.getMidX(), this.array.getMaxY() - 2, this.array.getMidZ(), is);
            this.render.addOverride(ChromaTiles.METEOR.getCraftedProduct(), is);
        } else if (this.page == ChromaResearch.MINIREPEATER) {
            this.render.addBlockHook(Blocks.field_150364_r, (StructureRenderer.BlockChoiceHook)new LogRenderHook());
            this.render.addBlockHook(Blocks.field_150363_s, (StructureRenderer.BlockChoiceHook)new LogRenderHook());
            for (i = 0; i < ModWoodList.woodList.length; ++i) {
                ModWoodList tree = ModWoodList.woodList[i];
                if (!tree.exists()) continue;
                this.render.addBlockHook(tree.getBlock(), (StructureRenderer.BlockChoiceHook)new LogRenderHook());
            }
        } else if (this.page == ChromaResearch.PORTALSTRUCT) {
            this.render.addOverride(new ItemStack(Blocks.field_150357_h), ChromaItems.ENDERCRYSTAL.getStackOfMetadata(1));
            this.render.addEntityRender(-5, -1, -9, GuiStructure.createCrystalRender());
            this.render.addEntityRender(-9, -1, -5, GuiStructure.createCrystalRender());
            this.render.addEntityRender(5, -1, -9, GuiStructure.createCrystalRender());
            this.render.addEntityRender(9, -1, -5, GuiStructure.createCrystalRender());
            this.render.addEntityRender(-5, -1, 9, GuiStructure.createCrystalRender());
            this.render.addEntityRender(-9, -1, 5, GuiStructure.createCrystalRender());
            this.render.addEntityRender(5, -1, 9, GuiStructure.createCrystalRender());
            this.render.addEntityRender(9, -1, 5, GuiStructure.createCrystalRender());
        }
        if (this.page != ChromaResearch.CAVERN) {
            this.render.addBlockHook(ChromaBlocks.RUNE.getBlockInstance(), (StructureRenderer.BlockChoiceHook)new RuneRenderHook());
        }
        if (this.page == ChromaResearch.GATESTRUCT) {
            this.render.addOverride(this.array.getMidX(), this.array.getMinY() + 1, this.array.getMidZ(), ChromaTiles.TELEPORT.getCraftedProduct());
        }
        if (this.page == ChromaResearch.CASTING2 || this.page == ChromaResearch.CASTING3) {
            for (i = -4; i <= 4; i += 2) {
                for (int k = -4; k <= 4; k += 2) {
                    if (i == 0 && k == 0) continue;
                    dx = this.array.getMidX() + i;
                    dz = this.array.getMidZ() + k;
                    dy = this.array.getMinY() + 1 + (Math.abs(i) != 4 && Math.abs(k) != 4 ? 0 : 1);
                    this.render.addOverride(dx, dy, dz, ChromaTiles.STAND.getCraftedProduct());
                }
            }
            this.render.addOverride(new ItemStack(ChromaTiles.STAND.getBlock(), ChromaTiles.STAND.getBlockMetadata()), ChromaTiles.STAND.getCraftedProduct());
        }
        this.render.addRenderHook(ChromaTiles.PYLON.getCraftedProduct(), (StructureRenderer.BlockRenderHook)new PylonRenderHook());
    }

    private static StructureRenderer.EntityRender createCrystalRender() {
        return new StructureRenderer.EntityRender((Entity)new EntityChromaEnderCrystal((World)Minecraft.func_71410_x().field_71441_e), ReikaEntityHelper.getEntityRenderer(EntityEnderCrystal.class));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.render.resetRotation();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.add(new CustomSoundGuiButton(0, j + 185, k - 2, 20, 20, "3D", (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton(1, j + 205, k - 2, 20, 20, "2D", (CustomSoundGuiButton.CustomSoundGui)this));
        this.field_146292_n.add(new CustomSoundGuiButton(4, this.mode == 1 ? j + 125 : j + 165, k - 2, 20, 20, "N#", (CustomSoundGuiButton.CustomSoundGui)this));
        if (this.mode == 1) {
            this.field_146292_n.add(new CustomSoundGuiButton(2, j + 165, k - 2, 20, 20, "+", (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton(3, j + 145, k - 2, 20, 20, "-", (CustomSoundGuiButton.CustomSoundGui)this));
        }
    }

    @Override
    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 0) {
            this.mode = 0;
            this.render.reset();
            this.func_73866_w_();
        } else if (b.field_146127_k == 1) {
            this.mode = 1;
            this.func_73866_w_();
        } else if (b.field_146127_k == 2) {
            this.render.incrementStepY();
            this.func_73866_w_();
        } else if (b.field_146127_k == 3) {
            this.render.decrementStepY();
            this.func_73866_w_();
        } else if (b.field_146127_k == 4) {
            this.mode = 2;
            this.func_73866_w_();
        }
    }

    @Override
    protected int getMaxSubpage() {
        return 0;
    }

    @Override
    protected GuiBookSection.PageType getGuiLayout() {
        return GuiBookSection.PageType.STRUCT;
    }

    @Override
    public final void func_73863_a(int mx, int my, float f) {
        super.func_73863_a(mx, my, f);
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String s = "(" + this.array.getSizeX() + "x" + this.array.getSizeY() + "x" + this.array.getSizeZ() + ")";
        this.field_146289_q.func_78276_b(s, j + 6, k + 10, 0xFFFFFF);
        ++this.tick;
        switch (this.mode) {
            case 0: {
                this.draw3d(j, k, f);
                break;
            }
            case 1: {
                this.drawSlice(j, k);
                break;
            }
            case 2: {
                this.drawTally(j, k);
            }
        }
    }

    private void drawSlice(int j, int k) {
        this.render.drawSlice(j, k);
    }

    private void drawTally(int j, int k) {
        ItemHashMap map = this.array.tally();
        int i = 0;
        int n = 8;
        ArrayList c = new ArrayList(map.keySet());
        Collections.sort(c, ReikaItemHelper.comparator);
        for (ItemStack is : c) {
            int dx = j + 10 + i / n * 50;
            int dy = k + 30 + i % n * 22;
            ItemStack is2 = is.func_77946_l();
            if (ChromaBlocks.CHROMA.match(is)) {
                is2 = ChromaItems.BUCKET.getStackOfMetadata(0);
            } else if (ChromaBlocks.RUNE.match(is)) {
                is2 = ChromaBlocks.RUNE.getStackOfMetadata(GuiStructure.getElementByTick());
            } else if (this.page == ChromaResearch.PORTALSTRUCT && Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150357_h) {
                is2 = ChromaItems.ENDERCRYSTAL.getStackOfMetadata(1);
            } else if ((this.page == ChromaResearch.TREE || this.page == ChromaResearch.BOOSTTREE) && Block.func_149634_a((Item)is.func_77973_b()) == ChromaBlocks.PYLON.getBlockInstance()) {
                is2 = ChromaTiles.POWERTREE.getCraftedProduct();
            } else if (this.page == ChromaResearch.CLOAKTOWER && Block.func_149634_a((Item)is.func_77973_b()) == ChromaBlocks.TILEMODELLED2.getBlockInstance()) {
                is2 = ChromaTiles.CLOAKING.getCraftedProduct();
            } else if (this.page.name().contains("METEOR") && Block.func_149634_a((Item)is.func_77973_b()) == ChromaTiles.METEOR.getBlock()) {
                is2 = ChromaTiles.METEOR.getCraftedProduct();
                if (this.page == ChromaResearch.METEOR1) {
                    is2.field_77990_d = new NBTTagCompound();
                    is2.field_77990_d.func_74768_a("tier", 0);
                } else if (this.page == ChromaResearch.METEOR2) {
                    is2.field_77990_d = new NBTTagCompound();
                    is2.field_77990_d.func_74768_a("tier", 1);
                } else if (this.page == ChromaResearch.METEOR3) {
                    is2.field_77990_d = new NBTTagCompound();
                    is2.field_77990_d.func_74768_a("tier", 2);
                }
            } else if (this.page.name().toLowerCase(Locale.ENGLISH).contains("casting") && ChromaBlocks.getEntryByID(ChromaTiles.STAND.getBlock()).match(is2) && is2.func_77960_j() == ChromaTiles.STAND.getBlockMetadata()) {
                is2 = ChromaTiles.STAND.getCraftedProduct();
            }
            if (ChromaBlocks.PYLON.match(is2)) {
                is2 = ChromaTiles.getTileFromIDandMetadata(Block.func_149634_a((Item)is2.func_77973_b()), is2.func_77960_j()).getCraftedProduct();
            }
            if (Block.func_149634_a((Item)is2.func_77973_b()) instanceof BlockModelledChromaTile) {
                is2 = ChromaTiles.getTileFromIDandMetadata(Block.func_149634_a((Item)is2.func_77973_b()), is2.func_77960_j()).getCraftedProduct();
            }
            api.drawItemStackWithTooltip(field_146296_j, this.field_146289_q, is2, dx, dy);
            this.field_146289_q.func_78276_b(String.valueOf(map.get(is)), dx + 20, dy + 5, 0xFFFFFF);
            ++i;
        }
    }

    private void draw3d(int j, int k, float ptick) {
        if (Mouse.isButtonDown((int)0) && this.tick > 2) {
            this.render.rotate(0.25 * (double)Mouse.getDY(), 0.25 * (double)Mouse.getDX(), 0.0);
        } else if (Mouse.isButtonDown((int)1)) {
            this.render.resetRotation();
        }
        if (Keyboard.isKeyDown((int)30)) {
            this.render.rotate(0.0, 0.75, 0.0);
        } else if (Keyboard.isKeyDown((int)32)) {
            this.render.rotate(0.0, -0.75, 0.0);
        } else if (Keyboard.isKeyDown((int)17)) {
            this.render.rotate(-0.75, 0.0, 0.0);
        } else if (Keyboard.isKeyDown((int)31)) {
            this.render.rotate(0.75, 0.0, 0.0);
        }
        this.render.draw3D(j, k, ptick, true);
    }

    private static int getElementByTick() {
        return (int)(System.currentTimeMillis() / 4000L % 16L);
    }

    private static class LogRenderHook
    implements StructureRenderer.BlockChoiceHook {
        private LogRenderHook() {
        }

        public ItemStack getBlock(Coordinate pos, int meta) {
            ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])ReikaTreeHelper.treeList);
            for (int i = 0; i < ModWoodList.woodList.length; ++i) {
                ModWoodList tree = ModWoodList.woodList[i];
                if (!tree.exists()) continue;
                li.add(tree);
            }
            int tick = (int)(System.currentTimeMillis() / 1000L % (long)li.size());
            return ((TreeType)li.get(tick)).getItem();
        }
    }

    private static class RuneRenderHook
    implements StructureRenderer.BlockChoiceHook {
        private RuneRenderHook() {
        }

        public ItemStack getBlock(Coordinate pos, int meta) {
            return new BlockKey(ChromaBlocks.RUNE.getBlockInstance(), GuiStructure.getElementByTick()).asItemStack();
        }
    }

    private static class PylonRenderHook
    implements StructureRenderer.BlockRenderHook {
        private PylonRenderHook() {
        }

        public double getScale() {
            return 2.0;
        }

        public int getOffsetX() {
            return -4;
        }

        public int getOffsetY() {
            return -6;
        }
    }
}

