/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.GuiScrollingPage;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.SequenceMap;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import java.awt.Point;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;

public class GuiProgressStages
extends GuiScrollingPage {
    private int randomIndex;
    private int clearLength;
    private ProgressionManager.ProgressStage active;
    private final SequenceMap.Topology<ProgressionManager.ProgressStage> map = ProgressionManager.instance.getTopology();
    private final Map<ProgressionManager.ProgressStage, Integer> levels = this.map.getDepthMap();
    private final EnumMap<ProgressionManager.ProgressStage, org.lwjgl.util.Point> renderPositions = new EnumMap(ProgressionManager.ProgressStage.class);
    private final EnumMap<ProgressionManager.ProgressStage, Rectangle> locations = new EnumMap(ProgressionManager.ProgressStage.class);
    private int elementWidth = 0;
    private int elementHeight = 20;
    private static final int spacingX = 30;
    private static final int spacingY = 15;

    public GuiProgressStages(EntityPlayer ep) {
        super(ChromaGuis.PROGRESS, ep, 256, 220, 242, 112);
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            ChromaDescriptions.reload();
        }
        HashMap<Integer, Integer> offsets = new HashMap<Integer, Integer>();
        for (ProgressionManager.ProgressStage p : this.levels.keySet()) {
            int depth = this.levels.get(p);
            int d = offsets.containsKey(depth) ? (Integer)offsets.get(depth) : 0;
            int dx = d * (this.elementWidth + 30);
            int dy = depth * (this.elementHeight + 15);
            offsets.put(depth, d + 1);
            this.renderPositions.put(p, new org.lwjgl.util.Point(dx, dy));
            this.elementWidth = 20;
            this.maxX = Math.max(this.maxX, dx + this.elementWidth);
            this.maxY = Math.max(this.maxY, dy + this.elementHeight);
        }
        this.maxX -= this.paneWidth - 15;
        this.maxY -= this.paneHeight - 15 - 30;
        if (this.maxX < 0) {
            this.maxX = 0;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String file = "Textures/GUIs/Handbook/buttons.png";
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(10, j + this.xSize, k, 22, 39, 42, 126, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Return");
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 10) {
            this.goTo(ChromaGuis.BOOKNAV, null);
            this.resetOffset();
        }
        this.func_73866_w_();
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        int posX = (this.field_146294_l - this.xSize) / 2;
        int posY = (this.field_146295_m - this.ySize) / 2 - 8;
        super.func_73863_a(x, y, f);
        this.renderTree(posX, posY);
        this.renderText(posX, posY);
    }

    private void renderTree(int posX, int posY) {
        this.locations.clear();
        this.renderLines(posX, posY);
        this.renderElements(posX, posY);
    }

    private void renderLines(int posX, int posY) {
        for (ProgressionManager.ProgressStage p : this.levels.keySet()) {
            this.renderLine(posX, posY, p);
        }
    }

    private void renderLine(int posX, int posY, ProgressionManager.ProgressStage p) {
        Collection c = this.map.getParents((Object)p);
        int dx = -offsetX + posX + 12;
        int dy = -offsetY + posY + 36;
        org.lwjgl.util.Point pt = this.renderPositions.get(p);
        for (ProgressionManager.ProgressStage par : c) {
            int y2;
            org.lwjgl.util.Point pt2 = this.renderPositions.get(par);
            int x1 = dx + pt.getX() + this.elementWidth / 2;
            int y1 = dy + pt.getY();
            int x2 = dx + pt2.getX() + this.elementWidth / 2;
            ImmutablePair ps = ReikaVectorHelper.clipLine((int)x1, (int)x2, (int)y1, (int)(y2 = dy + pt2.getY() + this.elementHeight), (int)(posX + 8), (int)(posY + 26), (int)(posX + this.xSize - 8), (int)(posY + this.ySize / 2 + 6));
            if (ps == null) continue;
            int clr = p == this.active || par == this.active ? 65280 : 0xFFFFFF;
            api.drawLine(((Point)ps.left).x, ((Point)ps.left).y, ((Point)ps.right).x, ((Point)ps.right).y, clr);
        }
    }

    private void renderElements(int posX, int posY) {
        for (ProgressionManager.ProgressStage p : this.levels.keySet()) {
            int y;
            org.lwjgl.util.Point pt;
            int x;
            if (!this.elementOnScreen(p, posX, posY, x = -offsetX + posX + 12 + (pt = this.renderPositions.get(p)).getX(), y = -offsetY + posY + 36 + pt.getY())) continue;
            this.renderElement(p, x, y);
        }
    }

    private boolean elementOnScreen(ProgressionManager.ProgressStage p, int posX, int posY, int x, int y) {
        return x >= posX + 8 && x <= posX + this.xSize - this.elementWidth - 8 && y >= posY + 24 && y - posY + this.elementHeight < this.ySize / 2;
    }

    private void renderElement(ProgressionManager.ProgressStage p, int x, int y) {
        int color = 0xFFFFFF;
        boolean see = this.renderClearText(p);
        GuiProgressStages.func_73734_a((int)x, (int)y, (int)(x + this.elementWidth), (int)(y + this.elementHeight), (int)-12303292);
        api.drawRectFrame(x, y, this.elementWidth, this.elementHeight, color);
        if (see || p.isOneStepAway(this.player)) {
            String s;
            String string = s = see ? p.getTitleString() : EnumChatFormatting.OBFUSCATED.toString() + p.getTitleString();
            if (!see) {
                color = 0xB5B5B5;
            }
            int dx = (this.elementWidth - this.field_146289_q.func_78256_a(s)) / 2;
            int dy = (this.elementHeight - this.field_146289_q.field_78288_b) / 2;
        } else {
            color = 0x888888;
        }
        if (see) {
            if (p.isPlayerAtStage(this.player)) {
                p.renderIcon(field_146296_j, this.field_146289_q, x + 2, y + 2);
            } else {
                GL11.glPushAttrib((int)1048575);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GuiProgressStages.field_146296_j.field_77024_a = false;
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2884);
                p.renderIcon(field_146296_j, this.field_146289_q, x + 2, y + 2);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopAttrib();
            }
        } else {
            GL11.glPushAttrib((int)1048575);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.INVERTEDADD.apply();
            api.func_94065_a(x + 2, y + 2, ChromaIcons.QUESTION.getIcon(), 16, 16);
            GL11.glPopAttrib();
        }
        this.locations.put(p, new Rectangle(x, y, this.elementWidth, this.elementHeight));
    }

    private boolean renderClearText(ProgressionManager.ProgressStage p) {
        return p.isPlayerAtStage(this.player) || p.playerHasPrerequisites(this.player);
    }

    private void renderText(int posX, int posY) {
        int c = 0xFFFFFF;
        int px = posX + 8;
        if (this.active != null) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ProgressionManager.ProgressStage p = this.active;
            if (p.isOneStepAway(this.player) || p.playerHasPrerequisites(this.player)) {
                this.field_146289_q.func_78279_b(p.getTitleString(), px, posY + 88 + 36, 242, 0xFFFFFF);
            } else {
                ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78279_b(p.getTitleString(), px, posY + 88 + 36, 242, 0xFFFFFF);
            }
            if (this.renderClearText(p)) {
                this.field_146289_q.func_78279_b(p.getHintString(), px, posY + 88 + 36 + 20, 242, 0xFFFFFF);
            } else {
                ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78279_b(p.getHintString(), px, posY + 88 + 36 + 20, 242, 0xFFFFFF);
            }
            int dy = posY + 88 + 100 + 15;
            if (p.isPlayerAtStage(this.player)) {
                String s = p.getRevealedString();
                this.field_146289_q.func_78279_b(s, px, dy -= this.field_146289_q.field_78288_b * this.field_146289_q.func_78256_a(s) / 242, 242, 0xFFFFFF);
            } else {
                ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78279_b(this.getIncompleteText(), px, dy, 242, 0xFFFFFF);
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        ProgressionManager.ProgressStage p = this.getUnderMouse(x, y);
        if (p != null) {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)0.33f, (float)1.0f);
            ChromaFontRenderer.FontType.OBFUSCATED.renderer.rerandomize();
        }
        this.active = p;
    }

    private ProgressionManager.ProgressStage getUnderMouse(int x, int y) {
        for (ProgressionManager.ProgressStage p : this.locations.keySet()) {
            Rectangle r = this.locations.get(p);
            if (!r.contains(x, y)) continue;
            return p;
        }
        return null;
    }

    private String getIncompleteText() {
        return this.getIncompleteString();
    }

    private String getIncompleteString() {
        return "There is still much to learn...";
    }

    private void randomizeString() {
        String s = this.getIncompleteString();
        this.randomIndex = rand.nextInt(s.length());
        this.clearLength = Math.min(Math.max(4, rand.nextInt(s.length())), Math.min(rand.nextInt(3) == 0 ? 12 : 6, s.length() - this.randomIndex));
    }

    @Override
    public String getBackgroundTexture() {
        return "Textures/GUIs/Handbook/progress.png";
    }

    @Override
    protected String getScrollingTexture() {
        return "Textures/GUIs/Handbook/navbcg.png";
    }
}

