/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.GuiScrollingPage;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemChromaBook;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.Data.Maps.RegionMap;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiNavigation
extends GuiScrollingPage {
    private static boolean craftMode = false;
    private final TreeMap<ChromaResearch, Section> sections = new TreeMap();
    private static final int SectionSpacing = 32;
    private static RegionMap<SectionElement> locations = new RegionMap();
    private static PluralMap<String> tooltips = new PluralMap(2);
    private final boolean isCreative;

    public GuiNavigation(EntityPlayer ep) {
        super(ChromaGuis.BOOKNAV, ep, 256, 220, 242, 206);
        Section z = null;
        for (int i = 0; i < ChromaResearch.researchList.length; ++i) {
            ChromaResearch b = ChromaResearch.researchList[i];
            if (b.isParent()) {
                z = new Section(b.getTitle());
                this.sections.put(b, z);
                continue;
            }
            if (!ItemChromaBook.hasPage(this.player.func_71045_bC(), b) || b.isDummiedOut()) continue;
            z.addElement(new SectionElement(b, this));
        }
        this.isCreative = ItemChromaBook.isCreative(this.player.func_71045_bC());
        Iterator<ChromaResearch> it = this.sections.keySet().iterator();
        while (it.hasNext()) {
            ChromaResearch r = it.next();
            Section s = this.sections.get(r);
            if (s.elements.isEmpty()) {
                it.remove();
                continue;
            }
            this.maxX = Math.max(this.maxX, leftX + 15 + s.getWidth(4));
            this.maxY += 32 + s.getHeight(4);
        }
        this.maxX -= this.paneWidth + 64 + 16;
        this.maxY -= this.paneHeight + 16;
        int sc = ReikaRenderHelper.getGUIScale();
        this.maxX *= 1;
        this.maxY *= 1;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String file = "Textures/GUIs/Handbook/buttons.png";
        if (craftMode) {
            this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(0, j - 13, k - 7, 13, 88, 15, 95, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Items");
            this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(1, j - 13, k + 27, 13, 88, 15, 4, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Recipes");
        } else {
            this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(1, j - 13, k + 27, 13, 88, 15, 95, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Recipes");
            this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(0, j - 13, k - 7, 13, 88, 15, 4, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Items");
        }
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(2, j + this.xSize, k, 22, 39, 42, 84, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Progress");
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(3, j + this.xSize, k + 40, 22, 39, 42, 168, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Recovery");
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(4, j + this.xSize, k + 80, 22, 39, 42, 168, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Notebook");
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            craftMode = false;
            this.field_146292_n.clear();
        } else if (button.field_146127_k == 1) {
            craftMode = true;
            this.field_146292_n.clear();
        } else if (button.field_146127_k == 2) {
            this.goTo(ChromaGuis.PROGRESS, null);
            this.resetOffset();
        } else if (button.field_146127_k == 3) {
            this.goTo(ChromaGuis.REFRAGMENT, null);
            this.resetOffset();
        } else if (button.field_146127_k == 4) {
            this.goTo(ChromaGuis.NOTES, null);
            this.resetOffset();
        }
        this.func_73866_w_();
    }

    @Override
    public String getBackgroundTexture() {
        return "Textures/GUIs/Handbook/navigation2.png";
    }

    @Override
    protected String getScrollingTexture() {
        return "Textures/GUIs/Handbook/navbcg.png";
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        locations.clear();
        tooltips.clear();
        super.func_73863_a(x, y, f);
        this.drawSections(leftX + 11 - offsetX, topY + 11 - offsetY);
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)500.0);
        GL11.glPopMatrix();
        for (List o : tooltips.pluralKeySet()) {
            int a = (Integer)o.get(0);
            int b = (Integer)o.get(1);
            String s = (String)tooltips.get(new Object[]{a, b});
            api.drawTooltipAt(this.field_146289_q, s, a, b);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        SectionElement e = this.getSectionElementAt(x, y);
        if (e != null && e.getGuiType() != null) {
            if (e.isActive()) {
                this.goTo(e.getGuiType(), e.destination);
            } else {
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ERROR, (Entity)this.player, (float)0.35f, (float)0.8f);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ERROR, (Entity)this.player, (float)0.35f, (float)1.2f);
            }
        }
    }

    private SectionElement getSectionElementAt(int x, int y) {
        return (SectionElement)locations.getRegion(x, y);
    }

    private void drawSections(int x, int y) {
        float line = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)2.0f);
        int dy = y + 1;
        for (Section z : this.sections.values()) {
            int dx = x + 4;
            int n = z.allOneLevel() ? 10 : 4;
            int c = ReikaColorAPI.GStoHex((int)(15 + z.hoverTime * 12));
            int ddx = dx + z.getWidth(n);
            int ddy = dy + z.getHeight(n);
            int dx_ = MathHelper.func_76125_a((int)dx, (int)(leftX + 2), (int)(leftX + this.paneWidth + 10));
            int dy_ = MathHelper.func_76125_a((int)dy, (int)(topY - 5), (int)(topY + this.paneHeight + 5));
            int ddx_ = MathHelper.func_76125_a((int)ddx, (int)(leftX + 2), (int)(leftX + this.paneWidth + 10));
            int ddy_ = MathHelper.func_76125_a((int)ddy, (int)(topY - 5), (int)(topY + this.paneHeight + 5));
            api.drawLine(dx_, dy_, ddx_, dy_, c);
            api.drawLine(dx_, dy_, dx_, ddy_, c);
            api.drawLine(ddx_, dy_, ddx_, ddy_, c);
            api.drawLine(dx_, ddy_, ddx_, ddy_, c);
            if (dx >= leftX && dx <= leftX + this.paneWidth - this.field_146289_q.func_78256_a(z.title) && dy >= topY && dy <= topY + this.paneHeight - this.field_146289_q.field_78288_b / 2) {
                this.field_146289_q.func_78276_b(z.title, dx + 2, dy - this.field_146289_q.field_78288_b, ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)0.675f));
            }
            z.drawElements(dx, dy + this.field_146289_q.field_78288_b + 2, n);
            if ((dy += z.getHeight(n) + 32) < this.paneHeight || Minecraft.func_71410_x().field_71474_y.field_74335_Z != 0) continue;
            break;
        }
        GL11.glLineWidth((float)line);
    }

    private static boolean craftMode() {
        return GuiScreen.func_146271_m() ^ craftMode;
    }

    private static class SectionElement
    implements Comparable<SectionElement> {
        private int hoverTime = 0;
        private final ChromaResearch destination;
        private final GuiNavigation gui;

        private SectionElement(ChromaResearch b, GuiNavigation g) {
            this.destination = b;
            this.gui = g;
        }

        private void increaseHover() {
            if (this.hoverTime < 20) {
                ++this.hoverTime;
            }
        }

        private void decreaseHover() {
            if (this.hoverTime > 0) {
                --this.hoverTime;
            }
        }

        public void draw(int ex, int ey) {
            GL11.glPushAttrib((int)1048575);
            float f = 0.2f + (float)this.hoverTime / 25.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glPushMatrix();
            this.destination.drawTabIcon(field_146296_j, ex, ey);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            if (!this.isActive()) {
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)1048575);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                ReikaGLHelper.BlendMode.DEFAULT.apply();
                GL11.glTranslated((double)0.0, (double)0.0, (double)400.0);
                ReikaTextureHelper.bindTerrainTexture();
                api.func_94065_a(ex + 8, ey + 8, ChromaIcons.QUESTION.getIcon(), 9, 9);
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            } else if (GuiNavigation.craftMode() && (this.destination.isCrafting() || this.destination.isAbility())) {
                GL11.glPushMatrix();
                GL11.glDisable((int)2896);
                GL11.glTranslated((double)0.0, (double)0.0, (double)400.0);
                ReikaTextureHelper.bindTerrainTexture();
                IIcon ico = ChromaTiles.TABLE.getBlock().func_149691_a(1, ChromaTiles.TABLE.getBlockMetadata());
                if (this.destination.isAbility()) {
                    ico = ChromaTiles.RITUAL.getBlock().func_149691_a(1, ChromaTiles.RITUAL.getBlockMetadata());
                } else if (this.destination.isVanillaRecipe()) {
                    ico = Blocks.field_150462_ai.func_149691_a(1, 0);
                }
                api.func_94065_a(ex + 8, ey + 8, ico, 9, 9);
                if (this.destination.isCrafting() && !this.destination.isCraftable()) {
                    ico = ChromaIcons.NOENTER.getIcon();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                    api.func_94065_a(ex + 8, ey + 8, ico, 9, 9);
                }
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
            }
            GL11.glPopAttrib();
        }

        private boolean isActive() {
            return this.gui.isCreative || ChromaResearchManager.instance.playerHasFragment(this.gui.player, this.destination);
        }

        public ChromaGuis getGuiType() {
            switch (this.destination.getParent()) {
                case MACHINEDESC: {
                    return GuiNavigation.craftMode() && this.destination.isCraftable() ? this.destination.getCraftingType() : ChromaGuis.MACHINEDESC;
                }
                case RESOURCEDESC: {
                    return GuiNavigation.craftMode() && this.destination.isCraftable() ? this.destination.getCraftingType() : ChromaGuis.BASICDESC;
                }
                case TOOLDESC: {
                    return GuiNavigation.craftMode() && this.destination.isCraftable() ? this.destination.getCraftingType() : ChromaGuis.TOOLDESC;
                }
                case BLOCKS: {
                    return GuiNavigation.craftMode() && this.destination.isCraftable() ? this.destination.getCraftingType() : ChromaGuis.BASICDESC;
                }
                case ABILITYDESC: {
                    return GuiNavigation.craftMode() ? ChromaGuis.RITUAL : ChromaGuis.ABILITYDESC;
                }
                case INTRO: {
                    return GuiNavigation.craftMode() && this.destination.isCraftable() ? this.destination.getCraftingType() : ChromaGuis.INFO;
                }
                case STRUCTUREDESC: {
                    return ChromaGuis.STRUCTURE;
                }
            }
            return null;
        }

        public int getGuiID() {
            return this.destination.ordinal();
        }

        public String getName() {
            return this.destination.getTitle();
        }

        public ChromaResearchManager.ResearchLevel research() {
            return this.destination.level;
        }

        @Override
        public int compareTo(SectionElement o) {
            return (this.destination.getParent().ordinal() - o.destination.getParent().ordinal()) * 10000 + this.destination.ordinal() - o.destination.ordinal();
        }

        public String toString() {
            return "ELEMENT{" + this.destination.toString() + "}";
        }
    }

    private class SectionCategory {
        private final ArrayList<SectionElement> elements = new ArrayList();
        private final ChromaResearchManager.ResearchLevel level;
        private int hoverTime = 0;

        private SectionCategory(ChromaResearchManager.ResearchLevel r) {
            this.level = r;
        }

        private void addElement(SectionElement e) {
            this.elements.add(e);
            Collections.sort(this.elements);
        }

        private boolean renderElements(int x, int y, int cols, int dox) {
            boolean hovered = false;
            int i = 0;
            for (SectionElement e : this.elements) {
                int dx = x + 8 + i % cols * 28 + dox;
                int dy = y + 8 + i / cols * 28;
                GL11.glPushMatrix();
                double s = 1.5;
                GL11.glScaled((double)s, (double)s, (double)1.0);
                int ix = (int)Math.round((double)dx / s);
                int iy = (int)Math.round((double)dy / s);
                if (dx >= leftX && dx <= leftX + GuiNavigation.this.paneWidth - 24 && dy >= topY && dy <= topY + GuiNavigation.this.paneHeight - 24) {
                    e.draw(ix, iy);
                    int mx = dx;
                    int mmx = mx + 24;
                    int my = dy;
                    int mmy = my + 24;
                    if (api.isMouseInBox(mx, mmx, my, mmy)) {
                        e.increaseHover();
                        tooltips.put((Object)e.getName(), new Object[]{api.getMouseRealX(), api.getMouseRealY()});
                        locations.addRegionByWH(mx, my, 24, 24, (Object)e);
                        hovered = true;
                    } else {
                        e.decreaseHover();
                    }
                    if (e.hoverTime > 0) {
                        int w = (int)Math.round(24.0 / s);
                        int mxs = (int)Math.round((double)mx / s);
                        int mys = (int)Math.round((double)my / s);
                        api.drawRectFrame(mxs, mys, w, w, ReikaColorAPI.GStoHex((int)(15 + e.hoverTime * 12)));
                    }
                }
                GL11.glPopMatrix();
                ++i;
            }
            if (hovered) {
                this.increaseHover();
            } else {
                this.decreaseHover();
            }
            return hovered;
        }

        private int size() {
            return this.elements.size();
        }

        private void increaseHover() {
            if (this.hoverTime < 20) {
                ++this.hoverTime;
            }
        }

        private void decreaseHover() {
            if (this.hoverTime > 0 && GuiNavigation.this.getGuiTick() % 3 > 0) {
                --this.hoverTime;
            }
        }
    }

    private class Section {
        private final TreeMap<ChromaResearchManager.ResearchLevel, SectionCategory> elements = new TreeMap();
        public final String title;
        private int hoverTime;
        private static final int elementWidth = 24;
        private static final int sectionSpacing = 64;
        private static final int margin = 8;
        private static final int spacing = 4;

        public Section(String s) {
            this.title = s;
        }

        public int getLevelCount() {
            return this.elements.keySet().size();
        }

        public boolean allOneLevel() {
            return this.getLevelCount() == 1;
        }

        public void addElement(SectionElement e) {
            SectionCategory s = this.elements.get(e.research());
            if (s == null) {
                s = new SectionCategory(e.research());
                this.elements.put(e.research(), s);
            }
            s.addElement(e);
        }

        public int getHeight(int cols) {
            int max = 0;
            for (ChromaResearchManager.ResearchLevel rl : this.elements.keySet()) {
                max = Math.max(max, 64 + this.getSubSectionHeight(cols, this.elements.get(rl)));
            }
            return (max -= 64) + 8 + Minecraft.func_71410_x().field_71466_p.field_78288_b + 2;
        }

        public int getWidth(int cols) {
            int sum = 0;
            for (ChromaResearchManager.ResearchLevel rl : this.elements.keySet()) {
                sum += this.getSubsectionWidth(cols, this.elements.get(rl), true);
                sum += 64;
            }
            return (sum -= 64) + 8 + Minecraft.func_71410_x().field_71466_p.func_78256_a(this.elements.lastKey().getDisplayName()) - 24 - 8;
        }

        public int getSubSectionHeight(int cols, SectionCategory se) {
            int num = 1 + (se.size() - 1) / cols;
            return num * 24 + (num - 1) * 4 + 8 - 1;
        }

        public int getSubsectionWidth(int cols, SectionCategory se, boolean wTitle) {
            int num = se.size() >= cols ? cols : se.size() % cols;
            int w = num * 24 + (num - 1) * 4 + 8 - 1;
            if (wTitle) {
                w = Math.max(w, Minecraft.func_71410_x().field_71466_p.func_78256_a(se.level.getDisplayName()) - 64 + 24);
            }
            return w;
        }

        private void increaseHover() {
            if (this.hoverTime < 20) {
                ++this.hoverTime;
            }
        }

        private void decreaseHover() {
            if (this.hoverTime > 0 && GuiNavigation.this.getGuiTick() % 2 == 0) {
                --this.hoverTime;
            }
        }

        private void drawElements(int x, int y, int cols) {
            int dox = 0;
            boolean hovered = false;
            for (ChromaResearchManager.ResearchLevel rl : this.elements.keySet()) {
                SectionCategory se = this.elements.get(rl);
                int c = ReikaColorAPI.GStoHex((int)(15 + se.hoverTime * 12));
                int dx2 = x + dox + 4;
                int dy2 = y + 4;
                int ddx2 = dx2 + this.getSubsectionWidth(cols, se, false);
                int ddy2 = dy2 + this.getSubSectionHeight(cols, se);
                int dx2_ = MathHelper.func_76125_a((int)dx2, (int)(leftX + 2), (int)(leftX + GuiNavigation.this.paneWidth + 10));
                int dy2_ = MathHelper.func_76125_a((int)dy2, (int)(topY - 5), (int)(topY + GuiNavigation.this.paneHeight + 5));
                int ddx2_ = MathHelper.func_76125_a((int)ddx2, (int)(leftX + 2), (int)(leftX + GuiNavigation.this.paneWidth + 10));
                int ddy2_ = MathHelper.func_76125_a((int)ddy2, (int)(topY - 5), (int)(topY + GuiNavigation.this.paneHeight + 5));
                api.drawLine(dx2_, dy2_, ddx2_, dy2_, c);
                api.drawLine(dx2_, dy2_, dx2_, ddy2_, c);
                api.drawLine(ddx2_, dy2_, ddx2_, ddy2_, c);
                api.drawLine(dx2_, ddy2_, ddx2_, ddy2_, c);
                ChromaFontRenderer fr = ChromaFontRenderer.FontType.LEXICON.renderer;
                String title = rl.getDisplayName();
                if (dx2 >= leftX && dx2 <= leftX + GuiNavigation.this.paneWidth - fr.func_78256_a(title) && dy2 >= topY && dy2 <= topY + GuiNavigation.this.paneHeight - ((FontRenderer)fr).field_78288_b / 2) {
                    GL11.glPushAttrib((int)1048575);
                    GL11.glDisable((int)2896);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    fr.func_78276_b(title, dx2, y - 5, ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)0.75f));
                    GL11.glPopAttrib();
                }
                hovered |= se.renderElements(x, y, cols, dox);
                dox += Math.max(this.getSubsectionWidth(cols, se, true) + 64, 0 + 0 * Minecraft.func_71410_x().field_71466_p.func_78256_a(se.level.getDisplayName()));
            }
            if (hovered) {
                this.increaseHover();
            } else {
                this.decreaseHover();
            }
        }
    }
}

