/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Base.ChromaBookGui;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemInfoFragment;
import Reika.ChromatiCraft.Items.Tools.ItemChromaBook;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Maps.RegionMap;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiFragmentRecovery
extends ChromaBookGui {
    private ArrayList<ChromaResearch> missing = new ArrayList();
    private ArrayList<ChromaResearch> missingVisible = new ArrayList();
    private RegionMap<ChromaResearch> locations = new RegionMap();

    public GuiFragmentRecovery(EntityPlayer ep) {
        super(ChromaGuis.REFRAGMENT, ep, 256, 220);
        Collection<ChromaResearch> c = ChromaResearchManager.instance.getFragments(ep);
        for (ChromaResearch r : c) {
            if (ItemChromaBook.hasPage(this.player.func_71045_bC(), r)) continue;
            this.missing.add(r);
        }
        Collections.sort(this.missing, ChromaResearchManager.instance.researchComparator);
        this.recalculateMissingVisible();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String file = "Textures/GUIs/Handbook/buttons.png";
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(10, j + this.xSize, k, 22, 39, 42, 126, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Return");
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 10) {
            this.goTo(ChromaGuis.BOOKNAV, null);
        }
        this.func_73866_w_();
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        ChromaResearch r = (ChromaResearch)this.locations.getRegion(x, y);
        if (r != null) {
            int ink;
            boolean cr = this.player.field_71075_bZ.field_75098_d;
            ItemStack[] inv = this.player.field_71071_by.field_70462_a;
            int n = ink = cr ? -1 : ItemChromaBook.checkForInk(inv);
            if (cr || ink >= 0) {
                int paper;
                int n2 = paper = cr ? -1 : ReikaInventoryHelper.locateInInventory((Item)Items.field_151121_aF, (ItemStack[])inv);
                if (cr || paper >= 0) {
                    this.giveResearch(r);
                }
            }
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)0.33f, (float)1.0f);
        }
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        this.locations.clear();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/GUIs/Handbook/navbcg.png");
        this.func_73729_b(j, k - 8, -7, -7, this.xSize, this.ySize);
        super.func_73863_a(x, y, f);
        int w = 7;
        for (int i = 0; i < this.missingVisible.size() && i < 35; ++i) {
            ChromaResearch r = this.missingVisible.get(i);
            int dx = j / 2 + 4 + i % w * 17;
            int dy = k / 2 + 9 + i / w * 16;
            GL11.glPushMatrix();
            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            api.drawItemStack(field_146296_j, ItemInfoFragment.getItem(r), dx, dy);
            GL11.glPopMatrix();
            this.locations.addRegionByWH(dx * 2, dy * 2, 32, 32, (Object)r);
            if (!api.isMouseInBox(dx * 2, dx * 2 + 32, dy * 2, dy * 2 + 32)) continue;
            api.drawRectFrame(dx * 2, dy * 2, 32, 32, CrystalElement.getBlendedColor(this.getGuiTick(), 300));
            this.field_146289_q.func_78276_b(r.getTitle() + " (" + r.level.getDisplayName() + ")", j + 8, k + 196, 0xFFFFFF);
        }
    }

    private void giveResearch(ChromaResearch r) {
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.RERESEARCH.ordinal(), (World)Minecraft.func_71410_x().field_71441_e, (int)0, (int)0, (int)0, (int)r.ordinal());
        this.missing.remove(r);
        this.recalculateMissingVisible();
    }

    private void recalculateMissingVisible() {
        this.missingVisible.clear();
        for (ChromaResearch r : this.missing) {
            if (!this.isVisible(r)) continue;
            this.missingVisible.add(r);
        }
        Collections.sort(this.missingVisible, ChromaResearchManager.instance.researchComparator);
    }

    private boolean isVisible(ChromaResearch r) {
        Collection<ChromaResearch> par = ChromaResearchManager.instance.getPreReqsFor(r);
        for (ChromaResearch p : par) {
            if (!this.missing.contains(p)) continue;
            return false;
        }
        if (r.level != ChromaResearchManager.ResearchLevel.ENTRY) {
            Collection<ChromaResearch> lvl = ChromaResearchManager.instance.getResearchForLevelAndBelow(r.level.pre());
            for (ChromaResearch p : lvl) {
                if (!this.missing.contains(p)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getBackgroundTexture() {
        return "/Reika/ChromatiCraft/Textures/GUIs/Handbook/fragments.png";
    }
}

