/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.GUI.Book;

import Reika.ChromatiCraft.Auxiliary.ChromaBookData;
import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Special.EnchantmentRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Auxiliary.Render.RuneShapeRenderer;
import Reika.ChromatiCraft.Base.CrystalBlock;
import Reika.ChromatiCraft.Base.GuiBookSection;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.RuneShape;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.ISBRH.CrystalRenderer;
import Reika.ChromatiCraft.TileEntity.Processing.TileEntityAutoEnchanter;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiBasicInfo
extends GuiBookSection {
    private Collection<PylonParticle> particles = new ArrayList<PylonParticle>();
    private RuneShape.RuneViewer view;
    private int modifier;
    private ArrayList<EnchantmentRecipe> enchants = new ArrayList();
    private static final Map<Enchantment, Integer> enchantMap = TileEntityAutoEnchanter.getBoostedLevels();
    private static final ArrayList<Enchantment> enchantIndices = new ArrayList<Enchantment>(enchantMap.keySet());

    public GuiBasicInfo(EntityPlayer ep, ChromaResearch r) {
        super(ChromaGuis.INFO, ep, r, 256, 220, false);
        if (r == ChromaResearch.USINGRUNES) {
            this.view = this.getAllUsedRunes();
        } else if (r == ChromaResearch.ENCHANTING) {
            for (EnchantmentRecipe e : RecipesCastingTable.instance.getAllEnchantingRecipes()) {
                if (!this.shouldDisplayFragment(e.parent)) continue;
                this.enchants.add(e);
            }
        }
    }

    private RuneShape.RuneViewer getAllUsedRunes() {
        HashMap<Coordinate, CrystalElement> data = new HashMap<Coordinate, CrystalElement>();
        Collection<CastingRecipe> li = RecipesCastingTable.instance.getAllRecipes();
        for (CastingRecipe cr : li) {
            ChromaResearch r;
            if (!(cr instanceof CastingRecipe.TempleCastingRecipe) || (r = cr.getFragment()) != null && !this.shouldDisplayFragment(r)) continue;
            CastingRecipe.TempleCastingRecipe t = (CastingRecipe.TempleCastingRecipe)cr;
            if (!ChromaResearchManager.instance.playerHasUsedRecipe(this.player, cr)) continue;
            Map<Coordinate, CrystalElement> map = t.getRunes().getRunes();
            data.putAll(map);
        }
        RuneShape rs = new RuneShape(data);
        return rs.getView();
    }

    private RuneShape.RuneViewer getAllVisibleRunes() {
        HashMap<Coordinate, CrystalElement> data = new HashMap<Coordinate, CrystalElement>();
        Collection<CastingRecipe> li = RecipesCastingTable.instance.getAllRecipes();
        for (CastingRecipe cr : li) {
            ChromaResearch r;
            if (!(cr instanceof CastingRecipe.TempleCastingRecipe) || (r = cr.getFragment()) != null && !this.shouldDisplayFragment(r)) continue;
            CastingRecipe.TempleCastingRecipe t = (CastingRecipe.TempleCastingRecipe)cr;
            Map<Coordinate, CrystalElement> map = t.getRunes().getRunes();
            data.putAll(map);
        }
        RuneShape rs = new RuneShape(data);
        return rs.getView();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String file = "Textures/GUIs/Handbook/buttons.png";
        if (this.page == ChromaResearch.USINGRUNES && this.subpage == 1 && this.view.getSizeY() > 1) {
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(3, j + 230, k + 75, 12, 10, 100, 6, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
            this.field_146292_n.add(new CustomSoundGuiButton.CustomSoundImagedGuiButton(2, j + 230, k + 85, 12, 10, 112, 6, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this));
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (System.currentTimeMillis() - this.buttoncooldown >= 50L) {
            if (button.field_146127_k == 2 && this.modifier > 0) {
                --this.modifier;
            } else if (button.field_146127_k == 3) {
                if (this.modifier < this.view.getSizeY() - 1) {
                    ++this.modifier;
                }
            } else {
                this.modifier = 0;
            }
        }
        super.func_146284_a(button);
        this.func_73866_w_();
    }

    @Override
    protected int getMaxSubpage() {
        if (this.page == ChromaResearch.ELEMENTS) {
            return CrystalElement.elements.length;
        }
        if (this.page == ChromaResearch.USINGRUNES) {
            return 1;
        }
        if (this.page == ChromaResearch.ENCHANTS) {
            return ChromaEnchants.enchantmentList.length + enchantMap.size();
        }
        if (this.page == ChromaResearch.ENCHANTING) {
            return this.enchants.size() + 1;
        }
        return 0;
    }

    @Override
    protected GuiBookSection.PageType getGuiLayout() {
        if (this.isElementPage()) {
            return GuiBookSection.PageType.ELEMENT;
        }
        if (this.page == ChromaResearch.USINGRUNES && this.subpage == 1) {
            return GuiBookSection.PageType.RUNES;
        }
        if (this.page == ChromaResearch.ENCHANTING && this.subpage > 1) {
            return GuiBookSection.PageType.MULTICAST;
        }
        if (this.page == ChromaResearch.ENCHANTING && this.subpage == 1) {
            return GuiBookSection.PageType.RUNES;
        }
        return GuiBookSection.PageType.PLAIN;
    }

    @Override
    public void func_73863_a(int mx, int my, float f) {
        int posX = (this.field_146294_l - this.xSize) / 2;
        int posY = (this.field_146295_m - this.ySize) / 2 - 8;
        super.func_73863_a(mx, my, f);
        int c = 0xFFFFFF;
        int px = posX + 8;
        if (this.subpage == 0 || this.page.sameTextAllSubpages()) {
            String s = String.format("%s", this.page.getData());
            boolean flag = this.page.isUnloadable();
            if (flag) {
                int c1 = 0x6C6C6C;
                int c2 = 0x828282;
                float mix = (float)(0.5 + 0.5 * Math.sin((double)this.getGuiTick() / 16.0));
                this.field_146289_q.func_78279_b(s, px, posY + 88, 242, ReikaColorAPI.mixColors((int)c1, (int)c2, (float)mix));
                ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78279_b(s, px, posY + 88, 242, ReikaColorAPI.mixColors((int)c1, (int)c2, (float)(1.0f - mix)));
                String err = "Something is wrong with the fabric of the world; this entry seems to be illegible, and whatever it pertains to is likely unavailable.";
                err = err + "\n\nPerhaps someone else might have influenced this, and perhaps they could be of assistance to you.";
                this.field_146289_q.func_78279_b(err, px, posY + 88, 242, 0xFFFFFF);
            } else {
                this.field_146289_q.func_78279_b(s, px, posY + 88, 242, c);
            }
        }
        if (this.isElementPage()) {
            this.renderElementPage(CrystalElement.elements[this.subpage - 1], posX, posY, px, c);
        } else if (this.page == ChromaResearch.CRYSTALS) {
            this.renderCrystal(posX, posY);
        } else if (this.page == ChromaResearch.PYLONS) {
            this.renderPylon(posX, posY);
        } else if (this.page == ChromaResearch.USINGRUNES && this.subpage == 1) {
            this.renderRunes(posX, posY);
        } else if (this.page == ChromaResearch.ENCHANTING && this.subpage > 0) {
            if (this.subpage == 1) {
                this.renderEnchantmentRunes(posX, posY);
            } else {
                this.renderEnchantment(posX, posY, this.enchants.get(this.subpage - 2));
            }
        } else if (this.page == ChromaResearch.ENCHANTS && this.subpage >= 1) {
            this.renderEnchantDesc(posX, posY, px, c);
        }
    }

    private void renderEnchantDesc(int posX, int posY, int px, int c) {
        Enchantment e = this.getActiveEnchant();
        String s = StatCollector.func_74838_a((String)e.func_77320_a()) + ": Up to " + e.func_77316_c(e.func_77325_b()) + "\n\n";
        if (ReikaEnchantmentHelper.isVanillaEnchant((Enchantment)e)) {
            s = "";
            s = s + ChromaDescriptions.getNotes(this.page, ChromaEnchants.enchantmentList.length + 1);
            s = String.format(s, e.func_77316_c(e.func_77325_b()), e.func_77316_c(enchantMap.get(e).intValue()));
        } else {
            s = s + ChromaDescriptions.getNotes(this.page, this.subpage);
        }
        this.field_146289_q.func_78279_b(s, px, posY + 88, 242, c);
    }

    private Enchantment getActiveEnchant() {
        if (this.subpage <= ChromaEnchants.enchantmentList.length) {
            return ChromaEnchants.enchantmentList[this.subpage - 1].getEnchantment();
        }
        return enchantIndices.get(this.subpage - ChromaEnchants.enchantmentList.length - 1);
    }

    private void renderEnchantmentRunes(int posX, int posY) {
        Map<Coordinate, CrystalElement> map = EnchantmentRecipe.getEnchantingRunes();
        RuneShape rs = new RuneShape(map);
        RuneShape.RuneViewer rv = rs.getView();
        RuneShapeRenderer.instance.render(rv, posX + this.xSize / 2, posY + this.ySize / 2 + 8, rv.getMinY());
    }

    private void renderEnchantment(int posX, int posY, EnchantmentRecipe r) {
        ChromaBookData.drawCastingRecipe(this.field_146289_q, field_146296_j, r, 2, posX, posY + 8);
        String s = r.getMainInput().func_82833_r() + " - " + r.enchantment.func_77316_c(r.level);
        this.field_146289_q.func_78276_b(s, posX + this.xSize / 2 - this.field_146289_q.func_78256_a(s) / 2, posY + 192, 0xFFFFFF);
    }

    private void renderRunes(int posX, int posY) {
        RuneShapeRenderer.instance.render(this.view, posX + this.xSize / 2, posY + this.ySize / 2 + 8, this.modifier + this.view.getMinY());
    }

    private void renderPylon(int posX, int posY) {
        float mod = 2000.0f;
        int tick = (int)((double)System.currentTimeMillis() / (double)mod % 16.0);
        CrystalElement e1 = CrystalElement.elements[tick];
        CrystalElement e2 = CrystalElement.elements[(tick + 1) % 16];
        float mix = (float)((double)System.currentTimeMillis() % (double)mod) / mod;
        mix = Math.min(mix * 2.0f, 1.0f);
        int c1 = e1.getColor();
        int c2 = e2.getColor();
        int color = ReikaColorAPI.mixColors((int)c2, (int)c1, (float)mix);
        ReikaTextureHelper.bindTerrainTexture();
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78380_c(240);
        v5.func_78382_b();
        v5.func_78378_d(color);
        IIcon ico = ChromaIcons.ROUNDFLARE.getIcon();
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        int w = 96;
        int x = posX + 115;
        int y = posY - 4;
        v5.func_78374_a((double)x, (double)(y + w), 0.0, (double)u, (double)dv);
        v5.func_78374_a((double)(x + w), (double)(y + w), 0.0, (double)du, (double)dv);
        v5.func_78374_a((double)(x + w), (double)y, 0.0, (double)du, (double)v);
        v5.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
        ico = ChromaIcons.BIGFLARE.getIcon();
        u = ico.func_94209_e();
        v = ico.func_94206_g();
        du = ico.func_94212_f();
        dv = ico.func_94210_h();
        w = 8;
        Iterator<PylonParticle> it = this.particles.iterator();
        while (it.hasNext()) {
            PylonParticle p = it.next();
            v5.func_78374_a(p.posX, p.posY + (double)w, 0.0, (double)u, (double)dv);
            v5.func_78374_a(p.posX + (double)w, p.posY + (double)w, 0.0, (double)du, (double)dv);
            v5.func_78374_a(p.posX + (double)w, p.posY, 0.0, (double)du, (double)v);
            v5.func_78374_a(p.posX, p.posY, 0.0, (double)u, (double)v);
            p.move(180.0 / (double)ReikaRenderHelper.getFPS());
            p.age++;
            if (ReikaMathLibrary.isValueInsideBounds((double)posX, (double)(posX + this.xSize - 8), (double)p.posX) && ReikaMathLibrary.isValueInsideBounds((double)posY, (double)(posY + 80), (double)p.posY)) continue;
            it.remove();
        }
        v5.func_78381_a();
        if (rand.nextInt(50) == 0) {
            this.particles.add(new PylonParticle(245, 40, rand.nextInt(360)));
        }
        ReikaGLHelper.BlendMode.DEFAULT.apply();
    }

    private void renderCrystal(int posX, int posY) {
        int color;
        float mod = 2000.0f;
        int tick = (int)((double)System.currentTimeMillis() / (double)mod % 16.0);
        CrystalElement e1 = CrystalElement.elements[tick];
        CrystalElement e2 = CrystalElement.elements[(tick + 1) % 16];
        float mix = (float)((double)System.currentTimeMillis() % (double)mod) / mod;
        mix = Math.min(mix * 2.0f, 1.0f);
        int c1 = ((CrystalBlock)ChromaBlocks.CRYSTAL.getBlockInstance()).getTintColor(e1.ordinal());
        int c2 = ((CrystalBlock)ChromaBlocks.CRYSTAL.getBlockInstance()).getTintColor(e2.ordinal());
        CrystalRenderer.staticColor = color = ReikaColorAPI.mixColors((int)c2, (int)c1, (float)mix);
        this.drawBlockRender(posX, posY, ChromaBlocks.CRYSTAL.getBlockInstance(), CrystalElement.WHITE.ordinal());
        CrystalRenderer.staticColor = -1;
    }

    private boolean isElementPage() {
        return this.page == ChromaResearch.ELEMENTS && this.subpage > 0;
    }

    private void renderElementPage(CrystalElement e, int posX, int posY, int px, int c) {
        String s = ChromaDescriptions.getElementDescription(e);
        this.field_146289_q.func_78279_b(String.format("%s", s), px, posY + 88, 242, c);
        IIcon ico = e.getGlowRune();
        ReikaTextureHelper.bindTerrainTexture();
        this.func_94065_a(posX + 153, posY + 12, ico, 64, 64);
    }

    private static class PylonParticle {
        private double posX;
        private double posY;
        private double angle;
        private int age;

        private PylonParticle(int x, int y, double ang) {
            this.posX = x;
            this.posY = y;
            this.angle = Math.toRadians(ang);
        }

        private void move(double sp) {
            this.posX += sp * Math.cos(this.angle);
            this.posY += sp * Math.sin(this.angle);
        }
    }
}

