/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Block.Dimension.Structure.Pinball.BlockPinballTile;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.Base.ParticleEntity;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityTNTPinball
extends ParticleEntity {
    private ForgeDirection direction;
    private double speed = 0.125;

    public EntityTNTPinball(World world) {
        super(world);
    }

    public EntityTNTPinball(World world, int x, int y, int z, ForgeDirection dir, double speed) {
        super(world, x, y, z, dir);
        this.direction = dir;
        this.speed = speed;
        this.setDirection(dir, true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)Float.valueOf(0.0f));
    }

    public double getHitboxSize() {
        return 0.4;
    }

    protected double getBlockThreshold() {
        return 0.125;
    }

    public boolean despawnOverTime() {
        return false;
    }

    public boolean despawnOverDistance() {
        return true;
    }

    protected double getDespawnDistance() {
        return 40.0;
    }

    public boolean canInteractWithSpawnLocation() {
        return false;
    }

    protected void onTick() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(24, (Object)Float.valueOf((float)this.speed));
        } else {
            this.speed = this.field_70180_af.func_111145_d(24);
        }
    }

    public double getSpeed() {
        return this.speed;
    }

    protected boolean onEnterBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (b == ChromaBlocks.PINBALL.getBlockInstance()) {
            int meta = world.func_72805_g(x, y, z);
            BlockPinballTile.PinballRerouteType e = BlockPinballTile.PinballRerouteType.list[meta];
            return e.affectPulse(world, x, y, z, this);
        }
        return true;
    }

    public void func_70108_f(Entity e) {
    }

    public void setDirection(ForgeDirection dir, boolean setPos) {
        super.setDirection(dir, setPos);
        this.direction = dir;
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.direction = ForgeDirection.VALID_DIRECTIONS[tag.func_74762_e("dir")];
        this.speed = tag.func_74769_h("speed");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("dir", this.direction.ordinal());
        tag.func_74780_a("speed", this.speed);
    }

    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeInt(this.direction.ordinal());
        data.writeDouble(this.speed);
    }

    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.direction = ForgeDirection.VALID_DIRECTIONS[data.readInt()];
        this.speed = data.readDouble();
    }

    protected boolean needsSpeedUpdates() {
        return true;
    }

    protected void updateSpeed() {
        if (this.speed > 0.125) {
            this.speed = Math.max(0.125, this.speed * 0.975);
        }
        this.setDirection(this.direction, false);
        this.field_70133_I = true;
    }

    public ForgeDirection getDirection() {
        return this.direction;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public void bounce(boolean state) {
        ForgeDirection dir = state ? ReikaDirectionHelper.getRightBy90((ForgeDirection)this.direction) : ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.direction);
        this.setDirection(dir, true);
    }

    public double getRenderRangeSquared() {
        return 16384.0;
    }
}

