/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFireSmokeFX;
import Reika.ChromatiCraft.TileEntity.AOE.Defence.TileEntityMeteorTower;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityMeteorShot
extends Entity
implements IEntityAdditionalSpawnData {
    private int level;
    private Entity target;
    private int groundTick;
    private final double gravity;

    public EntityMeteorShot(TileEntityMeteorTower te, Entity e) {
        this(te.field_145850_b);
        this.func_70107_b((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5 + 4.0, (double)te.field_145849_e + 0.5);
        this.target = e;
        double dx = e.field_70165_t - this.field_70165_t;
        double dz = e.field_70161_v - this.field_70161_v;
        double dy = this.field_70163_u - e.field_70163_u;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
        double ang = 70.0;
        double phi = ReikaPhysicsHelper.cartesianToPolar((double)(-dx), (double)0.0, (double)(-dz))[2];
        double v = ReikaPhysicsHelper.getProjectileVelocity((double)dd, (double)ang, (double)dy, (double)this.gravity);
        ang = Math.toRadians(ang);
        phi = Math.toRadians(phi);
        this.field_70159_w = v * Math.cos(ang) * Math.sin(phi);
        this.field_70179_y = v * Math.cos(ang) * Math.cos(phi);
        this.field_70181_x = v * Math.sin(ang);
        this.field_70133_I = true;
        this.level = te.getTier();
    }

    public EntityMeteorShot(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.gravity = this.getGravity(world);
    }

    private double getGravity(World world) {
        double g = 0.03125;
        if (ModList.GALACTICRAFT.isLoaded() && InterfaceCache.IGALACTICWORLD.instanceOf((Object)world)) {
            g += (double)((IGalacticraftWorldProvider)world.field_73011_w).getGravity();
        }
        return g;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.target == null) {
                this.func_70106_y();
            }
            if (this.field_70122_E) {
                if (this.groundTick == 0) {
                    this.impact();
                }
                ++this.groundTick;
                if (this.groundTick > 0) {
                    this.func_70106_y();
                }
            }
        } else {
            this.spawnParticles();
        }
        if (this.field_70122_E) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        } else {
            this.field_70181_x -= this.gravity;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        if (!(this.field_70170_p.field_72995_K || this.field_70128_L || this.impacted() || this.field_70173_aa % 5 != 0)) {
            ReikaPacketHelper.sendSoundPacket((String)"ChromaData", (SoundEnum)ChromaSounds.METEOR, (World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (float)0.75f, (float)1.0f, (boolean)false, (int)64);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        int n = 1 + this.level + this.field_70146_Z.nextInt((1 + this.level) * 2);
        for (int i = 0; i < n; ++i) {
            double d = 0.5 * (double)(1 + this.level);
            double px = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)d);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)d);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)d);
            int c = ReikaColorAPI.RGBtoHex((int)255, (int)this.field_70146_Z.nextInt(256), (int)0);
            float s = ReikaRandomHelper.getRandomBetween((int)Math.max(1, this.level * 2), (int)(2 + this.level * 3));
            EntityBlurFX fx = new EntityFireSmokeFX(this.field_70170_p, px, py, pz, c).setScale(s).setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void impact() {
        double r = TileEntityMeteorTower.attacks[this.level].splashRange;
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)this, (double)r);
        List li = this.field_70170_p.func_72872_a(EntityLiving.class, box);
        for (EntityLiving e : li) {
            if (e != this.target && !ReikaEntityHelper.isHostile((EntityLivingBase)e)) continue;
            double dmg = e == this.target ? (double)TileEntityMeteorTower.attacks[this.level].baseDamage : this.getDamage(e);
            e.func_70015_d(TileEntityMeteorTower.attacks[this.level].fireDuration);
            if (!(dmg > 0.0)) continue;
            e.func_70097_a(DamageSource.field_76376_m, (float)dmg);
        }
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.METEORIMPACT.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget((Entity)this, 96), (int[])new int[]{this.func_145782_y()});
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public static void doClientImpact(World world, int id) {
        EntityMeteorShot e = (EntityMeteorShot)world.func_73045_a(id);
        if (e != null) {
            int n = 32 * (1 + e.level) + e.field_70146_Z.nextInt(64 * (1 + e.level));
            double mr = TileEntityMeteorTower.attacks[e.level].splashRange;
            for (int i = 0; i < n; ++i) {
                double r = e.field_70146_Z.nextBoolean() ? mr * 0.75 : e.field_70146_Z.nextDouble() * mr;
                double a = e.field_70146_Z.nextDouble() * 360.0;
                double px = e.field_70165_t + r * Math.sin(Math.toRadians(a));
                double pz = e.field_70161_v + r * Math.cos(Math.toRadians(a));
                double py = ReikaRandomHelper.getRandomBetween((double)(e.field_70163_u - 0.5), (double)(e.field_70163_u + 1.0));
                int c = ReikaColorAPI.RGBtoHex((int)255, (int)e.field_70146_Z.nextInt(256), (int)0);
                float s = (float)ReikaRandomHelper.getRandomBetween((double)4.0, (double)10.0);
                EntityBlurFX fx = new EntityBlurFX(e.field_70170_p, px, py, pz).setScale(s).setColor(c);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            double d = e.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g);
            float v = 0.8f;
            if (d <= 256.0) {
                v = 4.0f;
            } else if (d <= 576.0) {
                v = 2.0f;
            } else if (d <= 1024.0) {
                v = 1.5f;
            } else if (d <= 2304.0) {
                v = 1.0f;
            }
            while (v > 0.0f) {
                float m = Math.min(2.0f, v);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.IMPACT, (double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v, (float)m, (float)2.0f, (boolean)false);
                v -= m;
            }
        }
    }

    private double getDamage(EntityLiving e) {
        return (double)TileEntityMeteorTower.attacks[this.level].baseDamage * (1.0 - 0.5 * (double)e.func_70032_d((Entity)this) / TileEntityMeteorTower.attacks[this.level].splashRange);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.groundTick = tag.func_74762_e("gtick");
        this.level = tag.func_74762_e("lvl");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("gtick", this.groundTick);
        tag.func_74768_a("lvl", this.level);
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.level);
    }

    public void readSpawnData(ByteBuf buf) {
        this.level = buf.readInt();
    }

    public int getTier() {
        return this.level;
    }

    public boolean impacted() {
        return this.groundTick > 0;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean func_70112_a(double dist) {
        return true;
    }
}

